<?php

namespace App\Traits;

trait ContentTraitX
{
    public function langaugeString($locale)
    {
        $language_strings = array(
            array(
                // English -en
                'locale' => 'en',
                'data' => array(
                    array('id' => '1', 'locale' => 'en','language_string' => 'Accept Booking'),
                    array('id' => '2', 'locale' => 'en','language_string' => 'User Cancel'),
                    array('id' => '3', 'locale' => 'en','language_string' => 'Ride Now Booking'),
                    array('id' => '4', 'locale' => 'en','language_string' => 'Start To PickUp'),
                    array('id' => '5', 'locale' => 'en','language_string' => 'Arrive'),
                    array('id' => '6', 'locale' => 'en','language_string' => 'PickUp'),
                    array('id' => '7', 'locale' => 'en','language_string' => 'Drop'),
                    array('id' => '8', 'locale' => 'en','language_string' => 'Start Ride'),
                    array('id' => '9', 'locale' => 'en','language_string' => 'End Ride'),
                    array('id' => '10', 'locale' => 'en','language_string' => 'Driver Cancel'),
                    array('id' => '11', 'locale' => 'en','language_string' => 'Dispatcher Cancel'),
                    array('id' => '12', 'locale' => 'en','language_string' => 'Arrive at location'),
                    array('id' => '13', 'locale' => 'en','language_string' => 'Start From Pickup Location'),
                    array('id' => '14', 'locale' => 'en','language_string' => 'Arriving'),
                    array('id' => '15', 'locale' => 'en','language_string' => 'Driver is waiting at Pickup'),
                    array('id' => '16', 'locale' => 'en','language_string' => 'Ride Started'),
                    array('id' => '17', 'locale' => 'en','language_string' => 'Ride Ended'),
                    array('id' => '18', 'locale' => 'en','language_string' => 'Your document(s) are under review'),
                    array('id' => '19', 'locale' => 'en','language_string' => 'Ride Now'),
                    array('id' => '20', 'locale' => 'en','language_string' => 'Ride Later'),
                    array('id' => '21', 'locale' => 'en','language_string' => 'Your Otp For Verification is'),
                    array('id' => '22', 'locale' => 'en','language_string' => 'Fare to be confirmed by driver'),
                    array('id' => '23', 'locale' => 'en','language_string' => 'Your Driver Account Verification Otp is'),
                    array('id' => '24', 'locale' => 'en','language_string' => 'New Booking'),
                    array('id' => '25', 'locale' => 'en','language_string' => 'There Is New Upcomming Booking'),
                    array('id' => '26', 'locale' => 'en','language_string' => 'Your Ride Assign To Driver'),
                    array('id' => '27', 'locale' => 'en','language_string' => 'Driver Start To Pickup Location'),
                    array('id' => '28', 'locale' => 'en','language_string' => 'Haven\'t tried %s User Application yet? Sign up with my code(%s) and enjoy the most affordable can rides! '),
                    array('id' => '29', 'locale' => 'en','language_string' => 'Your Ride Assign To Driver'),
                    array('id' => '30', 'locale' => 'en','language_string' => 'Arrive At Pickup Location'),
                    array('id' => '31', 'locale' => 'en','language_string' => 'Driver Start Ride'),
                    array('id' => '32', 'locale' => 'en','language_string' => 'Driver Reach At Drop Point'),
                    array('id' => '33', 'locale' => 'en','language_string' => 'Driver End Ride'),
                    array('id' => '34', 'locale' => 'en','language_string' => 'Your wallet balance is low. Please recharge it by %s or more to make further booking'),
                    array('id' => '35', 'locale' => 'en','language_string' => 'You are not authorize to take ride. Please contact you corporate support'),
                )),
            array(
                // Spanish - es
                'locale' => 'es',
                'data' => array(
                    array('id' => '1', 'locale' => 'es','language_string' => "acepta reservas"),
                    array('id' => '2', 'locale' => 'es','language_string' => "usuario Cancelar"),
                    array('id' => '3', 'locale' => 'es','language_string' => "Ride Ahora reserva"),
                    array('id' => '4', 'locale' => 'es','language_string' => "Inicio a la recolección"),
                    array('id' => '5', 'locale' => 'es','language_string' => "Llegar"),
                    array('id' => '6', 'locale' => 'es','language_string' => "Recoger"),
                    array('id' => '7', 'locale' => 'es','language_string' => "soltar"),
                    array('id' => '8', 'locale' => 'es','language_string' => "Inicio Ride"),
                    array('id' => '9', 'locale' => 'es','language_string' => "fin del paseo"),
                    array('id' => '10', 'locale' => 'es','language_string' => "conductor Cancelar"),
                    array('id' => '11', 'locale' => 'es','language_string' => "despachador Cancelar"),
                    array('id' => '12', 'locale' => 'es','language_string' => "Llegar a la ubicación"),
                    array('id' => '13', 'locale' => 'es','language_string' => "Empezar por Lugar de recogida"),
                    array('id' => '14', 'locale' => 'es','language_string' => "Ahora que llega"),
                    array('id' => '15', 'locale' => 'es','language_string' => "Conductor de espera En el establecimiento"),
                    array('id' => '16', 'locale' => 'es','language_string' => "Ahora montar"),
                    array('id' => '17', 'locale' => 'es','language_string' => "paseo Ended"),
                    array('id' => '18', 'locale' => 'es','language_string' => "Su documento (s) están en revisión"),
                    array('id' => '19', 'locale' => 'es','language_string' => "Montar ahora"),
                    array('id' => '20', 'locale' => 'es','language_string' => "Más tarde montar"),
                    array('id' => '21', 'locale' => 'es','language_string' => "Su Otp para la verificación es"),
                    array('id' => '22', 'locale' => 'es','language_string' => "Tarifa a ser confirmado por el conductor"),
                    array('id' => '23', 'locale' => 'es','language_string' => "Su controlador de Verificación de cuenta es Otp"),
                    array('id' => '24', 'locale' => 'es','language_string' => "Nueva reserva"),
                    array('id' => '25', 'locale' => 'es','language_string' => "Hay nueva upcomming Reservas"),
                    array('id' => '26', 'locale' => 'es','language_string' => "Su paseo Asignar a Conductor"),
                    array('id' => '27', 'locale' => 'es','language_string' => "Para controlador de inicio Lugar de recogida"),
                    array('id' => '28', 'locale' => 'es','language_string' => "No he probado% s aplicación de usuario todavía? Regístrese con mi código (% s) y disfrutar de la mayoría de los paseos en coche a buen precio"),
                    array('id' => '29', 'locale' => 'es','language_string' => "Su paseo Asignar a Conductor"),
                    array('id' => '30', 'locale' => 'es','language_string' => "Al llegar Lugar de recogida"),
                    array('id' => '31', 'locale' => 'es','language_string' => "Conductor de inicio Ride"),
                    array('id' => '32', 'locale' => 'es','language_string' => "Conductor alcanzar al punto de la gota"),
                    array('id' => '33', 'locale' => 'es','language_string' => "Conductor Final Ride"),
                    array('id' => '34', 'locale' => 'es','language_string' => "El saldo de su cartera es baja. Por favor, recargue por% s o más para hacer más de reserva"),
                    array('id' => '35', 'locale' => 'es','language_string' => "No se le autoriza para tomar paseo. Por favor, póngase en contacto con usted apoyo corporativo"),
                )),
            array(
                // Portuguese -pt
                'locale' => 'pt',
                'data' => array(
                    array('id' => '1', 'locale' => 'pt','language_string' => "aceitar Booking"),
                    array('id' => '2', 'locale' => 'pt','language_string' => "usuário Anular"),
                    array('id' => '3', 'locale' => 'pt','language_string' => "Passeio Agora Booking"),
                    array('id' => '4', 'locale' => 'pt','language_string' => "Iniciar Para PickUp"),
                    array('id' => '5', 'locale' => 'pt','language_string' => "Chegar"),
                    array('id' => '6', 'locale' => 'pt','language_string' => "Pegar"),
                    array('id' => '7', 'locale' => 'pt','language_string' => "Solta"),
                    array('id' => '8', 'locale' => 'pt','language_string' => "Iniciar passeio"),
                    array('id' => '9', 'locale' => 'pt','language_string' => "End passeio"),
                    array('id' => '10', 'locale' => 'pt','language_string' => "motorista Anular"),
                    array('id' => '11', 'locale' => 'pt','language_string' => "Dispatcher Anular"),
                    array('id' => '12', 'locale' => 'pt','language_string' => "Chegar ao local"),
                    array('id' => '13', 'locale' => 'pt','language_string' => "Start From local de retirada"),
                    array('id' => '14', 'locale' => 'pt','language_string' => "chegando Agora"),
                    array('id' => '15', 'locale' => 'pt','language_string' => "Motorista espera no Local"),
                    array('id' => '16', 'locale' => 'pt','language_string' => "cavalgando agora"),
                    array('id' => '17', 'locale' => 'pt','language_string' => "passeio Ended"),
                    array('id' => '18', 'locale' => 'pt','language_string' => "Seu documento (s) estão sob revisão"),
                    array('id' => '19', 'locale' => 'pt','language_string' => "Cavalgue agora"),
                    array('id' => '20', 'locale' => 'pt','language_string' => "passeio Mais tarde"),
                    array('id' => '21', 'locale' => 'pt','language_string' => "Seu Para Verificação Otp é"),
                    array('id' => '22', 'locale' => 'pt','language_string' => "Tarifa de ser confirmada pelo motorista"),
                    array('id' => '23', 'locale' => 'pt','language_string' => "Seu motorista Conta Verificação Otp é"),
                    array('id' => '24', 'locale' => 'pt','language_string' => "New Booking"),
                    array('id' => '25', 'locale' => 'pt','language_string' => "Há New upcomming Booking"),
                    array('id' => '26', 'locale' => 'pt','language_string' => "O driver de passeio Atribuir Para"),
                    array('id' => '27', 'locale' => 'pt','language_string' => "Motorista Iniciar Para local de retirada"),
                    array('id' => '28', 'locale' => 'pt','language_string' => "Ainda não tentei% s Aplicativo de Usuário ainda? Cadastre-se com o meu código (% s) e desfrutar ao máximo passeios de carro acessíveis!"),
                    array('id' => '29', 'locale' => 'pt','language_string' => "O driver de passeio Atribuir Para"),
                    array('id' => '30', 'locale' => 'pt','language_string' => "Chegar ao local de retirada"),
                    array('id' => '31', 'locale' => 'pt','language_string' => "Motorista Iniciar passeio"),
                    array('id' => '32', 'locale' => 'pt','language_string' => "Motorista atingir pelo Ponto de Gota"),
                    array('id' => '33', 'locale' => 'pt','language_string' => "Motorista End passeio"),
                    array('id' => '34', 'locale' => 'pt','language_string' => "Seu saldo da carteira é baixa. Por favor, recarregá-lo por% s ou mais para fazer ainda reserva"),
                    array('id' => '35', 'locale' => 'pt','language_string' => "Você não está autorizar a tomar carona. Entre em contato com você apoio corporativo"),
                )),
            array(
                // French -fr
                'locale' => 'fr',
                'data' => array(
                    array('id' => '1', 'locale' => 'fr','language_string' => "accepter Réservation"),
                    array('id' => '2', 'locale' => 'fr','language_string' => "utilisateur Annuler"),
                    array('id' => '3', 'locale' => 'fr','language_string' => "Tour toptable"),
                    array('id' => '4', 'locale' => 'fr','language_string' => "Début Intercepter"),
                    array('id' => '5', 'locale' => 'fr','language_string' => "Arrivée"),
                    array('id' => '6', 'locale' => 'fr','language_string' => "Ramasser"),
                    array('id' => '7', 'locale' => 'fr','language_string' => "Laissez tomber"),
                    array('id' => '8', 'locale' => 'fr','language_string' => "Démarrer tour"),
                    array('id' => '9', 'locale' => 'fr','language_string' => "fin tour"),
                    array('id' => '10', 'locale' => 'fr','language_string' => "pilote Annuler"),
                    array('id' => '11', 'locale' => 'fr','language_string' => "Dispatcher Annuler"),
                    array('id' => '12', 'locale' => 'fr','language_string' => "Arrivée à l'emplacement"),
                    array('id' => '13', 'locale' => 'fr','language_string' => "À partir de ramassage Lieu"),
                    array('id' => '14', 'locale' => 'fr','language_string' => "En arrivant maintenant"),
                    array('id' => '15', 'locale' => 'fr','language_string' => "Pilote d'attente à Lieu"),
                    array('id' => '16', 'locale' => 'fr','language_string' => "équitation maintenant"),
                    array('id' => '17', 'locale' => 'fr','language_string' => "tour Ended"),
                    array('id' => '18', 'locale' => 'fr','language_string' => "Vos documents (s) sont à l'étude"),
                    array('id' => '19', 'locale' => 'fr','language_string' => "maintenant, tour"),
                    array('id' => '20', 'locale' => 'fr','language_string' => "Roulez plus tard"),
                    array('id' => '21', 'locale' => 'fr','language_string' => "Votre Otp Pour la vérification est"),
                    array('id' => '22', 'locale' => 'fr','language_string' => "Tarifs à confirmer par le conducteur"),
                    array('id' => '23', 'locale' => 'fr','language_string' => "Votre pilote de vérification des comptes BdP"),
                    array('id' => '24', 'locale' => 'fr','language_string' => "nouvelle réservation"),
                    array('id' => '25', 'locale' => 'fr','language_string' => "Il y a New upcomming Réservation"),
                    array('id' => '26', 'locale' => 'fr','language_string' => "Bazou Assigner à Driver"),
                    array('id' => '27', 'locale' => 'fr','language_string' => "Pilote de démarrage Intercepter Lieu"),
                    array('id' => '28', 'locale' => 'fr','language_string' => "N'a pas essayé% de encore l'application utilisateur? Inscrivez-vous avec mon code (% s) et profiter de la plupart des promenades en voiture à prix abordable!"),
                    array('id' => '29', 'locale' => 'fr','language_string' => "Bazou Assigner à Driver"),
                    array('id' => '30', 'locale' => 'fr','language_string' => "Arrivée à Pickup Endroit"),
                    array('id' => '31', 'locale' => 'fr','language_string' => "Pilote de démarrage Tour"),
                    array('id' => '32', 'locale' => 'fr','language_string' => "Conducteur portée à point de chute"),
                    array('id' => '33', 'locale' => 'fr','language_string' => "Pilote Fin tour"),
                    array('id' => '34', 'locale' => 'fr','language_string' => "Le solde de votre portefeuille est faible. S'il vous plaît recharger par% s ou plus pour faire d'autres réservations"),
                    array('id' => '35', 'locale' => 'fr','language_string' => "Vous n'êtes pas autorisé à prendre tour. S'il vous plaît contacter le support d'entreprise"),
                )),
            array(
                // Arabic -ar
                'locale' => 'ar',
                'data' => array(
                    array('id' => '1', 'locale' => 'ar','language_string' => "استعرض الحجز"),
                    array('id' => '2', 'locale' => 'ar','language_string' => "العضو إلغاء"),
                    array('id' => '3', 'locale' => 'ar','language_string' => "ركوب الآن الحجز"),
                    array('id' => '4', 'locale' => 'ar','language_string' => "بداية لبيك اب"),
                    array('id' => '5', 'locale' => 'ar','language_string' => "يصل"),
                    array('id' => '6', 'locale' => 'ar','language_string' => "امسك"),
                    array('id' => '7', 'locale' => 'ar','language_string' => "قطرة"),
                    array('id' => '8', 'locale' => 'ar','language_string' => "بداية ركوب"),
                    array('id' => '9', 'locale' => 'ar','language_string' => "نهاية ركوب"),
                    array('id' => '10', 'locale' => 'ar','language_string' => "سائق إلغاء"),
                    array('id' => '11', 'locale' => 'ar','language_string' => "الغاء المرسل"),
                    array('id' => '12', 'locale' => 'ar','language_string' => "وصول إلى موقع"),
                    array('id' => '13', 'locale' => 'ar','language_string' => "بدء من لاقط الموقع"),
                    array('id' => '14', 'locale' => 'ar','language_string' => "وصوله الآن"),
                    array('id' => '15', 'locale' => 'ar','language_string' => "السائق الانتظار في الموقع"),
                    array('id' => '16', 'locale' => 'ar','language_string' => "ركوب الآن"),
                    array('id' => '17', 'locale' => 'ar','language_string' => "ركوب المنتهية"),
                    array('id' => '18', 'locale' => 'ar','language_string' => "وثيقة الخاص بك (ق) هي قيد المراجعة"),
                    array('id' => '19', 'locale' => 'ar','language_string' => "اركب الآن"),
                    array('id' => '20', 'locale' => 'ar','language_string' => "ركوب في وقت لاحق"),
                    array('id' => '21', 'locale' => 'ar','language_string' => "لديك مكتب المدعي العام على التحقق هو"),
                    array('id' => '22', 'locale' => 'ar','language_string' => "أجرة إلى تأكيد من سائق"),
                    array('id' => '23', 'locale' => 'ar','language_string' => "سائق حسابك التأكيد مكتب المدعي العام"),
                    array('id' => '24', 'locale' => 'ar','language_string' => "الحجز الجديد"),
                    array('id' => '25', 'locale' => 'ar','language_string' => "هناك هو جديد قادمة الحجز"),
                    array('id' => '26', 'locale' => 'ar','language_string' => "لديك سائق ركوب تعيين ل"),
                    array('id' => '27', 'locale' => 'ar','language_string' => "سائق البداية لاقط الموقع"),
                    array('id' => '28', 'locale' => 'ar','language_string' => "لم أحاول٪ ق تطبيق العضو حتى الآن؟ اشترك مع قانون بلدي (٪ ق) وتتمتع معظم ركوب السيارات بأسعار معقولة!"),
                    array('id' => '29', 'locale' => 'ar','language_string' => "لديك سائق ركوب تعيين ل"),
                    array('id' => '30', 'locale' => 'ar','language_string' => "يصل في لاقط الموقع"),
                    array('id' => '31', 'locale' => 'ar','language_string' => "سائق بدء ركوب"),
                    array('id' => '32', 'locale' => 'ar','language_string' => "سائق الوصول إسقاط نقطة في"),
                    array('id' => '33', 'locale' => 'ar','language_string' => "سائق نهاية ركوب"),
                    array('id' => '34', 'locale' => 'ar','language_string' => "توازن محفظتك منخفضة. يرجى إعادة الشحن بواسطة٪ s أو أكثر لتحقيق مزيد من الحجز"),
                    array('id' => '35', 'locale' => 'ar','language_string' => "انك لم تأذن لاتخاذ ركوب. يرجى الاتصال بك دعم الشركات"),
                ))
        );
//        $l = array_column($language_strings, 'locale');
//        p($l,0);
        $s = array_search($locale, array_column($language_strings, 'locale'));
        $language_string = $s ? $language_strings[$s]['data'] : $language_strings[0]['data'];
        return $language_string;
    }

    public function countryList(){
        $countries_list = array(
//            0 => array('Country_Name' => '', 'Official_Name_English' => 'Channel Islands', 'ISO3166_1_Alpha_2' => '', 'ISO3166_1_Alpha_3' => '', 'M49' => '830', 'ITU' => '', 'MARC' => '', 'WMO' => '', 'DS' => '', 'Dial' => '', 'FIFA' => '', 'FIPS' => '', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => '', 'Capital' => '', 'Continent' => '', 'TLD' => '', 'Languages' => '', 'Geo_Name_ID' => '', 'EDGAR' => ''),
//            1 => array('Country_Name' => '', 'Official_Name_English' => 'Sark', 'ISO3166_1_Alpha_2' => '', 'ISO3166_1_Alpha_3' => '', 'M49' => '680', 'ITU' => '', 'MARC' => '', 'WMO' => '', 'DS' => '', 'Dial' => '', 'FIFA' => '', 'FIPS' => '', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => '', 'Capital' => '', 'Continent' => '', 'TLD' => '', 'Languages' => '', 'Geo_Name_ID' => '', 'EDGAR' => ''),
            2 => array('Country_Name' => 'Afghanistan', 'Official_Name_English' => 'Afghanistan', 'ISO3166_1_Alpha_2' => 'AF', 'ISO3166_1_Alpha_3' => 'AFG', 'M49' => '004', 'ITU' => 'AFG', 'MARC' => 'af', 'WMO' => 'AF', 'DS' => 'AFG', 'Dial' => '93', 'FIFA' => 'AFG', 'FIPS' => 'AF', 'GAUL' => '1', 'IOC' => 'AFG', 'ISO4217_Currency_Alphabetic_Code' => 'AFN', 'ISO4217_Currency_Country_Name' => 'AFGHANISTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Afghani', 'ISO4217_Currency_Numeric_Code' => '971', 'Is_Independent' => 'Yes', 'Capital' => 'Kabul', 'Continent' => 'AS', 'TLD' => '.af', 'Languages' => 'fa-AF,ps,uz-AF,tk', 'Geo_Name_ID' => '1149361', 'EDGAR' => 'B2'),
            3 => array('Country_Name' => 'Albania', 'Official_Name_English' => 'Albania', 'ISO3166_1_Alpha_2' => 'AL', 'ISO3166_1_Alpha_3' => 'ALB', 'M49' => '008', 'ITU' => 'ALB', 'MARC' => 'aa', 'WMO' => 'AB', 'DS' => 'AL', 'Dial' => '355', 'FIFA' => 'ALB', 'FIPS' => 'AL', 'GAUL' => '3', 'IOC' => 'ALB', 'ISO4217_Currency_Alphabetic_Code' => 'ALL', 'ISO4217_Currency_Country_Name' => 'ALBANIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Lek', 'ISO4217_Currency_Numeric_Code' => '8', 'Is_Independent' => 'Yes', 'Capital' => 'Tirana', 'Continent' => 'EU', 'TLD' => '.al', 'Languages' => 'sq,el', 'Geo_Name_ID' => '783754', 'EDGAR' => 'B3'),
            4 => array('Country_Name' => 'Algeria', 'Official_Name_English' => 'Algeria', 'ISO3166_1_Alpha_2' => 'DZ', 'ISO3166_1_Alpha_3' => 'DZA', 'M49' => '012', 'ITU' => 'ALG', 'MARC' => 'ae', 'WMO' => 'AL', 'DS' => 'DZ', 'Dial' => '213', 'FIFA' => 'ALG', 'FIPS' => 'AG', 'GAUL' => '4', 'IOC' => 'ALG', 'ISO4217_Currency_Alphabetic_Code' => 'DZD', 'ISO4217_Currency_Country_Name' => 'ALGERIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Algerian Dinar', 'ISO4217_Currency_Numeric_Code' => '12', 'Is_Independent' => 'Yes', 'Capital' => 'Algiers', 'Continent' => 'AF', 'TLD' => '.dz', 'Languages' => 'ar-DZ', 'Geo_Name_ID' => '2589581', 'EDGAR' => 'B4'),
            5 => array('Country_Name' => 'American Samoa', 'Official_Name_English' => 'American Samoa', 'ISO3166_1_Alpha_2' => 'AS', 'ISO3166_1_Alpha_3' => 'ASM', 'M49' => '016', 'ITU' => 'SMA', 'MARC' => 'as', 'WMO' => '', 'DS' => 'USA', 'Dial' => '684', 'FIFA' => 'ASA', 'FIPS' => 'AQ', 'GAUL' => '5', 'IOC' => 'ASA', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'AMERICAN SAMOA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Territory of US', 'Capital' => 'Pago Pago', 'Continent' => 'OC', 'TLD' => '.as', 'Languages' => 'en-AS,sm,to', 'Geo_Name_ID' => '5880801', 'EDGAR' => 'B5'),
            6 => array('Country_Name' => 'Andorra', 'Official_Name_English' => 'Andorra', 'ISO3166_1_Alpha_2' => 'AD', 'ISO3166_1_Alpha_3' => 'AND', 'M49' => '020', 'ITU' => 'AND', 'MARC' => 'an', 'WMO' => '', 'DS' => 'AND', 'Dial' => '376', 'FIFA' => 'AND', 'FIPS' => 'AN', 'GAUL' => '7', 'IOC' => 'AND', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'ANDORRA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Andorra la Vella', 'Continent' => 'EU', 'TLD' => '.ad', 'Languages' => 'ca', 'Geo_Name_ID' => '3041565', 'EDGAR' => 'B6'),
            7 => array('Country_Name' => 'Angola', 'Official_Name_English' => 'Angola', 'ISO3166_1_Alpha_2' => 'AO', 'ISO3166_1_Alpha_3' => 'AGO', 'M49' => '024', 'ITU' => 'AGL', 'MARC' => 'ao', 'WMO' => 'AN', 'DS' => 'AO', 'Dial' => '244', 'FIFA' => 'ANG', 'FIPS' => 'AO', 'GAUL' => '8', 'IOC' => 'ANG', 'ISO4217_Currency_Alphabetic_Code' => 'AOA', 'ISO4217_Currency_Country_Name' => 'ANGOLA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Kwanza', 'ISO4217_Currency_Numeric_Code' => '973', 'Is_Independent' => 'Yes', 'Capital' => 'Luanda', 'Continent' => 'AF', 'TLD' => '.ao', 'Languages' => 'pt-AO', 'Geo_Name_ID' => '3351879', 'EDGAR' => 'B7'),
            8 => array('Country_Name' => 'Anguilla', 'Official_Name_English' => 'Anguilla', 'ISO3166_1_Alpha_2' => 'AI', 'ISO3166_1_Alpha_3' => 'AIA', 'M49' => '660', 'ITU' => 'AIA', 'MARC' => 'am', 'WMO' => '', 'DS' => '', 'Dial' => '264', 'FIFA' => 'AIA', 'FIPS' => 'AV', 'GAUL' => '9', 'IOC' => 'AIA', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'ANGUILLA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Territory of GB', 'Capital' => 'The Valley', 'Continent' => 'NA', 'TLD' => '.ai', 'Languages' => 'en-AI', 'Geo_Name_ID' => '3573511', 'EDGAR' => '1A'),
            9 => array('Country_Name' => 'Antarctica', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'AQ', 'ISO3166_1_Alpha_3' => 'ATA', 'M49' => '010', 'ITU' => '', 'MARC' => 'ay', 'WMO' => 'AA', 'DS' => '', 'Dial' => '672', 'FIFA' => 'ROS', 'FIPS' => 'AY', 'GAUL' => '10', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'International', 'Capital' => '', 'Continent' => 'AN', 'TLD' => '.aq', 'Languages' => '', 'Geo_Name_ID' => '6697173', 'EDGAR' => ''),
            10 => array('Country_Name' => 'Antigua & Barbuda', 'Official_Name_English' => 'Antigua and Barbuda', 'ISO3166_1_Alpha_2' => 'AG', 'ISO3166_1_Alpha_3' => 'ATG', 'M49' => '028', 'ITU' => 'ATG', 'MARC' => 'aq', 'WMO' => 'AT', 'DS' => '', 'Dial' => '268', 'FIFA' => 'ATG', 'FIPS' => 'AC', 'GAUL' => '11', 'IOC' => 'ANT', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'ANTIGUA AND BARBUDA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Yes', 'Capital' => 'St. John\'s', 'Continent' => 'NA', 'TLD' => '.ag', 'Languages' => 'en-AG', 'Geo_Name_ID' => '3576396', 'EDGAR' => 'B9'),
            11 => array('Country_Name' => 'Argentina', 'Official_Name_English' => 'Argentina', 'ISO3166_1_Alpha_2' => 'AR', 'ISO3166_1_Alpha_3' => 'ARG', 'M49' => '032', 'ITU' => 'ARG', 'MARC' => 'ag', 'WMO' => 'AG', 'DS' => 'RA', 'Dial' => '54', 'FIFA' => 'ARG', 'FIPS' => 'AR', 'GAUL' => '12', 'IOC' => 'ARG', 'ISO4217_Currency_Alphabetic_Code' => 'ARS', 'ISO4217_Currency_Country_Name' => 'ARGENTINA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Argentine Peso', 'ISO4217_Currency_Numeric_Code' => '32', 'Is_Independent' => 'Yes', 'Capital' => 'Buenos Aires', 'Continent' => 'SA', 'TLD' => '.ar', 'Languages' => 'es-AR,en,it,de,fr,gn', 'Geo_Name_ID' => '3865483', 'EDGAR' => 'C1'),
            12 => array('Country_Name' => 'Armenia', 'Official_Name_English' => 'Armenia', 'ISO3166_1_Alpha_2' => 'AM', 'ISO3166_1_Alpha_3' => 'ARM', 'M49' => '051', 'ITU' => 'ARM', 'MARC' => 'ai', 'WMO' => 'AY', 'DS' => 'AM', 'Dial' => '374', 'FIFA' => 'ARM', 'FIPS' => 'AM', 'GAUL' => '13', 'IOC' => 'ARM', 'ISO4217_Currency_Alphabetic_Code' => 'AMD', 'ISO4217_Currency_Country_Name' => 'ARMENIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Armenian Dram', 'ISO4217_Currency_Numeric_Code' => '51', 'Is_Independent' => 'Yes', 'Capital' => 'Yerevan', 'Continent' => 'AS', 'TLD' => '.am', 'Languages' => 'hy', 'Geo_Name_ID' => '174982', 'EDGAR' => '1B'),
            13 => array('Country_Name' => 'Aruba', 'Official_Name_English' => 'Aruba', 'ISO3166_1_Alpha_2' => 'AW', 'ISO3166_1_Alpha_3' => 'ABW', 'M49' => '533', 'ITU' => 'ABW', 'MARC' => 'aw', 'WMO' => 'NU', 'DS' => 'AW', 'Dial' => '297', 'FIFA' => 'ARU', 'FIPS' => 'AA', 'GAUL' => '14', 'IOC' => 'ARU', 'ISO4217_Currency_Alphabetic_Code' => 'AWG', 'ISO4217_Currency_Country_Name' => 'ARUBA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Aruban Florin', 'ISO4217_Currency_Numeric_Code' => '533', 'Is_Independent' => 'Part of NL', 'Capital' => 'Oranjestad', 'Continent' => 'NA', 'TLD' => '.aw', 'Languages' => 'nl-AW,es,en', 'Geo_Name_ID' => '3577279', 'EDGAR' => '1C'),
            14 => array('Country_Name' => 'Australia', 'Official_Name_English' => 'Australia', 'ISO3166_1_Alpha_2' => 'AU', 'ISO3166_1_Alpha_3' => 'AUS', 'M49' => '036', 'ITU' => 'AUS', 'MARC' => 'at', 'WMO' => 'AU', 'DS' => 'AUS', 'Dial' => '61', 'FIFA' => 'AUS', 'FIPS' => 'AS', 'GAUL' => '17', 'IOC' => 'AUS', 'ISO4217_Currency_Alphabetic_Code' => 'AUD', 'ISO4217_Currency_Country_Name' => 'AUSTRALIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Australian Dollar', 'ISO4217_Currency_Numeric_Code' => '36', 'Is_Independent' => 'Yes', 'Capital' => 'Canberra', 'Continent' => 'OC', 'TLD' => '.au', 'Languages' => 'en-AU', 'Geo_Name_ID' => '2077456', 'EDGAR' => 'C3'),
            15 => array('Country_Name' => 'Austria', 'Official_Name_English' => 'Austria', 'ISO3166_1_Alpha_2' => 'AT', 'ISO3166_1_Alpha_3' => 'AUT', 'M49' => '040', 'ITU' => 'AUT', 'MARC' => 'au', 'WMO' => 'OS', 'DS' => 'A', 'Dial' => '43', 'FIFA' => 'AUT', 'FIPS' => 'AU', 'GAUL' => '18', 'IOC' => 'AUT', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'AUSTRIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Vienna', 'Continent' => 'EU', 'TLD' => '.at', 'Languages' => 'de-AT,hr,hu,sl', 'Geo_Name_ID' => '2782113', 'EDGAR' => 'C4'),
            16 => array('Country_Name' => 'Azerbaijan', 'Official_Name_English' => 'Azerbaijan', 'ISO3166_1_Alpha_2' => 'AZ', 'ISO3166_1_Alpha_3' => 'AZE', 'M49' => '031', 'ITU' => 'AZE', 'MARC' => 'aj', 'WMO' => 'AJ', 'DS' => 'AZ', 'Dial' => '994', 'FIFA' => 'AZE', 'FIPS' => 'AJ', 'GAUL' => '19', 'IOC' => 'AZE', 'ISO4217_Currency_Alphabetic_Code' => 'AZN', 'ISO4217_Currency_Country_Name' => 'AZERBAIJAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Azerbaijanian Manat', 'ISO4217_Currency_Numeric_Code' => '944', 'Is_Independent' => 'Yes', 'Capital' => 'Baku', 'Continent' => 'AS', 'TLD' => '.az', 'Languages' => 'az,ru,hy', 'Geo_Name_ID' => '587116', 'EDGAR' => '1D'),
            17 => array('Country_Name' => 'Bahamas', 'Official_Name_English' => 'Bahamas', 'ISO3166_1_Alpha_2' => 'BS', 'ISO3166_1_Alpha_3' => 'BHS', 'M49' => '044', 'ITU' => 'BAH', 'MARC' => 'bf', 'WMO' => 'BA', 'DS' => 'BS', 'Dial' => '242', 'FIFA' => 'BAH', 'FIPS' => 'BF', 'GAUL' => '20', 'IOC' => 'BAH', 'ISO4217_Currency_Alphabetic_Code' => 'BSD', 'ISO4217_Currency_Country_Name' => 'BAHAMAS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Bahamian Dollar', 'ISO4217_Currency_Numeric_Code' => '44', 'Is_Independent' => 'Yes', 'Capital' => 'Nassau', 'Continent' => 'NA', 'TLD' => '.bs', 'Languages' => 'en-BS', 'Geo_Name_ID' => '3572887', 'EDGAR' => 'C5'),
            18 => array('Country_Name' => 'Bahrain', 'Official_Name_English' => 'Bahrain', 'ISO3166_1_Alpha_2' => 'BH', 'ISO3166_1_Alpha_3' => 'BHR', 'M49' => '048', 'ITU' => 'BHR', 'MARC' => 'ba', 'WMO' => 'BN', 'DS' => 'BRN', 'Dial' => '973', 'FIFA' => 'BHR', 'FIPS' => 'BA', 'GAUL' => '21', 'IOC' => 'BRN', 'ISO4217_Currency_Alphabetic_Code' => 'BHD', 'ISO4217_Currency_Country_Name' => 'BAHRAIN', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Bahraini Dinar', 'ISO4217_Currency_Numeric_Code' => '48', 'Is_Independent' => 'Yes', 'Capital' => 'Manama', 'Continent' => 'AS', 'TLD' => '.bh', 'Languages' => 'ar-BH,en,fa,ur', 'Geo_Name_ID' => '290291', 'EDGAR' => 'C6'),
            19 => array('Country_Name' => 'Bangladesh', 'Official_Name_English' => 'Bangladesh', 'ISO3166_1_Alpha_2' => 'BD', 'ISO3166_1_Alpha_3' => 'BGD', 'M49' => '050', 'ITU' => 'BGD', 'MARC' => 'bg', 'WMO' => 'BW', 'DS' => 'BD', 'Dial' => '880', 'FIFA' => 'BAN', 'FIPS' => 'BG', 'GAUL' => '23', 'IOC' => 'BAN', 'ISO4217_Currency_Alphabetic_Code' => 'BDT', 'ISO4217_Currency_Country_Name' => 'BANGLADESH', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Taka', 'ISO4217_Currency_Numeric_Code' => '50', 'Is_Independent' => 'Yes', 'Capital' => 'Dhaka', 'Continent' => 'AS', 'TLD' => '.bd', 'Languages' => 'bn-BD,en', 'Geo_Name_ID' => '1210997', 'EDGAR' => 'C7'),
            20 => array('Country_Name' => 'Barbados', 'Official_Name_English' => 'Barbados', 'ISO3166_1_Alpha_2' => 'BB', 'ISO3166_1_Alpha_3' => 'BRB', 'M49' => '052', 'ITU' => 'BRB', 'MARC' => 'bb', 'WMO' => 'BR', 'DS' => 'BDS', 'Dial' => '246', 'FIFA' => 'BRB', 'FIPS' => 'BB', 'GAUL' => '24', 'IOC' => 'BAR', 'ISO4217_Currency_Alphabetic_Code' => 'BBD', 'ISO4217_Currency_Country_Name' => 'BARBADOS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Barbados Dollar', 'ISO4217_Currency_Numeric_Code' => '52', 'Is_Independent' => 'Yes', 'Capital' => 'Bridgetown', 'Continent' => 'NA', 'TLD' => '.bb', 'Languages' => 'en-BB', 'Geo_Name_ID' => '3374084', 'EDGAR' => 'C8'),
            21 => array('Country_Name' => 'Belarus', 'Official_Name_English' => 'Belarus', 'ISO3166_1_Alpha_2' => 'BY', 'ISO3166_1_Alpha_3' => 'BLR', 'M49' => '112', 'ITU' => 'BLR', 'MARC' => 'bw', 'WMO' => 'BY', 'DS' => 'BY', 'Dial' => '375', 'FIFA' => 'BLR', 'FIPS' => 'BO', 'GAUL' => '26', 'IOC' => 'BLR', 'ISO4217_Currency_Alphabetic_Code' => 'BYR', 'ISO4217_Currency_Country_Name' => 'BELARUS', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Belarussian Ruble', 'ISO4217_Currency_Numeric_Code' => '974', 'Is_Independent' => 'Yes', 'Capital' => 'Minsk', 'Continent' => 'EU', 'TLD' => '.by', 'Languages' => 'be,ru', 'Geo_Name_ID' => '630336', 'EDGAR' => '1F'),
            22 => array('Country_Name' => 'Belgium', 'Official_Name_English' => 'Belgium', 'ISO3166_1_Alpha_2' => 'BE', 'ISO3166_1_Alpha_3' => 'BEL', 'M49' => '056', 'ITU' => 'BEL', 'MARC' => 'be', 'WMO' => 'BX', 'DS' => 'B', 'Dial' => '32', 'FIFA' => 'BEL', 'FIPS' => 'BE', 'GAUL' => '27', 'IOC' => 'BEL', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'BELGIUM', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Brussels', 'Continent' => 'EU', 'TLD' => '.be', 'Languages' => 'nl-BE,fr-BE,de-BE', 'Geo_Name_ID' => '2802361', 'EDGAR' => 'C9'),
            23 => array('Country_Name' => 'Belize', 'Official_Name_English' => 'Belize', 'ISO3166_1_Alpha_2' => 'BZ', 'ISO3166_1_Alpha_3' => 'BLZ', 'M49' => '084', 'ITU' => 'BLZ', 'MARC' => 'bh', 'WMO' => 'BH', 'DS' => 'BH', 'Dial' => '501', 'FIFA' => 'BLZ', 'FIPS' => 'BH', 'GAUL' => '28', 'IOC' => 'BIZ', 'ISO4217_Currency_Alphabetic_Code' => 'BZD', 'ISO4217_Currency_Country_Name' => 'BELIZE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Belize Dollar', 'ISO4217_Currency_Numeric_Code' => '84', 'Is_Independent' => 'Yes', 'Capital' => 'Belmopan', 'Continent' => 'NA', 'TLD' => '.bz', 'Languages' => 'en-BZ,es', 'Geo_Name_ID' => '3582678', 'EDGAR' => 'D1'),
            24 => array('Country_Name' => 'Benin', 'Official_Name_English' => 'Benin', 'ISO3166_1_Alpha_2' => 'BJ', 'ISO3166_1_Alpha_3' => 'BEN', 'M49' => '204', 'ITU' => 'BEN', 'MARC' => 'dm', 'WMO' => 'BJ', 'DS' => 'DY', 'Dial' => '229', 'FIFA' => 'BEN', 'FIPS' => 'BN', 'GAUL' => '29', 'IOC' => 'BEN', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'BENIN', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Porto-Novo', 'Continent' => 'AF', 'TLD' => '.bj', 'Languages' => 'fr-BJ', 'Geo_Name_ID' => '2395170', 'EDGAR' => 'G6'),
            25 => array('Country_Name' => 'Bermuda', 'Official_Name_English' => 'Bermuda', 'ISO3166_1_Alpha_2' => 'BM', 'ISO3166_1_Alpha_3' => 'BMU', 'M49' => '060', 'ITU' => 'BER', 'MARC' => 'bm', 'WMO' => 'BE', 'DS' => 'BM', 'Dial' => '441', 'FIFA' => 'BER', 'FIPS' => 'BD', 'GAUL' => '30', 'IOC' => 'BER', 'ISO4217_Currency_Alphabetic_Code' => 'BMD', 'ISO4217_Currency_Country_Name' => 'BERMUDA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Bermudian Dollar', 'ISO4217_Currency_Numeric_Code' => '60', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Hamilton', 'Continent' => 'NA', 'TLD' => '.bm', 'Languages' => 'en-BM,pt', 'Geo_Name_ID' => '3573345', 'EDGAR' => 'D0'),
            26 => array('Country_Name' => 'Bhutan', 'Official_Name_English' => 'Bhutan', 'ISO3166_1_Alpha_2' => 'BT', 'ISO3166_1_Alpha_3' => 'BTN', 'M49' => '064', 'ITU' => 'BTN', 'MARC' => 'bt', 'WMO' => '', 'DS' => 'BT', 'Dial' => '975', 'FIFA' => 'BHU', 'FIPS' => 'BT', 'GAUL' => '31', 'IOC' => 'BHU', 'ISO4217_Currency_Alphabetic_Code' => 'INR', 'ISO4217_Currency_Country_Name' => 'BHUTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Indian Rupee', 'ISO4217_Currency_Numeric_Code' => '356', 'Is_Independent' => 'Yes', 'Capital' => 'Thimphu', 'Continent' => 'AS', 'TLD' => '.bt', 'Languages' => 'dz', 'Geo_Name_ID' => '1252634', 'EDGAR' => 'D2'),
            27 => array('Country_Name' => 'Bolivia', 'Official_Name_English' => 'Bolivia (Plurinational State of)', 'ISO3166_1_Alpha_2' => 'BO', 'ISO3166_1_Alpha_3' => 'BOL', 'M49' => '068', 'ITU' => 'BOL', 'MARC' => 'bo', 'WMO' => 'BO', 'DS' => 'BOL', 'Dial' => '591', 'FIFA' => 'BOL', 'FIPS' => 'BL', 'GAUL' => '33', 'IOC' => 'BOL', 'ISO4217_Currency_Alphabetic_Code' => 'BOB', 'ISO4217_Currency_Country_Name' => 'BOLIVIA, PLURINATIONAL STATE OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Boliviano', 'ISO4217_Currency_Numeric_Code' => '68', 'Is_Independent' => 'Yes', 'Capital' => 'Sucre', 'Continent' => 'SA', 'TLD' => '.bo', 'Languages' => 'es-BO,qu,ay', 'Geo_Name_ID' => '3923057', 'EDGAR' => ''),
            28 => array('Country_Name' => 'Bosnia', 'Official_Name_English' => 'Bosnia and Herzegovina', 'ISO3166_1_Alpha_2' => 'BA', 'ISO3166_1_Alpha_3' => 'BIH', 'M49' => '070', 'ITU' => 'BIH', 'MARC' => 'bn', 'WMO' => 'BG', 'DS' => 'BIH', 'Dial' => '387', 'FIFA' => 'BIH', 'FIPS' => 'BK', 'GAUL' => '34', 'IOC' => 'BIH', 'ISO4217_Currency_Alphabetic_Code' => 'BAM', 'ISO4217_Currency_Country_Name' => 'BOSNIA AND HERZEGOVINA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Convertible Mark', 'ISO4217_Currency_Numeric_Code' => '977', 'Is_Independent' => 'Yes', 'Capital' => 'Sarajevo', 'Continent' => 'EU', 'TLD' => '.ba', 'Languages' => 'bs,hr-BA,sr-BA', 'Geo_Name_ID' => '3277605', 'EDGAR' => '1E'),
            29 => array('Country_Name' => 'Botswana', 'Official_Name_English' => 'Botswana', 'ISO3166_1_Alpha_2' => 'BW', 'ISO3166_1_Alpha_3' => 'BWA', 'M49' => '072', 'ITU' => 'BOT', 'MARC' => 'bs', 'WMO' => 'BC', 'DS' => 'BW', 'Dial' => '267', 'FIFA' => 'BOT', 'FIPS' => 'BC', 'GAUL' => '35', 'IOC' => 'BOT', 'ISO4217_Currency_Alphabetic_Code' => 'BWP', 'ISO4217_Currency_Country_Name' => 'BOTSWANA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pula', 'ISO4217_Currency_Numeric_Code' => '72', 'Is_Independent' => 'Yes', 'Capital' => 'Gaborone', 'Continent' => 'AF', 'TLD' => '.bw', 'Languages' => 'en-BW,tn-BW', 'Geo_Name_ID' => '933860', 'EDGAR' => 'B1'),
            30 => array('Country_Name' => 'Bouvet Island', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'BV', 'ISO3166_1_Alpha_3' => 'BVT', 'M49' => '074', 'ITU' => '', 'MARC' => 'bv', 'WMO' => 'BV', 'DS' => 'BV', 'Dial' => '47', 'FIFA' => '', 'FIPS' => 'BV', 'GAUL' => '36', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of NO', 'Capital' => '', 'Continent' => 'AN', 'TLD' => '.bv', 'Languages' => '', 'Geo_Name_ID' => '3371123', 'EDGAR' => ''),
            31 => array('Country_Name' => 'Brazil', 'Official_Name_English' => 'Brazil', 'ISO3166_1_Alpha_2' => 'BR', 'ISO3166_1_Alpha_3' => 'BRA', 'M49' => '076', 'ITU' => 'B', 'MARC' => 'bl', 'WMO' => 'BZ', 'DS' => 'BR', 'Dial' => '55', 'FIFA' => 'BRA', 'FIPS' => 'BR', 'GAUL' => '37', 'IOC' => 'BRA', 'ISO4217_Currency_Alphabetic_Code' => 'BRL', 'ISO4217_Currency_Country_Name' => 'BRAZIL', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Brazilian Real', 'ISO4217_Currency_Numeric_Code' => '986', 'Is_Independent' => 'Yes', 'Capital' => 'Brasilia', 'Continent' => 'SA', 'TLD' => '.br', 'Languages' => 'pt-BR,es,en,fr', 'Geo_Name_ID' => '3469034', 'EDGAR' => 'D5'),
            32 => array('Country_Name' => 'British Indian Ocean Territory', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'IO', 'ISO3166_1_Alpha_3' => 'IOT', 'M49' => '086', 'ITU' => 'BIO', 'MARC' => 'bi', 'WMO' => '', 'DS' => '', 'Dial' => '246', 'FIFA' => '', 'FIPS' => 'IO', 'GAUL' => '38', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Diego Garcia', 'Continent' => 'AS', 'TLD' => '.io', 'Languages' => 'en-IO', 'Geo_Name_ID' => '1282588', 'EDGAR' => ''),
            33 => array('Country_Name' => 'British Virgin Islands', 'Official_Name_English' => 'British Virgin Islands', 'ISO3166_1_Alpha_2' => 'VG', 'ISO3166_1_Alpha_3' => 'VGB', 'M49' => '092', 'ITU' => 'VRG', 'MARC' => 'vb', 'WMO' => 'VI', 'DS' => 'BVI', 'Dial' => '284', 'FIFA' => 'VGB', 'FIPS' => 'VI', 'GAUL' => '39', 'IOC' => 'IVB', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'VIRGIN ISLANDS (BRITISH)', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Road Town', 'Continent' => 'NA', 'TLD' => '.vg', 'Languages' => 'en-VG', 'Geo_Name_ID' => '3577718', 'EDGAR' => ''),
            34 => array('Country_Name' => 'Brunei', 'Official_Name_English' => 'Brunei Darussalam', 'ISO3166_1_Alpha_2' => 'BN', 'ISO3166_1_Alpha_3' => 'BRN', 'M49' => '096', 'ITU' => 'BRU', 'MARC' => 'bx', 'WMO' => 'BD', 'DS' => 'BRU', 'Dial' => '673', 'FIFA' => 'BRU', 'FIPS' => 'BX', 'GAUL' => '40', 'IOC' => 'BRU', 'ISO4217_Currency_Alphabetic_Code' => 'BND', 'ISO4217_Currency_Country_Name' => 'BRUNEI DARUSSALAM', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Brunei Dollar', 'ISO4217_Currency_Numeric_Code' => '96', 'Is_Independent' => 'Yes', 'Capital' => 'Bandar Seri Begawan', 'Continent' => 'AS', 'TLD' => '.bn', 'Languages' => 'ms-BN,en-BN', 'Geo_Name_ID' => '1820814', 'EDGAR' => 'D9'),
            35 => array('Country_Name' => 'Bulgaria', 'Official_Name_English' => 'Bulgaria', 'ISO3166_1_Alpha_2' => 'BG', 'ISO3166_1_Alpha_3' => 'BGR', 'M49' => '100', 'ITU' => 'BUL', 'MARC' => 'bu', 'WMO' => 'BU', 'DS' => 'BG', 'Dial' => '359', 'FIFA' => 'BUL', 'FIPS' => 'BU', 'GAUL' => '41', 'IOC' => 'BUL', 'ISO4217_Currency_Alphabetic_Code' => 'BGN', 'ISO4217_Currency_Country_Name' => 'BULGARIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Bulgarian Lev', 'ISO4217_Currency_Numeric_Code' => '975', 'Is_Independent' => 'Yes', 'Capital' => 'Sofia', 'Continent' => 'EU', 'TLD' => '.bg', 'Languages' => 'bg,tr-BG,rom', 'Geo_Name_ID' => '732800', 'EDGAR' => 'E0'),
            36 => array('Country_Name' => 'Burkina Faso', 'Official_Name_English' => 'Burkina Faso', 'ISO3166_1_Alpha_2' => 'BF', 'ISO3166_1_Alpha_3' => 'BFA', 'M49' => '854', 'ITU' => 'BFA', 'MARC' => 'uv', 'WMO' => 'HV', 'DS' => 'BF', 'Dial' => '226', 'FIFA' => 'BFA', 'FIPS' => 'UV', 'GAUL' => '42', 'IOC' => 'BUR', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'BURKINA FASO', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Ouagadougou', 'Continent' => 'AF', 'TLD' => '.bf', 'Languages' => 'fr-BF', 'Geo_Name_ID' => '2361809', 'EDGAR' => 'X2'),
            37 => array('Country_Name' => 'Burundi', 'Official_Name_English' => 'Burundi', 'ISO3166_1_Alpha_2' => 'BI', 'ISO3166_1_Alpha_3' => 'BDI', 'M49' => '108', 'ITU' => 'BDI', 'MARC' => 'bd', 'WMO' => 'BI', 'DS' => 'RU', 'Dial' => '257', 'FIFA' => 'BDI', 'FIPS' => 'BY', 'GAUL' => '43', 'IOC' => 'BDI', 'ISO4217_Currency_Alphabetic_Code' => 'BIF', 'ISO4217_Currency_Country_Name' => 'BURUNDI', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Burundi Franc', 'ISO4217_Currency_Numeric_Code' => '108', 'Is_Independent' => 'Yes', 'Capital' => 'Bujumbura', 'Continent' => 'AF', 'TLD' => '.bi', 'Languages' => 'fr-BI,rn', 'Geo_Name_ID' => '433561', 'EDGAR' => 'E2'),
            38 => array('Country_Name' => 'Cambodia', 'Official_Name_English' => 'Cambodia', 'ISO3166_1_Alpha_2' => 'KH', 'ISO3166_1_Alpha_3' => 'KHM', 'M49' => '116', 'ITU' => 'CBG', 'MARC' => 'cb', 'WMO' => 'KP', 'DS' => 'K', 'Dial' => '855', 'FIFA' => 'CAM', 'FIPS' => 'CB', 'GAUL' => '44', 'IOC' => 'CAM', 'ISO4217_Currency_Alphabetic_Code' => 'KHR', 'ISO4217_Currency_Country_Name' => 'CAMBODIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Riel', 'ISO4217_Currency_Numeric_Code' => '116', 'Is_Independent' => 'Yes', 'Capital' => 'Phnom Penh', 'Continent' => 'AS', 'TLD' => '.kh', 'Languages' => 'km,fr,en', 'Geo_Name_ID' => '1831722', 'EDGAR' => 'E3'),
            39 => array('Country_Name' => 'Cameroon', 'Official_Name_English' => 'Cameroon', 'ISO3166_1_Alpha_2' => 'CM', 'ISO3166_1_Alpha_3' => 'CMR', 'M49' => '120', 'ITU' => 'CME', 'MARC' => 'cm', 'WMO' => 'CM', 'DS' => 'CAM', 'Dial' => '237', 'FIFA' => 'CMR', 'FIPS' => 'CM', 'GAUL' => '45', 'IOC' => 'CMR', 'ISO4217_Currency_Alphabetic_Code' => 'XAF', 'ISO4217_Currency_Country_Name' => 'CAMEROON', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BEAC', 'ISO4217_Currency_Numeric_Code' => '950', 'Is_Independent' => 'Yes', 'Capital' => 'Yaounde', 'Continent' => 'AF', 'TLD' => '.cm', 'Languages' => 'en-CM,fr-CM', 'Geo_Name_ID' => '2233387', 'EDGAR' => 'E4'),
            40 => array('Country_Name' => 'Canada', 'Official_Name_English' => 'Canada', 'ISO3166_1_Alpha_2' => 'CA', 'ISO3166_1_Alpha_3' => 'CAN', 'M49' => '124', 'ITU' => 'CAN', 'MARC' => 'xxc', 'WMO' => 'CN', 'DS' => 'CDN', 'Dial' => '1', 'FIFA' => 'CAN', 'FIPS' => 'CA', 'GAUL' => '46', 'IOC' => 'CAN', 'ISO4217_Currency_Alphabetic_Code' => 'CAD', 'ISO4217_Currency_Country_Name' => 'CANADA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Canadian Dollar', 'ISO4217_Currency_Numeric_Code' => '124', 'Is_Independent' => 'Yes', 'Capital' => 'Ottawa', 'Continent' => 'NA', 'TLD' => '.ca', 'Languages' => 'en-CA,fr-CA,iu', 'Geo_Name_ID' => '6251999', 'EDGAR' => ''),
            41 => array('Country_Name' => 'Cape Verde', 'Official_Name_English' => 'Cabo Verde', 'ISO3166_1_Alpha_2' => 'CV', 'ISO3166_1_Alpha_3' => 'CPV', 'M49' => '132', 'ITU' => 'CPV', 'MARC' => 'cv', 'WMO' => 'CV', 'DS' => 'CV', 'Dial' => '238', 'FIFA' => 'CPV', 'FIPS' => 'CV', 'GAUL' => '47', 'IOC' => 'CPV', 'ISO4217_Currency_Alphabetic_Code' => 'CVE', 'ISO4217_Currency_Country_Name' => 'CABO VERDE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Cabo Verde Escudo', 'ISO4217_Currency_Numeric_Code' => '132', 'Is_Independent' => 'Yes', 'Capital' => 'Praia', 'Continent' => 'AF', 'TLD' => '.cv', 'Languages' => 'pt-CV', 'Geo_Name_ID' => '3374766', 'EDGAR' => ''),
            42 => array('Country_Name' => 'Caribbean Netherlands', 'Official_Name_English' => 'Bonaire, Sint Eustatius and Saba', 'ISO3166_1_Alpha_2' => 'BQ', 'ISO3166_1_Alpha_3' => 'BES', 'M49' => '535', 'ITU' => 'ATN', 'MARC' => 'ca', 'WMO' => 'NU', 'DS' => 'NA', 'Dial' => '599', 'FIFA' => 'ANT', 'FIPS' => 'NL', 'GAUL' => '176', 'IOC' => 'AHO', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'BONAIRE, SINT EUSTATIUS AND SABA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Part of NL', 'Capital' => '', 'Continent' => 'NA', 'TLD' => '.bq', 'Languages' => 'nl,pap,en', 'Geo_Name_ID' => '7626844', 'EDGAR' => ''),
            43 => array('Country_Name' => 'Cayman Islands', 'Official_Name_English' => 'Cayman Islands', 'ISO3166_1_Alpha_2' => 'KY', 'ISO3166_1_Alpha_3' => 'CYM', 'M49' => '136', 'ITU' => 'CYM', 'MARC' => 'cj', 'WMO' => 'GC', 'DS' => 'KY', 'Dial' => '345', 'FIFA' => 'CAY', 'FIPS' => 'CJ', 'GAUL' => '48', 'IOC' => 'CAY', 'ISO4217_Currency_Alphabetic_Code' => 'KYD', 'ISO4217_Currency_Country_Name' => 'CAYMAN ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Cayman Islands Dollar', 'ISO4217_Currency_Numeric_Code' => '136', 'Is_Independent' => 'Territory of GB', 'Capital' => 'George Town', 'Continent' => 'NA', 'TLD' => '.ky', 'Languages' => 'en-KY', 'Geo_Name_ID' => '3580718', 'EDGAR' => 'E9'),
            44 => array('Country_Name' => 'Central African Republic', 'Official_Name_English' => 'Central African Republic', 'ISO3166_1_Alpha_2' => 'CF', 'ISO3166_1_Alpha_3' => 'CAF', 'M49' => '140', 'ITU' => 'CAF', 'MARC' => 'cx', 'WMO' => 'CE', 'DS' => 'RCA', 'Dial' => '236', 'FIFA' => 'CTA', 'FIPS' => 'CT', 'GAUL' => '49', 'IOC' => 'CAF', 'ISO4217_Currency_Alphabetic_Code' => 'XAF', 'ISO4217_Currency_Country_Name' => 'CENTRAL AFRICAN REPUBLIC', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BEAC', 'ISO4217_Currency_Numeric_Code' => '950', 'Is_Independent' => 'Yes', 'Capital' => 'Bangui', 'Continent' => 'AF', 'TLD' => '.cf', 'Languages' => 'fr-CF,sg,ln,kg', 'Geo_Name_ID' => '239880', 'EDGAR' => 'F0'),
            45 => array('Country_Name' => 'Chad', 'Official_Name_English' => 'Chad', 'ISO3166_1_Alpha_2' => 'TD', 'ISO3166_1_Alpha_3' => 'TCD', 'M49' => '148', 'ITU' => 'TCD', 'MARC' => 'cd', 'WMO' => 'CD', 'DS' => 'TCH', 'Dial' => '235', 'FIFA' => 'CHA', 'FIPS' => 'CD', 'GAUL' => '50', 'IOC' => 'CHA', 'ISO4217_Currency_Alphabetic_Code' => 'XAF', 'ISO4217_Currency_Country_Name' => 'CHAD', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BEAC', 'ISO4217_Currency_Numeric_Code' => '950', 'Is_Independent' => 'Yes', 'Capital' => 'N\'Djamena', 'Continent' => 'AF', 'TLD' => '.td', 'Languages' => 'fr-TD,ar-TD,sre', 'Geo_Name_ID' => '2434508', 'EDGAR' => 'F2'),
            46 => array('Country_Name' => 'Chile', 'Official_Name_English' => 'Chile', 'ISO3166_1_Alpha_2' => 'CL', 'ISO3166_1_Alpha_3' => 'CHL', 'M49' => '152', 'ITU' => 'CHL', 'MARC' => 'cl', 'WMO' => 'CH', 'DS' => 'RCH', 'Dial' => '56', 'FIFA' => 'CHI', 'FIPS' => 'CI', 'GAUL' => '51', 'IOC' => 'CHI', 'ISO4217_Currency_Alphabetic_Code' => 'CLP', 'ISO4217_Currency_Country_Name' => 'CHILE', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Chilean Peso', 'ISO4217_Currency_Numeric_Code' => '152', 'Is_Independent' => 'Yes', 'Capital' => 'Santiago', 'Continent' => 'SA', 'TLD' => '.cl', 'Languages' => 'es-CL', 'Geo_Name_ID' => '3895114', 'EDGAR' => 'F3'),
            47 => array('Country_Name' => 'China', 'Official_Name_English' => 'China', 'ISO3166_1_Alpha_2' => 'CN', 'ISO3166_1_Alpha_3' => 'CHN', 'M49' => '156', 'ITU' => 'CHN', 'MARC' => 'cc', 'WMO' => 'CI', 'DS' => 'CN', 'Dial' => '86', 'FIFA' => 'CHN', 'FIPS' => 'CH', 'GAUL' => '53', 'IOC' => 'CHN', 'ISO4217_Currency_Alphabetic_Code' => 'CNY', 'ISO4217_Currency_Country_Name' => 'CHINA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Yuan Renminbi', 'ISO4217_Currency_Numeric_Code' => '156', 'Is_Independent' => 'Yes', 'Capital' => 'Beijing', 'Continent' => 'AS', 'TLD' => '.cn', 'Languages' => 'zh-CN,yue,wuu,dta,ug,za', 'Geo_Name_ID' => '1814991', 'EDGAR' => 'F4'),
            48 => array('Country_Name' => 'Christmas Island', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'CX', 'ISO3166_1_Alpha_3' => 'CXR', 'M49' => '162', 'ITU' => 'CHR', 'MARC' => 'xa', 'WMO' => 'KI', 'DS' => 'AUS', 'Dial' => '61', 'FIFA' => 'CXR', 'FIPS' => 'KT', 'GAUL' => '54', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of AU', 'Capital' => 'Flying Fish Cove', 'Continent' => 'AS', 'TLD' => '.cx', 'Languages' => 'en,zh,ms-CC', 'Geo_Name_ID' => '2078138', 'EDGAR' => ''),
            49 => array('Country_Name' => 'Cocos (Keeling) Islands', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'CC', 'ISO3166_1_Alpha_3' => 'CCK', 'M49' => '166', 'ITU' => 'ICO', 'MARC' => 'xb', 'WMO' => 'KK', 'DS' => 'AUS', 'Dial' => '61', 'FIFA' => 'CCK', 'FIPS' => 'CK', 'GAUL' => '56', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of AU', 'Capital' => 'West Island', 'Continent' => 'AS', 'TLD' => '.cc', 'Languages' => 'ms-CC,en', 'Geo_Name_ID' => '1547376', 'EDGAR' => ''),
            50 => array('Country_Name' => 'Colombia', 'Official_Name_English' => 'Colombia', 'ISO3166_1_Alpha_2' => 'CO', 'ISO3166_1_Alpha_3' => 'COL', 'M49' => '170', 'ITU' => 'CLM', 'MARC' => 'ck', 'WMO' => 'CO', 'DS' => 'CO', 'Dial' => '57', 'FIFA' => 'COL', 'FIPS' => 'CO', 'GAUL' => '57', 'IOC' => 'COL', 'ISO4217_Currency_Alphabetic_Code' => 'COP', 'ISO4217_Currency_Country_Name' => 'COLOMBIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Colombian Peso', 'ISO4217_Currency_Numeric_Code' => '170', 'Is_Independent' => 'Yes', 'Capital' => 'Bogota', 'Continent' => 'SA', 'TLD' => '.co', 'Languages' => 'es-CO', 'Geo_Name_ID' => '3686110', 'EDGAR' => 'F8'),
            51 => array('Country_Name' => 'Comoros', 'Official_Name_English' => 'Comoros', 'ISO3166_1_Alpha_2' => 'KM', 'ISO3166_1_Alpha_3' => 'COM', 'M49' => '174', 'ITU' => 'COM', 'MARC' => 'cq', 'WMO' => 'IC', 'DS' => 'KM', 'Dial' => '269', 'FIFA' => 'COM', 'FIPS' => 'CN', 'GAUL' => '58', 'IOC' => 'COM', 'ISO4217_Currency_Alphabetic_Code' => 'KMF', 'ISO4217_Currency_Country_Name' => 'COMOROS', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Comoro Franc', 'ISO4217_Currency_Numeric_Code' => '174', 'Is_Independent' => 'Yes', 'Capital' => 'Moroni', 'Continent' => 'AF', 'TLD' => '.km', 'Languages' => 'ar,fr-KM', 'Geo_Name_ID' => '921929', 'EDGAR' => 'F9'),
            52 => array('Country_Name' => 'Congo - Brazzaville', 'Official_Name_English' => 'Congo', 'ISO3166_1_Alpha_2' => 'CG', 'ISO3166_1_Alpha_3' => 'COG', 'M49' => '178', 'ITU' => 'COG', 'MARC' => 'cf', 'WMO' => 'CG', 'DS' => 'RCB', 'Dial' => '242', 'FIFA' => 'CGO', 'FIPS' => 'CF', 'GAUL' => '59', 'IOC' => 'CGO', 'ISO4217_Currency_Alphabetic_Code' => 'XAF', 'ISO4217_Currency_Country_Name' => 'CONGO', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BEAC', 'ISO4217_Currency_Numeric_Code' => '950', 'Is_Independent' => 'Yes', 'Capital' => 'Brazzaville', 'Continent' => 'AF', 'TLD' => '.cg', 'Languages' => 'fr-CG,kg,ln-CG', 'Geo_Name_ID' => '2260494', 'EDGAR' => 'G0'),
            53 => array('Country_Name' => 'Congo - Kinshasa', 'Official_Name_English' => 'Democratic Republic of the Congo', 'ISO3166_1_Alpha_2' => 'CD', 'ISO3166_1_Alpha_3' => 'COD', 'M49' => '180', 'ITU' => 'COD', 'MARC' => 'cg', 'WMO' => 'ZR', 'DS' => 'ZRE', 'Dial' => '243', 'FIFA' => 'COD', 'FIPS' => 'CG', 'GAUL' => '68', 'IOC' => 'COD', 'ISO4217_Currency_Alphabetic_Code' => 'COD', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => 'COD', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Yes', 'Capital' => 'Kinshasa', 'Continent' => 'AF', 'TLD' => '.cd', 'Languages' => 'fr-CD,ln,kg', 'Geo_Name_ID' => '203312', 'EDGAR' => ''),
            54 => array('Country_Name' => 'Cook Islands', 'Official_Name_English' => 'Cook Islands', 'ISO3166_1_Alpha_2' => 'CK', 'ISO3166_1_Alpha_3' => 'COK', 'M49' => '184', 'ITU' => 'CKH', 'MARC' => 'cw', 'WMO' => 'KU', 'DS' => 'NZ', 'Dial' => '682', 'FIFA' => 'COK', 'FIPS' => 'CW', 'GAUL' => '60', 'IOC' => 'COK', 'ISO4217_Currency_Alphabetic_Code' => 'NZD', 'ISO4217_Currency_Country_Name' => 'COOK ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Zealand Dollar', 'ISO4217_Currency_Numeric_Code' => '554', 'Is_Independent' => 'Associated with NZ', 'Capital' => 'Avarua', 'Continent' => 'OC', 'TLD' => '.ck', 'Languages' => 'en-CK,mi', 'Geo_Name_ID' => '1899402', 'EDGAR' => 'G1'),
            55 => array('Country_Name' => 'Costa Rica', 'Official_Name_English' => 'Costa Rica', 'ISO3166_1_Alpha_2' => 'CR', 'ISO3166_1_Alpha_3' => 'CRI', 'M49' => '188', 'ITU' => 'CTR', 'MARC' => 'cr', 'WMO' => 'CS', 'DS' => 'CR', 'Dial' => '506', 'FIFA' => 'CRC', 'FIPS' => 'CS', 'GAUL' => '61', 'IOC' => 'CRC', 'ISO4217_Currency_Alphabetic_Code' => 'CRC', 'ISO4217_Currency_Country_Name' => 'COSTA RICA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Costa Rican Colon', 'ISO4217_Currency_Numeric_Code' => '188', 'Is_Independent' => 'Yes', 'Capital' => 'San Jose', 'Continent' => 'NA', 'TLD' => '.cr', 'Languages' => 'es-CR,en', 'Geo_Name_ID' => '3624060', 'EDGAR' => 'G2'),
            56 => array('Country_Name' => 'Croatia', 'Official_Name_English' => 'Croatia', 'ISO3166_1_Alpha_2' => 'HR', 'ISO3166_1_Alpha_3' => 'HRV', 'M49' => '191', 'ITU' => 'HRV', 'MARC' => 'ci', 'WMO' => 'RH', 'DS' => 'HR', 'Dial' => '385', 'FIFA' => 'CRO', 'FIPS' => 'HR', 'GAUL' => '62', 'IOC' => 'CRO', 'ISO4217_Currency_Alphabetic_Code' => 'HRK', 'ISO4217_Currency_Country_Name' => 'CROATIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Croatian Kuna', 'ISO4217_Currency_Numeric_Code' => '191', 'Is_Independent' => 'Yes', 'Capital' => 'Zagreb', 'Continent' => 'EU', 'TLD' => '.hr', 'Languages' => 'hr-HR,sr', 'Geo_Name_ID' => '3202326', 'EDGAR' => '1M'),
            57 => array('Country_Name' => 'Cuba', 'Official_Name_English' => 'Cuba', 'ISO3166_1_Alpha_2' => 'CU', 'ISO3166_1_Alpha_3' => 'CUB', 'M49' => '192', 'ITU' => 'CUB', 'MARC' => 'cu', 'WMO' => 'CU', 'DS' => 'C', 'Dial' => '53', 'FIFA' => 'CUB', 'FIPS' => 'CU', 'GAUL' => '63', 'IOC' => 'CUB', 'ISO4217_Currency_Alphabetic_Code' => 'CUP', 'ISO4217_Currency_Country_Name' => 'CUBA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Cuban Peso', 'ISO4217_Currency_Numeric_Code' => '192', 'Is_Independent' => 'Yes', 'Capital' => 'Havana', 'Continent' => 'NA', 'TLD' => '.cu', 'Languages' => 'es-CU', 'Geo_Name_ID' => '3562981', 'EDGAR' => 'G3'),
            58 => array('Country_Name' => 'Curaçao', 'Official_Name_English' => 'Curaçao', 'ISO3166_1_Alpha_2' => 'CW', 'ISO3166_1_Alpha_3' => 'CUW', 'M49' => '531', 'ITU' => '', 'MARC' => 'co', 'WMO' => '', 'DS' => '', 'Dial' => '599', 'FIFA' => '', 'FIPS' => 'UC', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'ANG', 'ISO4217_Currency_Country_Name' => 'CURAÇAO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Netherlands Antillean Guilder', 'ISO4217_Currency_Numeric_Code' => '532', 'Is_Independent' => 'Part of NL', 'Capital' => 'Willemstad', 'Continent' => 'NA', 'TLD' => '.cw', 'Languages' => 'nl,pap', 'Geo_Name_ID' => '7626836', 'EDGAR' => ''),
            59 => array('Country_Name' => 'Cyprus', 'Official_Name_English' => 'Cyprus', 'ISO3166_1_Alpha_2' => 'CY', 'ISO3166_1_Alpha_3' => 'CYP', 'M49' => '196', 'ITU' => 'CYP', 'MARC' => 'cy', 'WMO' => 'CY', 'DS' => 'CY', 'Dial' => '357', 'FIFA' => 'CYP', 'FIPS' => 'CY', 'GAUL' => '64', 'IOC' => 'CYP', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'CYPRUS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Nicosia', 'Continent' => 'EU', 'TLD' => '.cy', 'Languages' => 'el-CY,tr-CY,en', 'Geo_Name_ID' => '146669', 'EDGAR' => 'G4'),
            60 => array('Country_Name' => 'Czech Republic', 'Official_Name_English' => 'Czechia', 'ISO3166_1_Alpha_2' => 'CZ', 'ISO3166_1_Alpha_3' => 'CZE', 'M49' => '203', 'ITU' => 'CZE', 'MARC' => 'xr', 'WMO' => 'CZ', 'DS' => 'CZ', 'Dial' => '420', 'FIFA' => 'CZE', 'FIPS' => 'EZ', 'GAUL' => '65', 'IOC' => 'CZE', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Yes', 'Capital' => 'Prague', 'Continent' => 'EU', 'TLD' => '.cz', 'Languages' => 'cs,sk', 'Geo_Name_ID' => '3077311', 'EDGAR' => ''),
            61 => array('Country_Name' => 'Côte d\'Ivoire', 'Official_Name_English' => 'Côte d\'Ivoire', 'ISO3166_1_Alpha_2' => 'CI', 'ISO3166_1_Alpha_3' => 'CIV', 'M49' => '384', 'ITU' => 'CTI', 'MARC' => 'iv', 'WMO' => 'IV', 'DS' => 'CI', 'Dial' => '225', 'FIFA' => 'CIV', 'FIPS' => 'IV', 'GAUL' => '66', 'IOC' => 'CIV', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'CÔTE D\'IVOIRE', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Yamoussoukro', 'Continent' => 'AF', 'TLD' => '.ci', 'Languages' => 'fr-CI', 'Geo_Name_ID' => '2287781', 'EDGAR' => ''),
            62 => array('Country_Name' => 'Denmark', 'Official_Name_English' => 'Denmark', 'ISO3166_1_Alpha_2' => 'DK', 'ISO3166_1_Alpha_3' => 'DNK', 'M49' => '208', 'ITU' => 'DNK', 'MARC' => 'dk', 'WMO' => 'DN', 'DS' => 'DK', 'Dial' => '45', 'FIFA' => 'DEN', 'FIPS' => 'DA', 'GAUL' => '69', 'IOC' => 'DEN', 'ISO4217_Currency_Alphabetic_Code' => 'DKK', 'ISO4217_Currency_Country_Name' => 'DENMARK', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Danish Krone', 'ISO4217_Currency_Numeric_Code' => '208', 'Is_Independent' => 'Yes', 'Capital' => 'Copenhagen', 'Continent' => 'EU', 'TLD' => '.dk', 'Languages' => 'da-DK,en,fo,de-DK', 'Geo_Name_ID' => '2623032', 'EDGAR' => 'G7'),
            63 => array('Country_Name' => 'Djibouti', 'Official_Name_English' => 'Djibouti', 'ISO3166_1_Alpha_2' => 'DJ', 'ISO3166_1_Alpha_3' => 'DJI', 'M49' => '262', 'ITU' => 'DJI', 'MARC' => 'ft', 'WMO' => 'DJ', 'DS' => 'F', 'Dial' => '253', 'FIFA' => 'DJI', 'FIPS' => 'DJ', 'GAUL' => '70', 'IOC' => 'DJI', 'ISO4217_Currency_Alphabetic_Code' => 'DJF', 'ISO4217_Currency_Country_Name' => 'DJIBOUTI', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Djibouti Franc', 'ISO4217_Currency_Numeric_Code' => '262', 'Is_Independent' => 'Yes', 'Capital' => 'Djibouti', 'Continent' => 'AF', 'TLD' => '.dj', 'Languages' => 'fr-DJ,ar,so-DJ,aa', 'Geo_Name_ID' => '223816', 'EDGAR' => '1G'),
            64 => array('Country_Name' => 'Dominica', 'Official_Name_English' => 'Dominica', 'ISO3166_1_Alpha_2' => 'DM', 'ISO3166_1_Alpha_3' => 'DMA', 'M49' => '212', 'ITU' => 'DMA', 'MARC' => 'dq', 'WMO' => 'DO', 'DS' => 'WD', 'Dial' => '767', 'FIFA' => 'DMA', 'FIPS' => 'DO', 'GAUL' => '71', 'IOC' => 'DMA', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'DOMINICA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Yes', 'Capital' => 'Roseau', 'Continent' => 'NA', 'TLD' => '.dm', 'Languages' => 'en-DM', 'Geo_Name_ID' => '3575830', 'EDGAR' => 'G9'),
            65 => array('Country_Name' => 'Dominican Republic', 'Official_Name_English' => 'Dominican Republic', 'ISO3166_1_Alpha_2' => 'DO', 'ISO3166_1_Alpha_3' => 'DOM', 'M49' => '214', 'ITU' => 'DOM', 'MARC' => 'dr', 'WMO' => 'DR', 'DS' => 'DOM', 'Dial' => '809', 'FIFA' => 'DOM', 'FIPS' => 'DR', 'GAUL' => '72', 'IOC' => 'DOM', 'ISO4217_Currency_Alphabetic_Code' => 'DOP', 'ISO4217_Currency_Country_Name' => 'DOMINICAN REPUBLIC', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Dominican Peso', 'ISO4217_Currency_Numeric_Code' => '214', 'Is_Independent' => 'Yes', 'Capital' => 'Santo Domingo', 'Continent' => 'NA', 'TLD' => '.do', 'Languages' => 'es-DO', 'Geo_Name_ID' => '3508796', 'EDGAR' => 'G8'),
            66 => array('Country_Name' => 'Ecuador', 'Official_Name_English' => 'Ecuador', 'ISO3166_1_Alpha_2' => 'EC', 'ISO3166_1_Alpha_3' => 'ECU', 'M49' => '218', 'ITU' => 'EQA', 'MARC' => 'ec', 'WMO' => 'EQ', 'DS' => 'EC', 'Dial' => '593', 'FIFA' => 'ECU', 'FIPS' => 'EC', 'GAUL' => '73', 'IOC' => 'ECU', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'ECUADOR', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Quito', 'Continent' => 'SA', 'TLD' => '.ec', 'Languages' => 'es-EC', 'Geo_Name_ID' => '3658394', 'EDGAR' => 'H1'),
            67 => array('Country_Name' => 'Egypt', 'Official_Name_English' => 'Egypt', 'ISO3166_1_Alpha_2' => 'EG', 'ISO3166_1_Alpha_3' => 'EGY', 'M49' => '818', 'ITU' => 'EGY', 'MARC' => 'ua', 'WMO' => 'EG', 'DS' => 'ET', 'Dial' => '20', 'FIFA' => 'EGY', 'FIPS' => 'EG', 'GAUL' => '40765', 'IOC' => 'EGY', 'ISO4217_Currency_Alphabetic_Code' => 'EGP', 'ISO4217_Currency_Country_Name' => 'EGYPT', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Egyptian Pound', 'ISO4217_Currency_Numeric_Code' => '818', 'Is_Independent' => 'Yes', 'Capital' => 'Cairo', 'Continent' => 'AF', 'TLD' => '.eg', 'Languages' => 'ar-EG,en,fr', 'Geo_Name_ID' => '357994', 'EDGAR' => 'H2'),
            68 => array('Country_Name' => 'El Salvador', 'Official_Name_English' => 'El Salvador', 'ISO3166_1_Alpha_2' => 'SV', 'ISO3166_1_Alpha_3' => 'SLV', 'M49' => '222', 'ITU' => 'SLV', 'MARC' => 'es', 'WMO' => 'ES', 'DS' => 'ES', 'Dial' => '503', 'FIFA' => 'SLV', 'FIPS' => 'ES', 'GAUL' => '75', 'IOC' => 'ESA', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'EL SALVADOR', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'San Salvador', 'Continent' => 'NA', 'TLD' => '.sv', 'Languages' => 'es-SV', 'Geo_Name_ID' => '3585968', 'EDGAR' => 'H3'),
            69 => array('Country_Name' => 'Equatorial Guinea', 'Official_Name_English' => 'Equatorial Guinea', 'ISO3166_1_Alpha_2' => 'GQ', 'ISO3166_1_Alpha_3' => 'GNQ', 'M49' => '226', 'ITU' => 'GNE', 'MARC' => 'eg', 'WMO' => 'GQ', 'DS' => 'EQ', 'Dial' => '240', 'FIFA' => 'EQG', 'FIPS' => 'EK', 'GAUL' => '76', 'IOC' => 'GEQ', 'ISO4217_Currency_Alphabetic_Code' => 'XAF', 'ISO4217_Currency_Country_Name' => 'EQUATORIAL GUINEA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BEAC', 'ISO4217_Currency_Numeric_Code' => '950', 'Is_Independent' => 'Yes', 'Capital' => 'Malabo', 'Continent' => 'AF', 'TLD' => '.gq', 'Languages' => 'es-GQ,fr', 'Geo_Name_ID' => '2309096', 'EDGAR' => 'H4'),
            70 => array('Country_Name' => 'Eritrea', 'Official_Name_English' => 'Eritrea', 'ISO3166_1_Alpha_2' => 'ER', 'ISO3166_1_Alpha_3' => 'ERI', 'M49' => '232', 'ITU' => 'ERI', 'MARC' => 'ea', 'WMO' => '', 'DS' => 'ER', 'Dial' => '291', 'FIFA' => 'ERI', 'FIPS' => 'ER', 'GAUL' => '77', 'IOC' => 'ERI', 'ISO4217_Currency_Alphabetic_Code' => 'ERN', 'ISO4217_Currency_Country_Name' => 'ERITREA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Nakfa', 'ISO4217_Currency_Numeric_Code' => '232', 'Is_Independent' => 'Yes', 'Capital' => 'Asmara', 'Continent' => 'AF', 'TLD' => '.er', 'Languages' => 'aa-ER,ar,tig,kun,ti-ER', 'Geo_Name_ID' => '338010', 'EDGAR' => '1J'),
            71 => array('Country_Name' => 'Estonia', 'Official_Name_English' => 'Estonia', 'ISO3166_1_Alpha_2' => 'EE', 'ISO3166_1_Alpha_3' => 'EST', 'M49' => '233', 'ITU' => 'EST', 'MARC' => 'er', 'WMO' => 'EO', 'DS' => 'EST', 'Dial' => '372', 'FIFA' => 'EST', 'FIPS' => 'EN', 'GAUL' => '78', 'IOC' => 'EST', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'ESTONIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Tallinn', 'Continent' => 'EU', 'TLD' => '.ee', 'Languages' => 'et,ru', 'Geo_Name_ID' => '453733', 'EDGAR' => '1H'),
            72 => array('Country_Name' => 'Ethiopia', 'Official_Name_English' => 'Ethiopia', 'ISO3166_1_Alpha_2' => 'ET', 'ISO3166_1_Alpha_3' => 'ETH', 'M49' => '231', 'ITU' => 'ETH', 'MARC' => 'et', 'WMO' => 'ET', 'DS' => 'ETH', 'Dial' => '251', 'FIFA' => 'ETH', 'FIPS' => 'ET', 'GAUL' => '79', 'IOC' => 'ETH', 'ISO4217_Currency_Alphabetic_Code' => 'ETB', 'ISO4217_Currency_Country_Name' => 'ETHIOPIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Ethiopian Birr', 'ISO4217_Currency_Numeric_Code' => '230', 'Is_Independent' => 'Yes', 'Capital' => 'Addis Ababa', 'Continent' => 'AF', 'TLD' => '.et', 'Languages' => 'am,en-ET,om-ET,ti-ET,so-ET,sid', 'Geo_Name_ID' => '337996', 'EDGAR' => 'H5'),
            73 => array('Country_Name' => 'Falkland Islands', 'Official_Name_English' => 'Falkland Islands (Malvinas)', 'ISO3166_1_Alpha_2' => 'FK', 'ISO3166_1_Alpha_3' => 'FLK', 'M49' => '238', 'ITU' => 'FLK', 'MARC' => 'fk', 'WMO' => 'FK', 'DS' => '', 'Dial' => '500', 'FIFA' => 'FLK', 'FIPS' => 'FK', 'GAUL' => '81', 'IOC' => 'FLK', 'ISO4217_Currency_Alphabetic_Code' => 'FKP', 'ISO4217_Currency_Country_Name' => 'FALKLAND ISLANDS (MALVINAS)', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Falkland Islands Pound', 'ISO4217_Currency_Numeric_Code' => '238', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Stanley', 'Continent' => 'SA', 'TLD' => '.fk', 'Languages' => 'en-FK', 'Geo_Name_ID' => '3474414', 'EDGAR' => 'H7'),
            74 => array('Country_Name' => 'Faroe Islands', 'Official_Name_English' => 'Faeroe Islands', 'ISO3166_1_Alpha_2' => 'FO', 'ISO3166_1_Alpha_3' => 'FRO', 'M49' => '234', 'ITU' => 'FRO', 'MARC' => 'fa', 'WMO' => 'FA', 'DS' => 'FO', 'Dial' => '298', 'FIFA' => 'FRO', 'FIPS' => 'FO', 'GAUL' => '82', 'IOC' => 'FAR', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Part of DK', 'Capital' => 'Torshavn', 'Continent' => 'EU', 'TLD' => '.fo', 'Languages' => 'fo,da-FO', 'Geo_Name_ID' => '2622320', 'EDGAR' => ''),
            75 => array('Country_Name' => 'Fiji', 'Official_Name_English' => 'Fiji', 'ISO3166_1_Alpha_2' => 'FJ', 'ISO3166_1_Alpha_3' => 'FJI', 'M49' => '242', 'ITU' => 'FJI', 'MARC' => 'fj', 'WMO' => 'FJ', 'DS' => 'FJI', 'Dial' => '679', 'FIFA' => 'FIJ', 'FIPS' => 'FJ', 'GAUL' => '83', 'IOC' => 'FIJ', 'ISO4217_Currency_Alphabetic_Code' => 'FJD', 'ISO4217_Currency_Country_Name' => 'FIJI', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Fiji Dollar', 'ISO4217_Currency_Numeric_Code' => '242', 'Is_Independent' => 'Yes', 'Capital' => 'Suva', 'Continent' => 'OC', 'TLD' => '.fj', 'Languages' => 'en-FJ,fj', 'Geo_Name_ID' => '2205218', 'EDGAR' => 'H8'),
            76 => array('Country_Name' => 'Finland', 'Official_Name_English' => 'Finland', 'ISO3166_1_Alpha_2' => 'FI', 'ISO3166_1_Alpha_3' => 'FIN', 'M49' => '246', 'ITU' => 'FIN', 'MARC' => 'fi', 'WMO' => 'FI', 'DS' => 'FIN', 'Dial' => '358', 'FIFA' => 'FIN', 'FIPS' => 'FI', 'GAUL' => '84', 'IOC' => 'FIN', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'FINLAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Helsinki', 'Continent' => 'EU', 'TLD' => '.fi', 'Languages' => 'fi-FI,sv-FI,smn', 'Geo_Name_ID' => '660013', 'EDGAR' => 'H9'),
            77 => array('Country_Name' => 'France', 'Official_Name_English' => 'France', 'ISO3166_1_Alpha_2' => 'FR', 'ISO3166_1_Alpha_3' => 'FRA', 'M49' => '250', 'ITU' => 'F', 'MARC' => 'fr', 'WMO' => 'FR', 'DS' => 'F', 'Dial' => '33', 'FIFA' => 'FRA', 'FIPS' => 'FR', 'GAUL' => '85', 'IOC' => 'FRA', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'FRANCE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Paris', 'Continent' => 'EU', 'TLD' => '.fr', 'Languages' => 'fr-FR,frp,br,co,ca,eu,oc', 'Geo_Name_ID' => '3017382', 'EDGAR' => 'I0'),
            78 => array('Country_Name' => 'French Guiana', 'Official_Name_English' => 'French Guiana', 'ISO3166_1_Alpha_2' => 'GF', 'ISO3166_1_Alpha_3' => 'GUF', 'M49' => '254', 'ITU' => 'GUF', 'MARC' => 'fg', 'WMO' => 'FG', 'DS' => 'F', 'Dial' => '594', 'FIFA' => 'GUF', 'FIPS' => 'FG', 'GAUL' => '86', 'IOC' => 'FGU', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'FRENCH GUIANA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Cayenne', 'Continent' => 'SA', 'TLD' => '.gf', 'Languages' => 'fr-GF', 'Geo_Name_ID' => '3381670', 'EDGAR' => 'I3'),
            79 => array('Country_Name' => 'French Polynesia', 'Official_Name_English' => 'French Polynesia', 'ISO3166_1_Alpha_2' => 'PF', 'ISO3166_1_Alpha_3' => 'PYF', 'M49' => '258', 'ITU' => 'OCE', 'MARC' => 'fp', 'WMO' => 'PF', 'DS' => 'F', 'Dial' => '689', 'FIFA' => 'TAH', 'FIPS' => 'FP', 'GAUL' => '87', 'IOC' => 'FPO', 'ISO4217_Currency_Alphabetic_Code' => 'XPF', 'ISO4217_Currency_Country_Name' => 'FRENCH POLYNESIA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFP Franc', 'ISO4217_Currency_Numeric_Code' => '953', 'Is_Independent' => 'Territory of FR', 'Capital' => 'Papeete', 'Continent' => 'OC', 'TLD' => '.pf', 'Languages' => 'fr-PF,ty', 'Geo_Name_ID' => '4030656', 'EDGAR' => 'I4'),
            80 => array('Country_Name' => 'French Southern Territories', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'TF', 'ISO3166_1_Alpha_3' => 'ATF', 'M49' => '260', 'ITU' => '', 'MARC' => 'fs', 'WMO' => '', 'DS' => 'F', 'Dial' => '262', 'FIFA' => '', 'FIPS' => 'FS', 'GAUL' => '88', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of FR', 'Capital' => 'Port-aux-Francais', 'Continent' => 'AN', 'TLD' => '.tf', 'Languages' => 'fr', 'Geo_Name_ID' => '1546748', 'EDGAR' => ''),
            81 => array('Country_Name' => 'Gabon', 'Official_Name_English' => 'Gabon', 'ISO3166_1_Alpha_2' => 'GA', 'ISO3166_1_Alpha_3' => 'GAB', 'M49' => '266', 'ITU' => 'GAB', 'MARC' => 'go', 'WMO' => 'GO', 'DS' => 'G', 'Dial' => '241', 'FIFA' => 'GAB', 'FIPS' => 'GB', 'GAUL' => '89', 'IOC' => 'GAB', 'ISO4217_Currency_Alphabetic_Code' => 'XAF', 'ISO4217_Currency_Country_Name' => 'GABON', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BEAC', 'ISO4217_Currency_Numeric_Code' => '950', 'Is_Independent' => 'Yes', 'Capital' => 'Libreville', 'Continent' => 'AF', 'TLD' => '.ga', 'Languages' => 'fr-GA', 'Geo_Name_ID' => '2400553', 'EDGAR' => 'I5'),
            82 => array('Country_Name' => 'Gambia', 'Official_Name_English' => 'Gambia', 'ISO3166_1_Alpha_2' => 'GM', 'ISO3166_1_Alpha_3' => 'GMB', 'M49' => '270', 'ITU' => 'GMB', 'MARC' => 'gm', 'WMO' => 'GB', 'DS' => 'WAG', 'Dial' => '220', 'FIFA' => 'GAM', 'FIPS' => 'GA', 'GAUL' => '90', 'IOC' => 'GAM', 'ISO4217_Currency_Alphabetic_Code' => 'GMD', 'ISO4217_Currency_Country_Name' => 'GAMBIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Dalasi', 'ISO4217_Currency_Numeric_Code' => '270', 'Is_Independent' => 'Yes', 'Capital' => 'Banjul', 'Continent' => 'AF', 'TLD' => '.gm', 'Languages' => 'en-GM,mnk,wof,wo,ff', 'Geo_Name_ID' => '2413451', 'EDGAR' => 'I6'),
            83 => array('Country_Name' => 'Georgia', 'Official_Name_English' => 'Georgia', 'ISO3166_1_Alpha_2' => 'GE', 'ISO3166_1_Alpha_3' => 'GEO', 'M49' => '268', 'ITU' => 'GEO', 'MARC' => 'gs', 'WMO' => 'GG', 'DS' => 'GE', 'Dial' => '995', 'FIFA' => 'GEO', 'FIPS' => 'GG', 'GAUL' => '92', 'IOC' => 'GEO', 'ISO4217_Currency_Alphabetic_Code' => 'GEL', 'ISO4217_Currency_Country_Name' => 'GEORGIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Lari', 'ISO4217_Currency_Numeric_Code' => '981', 'Is_Independent' => 'Yes', 'Capital' => 'Tbilisi', 'Continent' => 'AS', 'TLD' => '.ge', 'Languages' => 'ka,ru,hy,az', 'Geo_Name_ID' => '614540', 'EDGAR' => '2Q'),
            84 => array('Country_Name' => 'Germany', 'Official_Name_English' => 'Germany', 'ISO3166_1_Alpha_2' => 'DE', 'ISO3166_1_Alpha_3' => 'DEU', 'M49' => '276', 'ITU' => 'D', 'MARC' => 'gw', 'WMO' => 'DL', 'DS' => 'D', 'Dial' => '49', 'FIFA' => 'GER', 'FIPS' => 'GM', 'GAUL' => '93', 'IOC' => 'GER', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'GERMANY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Berlin', 'Continent' => 'EU', 'TLD' => '.de', 'Languages' => 'de', 'Geo_Name_ID' => '2921044', 'EDGAR' => '2M'),
            85 => array('Country_Name' => 'Ghana', 'Official_Name_English' => 'Ghana', 'ISO3166_1_Alpha_2' => 'GH', 'ISO3166_1_Alpha_3' => 'GHA', 'M49' => '288', 'ITU' => 'GHA', 'MARC' => 'gh', 'WMO' => 'GH', 'DS' => 'GH', 'Dial' => '233', 'FIFA' => 'GHA', 'FIPS' => 'GH', 'GAUL' => '94', 'IOC' => 'GHA', 'ISO4217_Currency_Alphabetic_Code' => 'GHS', 'ISO4217_Currency_Country_Name' => 'GHANA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Ghana Cedi', 'ISO4217_Currency_Numeric_Code' => '936', 'Is_Independent' => 'Yes', 'Capital' => 'Accra', 'Continent' => 'AF', 'TLD' => '.gh', 'Languages' => 'en-GH,ak,ee,tw', 'Geo_Name_ID' => '2300660', 'EDGAR' => 'J0'),
            86 => array('Country_Name' => 'Gibraltar', 'Official_Name_English' => 'Gibraltar', 'ISO3166_1_Alpha_2' => 'GI', 'ISO3166_1_Alpha_3' => 'GIB', 'M49' => '292', 'ITU' => 'GIB', 'MARC' => 'gi', 'WMO' => 'GI', 'DS' => 'GBZ', 'Dial' => '350', 'FIFA' => 'GBZ', 'FIPS' => 'GI', 'GAUL' => '95', 'IOC' => 'GIB', 'ISO4217_Currency_Alphabetic_Code' => 'GIP', 'ISO4217_Currency_Country_Name' => 'GIBRALTAR', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Gibraltar Pound', 'ISO4217_Currency_Numeric_Code' => '292', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Gibraltar', 'Continent' => 'EU', 'TLD' => '.gi', 'Languages' => 'en-GI,es,it,pt', 'Geo_Name_ID' => '2411586', 'EDGAR' => 'J1'),
            87 => array('Country_Name' => 'Greece', 'Official_Name_English' => 'Greece', 'ISO3166_1_Alpha_2' => 'GR', 'ISO3166_1_Alpha_3' => 'GRC', 'M49' => '300', 'ITU' => 'GRC', 'MARC' => 'gr', 'WMO' => 'GR', 'DS' => 'GR', 'Dial' => '30', 'FIFA' => 'GRE', 'FIPS' => 'GR', 'GAUL' => '97', 'IOC' => 'GRE', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'GREECE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Athens', 'Continent' => 'EU', 'TLD' => '.gr', 'Languages' => 'el-GR,en,fr', 'Geo_Name_ID' => '390903', 'EDGAR' => 'J3'),
            88 => array('Country_Name' => 'Greenland', 'Official_Name_English' => 'Greenland', 'ISO3166_1_Alpha_2' => 'GL', 'ISO3166_1_Alpha_3' => 'GRL', 'M49' => '304', 'ITU' => 'GRL', 'MARC' => 'gl', 'WMO' => 'GL', 'DS' => 'DK', 'Dial' => '299', 'FIFA' => 'GRL', 'FIPS' => 'GL', 'GAUL' => '98', 'IOC' => 'GRL', 'ISO4217_Currency_Alphabetic_Code' => 'DKK', 'ISO4217_Currency_Country_Name' => 'GREENLAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Danish Krone', 'ISO4217_Currency_Numeric_Code' => '208', 'Is_Independent' => 'Part of DK', 'Capital' => 'Nuuk', 'Continent' => 'NA', 'TLD' => '.gl', 'Languages' => 'kl,da-GL,en', 'Geo_Name_ID' => '3425505', 'EDGAR' => 'J4'),
            89 => array('Country_Name' => 'Grenada', 'Official_Name_English' => 'Grenada', 'ISO3166_1_Alpha_2' => 'GD', 'ISO3166_1_Alpha_3' => 'GRD', 'M49' => '308', 'ITU' => 'GRD', 'MARC' => 'gd', 'WMO' => 'GD', 'DS' => 'WG', 'Dial' => '473', 'FIFA' => 'GRN', 'FIPS' => 'GJ', 'GAUL' => '99', 'IOC' => 'GRN', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'GRENADA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Yes', 'Capital' => 'St. George\'s', 'Continent' => 'NA', 'TLD' => '.gd', 'Languages' => 'en-GD', 'Geo_Name_ID' => '3580239', 'EDGAR' => 'J5'),
            90 => array('Country_Name' => 'Guadeloupe', 'Official_Name_English' => 'Guadeloupe', 'ISO3166_1_Alpha_2' => 'GP', 'ISO3166_1_Alpha_3' => 'GLP', 'M49' => '312', 'ITU' => 'GDL', 'MARC' => 'gp', 'WMO' => 'MF', 'DS' => 'F', 'Dial' => '590', 'FIFA' => 'GLP', 'FIPS' => 'GP', 'GAUL' => '100', 'IOC' => 'GUD', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'GUADELOUPE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Basse-Terre', 'Continent' => 'NA', 'TLD' => '.gp', 'Languages' => 'fr-GP', 'Geo_Name_ID' => '3579143', 'EDGAR' => 'J6'),
            91 => array('Country_Name' => 'Guam', 'Official_Name_English' => 'Guam', 'ISO3166_1_Alpha_2' => 'GU', 'ISO3166_1_Alpha_3' => 'GUM', 'M49' => '316', 'ITU' => 'GUM', 'MARC' => 'gu', 'WMO' => 'GM', 'DS' => 'USA', 'Dial' => '671', 'FIFA' => 'GUM', 'FIPS' => 'GQ', 'GAUL' => '101', 'IOC' => 'GUM', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'GUAM', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Territory of US', 'Capital' => 'Hagatna', 'Continent' => 'OC', 'TLD' => '.gu', 'Languages' => 'en-GU,ch-GU', 'Geo_Name_ID' => '4043988', 'EDGAR' => 'GU'),
            92 => array('Country_Name' => 'Guatemala', 'Official_Name_English' => 'Guatemala', 'ISO3166_1_Alpha_2' => 'GT', 'ISO3166_1_Alpha_3' => 'GTM', 'M49' => '320', 'ITU' => 'GTM', 'MARC' => 'gt', 'WMO' => 'GU', 'DS' => 'GCA', 'Dial' => '502', 'FIFA' => 'GUA', 'FIPS' => 'GT', 'GAUL' => '103', 'IOC' => 'GUA', 'ISO4217_Currency_Alphabetic_Code' => 'GTQ', 'ISO4217_Currency_Country_Name' => 'GUATEMALA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Quetzal', 'ISO4217_Currency_Numeric_Code' => '320', 'Is_Independent' => 'Yes', 'Capital' => 'Guatemala City', 'Continent' => 'NA', 'TLD' => '.gt', 'Languages' => 'es-GT', 'Geo_Name_ID' => '3595528', 'EDGAR' => 'J8'),
            93 => array('Country_Name' => 'Guernsey', 'Official_Name_English' => 'Guernsey', 'ISO3166_1_Alpha_2' => 'GG', 'ISO3166_1_Alpha_3' => 'GGY', 'M49' => '831', 'ITU' => '', 'MARC' => 'uik', 'WMO' => '', 'DS' => 'GBG', 'Dial' => '44', 'FIFA' => 'GBG', 'FIPS' => 'GK', 'GAUL' => '104', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'GBP', 'ISO4217_Currency_Country_Name' => 'GUERNSEY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pound Sterling', 'ISO4217_Currency_Numeric_Code' => '826', 'Is_Independent' => 'Crown dependency of GB', 'Capital' => 'St Peter Port', 'Continent' => 'EU', 'TLD' => '.gg', 'Languages' => 'en,fr', 'Geo_Name_ID' => '3042362', 'EDGAR' => 'Y7'),
            94 => array('Country_Name' => 'Guinea', 'Official_Name_English' => 'Guinea', 'ISO3166_1_Alpha_2' => 'GN', 'ISO3166_1_Alpha_3' => 'GIN', 'M49' => '324', 'ITU' => 'GUI', 'MARC' => 'gv', 'WMO' => 'GN', 'DS' => 'RG', 'Dial' => '224', 'FIFA' => 'GUI', 'FIPS' => 'GV', 'GAUL' => '106', 'IOC' => 'GUI', 'ISO4217_Currency_Alphabetic_Code' => 'GNF', 'ISO4217_Currency_Country_Name' => 'GUINEA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Guinea Franc', 'ISO4217_Currency_Numeric_Code' => '324', 'Is_Independent' => 'Yes', 'Capital' => 'Conakry', 'Continent' => 'AF', 'TLD' => '.gn', 'Languages' => 'fr-GN', 'Geo_Name_ID' => '2420477', 'EDGAR' => 'J9'),
            95 => array('Country_Name' => 'Guinea-Bissau', 'Official_Name_English' => 'Guinea-Bissau', 'ISO3166_1_Alpha_2' => 'GW', 'ISO3166_1_Alpha_3' => 'GNB', 'M49' => '624', 'ITU' => 'GNB', 'MARC' => 'pg', 'WMO' => 'GW', 'DS' => 'GW', 'Dial' => '245', 'FIFA' => 'GNB', 'FIPS' => 'PU', 'GAUL' => '105', 'IOC' => 'GBS', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'GUINEA-BISSAU', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Bissau', 'Continent' => 'AF', 'TLD' => '.gw', 'Languages' => 'pt-GW,pov', 'Geo_Name_ID' => '2372248', 'EDGAR' => 'S0'),
            96 => array('Country_Name' => 'Guyana', 'Official_Name_English' => 'Guyana', 'ISO3166_1_Alpha_2' => 'GY', 'ISO3166_1_Alpha_3' => 'GUY', 'M49' => '328', 'ITU' => 'GUY', 'MARC' => 'gy', 'WMO' => 'GY', 'DS' => 'GUY', 'Dial' => '592', 'FIFA' => 'GUY', 'FIPS' => 'GY', 'GAUL' => '107', 'IOC' => 'GUY', 'ISO4217_Currency_Alphabetic_Code' => 'GYD', 'ISO4217_Currency_Country_Name' => 'GUYANA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Guyana Dollar', 'ISO4217_Currency_Numeric_Code' => '328', 'Is_Independent' => 'Yes', 'Capital' => 'Georgetown', 'Continent' => 'SA', 'TLD' => '.gy', 'Languages' => 'en-GY', 'Geo_Name_ID' => '3378535', 'EDGAR' => 'K0'),
            97 => array('Country_Name' => 'Haiti', 'Official_Name_English' => 'Haiti', 'ISO3166_1_Alpha_2' => 'HT', 'ISO3166_1_Alpha_3' => 'HTI', 'M49' => '332', 'ITU' => 'HTI', 'MARC' => 'ht', 'WMO' => 'HA', 'DS' => 'RH', 'Dial' => '509', 'FIFA' => 'HAI', 'FIPS' => 'HA', 'GAUL' => '108', 'IOC' => 'HAI', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'HAITI', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Port-au-Prince', 'Continent' => 'NA', 'TLD' => '.ht', 'Languages' => 'ht,fr-HT', 'Geo_Name_ID' => '3723988', 'EDGAR' => 'K1'),
            98 => array('Country_Name' => 'Heard & McDonald Islands', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'HM', 'ISO3166_1_Alpha_3' => 'HMD', 'M49' => '334', 'ITU' => '', 'MARC' => 'hm', 'WMO' => '', 'DS' => 'AUS', 'Dial' => '672', 'FIFA' => '', 'FIPS' => 'HM', 'GAUL' => '109', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of AU', 'Capital' => '', 'Continent' => 'AN', 'TLD' => '.hm', 'Languages' => '', 'Geo_Name_ID' => '1547314', 'EDGAR' => ''),
            99 => array('Country_Name' => 'Honduras', 'Official_Name_English' => 'Honduras', 'ISO3166_1_Alpha_2' => 'HN', 'ISO3166_1_Alpha_3' => 'HND', 'M49' => '340', 'ITU' => 'HND', 'MARC' => 'ho', 'WMO' => 'HO', 'DS' => '', 'Dial' => '504', 'FIFA' => 'HON', 'FIPS' => 'HO', 'GAUL' => '111', 'IOC' => 'HON', 'ISO4217_Currency_Alphabetic_Code' => 'HNL', 'ISO4217_Currency_Country_Name' => 'HONDURAS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Lempira', 'ISO4217_Currency_Numeric_Code' => '340', 'Is_Independent' => 'Yes', 'Capital' => 'Tegucigalpa', 'Continent' => 'NA', 'TLD' => '.hn', 'Languages' => 'es-HN', 'Geo_Name_ID' => '3608932', 'EDGAR' => 'K2'),
            100 => array('Country_Name' => 'Hong Kong', 'Official_Name_English' => 'China, Hong Kong Special Administrative Region', 'ISO3166_1_Alpha_2' => 'HK', 'ISO3166_1_Alpha_3' => 'HKG', 'M49' => '344', 'ITU' => 'HKG', 'MARC' => '', 'WMO' => 'HK', 'DS' => 'HK', 'Dial' => '852', 'FIFA' => 'HKG', 'FIPS' => 'HK', 'GAUL' => '33364', 'IOC' => 'HKG', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Part of CN', 'Capital' => 'Hong Kong', 'Continent' => 'AS', 'TLD' => '.hk', 'Languages' => 'zh-HK,yue,zh,en', 'Geo_Name_ID' => '1819730', 'EDGAR' => ''),
            101 => array('Country_Name' => 'Hungary', 'Official_Name_English' => 'Hungary', 'ISO3166_1_Alpha_2' => 'HU', 'ISO3166_1_Alpha_3' => 'HUN', 'M49' => '348', 'ITU' => 'HNG', 'MARC' => 'hu', 'WMO' => 'HU', 'DS' => 'H', 'Dial' => '36', 'FIFA' => 'HUN', 'FIPS' => 'HU', 'GAUL' => '113', 'IOC' => 'HUN', 'ISO4217_Currency_Alphabetic_Code' => 'HUF', 'ISO4217_Currency_Country_Name' => 'HUNGARY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Forint', 'ISO4217_Currency_Numeric_Code' => '348', 'Is_Independent' => 'Yes', 'Capital' => 'Budapest', 'Continent' => 'EU', 'TLD' => '.hu', 'Languages' => 'hu-HU', 'Geo_Name_ID' => '719819', 'EDGAR' => 'K5'),
            102 => array('Country_Name' => 'Iceland', 'Official_Name_English' => 'Iceland', 'ISO3166_1_Alpha_2' => 'IS', 'ISO3166_1_Alpha_3' => 'ISL', 'M49' => '352', 'ITU' => 'ISL', 'MARC' => 'ic', 'WMO' => 'IL', 'DS' => 'IS', 'Dial' => '354', 'FIFA' => 'ISL', 'FIPS' => 'IC', 'GAUL' => '114', 'IOC' => 'ISL', 'ISO4217_Currency_Alphabetic_Code' => 'ISK', 'ISO4217_Currency_Country_Name' => 'ICELAND', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Iceland Krona', 'ISO4217_Currency_Numeric_Code' => '352', 'Is_Independent' => 'Yes', 'Capital' => 'Reykjavik', 'Continent' => 'EU', 'TLD' => '.is', 'Languages' => 'is,en,de,da,sv,no', 'Geo_Name_ID' => '2629691', 'EDGAR' => 'K6'),
            103 => array('Country_Name' => 'India', 'Official_Name_English' => 'India', 'ISO3166_1_Alpha_2' => 'IN', 'ISO3166_1_Alpha_3' => 'IND', 'M49' => '356', 'ITU' => 'IND', 'MARC' => 'ii', 'WMO' => 'IN', 'DS' => 'IND', 'Dial' => '91', 'FIFA' => 'IND', 'FIPS' => 'IN', 'GAUL' => '115', 'IOC' => 'IND', 'ISO4217_Currency_Alphabetic_Code' => 'INR', 'ISO4217_Currency_Country_Name' => 'INDIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Indian Rupee', 'ISO4217_Currency_Numeric_Code' => '356', 'Is_Independent' => 'Yes', 'Capital' => 'New Delhi', 'Continent' => 'AS', 'TLD' => '.in', 'Languages' => 'en-IN,hi,bn,te,mr,ta,ur,gu,kn,ml,or,pa,as,bh,sat,ks,ne,sd,kok,doi,mni,sit,sa,fr,lus,inc', 'Geo_Name_ID' => '1269750', 'EDGAR' => 'K7'),
            104 => array('Country_Name' => 'Indonesia', 'Official_Name_English' => 'Indonesia', 'ISO3166_1_Alpha_2' => 'ID', 'ISO3166_1_Alpha_3' => 'IDN', 'M49' => '360', 'ITU' => 'INS', 'MARC' => 'io', 'WMO' => 'ID', 'DS' => 'RI', 'Dial' => '62', 'FIFA' => 'IDN', 'FIPS' => 'ID', 'GAUL' => '116', 'IOC' => 'INA', 'ISO4217_Currency_Alphabetic_Code' => 'IDR', 'ISO4217_Currency_Country_Name' => 'INDONESIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Rupiah', 'ISO4217_Currency_Numeric_Code' => '360', 'Is_Independent' => 'Yes', 'Capital' => 'Jakarta', 'Continent' => 'AS', 'TLD' => '.id', 'Languages' => 'id,en,nl,jv', 'Geo_Name_ID' => '1643084', 'EDGAR' => 'K8'),
            105 => array('Country_Name' => 'Iran', 'Official_Name_English' => 'Iran (Islamic Republic of)', 'ISO3166_1_Alpha_2' => 'IR', 'ISO3166_1_Alpha_3' => 'IRN', 'M49' => '364', 'ITU' => 'IRN', 'MARC' => 'ir', 'WMO' => 'IR', 'DS' => 'IR', 'Dial' => '98', 'FIFA' => 'IRN', 'FIPS' => 'IR', 'GAUL' => '117', 'IOC' => 'IRI', 'ISO4217_Currency_Alphabetic_Code' => 'IRR', 'ISO4217_Currency_Country_Name' => 'IRAN, ISLAMIC REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Iranian Rial', 'ISO4217_Currency_Numeric_Code' => '364', 'Is_Independent' => 'Yes', 'Capital' => 'Tehran', 'Continent' => 'AS', 'TLD' => '.ir', 'Languages' => 'fa-IR,ku', 'Geo_Name_ID' => '130758', 'EDGAR' => 'K9'),
            106 => array('Country_Name' => 'Iraq', 'Official_Name_English' => 'Iraq', 'ISO3166_1_Alpha_2' => 'IQ', 'ISO3166_1_Alpha_3' => 'IRQ', 'M49' => '368', 'ITU' => 'IRQ', 'MARC' => 'iq', 'WMO' => 'IQ', 'DS' => 'IRQ', 'Dial' => '964', 'FIFA' => 'IRQ', 'FIPS' => 'IZ', 'GAUL' => '118', 'IOC' => 'IRQ', 'ISO4217_Currency_Alphabetic_Code' => 'IQD', 'ISO4217_Currency_Country_Name' => 'IRAQ', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Iraqi Dinar', 'ISO4217_Currency_Numeric_Code' => '368', 'Is_Independent' => 'Yes', 'Capital' => 'Baghdad', 'Continent' => 'AS', 'TLD' => '.iq', 'Languages' => 'ar-IQ,ku,hy', 'Geo_Name_ID' => '99237', 'EDGAR' => 'L0'),
            107 => array('Country_Name' => 'Ireland', 'Official_Name_English' => 'Ireland', 'ISO3166_1_Alpha_2' => 'IE', 'ISO3166_1_Alpha_3' => 'IRL', 'M49' => '372', 'ITU' => 'IRL', 'MARC' => 'ie', 'WMO' => 'IE', 'DS' => 'IRL', 'Dial' => '353', 'FIFA' => 'IRL', 'FIPS' => 'EI', 'GAUL' => '119', 'IOC' => 'IRL', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'IRELAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Dublin', 'Continent' => 'EU', 'TLD' => '.ie', 'Languages' => 'en-IE,ga-IE', 'Geo_Name_ID' => '2963597', 'EDGAR' => 'L2'),
            108 => array('Country_Name' => 'Isle of Man', 'Official_Name_English' => 'Isle of Man', 'ISO3166_1_Alpha_2' => 'IM', 'ISO3166_1_Alpha_3' => 'IMN', 'M49' => '833', 'ITU' => '', 'MARC' => 'uik', 'WMO' => '', 'DS' => 'GBM', 'Dial' => '44', 'FIFA' => 'GBM', 'FIPS' => 'IM', 'GAUL' => '120', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'GBP', 'ISO4217_Currency_Country_Name' => 'ISLE OF MAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pound Sterling', 'ISO4217_Currency_Numeric_Code' => '826', 'Is_Independent' => 'Crown dependency of GB', 'Capital' => 'Douglas', 'Continent' => 'EU', 'TLD' => '.im', 'Languages' => 'en,gv', 'Geo_Name_ID' => '3042225', 'EDGAR' => 'Y8'),
            109 => array('Country_Name' => 'Israel', 'Official_Name_English' => 'Israel', 'ISO3166_1_Alpha_2' => 'IL', 'ISO3166_1_Alpha_3' => 'ISR', 'M49' => '376', 'ITU' => 'ISR', 'MARC' => 'is', 'WMO' => 'IS', 'DS' => 'IL', 'Dial' => '972', 'FIFA' => 'ISR', 'FIPS' => 'IS', 'GAUL' => '121', 'IOC' => 'ISR', 'ISO4217_Currency_Alphabetic_Code' => 'ILS', 'ISO4217_Currency_Country_Name' => 'ISRAEL', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Israeli Sheqel', 'ISO4217_Currency_Numeric_Code' => '376', 'Is_Independent' => 'Yes', 'Capital' => 'Jerusalem', 'Continent' => 'AS', 'TLD' => '.il', 'Languages' => 'he,ar-IL,en-IL,', 'Geo_Name_ID' => '294640', 'EDGAR' => 'L3'),
            110 => array('Country_Name' => 'Italy', 'Official_Name_English' => 'Italy', 'ISO3166_1_Alpha_2' => 'IT', 'ISO3166_1_Alpha_3' => 'ITA', 'M49' => '380', 'ITU' => 'I', 'MARC' => 'it', 'WMO' => 'IY', 'DS' => 'I', 'Dial' => '39', 'FIFA' => 'ITA', 'FIPS' => 'IT', 'GAUL' => '122', 'IOC' => 'ITA', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'ITALY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Rome', 'Continent' => 'EU', 'TLD' => '.it', 'Languages' => 'it-IT,de-IT,fr-IT,sc,ca,co,sl', 'Geo_Name_ID' => '3175395', 'EDGAR' => 'L6'),
            111 => array('Country_Name' => 'Jamaica', 'Official_Name_English' => 'Jamaica', 'ISO3166_1_Alpha_2' => 'JM', 'ISO3166_1_Alpha_3' => 'JAM', 'M49' => '388', 'ITU' => 'JMC', 'MARC' => 'jm', 'WMO' => 'JM', 'DS' => 'JA', 'Dial' => '876', 'FIFA' => 'JAM', 'FIPS' => 'JM', 'GAUL' => '123', 'IOC' => 'JAM', 'ISO4217_Currency_Alphabetic_Code' => 'JMD', 'ISO4217_Currency_Country_Name' => 'JAMAICA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Jamaican Dollar', 'ISO4217_Currency_Numeric_Code' => '388', 'Is_Independent' => 'Yes', 'Capital' => 'Kingston', 'Continent' => 'NA', 'TLD' => '.jm', 'Languages' => 'en-JM', 'Geo_Name_ID' => '3489940', 'EDGAR' => 'L8'),
            112 => array('Country_Name' => 'Japan', 'Official_Name_English' => 'Japan', 'ISO3166_1_Alpha_2' => 'JP', 'ISO3166_1_Alpha_3' => 'JPN', 'M49' => '392', 'ITU' => 'J', 'MARC' => 'ja', 'WMO' => 'JP', 'DS' => 'J', 'Dial' => '81', 'FIFA' => 'JPN', 'FIPS' => 'JA', 'GAUL' => '126', 'IOC' => 'JPN', 'ISO4217_Currency_Alphabetic_Code' => 'JPY', 'ISO4217_Currency_Country_Name' => 'JAPAN', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Yen', 'ISO4217_Currency_Numeric_Code' => '392', 'Is_Independent' => 'Yes', 'Capital' => 'Tokyo', 'Continent' => 'AS', 'TLD' => '.jp', 'Languages' => 'ja', 'Geo_Name_ID' => '1861060', 'EDGAR' => 'M0'),
            113 => array('Country_Name' => 'Jersey', 'Official_Name_English' => 'Jersey', 'ISO3166_1_Alpha_2' => 'JE', 'ISO3166_1_Alpha_3' => 'JEY', 'M49' => '832', 'ITU' => '', 'MARC' => 'uik', 'WMO' => '', 'DS' => 'GBJ', 'Dial' => '44', 'FIFA' => 'GBJ', 'FIPS' => 'JE', 'GAUL' => '128', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'GBP', 'ISO4217_Currency_Country_Name' => 'JERSEY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pound Sterling', 'ISO4217_Currency_Numeric_Code' => '826', 'Is_Independent' => 'Crown dependency of GB', 'Capital' => 'Saint Helier', 'Continent' => 'EU', 'TLD' => '.je', 'Languages' => 'en,pt', 'Geo_Name_ID' => '3042142', 'EDGAR' => 'Y9'),
            114 => array('Country_Name' => 'Jordan', 'Official_Name_English' => 'Jordan', 'ISO3166_1_Alpha_2' => 'JO', 'ISO3166_1_Alpha_3' => 'JOR', 'M49' => '400', 'ITU' => 'JOR', 'MARC' => 'jo', 'WMO' => 'JD', 'DS' => 'HKJ', 'Dial' => '962', 'FIFA' => 'JOR', 'FIPS' => 'JO', 'GAUL' => '130', 'IOC' => 'JOR', 'ISO4217_Currency_Alphabetic_Code' => 'JOD', 'ISO4217_Currency_Country_Name' => 'JORDAN', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Jordanian Dinar', 'ISO4217_Currency_Numeric_Code' => '400', 'Is_Independent' => 'Yes', 'Capital' => 'Amman', 'Continent' => 'AS', 'TLD' => '.jo', 'Languages' => 'ar-JO,en', 'Geo_Name_ID' => '248816', 'EDGAR' => 'M2'),
            115 => array('Country_Name' => 'Kazakhstan', 'Official_Name_English' => 'Kazakhstan', 'ISO3166_1_Alpha_2' => 'KZ', 'ISO3166_1_Alpha_3' => 'KAZ', 'M49' => '398', 'ITU' => 'KAZ', 'MARC' => 'kz', 'WMO' => 'KZ', 'DS' => 'KZ', 'Dial' => '7', 'FIFA' => 'KAZ', 'FIPS' => 'KZ', 'GAUL' => '132', 'IOC' => 'KAZ', 'ISO4217_Currency_Alphabetic_Code' => 'KZT', 'ISO4217_Currency_Country_Name' => 'KAZAKHSTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Tenge', 'ISO4217_Currency_Numeric_Code' => '398', 'Is_Independent' => 'Yes', 'Capital' => 'Astana', 'Continent' => 'AS', 'TLD' => '.kz', 'Languages' => 'kk,ru', 'Geo_Name_ID' => '1522867', 'EDGAR' => ''),
            116 => array('Country_Name' => 'Kenya', 'Official_Name_English' => 'Kenya', 'ISO3166_1_Alpha_2' => 'KE', 'ISO3166_1_Alpha_3' => 'KEN', 'M49' => '404', 'ITU' => 'KEN', 'MARC' => 'ke', 'WMO' => 'KN', 'DS' => 'EAK', 'Dial' => '254', 'FIFA' => 'KEN', 'FIPS' => 'KE', 'GAUL' => '133', 'IOC' => 'KEN', 'ISO4217_Currency_Alphabetic_Code' => 'KES', 'ISO4217_Currency_Country_Name' => 'KENYA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Kenyan Shilling', 'ISO4217_Currency_Numeric_Code' => '404', 'Is_Independent' => 'Yes', 'Capital' => 'Nairobi', 'Continent' => 'AF', 'TLD' => '.ke', 'Languages' => 'en-KE,sw-KE', 'Geo_Name_ID' => '192950', 'EDGAR' => 'M3'),
            117 => array('Country_Name' => 'Kiribati', 'Official_Name_English' => 'Kiribati', 'ISO3166_1_Alpha_2' => 'KI', 'ISO3166_1_Alpha_3' => 'KIR', 'M49' => '296', 'ITU' => 'KIR', 'MARC' => 'gb', 'WMO' => 'KB', 'DS' => '', 'Dial' => '686', 'FIFA' => 'KIR', 'FIPS' => 'KR', 'GAUL' => '135', 'IOC' => 'KIR', 'ISO4217_Currency_Alphabetic_Code' => 'AUD', 'ISO4217_Currency_Country_Name' => 'KIRIBATI', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Australian Dollar', 'ISO4217_Currency_Numeric_Code' => '36', 'Is_Independent' => 'Yes', 'Capital' => 'Tarawa', 'Continent' => 'OC', 'TLD' => '.ki', 'Languages' => 'en-KI,gil', 'Geo_Name_ID' => '4030945', 'EDGAR' => 'J2'),
            118 => array('Country_Name' => 'Kuwait', 'Official_Name_English' => 'Kuwait', 'ISO3166_1_Alpha_2' => 'KW', 'ISO3166_1_Alpha_3' => 'KWT', 'M49' => '414', 'ITU' => 'KWT', 'MARC' => 'ku', 'WMO' => 'KW', 'DS' => 'KWT', 'Dial' => '965', 'FIFA' => 'KUW', 'FIPS' => 'KU', 'GAUL' => '137', 'IOC' => 'KUW', 'ISO4217_Currency_Alphabetic_Code' => 'KWD', 'ISO4217_Currency_Country_Name' => 'KUWAIT', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Kuwaiti Dinar', 'ISO4217_Currency_Numeric_Code' => '414', 'Is_Independent' => 'Yes', 'Capital' => 'Kuwait City', 'Continent' => 'AS', 'TLD' => '.kw', 'Languages' => 'ar-KW,en', 'Geo_Name_ID' => '285570', 'EDGAR' => 'M6'),
            119 => array('Country_Name' => 'Kyrgyzstan', 'Official_Name_English' => 'Kyrgyzstan', 'ISO3166_1_Alpha_2' => 'KG', 'ISO3166_1_Alpha_3' => 'KGZ', 'M49' => '417', 'ITU' => 'KGZ', 'MARC' => 'kg', 'WMO' => 'KG', 'DS' => 'KS', 'Dial' => '996', 'FIFA' => 'KGZ', 'FIPS' => 'KG', 'GAUL' => '138', 'IOC' => 'KGZ', 'ISO4217_Currency_Alphabetic_Code' => 'KGS', 'ISO4217_Currency_Country_Name' => 'KYRGYZSTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Som', 'ISO4217_Currency_Numeric_Code' => '417', 'Is_Independent' => 'Yes', 'Capital' => 'Bishkek', 'Continent' => 'AS', 'TLD' => '.kg', 'Languages' => 'ky,uz,ru', 'Geo_Name_ID' => '1527747', 'EDGAR' => '1N'),
            120 => array('Country_Name' => 'Laos', 'Official_Name_English' => 'Lao People\'s Democratic Republic', 'ISO3166_1_Alpha_2' => 'LA', 'ISO3166_1_Alpha_3' => 'LAO', 'M49' => '418', 'ITU' => 'LAO', 'MARC' => 'ls', 'WMO' => 'LA', 'DS' => 'LAO', 'Dial' => '856', 'FIFA' => 'LAO', 'FIPS' => 'LA', 'GAUL' => '139', 'IOC' => 'LAO', 'ISO4217_Currency_Alphabetic_Code' => 'LAK', 'ISO4217_Currency_Country_Name' => 'LAO PEOPLEâ€™S DEMOCRATIC REPUBLIC', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Kip', 'ISO4217_Currency_Numeric_Code' => '418', 'Is_Independent' => 'Yes', 'Capital' => 'Vientiane', 'Continent' => 'AS', 'TLD' => '.la', 'Languages' => 'lo,fr,en', 'Geo_Name_ID' => '1655842', 'EDGAR' => ''),
            121 => array('Country_Name' => 'Latvia', 'Official_Name_English' => 'Latvia', 'ISO3166_1_Alpha_2' => 'LV', 'ISO3166_1_Alpha_3' => 'LVA', 'M49' => '428', 'ITU' => 'LVA', 'MARC' => 'lv', 'WMO' => 'LV', 'DS' => 'LV', 'Dial' => '371', 'FIFA' => 'LVA', 'FIPS' => 'LG', 'GAUL' => '140', 'IOC' => 'LAT', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'LATVIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Riga', 'Continent' => 'EU', 'TLD' => '.lv', 'Languages' => 'lv,ru,lt', 'Geo_Name_ID' => '458258', 'EDGAR' => '1R'),
            122 => array('Country_Name' => 'Lebanon', 'Official_Name_English' => 'Lebanon', 'ISO3166_1_Alpha_2' => 'LB', 'ISO3166_1_Alpha_3' => 'LBN', 'M49' => '422', 'ITU' => 'LBN', 'MARC' => 'le', 'WMO' => 'LB', 'DS' => 'RL', 'Dial' => '961', 'FIFA' => 'LIB', 'FIPS' => 'LE', 'GAUL' => '141', 'IOC' => 'LIB', 'ISO4217_Currency_Alphabetic_Code' => 'LBP', 'ISO4217_Currency_Country_Name' => 'LEBANON', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Lebanese Pound', 'ISO4217_Currency_Numeric_Code' => '422', 'Is_Independent' => 'Yes', 'Capital' => 'Beirut', 'Continent' => 'AS', 'TLD' => '.lb', 'Languages' => 'ar-LB,fr-LB,en,hy', 'Geo_Name_ID' => '272103', 'EDGAR' => 'M8'),
            123 => array('Country_Name' => 'Lesotho', 'Official_Name_English' => 'Lesotho', 'ISO3166_1_Alpha_2' => 'LS', 'ISO3166_1_Alpha_3' => 'LSO', 'M49' => '426', 'ITU' => 'LSO', 'MARC' => 'lo', 'WMO' => 'LS', 'DS' => 'LS', 'Dial' => '266', 'FIFA' => 'LES', 'FIPS' => 'LT', 'GAUL' => '142', 'IOC' => 'LES', 'ISO4217_Currency_Alphabetic_Code' => 'ZAR', 'ISO4217_Currency_Country_Name' => 'LESOTHO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Rand', 'ISO4217_Currency_Numeric_Code' => '710', 'Is_Independent' => 'Yes', 'Capital' => 'Maseru', 'Continent' => 'AF', 'TLD' => '.ls', 'Languages' => 'en-LS,st,zu,xh', 'Geo_Name_ID' => '932692', 'EDGAR' => 'M9'),
            124 => array('Country_Name' => 'Liberia', 'Official_Name_English' => 'Liberia', 'ISO3166_1_Alpha_2' => 'LR', 'ISO3166_1_Alpha_3' => 'LBR', 'M49' => '430', 'ITU' => 'LBR', 'MARC' => 'lb', 'WMO' => 'LI', 'DS' => 'LB', 'Dial' => '231', 'FIFA' => 'LBR', 'FIPS' => 'LI', 'GAUL' => '144', 'IOC' => 'LBR', 'ISO4217_Currency_Alphabetic_Code' => 'LRD', 'ISO4217_Currency_Country_Name' => 'LIBERIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Liberian Dollar', 'ISO4217_Currency_Numeric_Code' => '430', 'Is_Independent' => 'Yes', 'Capital' => 'Monrovia', 'Continent' => 'AF', 'TLD' => '.lr', 'Languages' => 'en-LR', 'Geo_Name_ID' => '2275384', 'EDGAR' => 'N0'),
            125 => array('Country_Name' => 'Libya', 'Official_Name_English' => 'Libya', 'ISO3166_1_Alpha_2' => 'LY', 'ISO3166_1_Alpha_3' => 'LBY', 'M49' => '434', 'ITU' => 'LBY', 'MARC' => 'ly', 'WMO' => 'LY', 'DS' => 'LAR', 'Dial' => '218', 'FIFA' => 'LBY', 'FIPS' => 'LY', 'GAUL' => '145', 'IOC' => 'LBA', 'ISO4217_Currency_Alphabetic_Code' => 'LYD', 'ISO4217_Currency_Country_Name' => 'LIBYA', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Libyan Dinar', 'ISO4217_Currency_Numeric_Code' => '434', 'Is_Independent' => 'Yes', 'Capital' => 'Tripoli', 'Continent' => 'AF', 'TLD' => '.ly', 'Languages' => 'ar-LY,it,en', 'Geo_Name_ID' => '2215636', 'EDGAR' => ''),
            126 => array('Country_Name' => 'Liechtenstein', 'Official_Name_English' => 'Liechtenstein', 'ISO3166_1_Alpha_2' => 'LI', 'ISO3166_1_Alpha_3' => 'LIE', 'M49' => '438', 'ITU' => 'LIE', 'MARC' => 'lh', 'WMO' => '', 'DS' => 'FL', 'Dial' => '423', 'FIFA' => 'LIE', 'FIPS' => 'LS', 'GAUL' => '146', 'IOC' => 'LIE', 'ISO4217_Currency_Alphabetic_Code' => 'CHF', 'ISO4217_Currency_Country_Name' => 'LIECHTENSTEIN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Swiss Franc', 'ISO4217_Currency_Numeric_Code' => '756', 'Is_Independent' => 'Yes', 'Capital' => 'Vaduz', 'Continent' => 'EU', 'TLD' => '.li', 'Languages' => 'de-LI', 'Geo_Name_ID' => '3042058', 'EDGAR' => 'N2'),
            127 => array('Country_Name' => 'Lithuania', 'Official_Name_English' => 'Lithuania', 'ISO3166_1_Alpha_2' => 'LT', 'ISO3166_1_Alpha_3' => 'LTU', 'M49' => '440', 'ITU' => 'LTU', 'MARC' => 'li', 'WMO' => 'LT', 'DS' => 'LT', 'Dial' => '370', 'FIFA' => 'LTU', 'FIPS' => 'LH', 'GAUL' => '147', 'IOC' => 'LTU', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'LITHUANIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Vilnius', 'Continent' => 'EU', 'TLD' => '.lt', 'Languages' => 'lt,ru,pl', 'Geo_Name_ID' => '597427', 'EDGAR' => '1Q'),
            128 => array('Country_Name' => 'Luxembourg', 'Official_Name_English' => 'Luxembourg', 'ISO3166_1_Alpha_2' => 'LU', 'ISO3166_1_Alpha_3' => 'LUX', 'M49' => '442', 'ITU' => 'LUX', 'MARC' => 'lu', 'WMO' => 'BX', 'DS' => 'L', 'Dial' => '352', 'FIFA' => 'LUX', 'FIPS' => 'LU', 'GAUL' => '148', 'IOC' => 'LUX', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'LUXEMBOURG', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Luxembourg', 'Continent' => 'EU', 'TLD' => '.lu', 'Languages' => 'lb,de-LU,fr-LU', 'Geo_Name_ID' => '2960313', 'EDGAR' => 'N4'),
            129 => array('Country_Name' => 'Macau', 'Official_Name_English' => 'China, Macao Special Administrative Region', 'ISO3166_1_Alpha_2' => 'MO', 'ISO3166_1_Alpha_3' => 'MAC', 'M49' => '446', 'ITU' => 'MAC', 'MARC' => '', 'WMO' => 'MU', 'DS' => 'MO', 'Dial' => '853', 'FIFA' => 'MAC', 'FIPS' => 'MC', 'GAUL' => '149', 'IOC' => 'MAC', 'ISO4217_Currency_Alphabetic_Code' => 'MOP', 'ISO4217_Currency_Country_Name' => 'MACAO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pataca', 'ISO4217_Currency_Numeric_Code' => '446', 'Is_Independent' => 'Part of CN', 'Capital' => 'Macao', 'Continent' => 'AS', 'TLD' => '.mo', 'Languages' => 'zh,zh-MO,pt', 'Geo_Name_ID' => '1821275', 'EDGAR' => ''),
            130 => array('Country_Name' => 'Macedonia', 'Official_Name_English' => 'The former Yugoslav Republic of Macedonia', 'ISO3166_1_Alpha_2' => 'MK', 'ISO3166_1_Alpha_3' => 'MKD', 'M49' => '807', 'ITU' => 'MKD', 'MARC' => 'xn', 'WMO' => 'MJ', 'DS' => 'MK', 'Dial' => '389', 'FIFA' => 'MKD', 'FIPS' => 'MK', 'GAUL' => '241', 'IOC' => 'MKD', 'ISO4217_Currency_Alphabetic_Code' => 'MKD', 'ISO4217_Currency_Country_Name' => 'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Denar', 'ISO4217_Currency_Numeric_Code' => '807', 'Is_Independent' => 'Yes', 'Capital' => 'Skopje', 'Continent' => 'EU', 'TLD' => '.mk', 'Languages' => 'mk,sq,tr,rmm,sr', 'Geo_Name_ID' => '718075', 'EDGAR' => '1U'),
            131 => array('Country_Name' => 'Madagascar', 'Official_Name_English' => 'Madagascar', 'ISO3166_1_Alpha_2' => 'MG', 'ISO3166_1_Alpha_3' => 'MDG', 'M49' => '450', 'ITU' => 'MDG', 'MARC' => 'mg', 'WMO' => 'MG', 'DS' => 'RM', 'Dial' => '261', 'FIFA' => 'MAD', 'FIPS' => 'MA', 'GAUL' => '150', 'IOC' => 'MAD', 'ISO4217_Currency_Alphabetic_Code' => 'MGA', 'ISO4217_Currency_Country_Name' => 'MADAGASCAR', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Malagasy Ariary', 'ISO4217_Currency_Numeric_Code' => '969', 'Is_Independent' => 'Yes', 'Capital' => 'Antananarivo', 'Continent' => 'AF', 'TLD' => '.mg', 'Languages' => 'fr-MG,mg', 'Geo_Name_ID' => '1062947', 'EDGAR' => 'N6'),
            132 => array('Country_Name' => 'Malawi', 'Official_Name_English' => 'Malawi', 'ISO3166_1_Alpha_2' => 'MW', 'ISO3166_1_Alpha_3' => 'MWI', 'M49' => '454', 'ITU' => 'MWI', 'MARC' => 'mw', 'WMO' => 'MW', 'DS' => 'MW', 'Dial' => '265', 'FIFA' => 'MWI', 'FIPS' => 'MI', 'GAUL' => '152', 'IOC' => 'MAW', 'ISO4217_Currency_Alphabetic_Code' => 'MWK', 'ISO4217_Currency_Country_Name' => 'MALAWI', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Kwacha', 'ISO4217_Currency_Numeric_Code' => '454', 'Is_Independent' => 'Yes', 'Capital' => 'Lilongwe', 'Continent' => 'AF', 'TLD' => '.mw', 'Languages' => 'ny,yao,tum,swk', 'Geo_Name_ID' => '927384', 'EDGAR' => 'N7'),
            133 => array('Country_Name' => 'Malaysia', 'Official_Name_English' => 'Malaysia', 'ISO3166_1_Alpha_2' => 'MY', 'ISO3166_1_Alpha_3' => 'MYS', 'M49' => '458', 'ITU' => 'MLA', 'MARC' => 'my', 'WMO' => 'MS', 'DS' => 'MAL', 'Dial' => '60', 'FIFA' => 'MAS', 'FIPS' => 'MY', 'GAUL' => '153', 'IOC' => 'MAS', 'ISO4217_Currency_Alphabetic_Code' => 'MYR', 'ISO4217_Currency_Country_Name' => 'MALAYSIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Malaysian Ringgit', 'ISO4217_Currency_Numeric_Code' => '458', 'Is_Independent' => 'Yes', 'Capital' => 'Kuala Lumpur', 'Continent' => 'AS', 'TLD' => '.my', 'Languages' => 'ms-MY,en,zh,ta,te,ml,pa,th', 'Geo_Name_ID' => '1733045', 'EDGAR' => 'N8'),
            134 => array('Country_Name' => 'Maldives', 'Official_Name_English' => 'Maldives', 'ISO3166_1_Alpha_2' => 'MV', 'ISO3166_1_Alpha_3' => 'MDV', 'M49' => '462', 'ITU' => 'MLD', 'MARC' => 'xc', 'WMO' => 'MV', 'DS' => 'MV', 'Dial' => '960', 'FIFA' => 'MDV', 'FIPS' => 'MV', 'GAUL' => '154', 'IOC' => 'MDV', 'ISO4217_Currency_Alphabetic_Code' => 'MVR', 'ISO4217_Currency_Country_Name' => 'MALDIVES', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Rufiyaa', 'ISO4217_Currency_Numeric_Code' => '462', 'Is_Independent' => 'Yes', 'Capital' => 'Male', 'Continent' => 'AS', 'TLD' => '.mv', 'Languages' => 'dv,en', 'Geo_Name_ID' => '1282028', 'EDGAR' => 'N9'),
            135 => array('Country_Name' => 'Mali', 'Official_Name_English' => 'Mali', 'ISO3166_1_Alpha_2' => 'ML', 'ISO3166_1_Alpha_3' => 'MLI', 'M49' => '466', 'ITU' => 'MLI', 'MARC' => 'ml', 'WMO' => 'MI', 'DS' => 'RMM', 'Dial' => '223', 'FIFA' => 'MLI', 'FIPS' => 'ML', 'GAUL' => '155', 'IOC' => 'MLI', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'MALI', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Bamako', 'Continent' => 'AF', 'TLD' => '.ml', 'Languages' => 'fr-ML,bm', 'Geo_Name_ID' => '2453866', 'EDGAR' => 'O0'),
            136 => array('Country_Name' => 'Malta', 'Official_Name_English' => 'Malta', 'ISO3166_1_Alpha_2' => 'MT', 'ISO3166_1_Alpha_3' => 'MLT', 'M49' => '470', 'ITU' => 'MLT', 'MARC' => 'mm', 'WMO' => 'ML', 'DS' => 'M', 'Dial' => '356', 'FIFA' => 'MLT', 'FIPS' => 'MT', 'GAUL' => '156', 'IOC' => 'MLT', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'MALTA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Valletta', 'Continent' => 'EU', 'TLD' => '.mt', 'Languages' => 'mt,en-MT', 'Geo_Name_ID' => '2562770', 'EDGAR' => 'O1'),
            137 => array('Country_Name' => 'Marshall Islands', 'Official_Name_English' => 'Marshall Islands', 'ISO3166_1_Alpha_2' => 'MH', 'ISO3166_1_Alpha_3' => 'MHL', 'M49' => '584', 'ITU' => 'MHL', 'MARC' => 'xe', 'WMO' => 'MH', 'DS' => '', 'Dial' => '692', 'FIFA' => 'MHL', 'FIPS' => 'RM', 'GAUL' => '157', 'IOC' => 'MSH', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'MARSHALL ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Majuro', 'Continent' => 'OC', 'TLD' => '.mh', 'Languages' => 'mh,en-MH', 'Geo_Name_ID' => '2080185', 'EDGAR' => '1T'),
            138 => array('Country_Name' => 'Martinique', 'Official_Name_English' => 'Martinique', 'ISO3166_1_Alpha_2' => 'MQ', 'ISO3166_1_Alpha_3' => 'MTQ', 'M49' => '474', 'ITU' => 'MRT', 'MARC' => 'mq', 'WMO' => 'MR', 'DS' => 'F', 'Dial' => '596', 'FIFA' => 'MTQ', 'FIPS' => 'MB', 'GAUL' => '158', 'IOC' => 'MRT', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'MARTINIQUE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Fort-de-France', 'Continent' => 'NA', 'TLD' => '.mq', 'Languages' => 'fr-MQ', 'Geo_Name_ID' => '3570311', 'EDGAR' => 'O2'),
            139 => array('Country_Name' => 'Mauritania', 'Official_Name_English' => 'Mauritania', 'ISO3166_1_Alpha_2' => 'MR', 'ISO3166_1_Alpha_3' => 'MRT', 'M49' => '478', 'ITU' => 'MTN', 'MARC' => 'mu', 'WMO' => 'MT', 'DS' => 'RIM', 'Dial' => '222', 'FIFA' => 'MTN', 'FIPS' => 'MR', 'GAUL' => '159', 'IOC' => 'MTN', 'ISO4217_Currency_Alphabetic_Code' => 'MRO', 'ISO4217_Currency_Country_Name' => 'MAURITANIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Ouguiya', 'ISO4217_Currency_Numeric_Code' => '478', 'Is_Independent' => 'Yes', 'Capital' => 'Nouakchott', 'Continent' => 'AF', 'TLD' => '.mr', 'Languages' => 'ar-MR,fuc,snk,fr,mey,wo', 'Geo_Name_ID' => '2378080', 'EDGAR' => 'O3'),
            140 => array('Country_Name' => 'Mauritius', 'Official_Name_English' => 'Mauritius', 'ISO3166_1_Alpha_2' => 'MU', 'ISO3166_1_Alpha_3' => 'MUS', 'M49' => '480', 'ITU' => 'MAU', 'MARC' => 'mf', 'WMO' => 'MA', 'DS' => 'MS', 'Dial' => '230', 'FIFA' => 'MRI', 'FIPS' => 'MP', 'GAUL' => '160', 'IOC' => 'MRI', 'ISO4217_Currency_Alphabetic_Code' => 'MUR', 'ISO4217_Currency_Country_Name' => 'MAURITIUS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Mauritius Rupee', 'ISO4217_Currency_Numeric_Code' => '480', 'Is_Independent' => 'Yes', 'Capital' => 'Port Louis', 'Continent' => 'AF', 'TLD' => '.mu', 'Languages' => 'en-MU,bho,fr', 'Geo_Name_ID' => '934292', 'EDGAR' => 'O4'),
            141 => array('Country_Name' => 'Mayotte', 'Official_Name_English' => 'Mayotte', 'ISO3166_1_Alpha_2' => 'YT', 'ISO3166_1_Alpha_3' => 'MYT', 'M49' => '175', 'ITU' => 'MYT', 'MARC' => 'ot', 'WMO' => '', 'DS' => '', 'Dial' => '262', 'FIFA' => 'MYT', 'FIPS' => 'MF', 'GAUL' => '161', 'IOC' => 'MAY', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'MAYOTTE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Mamoudzou', 'Continent' => 'AF', 'TLD' => '.yt', 'Languages' => 'fr-YT', 'Geo_Name_ID' => '1024031', 'EDGAR' => '2P'),
            142 => array('Country_Name' => 'Mexico', 'Official_Name_English' => 'Mexico', 'ISO3166_1_Alpha_2' => 'MX', 'ISO3166_1_Alpha_3' => 'MEX', 'M49' => '484', 'ITU' => 'MEX', 'MARC' => 'mx', 'WMO' => 'MX', 'DS' => 'MEX', 'Dial' => '52', 'FIFA' => 'MEX', 'FIPS' => 'MX', 'GAUL' => '162', 'IOC' => 'MEX', 'ISO4217_Currency_Alphabetic_Code' => 'MXN', 'ISO4217_Currency_Country_Name' => 'MEXICO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Mexican Peso', 'ISO4217_Currency_Numeric_Code' => '484', 'Is_Independent' => 'Yes', 'Capital' => 'Mexico City', 'Continent' => 'NA', 'TLD' => '.mx', 'Languages' => 'es-MX', 'Geo_Name_ID' => '3996063', 'EDGAR' => 'O5'),
            143 => array('Country_Name' => 'Micronesia', 'Official_Name_English' => 'Micronesia (Federated States of)', 'ISO3166_1_Alpha_2' => 'FM', 'ISO3166_1_Alpha_3' => 'FSM', 'M49' => '583', 'ITU' => 'FSM', 'MARC' => 'fm', 'WMO' => '', 'DS' => '', 'Dial' => '691', 'FIFA' => 'FSM', 'FIPS' => 'FM', 'GAUL' => '163', 'IOC' => 'FSM', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'MICRONESIA, FEDERATED STATES OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Palikir', 'Continent' => 'OC', 'TLD' => '.fm', 'Languages' => 'en-FM,chk,pon,yap,kos,uli,woe,nkr,kpg', 'Geo_Name_ID' => '2081918', 'EDGAR' => '1K'),
            144 => array('Country_Name' => 'Moldova', 'Official_Name_English' => 'Republic of Moldova', 'ISO3166_1_Alpha_2' => 'MD', 'ISO3166_1_Alpha_3' => 'MDA', 'M49' => '498', 'ITU' => 'MDA', 'MARC' => 'mv', 'WMO' => 'RM', 'DS' => 'MD', 'Dial' => '373', 'FIFA' => 'MDA', 'FIPS' => 'MD', 'GAUL' => '165', 'IOC' => 'MDA', 'ISO4217_Currency_Alphabetic_Code' => 'MDL', 'ISO4217_Currency_Country_Name' => 'MOLDOVA, REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Moldovan Leu', 'ISO4217_Currency_Numeric_Code' => '498', 'Is_Independent' => 'Yes', 'Capital' => 'Chisinau', 'Continent' => 'EU', 'TLD' => '.md', 'Languages' => 'ro,ru,gag,tr', 'Geo_Name_ID' => '617790', 'EDGAR' => '1S'),
            145 => array('Country_Name' => 'Monaco', 'Official_Name_English' => 'Monaco', 'ISO3166_1_Alpha_2' => 'MC', 'ISO3166_1_Alpha_3' => 'MCO', 'M49' => '492', 'ITU' => 'MCO', 'MARC' => 'mc', 'WMO' => '', 'DS' => 'MC', 'Dial' => '377', 'FIFA' => 'MON', 'FIPS' => 'MN', 'GAUL' => '166', 'IOC' => 'MON', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'MONACO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Monaco', 'Continent' => 'EU', 'TLD' => '.mc', 'Languages' => 'fr-MC,en,it', 'Geo_Name_ID' => '2993457', 'EDGAR' => 'O9'),
            146 => array('Country_Name' => 'Mongolia', 'Official_Name_English' => 'Mongolia', 'ISO3166_1_Alpha_2' => 'MN', 'ISO3166_1_Alpha_3' => 'MNG', 'M49' => '496', 'ITU' => 'MNG', 'MARC' => 'mp', 'WMO' => 'MO', 'DS' => 'MGL', 'Dial' => '976', 'FIFA' => 'MNG', 'FIPS' => 'MG', 'GAUL' => '167', 'IOC' => 'MGL', 'ISO4217_Currency_Alphabetic_Code' => 'MNT', 'ISO4217_Currency_Country_Name' => 'MONGOLIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Tugrik', 'ISO4217_Currency_Numeric_Code' => '496', 'Is_Independent' => 'Yes', 'Capital' => 'Ulan Bator', 'Continent' => 'AS', 'TLD' => '.mn', 'Languages' => 'mn,ru', 'Geo_Name_ID' => '2029969', 'EDGAR' => 'P0'),
            147 => array('Country_Name' => 'Montenegro', 'Official_Name_English' => 'Montenegro', 'ISO3166_1_Alpha_2' => 'ME', 'ISO3166_1_Alpha_3' => 'MNE', 'M49' => '499', 'ITU' => 'MNE', 'MARC' => 'mo', 'WMO' => '', 'DS' => 'MNE', 'Dial' => '382', 'FIFA' => 'MNE', 'FIPS' => 'MJ', 'GAUL' => '2647', 'IOC' => 'MGO', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'MONTENEGRO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Podgorica', 'Continent' => 'EU', 'TLD' => '.me', 'Languages' => 'sr,hu,bs,sq,hr,rom', 'Geo_Name_ID' => '3194884', 'EDGAR' => 'Z5'),
            148 => array('Country_Name' => 'Montserrat', 'Official_Name_English' => 'Montserrat', 'ISO3166_1_Alpha_2' => 'MS', 'ISO3166_1_Alpha_3' => 'MSR', 'M49' => '500', 'ITU' => 'MSR', 'MARC' => 'mj', 'WMO' => '', 'DS' => '', 'Dial' => '664', 'FIFA' => 'MSR', 'FIPS' => 'MH', 'GAUL' => '168', 'IOC' => 'MNT', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'MONTSERRAT', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Plymouth', 'Continent' => 'NA', 'TLD' => '.ms', 'Languages' => 'en-MS', 'Geo_Name_ID' => '3578097', 'EDGAR' => 'P1'),
            149 => array('Country_Name' => 'Morocco', 'Official_Name_English' => 'Morocco', 'ISO3166_1_Alpha_2' => 'MA', 'ISO3166_1_Alpha_3' => 'MAR', 'M49' => '504', 'ITU' => 'MRC', 'MARC' => 'mr', 'WMO' => 'MC', 'DS' => 'MA', 'Dial' => '212', 'FIFA' => 'MAR', 'FIPS' => 'MO', 'GAUL' => '169', 'IOC' => 'MAR', 'ISO4217_Currency_Alphabetic_Code' => 'MAD', 'ISO4217_Currency_Country_Name' => 'MOROCCO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Moroccan Dirham', 'ISO4217_Currency_Numeric_Code' => '504', 'Is_Independent' => 'Yes', 'Capital' => 'Rabat', 'Continent' => 'AF', 'TLD' => '.ma', 'Languages' => 'ar-MA,ber,fr', 'Geo_Name_ID' => '2542007', 'EDGAR' => 'P2'),
            150 => array('Country_Name' => 'Mozambique', 'Official_Name_English' => 'Mozambique', 'ISO3166_1_Alpha_2' => 'MZ', 'ISO3166_1_Alpha_3' => 'MOZ', 'M49' => '508', 'ITU' => 'MOZ', 'MARC' => 'mz', 'WMO' => 'MZ', 'DS' => 'MOC', 'Dial' => '258', 'FIFA' => 'MOZ', 'FIPS' => 'MZ', 'GAUL' => '170', 'IOC' => 'MOZ', 'ISO4217_Currency_Alphabetic_Code' => 'MZN', 'ISO4217_Currency_Country_Name' => 'MOZAMBIQUE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Mozambique Metical', 'ISO4217_Currency_Numeric_Code' => '943', 'Is_Independent' => 'Yes', 'Capital' => 'Maputo', 'Continent' => 'AF', 'TLD' => '.mz', 'Languages' => 'pt-MZ,vmw', 'Geo_Name_ID' => '1036973', 'EDGAR' => 'P3'),
            151 => array('Country_Name' => 'Myanmar', 'Official_Name_English' => 'Myanmar', 'ISO3166_1_Alpha_2' => 'MM', 'ISO3166_1_Alpha_3' => 'MMR', 'M49' => '104', 'ITU' => 'MYA', 'MARC' => 'br', 'WMO' => 'BM', 'DS' => 'BUR', 'Dial' => '95', 'FIFA' => 'MYA', 'FIPS' => 'BM', 'GAUL' => '171', 'IOC' => 'MYA', 'ISO4217_Currency_Alphabetic_Code' => 'MMK', 'ISO4217_Currency_Country_Name' => 'MYANMAR', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Kyat', 'ISO4217_Currency_Numeric_Code' => '104', 'Is_Independent' => 'Yes', 'Capital' => 'Nay Pyi Taw', 'Continent' => 'AS', 'TLD' => '.mm', 'Languages' => 'my', 'Geo_Name_ID' => '1327865', 'EDGAR' => 'E1'),
            152 => array('Country_Name' => 'Namibia', 'Official_Name_English' => 'Namibia', 'ISO3166_1_Alpha_2' => 'NA', 'ISO3166_1_Alpha_3' => 'NAM', 'M49' => '516', 'ITU' => 'NMB', 'MARC' => 'sx', 'WMO' => 'NM', 'DS' => 'NAM', 'Dial' => '264', 'FIFA' => 'NAM', 'FIPS' => 'WA', 'GAUL' => '172', 'IOC' => 'NAM', 'ISO4217_Currency_Alphabetic_Code' => 'ZAR', 'ISO4217_Currency_Country_Name' => 'NAMIBIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Rand', 'ISO4217_Currency_Numeric_Code' => '710', 'Is_Independent' => 'Yes', 'Capital' => 'Windhoek', 'Continent' => 'AF', 'TLD' => '.na', 'Languages' => 'en-NA,af,de,hz,naq', 'Geo_Name_ID' => '3355338', 'EDGAR' => 'T6'),
            153 => array('Country_Name' => 'Nauru', 'Official_Name_English' => 'Nauru', 'ISO3166_1_Alpha_2' => 'NR', 'ISO3166_1_Alpha_3' => 'NRU', 'M49' => '520', 'ITU' => 'NRU', 'MARC' => 'nu', 'WMO' => 'NW', 'DS' => 'NAU', 'Dial' => '674', 'FIFA' => 'NRU', 'FIPS' => 'NR', 'GAUL' => '173', 'IOC' => 'NRU', 'ISO4217_Currency_Alphabetic_Code' => 'AUD', 'ISO4217_Currency_Country_Name' => 'NAURU', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Australian Dollar', 'ISO4217_Currency_Numeric_Code' => '36', 'Is_Independent' => 'Yes', 'Capital' => 'Yaren', 'Continent' => 'OC', 'TLD' => '.nr', 'Languages' => 'na,en-NR', 'Geo_Name_ID' => '2110425', 'EDGAR' => 'P5'),
            154 => array('Country_Name' => 'Nepal', 'Official_Name_English' => 'Nepal', 'ISO3166_1_Alpha_2' => 'NP', 'ISO3166_1_Alpha_3' => 'NPL', 'M49' => '524', 'ITU' => 'NPL', 'MARC' => 'np', 'WMO' => 'NP', 'DS' => 'NEP', 'Dial' => '977', 'FIFA' => 'NEP', 'FIPS' => 'NP', 'GAUL' => '175', 'IOC' => 'NEP', 'ISO4217_Currency_Alphabetic_Code' => 'NPR', 'ISO4217_Currency_Country_Name' => 'NEPAL', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Nepalese Rupee', 'ISO4217_Currency_Numeric_Code' => '524', 'Is_Independent' => 'Yes', 'Capital' => 'Kathmandu', 'Continent' => 'AS', 'TLD' => '.np', 'Languages' => 'ne,en', 'Geo_Name_ID' => '1282988', 'EDGAR' => 'P6'),
            155 => array('Country_Name' => 'Netherlands', 'Official_Name_English' => 'Netherlands', 'ISO3166_1_Alpha_2' => 'NL', 'ISO3166_1_Alpha_3' => 'NLD', 'M49' => '528', 'ITU' => 'HOL', 'MARC' => 'ne', 'WMO' => 'NL', 'DS' => 'NL', 'Dial' => '31', 'FIFA' => 'NED', 'FIPS' => 'NL', 'GAUL' => '177', 'IOC' => 'NED', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'NETHERLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Amsterdam', 'Continent' => 'EU', 'TLD' => '.nl', 'Languages' => 'nl-NL,fy-NL', 'Geo_Name_ID' => '2750405', 'EDGAR' => 'P7'),
            156 => array('Country_Name' => 'New Caledonia', 'Official_Name_English' => 'New Caledonia', 'ISO3166_1_Alpha_2' => 'NC', 'ISO3166_1_Alpha_3' => 'NCL', 'M49' => '540', 'ITU' => 'NCL', 'MARC' => 'nl', 'WMO' => 'NC', 'DS' => 'F', 'Dial' => '687', 'FIFA' => 'NCL', 'FIPS' => 'NC', 'GAUL' => '178', 'IOC' => 'NCD', 'ISO4217_Currency_Alphabetic_Code' => 'XPF', 'ISO4217_Currency_Country_Name' => 'NEW CALEDONIA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFP Franc', 'ISO4217_Currency_Numeric_Code' => '953', 'Is_Independent' => 'Territory of FR', 'Capital' => 'Noumea', 'Continent' => 'OC', 'TLD' => '.nc', 'Languages' => 'fr-NC', 'Geo_Name_ID' => '2139685', 'EDGAR' => '1W'),
            157 => array('Country_Name' => 'New Zealand', 'Official_Name_English' => 'New Zealand', 'ISO3166_1_Alpha_2' => 'NZ', 'ISO3166_1_Alpha_3' => 'NZL', 'M49' => '554', 'ITU' => 'NZL', 'MARC' => 'nz', 'WMO' => 'NZ', 'DS' => 'NZ', 'Dial' => '64', 'FIFA' => 'NZL', 'FIPS' => 'NZ', 'GAUL' => '179', 'IOC' => 'NZL', 'ISO4217_Currency_Alphabetic_Code' => 'NZD', 'ISO4217_Currency_Country_Name' => 'NEW ZEALAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Zealand Dollar', 'ISO4217_Currency_Numeric_Code' => '554', 'Is_Independent' => 'Yes', 'Capital' => 'Wellington', 'Continent' => 'OC', 'TLD' => '.nz', 'Languages' => 'en-NZ,mi', 'Geo_Name_ID' => '2186224', 'EDGAR' => 'Q2'),
            158 => array('Country_Name' => 'Nicaragua', 'Official_Name_English' => 'Nicaragua', 'ISO3166_1_Alpha_2' => 'NI', 'ISO3166_1_Alpha_3' => 'NIC', 'M49' => '558', 'ITU' => 'NCG', 'MARC' => 'nq', 'WMO' => 'NK', 'DS' => 'NIC', 'Dial' => '505', 'FIFA' => 'NCA', 'FIPS' => 'NU', 'GAUL' => '180', 'IOC' => 'NCA', 'ISO4217_Currency_Alphabetic_Code' => 'NIO', 'ISO4217_Currency_Country_Name' => 'NICARAGUA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Cordoba Oro', 'ISO4217_Currency_Numeric_Code' => '558', 'Is_Independent' => 'Yes', 'Capital' => 'Managua', 'Continent' => 'NA', 'TLD' => '.ni', 'Languages' => 'es-NI,en', 'Geo_Name_ID' => '3617476', 'EDGAR' => 'Q3'),
            159 => array('Country_Name' => 'Niger', 'Official_Name_English' => 'Niger', 'ISO3166_1_Alpha_2' => 'NE', 'ISO3166_1_Alpha_3' => 'NER', 'M49' => '562', 'ITU' => 'NGR', 'MARC' => 'ng', 'WMO' => 'NR', 'DS' => 'RN', 'Dial' => '227', 'FIFA' => 'NIG', 'FIPS' => 'NG', 'GAUL' => '181', 'IOC' => 'NIG', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'NIGER', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Niamey', 'Continent' => 'AF', 'TLD' => '.ne', 'Languages' => 'fr-NE,ha,kr,dje', 'Geo_Name_ID' => '2440476', 'EDGAR' => 'Q4'),
            160 => array('Country_Name' => 'Nigeria', 'Official_Name_English' => 'Nigeria', 'ISO3166_1_Alpha_2' => 'NG', 'ISO3166_1_Alpha_3' => 'NGA', 'M49' => '566', 'ITU' => 'NIG', 'MARC' => 'nr', 'WMO' => 'NI', 'DS' => 'WAN', 'Dial' => '234', 'FIFA' => 'NGA', 'FIPS' => 'NI', 'GAUL' => '182', 'IOC' => 'NGR', 'ISO4217_Currency_Alphabetic_Code' => 'NGN', 'ISO4217_Currency_Country_Name' => 'NIGERIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Naira', 'ISO4217_Currency_Numeric_Code' => '566', 'Is_Independent' => 'Yes', 'Capital' => 'Abuja', 'Continent' => 'AF', 'TLD' => '.ng', 'Languages' => 'en-NG,ha,yo,ig,ff', 'Geo_Name_ID' => '2328926', 'EDGAR' => 'Q5'),
            161 => array('Country_Name' => 'Niue', 'Official_Name_English' => 'Niue', 'ISO3166_1_Alpha_2' => 'NU', 'ISO3166_1_Alpha_3' => 'NIU', 'M49' => '570', 'ITU' => 'NIU', 'MARC' => 'xh', 'WMO' => '', 'DS' => 'NZ', 'Dial' => '683', 'FIFA' => 'NIU', 'FIPS' => 'NE', 'GAUL' => '183', 'IOC' => 'NIU', 'ISO4217_Currency_Alphabetic_Code' => 'NZD', 'ISO4217_Currency_Country_Name' => 'NIUE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Zealand Dollar', 'ISO4217_Currency_Numeric_Code' => '554', 'Is_Independent' => 'Associated with NZ', 'Capital' => 'Alofi', 'Continent' => 'OC', 'TLD' => '.nu', 'Languages' => 'niu,en-NU', 'Geo_Name_ID' => '4036232', 'EDGAR' => 'Q6'),
            162 => array('Country_Name' => 'Norfolk Island', 'Official_Name_English' => 'Norfolk Island', 'ISO3166_1_Alpha_2' => 'NF', 'ISO3166_1_Alpha_3' => 'NFK', 'M49' => '574', 'ITU' => 'NFK', 'MARC' => 'nx', 'WMO' => 'NF', 'DS' => 'AUS', 'Dial' => '672', 'FIFA' => 'NFK', 'FIPS' => 'NF', 'GAUL' => '184', 'IOC' => 'NFI', 'ISO4217_Currency_Alphabetic_Code' => 'AUD', 'ISO4217_Currency_Country_Name' => 'NORFOLK ISLAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Australian Dollar', 'ISO4217_Currency_Numeric_Code' => '36', 'Is_Independent' => 'Territory of AU', 'Capital' => 'Kingston', 'Continent' => 'OC', 'TLD' => '.nf', 'Languages' => 'en-NF', 'Geo_Name_ID' => '2155115', 'EDGAR' => 'Q7'),
            163 => array('Country_Name' => 'North Korea', 'Official_Name_English' => 'Democratic People\'s Republic of Korea', 'ISO3166_1_Alpha_2' => 'KP', 'ISO3166_1_Alpha_3' => 'PRK', 'M49' => '408', 'ITU' => 'KRE', 'MARC' => 'kn', 'WMO' => 'KR', 'DS' => '', 'Dial' => '850', 'FIFA' => 'PRK', 'FIPS' => 'KN', 'GAUL' => '67', 'IOC' => 'PRK', 'ISO4217_Currency_Alphabetic_Code' => 'KPW', 'ISO4217_Currency_Country_Name' => 'KOREA, DEMOCRATIC PEOPLEâ€™S REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'North Korean Won', 'ISO4217_Currency_Numeric_Code' => '408', 'Is_Independent' => 'Yes', 'Capital' => 'Pyongyang', 'Continent' => 'AS', 'TLD' => '.kp', 'Languages' => 'ko-KP', 'Geo_Name_ID' => '1873107', 'EDGAR' => ''),
            164 => array('Country_Name' => 'Northern Mariana Islands', 'Official_Name_English' => 'Northern Mariana Islands', 'ISO3166_1_Alpha_2' => 'MP', 'ISO3166_1_Alpha_3' => 'MNP', 'M49' => '580', 'ITU' => 'MRA', 'MARC' => 'nw', 'WMO' => 'MY', 'DS' => 'USA', 'Dial' => '670', 'FIFA' => 'NMI', 'FIPS' => 'CQ', 'GAUL' => '185', 'IOC' => 'NMA', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'NORTHERN MARIANA ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Commonwealth of US', 'Capital' => 'Saipan', 'Continent' => 'OC', 'TLD' => '.mp', 'Languages' => 'fil,tl,zh,ch-MP,en-MP', 'Geo_Name_ID' => '4041468', 'EDGAR' => '1V'),
            165 => array('Country_Name' => 'Norway', 'Official_Name_English' => 'Norway', 'ISO3166_1_Alpha_2' => 'NO', 'ISO3166_1_Alpha_3' => 'NOR', 'M49' => '578', 'ITU' => 'NOR', 'MARC' => 'no', 'WMO' => 'NO', 'DS' => 'N', 'Dial' => '47', 'FIFA' => 'NOR', 'FIPS' => 'NO', 'GAUL' => '186', 'IOC' => 'NOR', 'ISO4217_Currency_Alphabetic_Code' => 'NOK', 'ISO4217_Currency_Country_Name' => 'NORWAY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Norwegian Krone', 'ISO4217_Currency_Numeric_Code' => '578', 'Is_Independent' => 'Yes', 'Capital' => 'Oslo', 'Continent' => 'EU', 'TLD' => '.no', 'Languages' => 'no,nb,nn,se,fi', 'Geo_Name_ID' => '3144096', 'EDGAR' => 'Q8'),
            166 => array('Country_Name' => 'Oman', 'Official_Name_English' => 'Oman', 'ISO3166_1_Alpha_2' => 'OM', 'ISO3166_1_Alpha_3' => 'OMN', 'M49' => '512', 'ITU' => 'OMA', 'MARC' => 'mk', 'WMO' => 'OM', 'DS' => '', 'Dial' => '968', 'FIFA' => 'OMA', 'FIPS' => 'MU', 'GAUL' => '187', 'IOC' => 'OMA', 'ISO4217_Currency_Alphabetic_Code' => 'OMR', 'ISO4217_Currency_Country_Name' => 'OMAN', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Rial Omani', 'ISO4217_Currency_Numeric_Code' => '512', 'Is_Independent' => 'Yes', 'Capital' => 'Muscat', 'Continent' => 'AS', 'TLD' => '.om', 'Languages' => 'ar-OM,en,bal,ur', 'Geo_Name_ID' => '286963', 'EDGAR' => 'P4'),
            167 => array('Country_Name' => 'Pakistan', 'Official_Name_English' => 'Pakistan', 'ISO3166_1_Alpha_2' => 'PK', 'ISO3166_1_Alpha_3' => 'PAK', 'M49' => '586', 'ITU' => 'PAK', 'MARC' => 'pk', 'WMO' => 'PK', 'DS' => 'PK', 'Dial' => '92', 'FIFA' => 'PAK', 'FIPS' => 'PK', 'GAUL' => '188', 'IOC' => 'PAK', 'ISO4217_Currency_Alphabetic_Code' => 'PKR', 'ISO4217_Currency_Country_Name' => 'PAKISTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pakistan Rupee', 'ISO4217_Currency_Numeric_Code' => '586', 'Is_Independent' => 'Yes', 'Capital' => 'Islamabad', 'Continent' => 'AS', 'TLD' => '.pk', 'Languages' => 'ur-PK,en-PK,pa,sd,ps,brh', 'Geo_Name_ID' => '1168579', 'EDGAR' => 'R0'),
            168 => array('Country_Name' => 'Palau', 'Official_Name_English' => 'Palau', 'ISO3166_1_Alpha_2' => 'PW', 'ISO3166_1_Alpha_3' => 'PLW', 'M49' => '585', 'ITU' => 'PLW', 'MARC' => 'pw', 'WMO' => '', 'DS' => '', 'Dial' => '680', 'FIFA' => 'PLW', 'FIPS' => 'PS', 'GAUL' => '189', 'IOC' => 'PLW', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'PALAU', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Melekeok', 'Continent' => 'OC', 'TLD' => '.pw', 'Languages' => 'pau,sov,en-PW,tox,ja,fil,zh', 'Geo_Name_ID' => '1559582', 'EDGAR' => '1Y'),
            169 => array('Country_Name' => 'Palestine', 'Official_Name_English' => 'State of Palestine', 'ISO3166_1_Alpha_2' => 'PS', 'ISO3166_1_Alpha_3' => 'PSE', 'M49' => '275', 'ITU' => '', 'MARC' => 'gz,wj', 'WMO' => '', 'DS' => '', 'Dial' => '970', 'FIFA' => 'PLE', 'FIPS' => 'GZ,WE', 'GAUL' => '91,267', 'IOC' => 'PLE', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => 'PALESTINE, STATE OF', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => 'No universal currency', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'In contention', 'Capital' => 'East Jerusalem', 'Continent' => 'AS', 'TLD' => '.ps', 'Languages' => 'ar-PS', 'Geo_Name_ID' => '6254930', 'EDGAR' => ''),
            170 => array('Country_Name' => 'Panama', 'Official_Name_English' => 'Panama', 'ISO3166_1_Alpha_2' => 'PA', 'ISO3166_1_Alpha_3' => 'PAN', 'M49' => '591', 'ITU' => 'PNR', 'MARC' => 'pn', 'WMO' => 'PM', 'DS' => 'PA', 'Dial' => '507', 'FIFA' => 'PAN', 'FIPS' => 'PM', 'GAUL' => '191', 'IOC' => 'PAN', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'PANAMA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Panama City', 'Continent' => 'NA', 'TLD' => '.pa', 'Languages' => 'es-PA,en', 'Geo_Name_ID' => '3703430', 'EDGAR' => 'R1'),
            171 => array('Country_Name' => 'Papua New Guinea', 'Official_Name_English' => 'Papua New Guinea', 'ISO3166_1_Alpha_2' => 'PG', 'ISO3166_1_Alpha_3' => 'PNG', 'M49' => '598', 'ITU' => 'PNG', 'MARC' => 'pp', 'WMO' => 'NG', 'DS' => 'PNG', 'Dial' => '675', 'FIFA' => 'PNG', 'FIPS' => 'PP', 'GAUL' => '192', 'IOC' => 'PNG', 'ISO4217_Currency_Alphabetic_Code' => 'PGK', 'ISO4217_Currency_Country_Name' => 'PAPUA NEW GUINEA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Kina', 'ISO4217_Currency_Numeric_Code' => '598', 'Is_Independent' => 'Yes', 'Capital' => 'Port Moresby', 'Continent' => 'OC', 'TLD' => '.pg', 'Languages' => 'en-PG,ho,meu,tpi', 'Geo_Name_ID' => '2088628', 'EDGAR' => 'R2'),
            172 => array('Country_Name' => 'Paraguay', 'Official_Name_English' => 'Paraguay', 'ISO3166_1_Alpha_2' => 'PY', 'ISO3166_1_Alpha_3' => 'PRY', 'M49' => '600', 'ITU' => 'PRG', 'MARC' => 'py', 'WMO' => 'PY', 'DS' => 'PY', 'Dial' => '595', 'FIFA' => 'PAR', 'FIPS' => 'PA', 'GAUL' => '194', 'IOC' => 'PAR', 'ISO4217_Currency_Alphabetic_Code' => 'PYG', 'ISO4217_Currency_Country_Name' => 'PARAGUAY', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Guarani', 'ISO4217_Currency_Numeric_Code' => '600', 'Is_Independent' => 'Yes', 'Capital' => 'Asuncion', 'Continent' => 'SA', 'TLD' => '.py', 'Languages' => 'es-PY,gn', 'Geo_Name_ID' => '3437598', 'EDGAR' => 'R4'),
            173 => array('Country_Name' => 'Peru', 'Official_Name_English' => 'Peru', 'ISO3166_1_Alpha_2' => 'PE', 'ISO3166_1_Alpha_3' => 'PER', 'M49' => '604', 'ITU' => 'PRU', 'MARC' => 'pe', 'WMO' => 'PR', 'DS' => 'PE', 'Dial' => '51', 'FIFA' => 'PER', 'FIPS' => 'PE', 'GAUL' => '195', 'IOC' => 'PER', 'ISO4217_Currency_Alphabetic_Code' => 'PEN', 'ISO4217_Currency_Country_Name' => 'PERU', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Nuevo Sol', 'ISO4217_Currency_Numeric_Code' => '604', 'Is_Independent' => 'Yes', 'Capital' => 'Lima', 'Continent' => 'SA', 'TLD' => '.pe', 'Languages' => 'es-PE,qu,ay', 'Geo_Name_ID' => '3932488', 'EDGAR' => 'R5'),
            174 => array('Country_Name' => 'Philippines', 'Official_Name_English' => 'Philippines', 'ISO3166_1_Alpha_2' => 'PH', 'ISO3166_1_Alpha_3' => 'PHL', 'M49' => '608', 'ITU' => 'PHL', 'MARC' => 'ph', 'WMO' => 'PH', 'DS' => 'RP', 'Dial' => '63', 'FIFA' => 'PHI', 'FIPS' => 'RP', 'GAUL' => '196', 'IOC' => 'PHI', 'ISO4217_Currency_Alphabetic_Code' => 'PHP', 'ISO4217_Currency_Country_Name' => 'PHILIPPINES', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Philippine Peso', 'ISO4217_Currency_Numeric_Code' => '608', 'Is_Independent' => 'Yes', 'Capital' => 'Manila', 'Continent' => 'AS', 'TLD' => '.ph', 'Languages' => 'tl,en-PH,fil', 'Geo_Name_ID' => '1694008', 'EDGAR' => 'R6'),
            175 => array('Country_Name' => 'Pitcairn Islands', 'Official_Name_English' => 'Pitcairn', 'ISO3166_1_Alpha_2' => 'PN', 'ISO3166_1_Alpha_3' => 'PCN', 'M49' => '612', 'ITU' => 'PTC', 'MARC' => 'pc', 'WMO' => 'PT', 'DS' => '', 'Dial' => '870', 'FIFA' => 'PCN', 'FIPS' => 'PC', 'GAUL' => '197', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'NZD', 'ISO4217_Currency_Country_Name' => 'PITCAIRN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Zealand Dollar', 'ISO4217_Currency_Numeric_Code' => '554', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Adamstown', 'Continent' => 'OC', 'TLD' => '.pn', 'Languages' => 'en-PN', 'Geo_Name_ID' => '4030699', 'EDGAR' => 'R8'),
            176 => array('Country_Name' => 'Poland', 'Official_Name_English' => 'Poland', 'ISO3166_1_Alpha_2' => 'PL', 'ISO3166_1_Alpha_3' => 'POL', 'M49' => '616', 'ITU' => 'POL', 'MARC' => 'pl', 'WMO' => 'PL', 'DS' => 'PL', 'Dial' => '48', 'FIFA' => 'POL', 'FIPS' => 'PL', 'GAUL' => '198', 'IOC' => 'POL', 'ISO4217_Currency_Alphabetic_Code' => 'PLN', 'ISO4217_Currency_Country_Name' => 'POLAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Zloty', 'ISO4217_Currency_Numeric_Code' => '985', 'Is_Independent' => 'Yes', 'Capital' => 'Warsaw', 'Continent' => 'EU', 'TLD' => '.pl', 'Languages' => 'pl', 'Geo_Name_ID' => '798544', 'EDGAR' => 'R9'),
            177 => array('Country_Name' => 'Portugal', 'Official_Name_English' => 'Portugal', 'ISO3166_1_Alpha_2' => 'PT', 'ISO3166_1_Alpha_3' => 'PRT', 'M49' => '620', 'ITU' => 'POR', 'MARC' => 'po', 'WMO' => 'PO', 'DS' => 'P', 'Dial' => '351', 'FIFA' => 'POR', 'FIPS' => 'PO', 'GAUL' => '199', 'IOC' => 'POR', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'PORTUGAL', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Lisbon', 'Continent' => 'EU', 'TLD' => '.pt', 'Languages' => 'pt-PT,mwl', 'Geo_Name_ID' => '2264397', 'EDGAR' => 'S1'),
            178 => array('Country_Name' => 'Puerto Rico', 'Official_Name_English' => 'Puerto Rico', 'ISO3166_1_Alpha_2' => 'PR', 'ISO3166_1_Alpha_3' => 'PRI', 'M49' => '630', 'ITU' => 'PTR', 'MARC' => 'pr', 'WMO' => 'PU', 'DS' => 'USA', 'Dial' => '1', 'FIFA' => 'PUR', 'FIPS' => 'RQ', 'GAUL' => '200', 'IOC' => 'PUR', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'PUERTO RICO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Commonwealth of US', 'Capital' => 'San Juan', 'Continent' => 'NA', 'TLD' => '.pr', 'Languages' => 'en-PR,es-PR', 'Geo_Name_ID' => '4566966', 'EDGAR' => 'PR'),
            179 => array('Country_Name' => 'Qatar', 'Official_Name_English' => 'Qatar', 'ISO3166_1_Alpha_2' => 'QA', 'ISO3166_1_Alpha_3' => 'QAT', 'M49' => '634', 'ITU' => 'QAT', 'MARC' => 'qa', 'WMO' => 'QT', 'DS' => 'Q', 'Dial' => '974', 'FIFA' => 'QAT', 'FIPS' => 'QA', 'GAUL' => '201', 'IOC' => 'QAT', 'ISO4217_Currency_Alphabetic_Code' => 'QAR', 'ISO4217_Currency_Country_Name' => 'QATAR', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Qatari Rial', 'ISO4217_Currency_Numeric_Code' => '634', 'Is_Independent' => 'Yes', 'Capital' => 'Doha', 'Continent' => 'AS', 'TLD' => '.qa', 'Languages' => 'ar-QA,es', 'Geo_Name_ID' => '289688', 'EDGAR' => 'S3'),
            180 => array('Country_Name' => 'Romania', 'Official_Name_English' => 'Romania', 'ISO3166_1_Alpha_2' => 'RO', 'ISO3166_1_Alpha_3' => 'ROU', 'M49' => '642', 'ITU' => 'ROU', 'MARC' => 'rm', 'WMO' => 'RO', 'DS' => 'RO', 'Dial' => '40', 'FIFA' => 'ROU', 'FIPS' => 'RO', 'GAUL' => '203', 'IOC' => 'ROU', 'ISO4217_Currency_Alphabetic_Code' => 'RON', 'ISO4217_Currency_Country_Name' => 'ROMANIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Romanian Leu', 'ISO4217_Currency_Numeric_Code' => '946', 'Is_Independent' => 'Yes', 'Capital' => 'Bucharest', 'Continent' => 'EU', 'TLD' => '.ro', 'Languages' => 'ro,hu,rom', 'Geo_Name_ID' => '798549', 'EDGAR' => 'S5'),
            181 => array('Country_Name' => 'Russia', 'Official_Name_English' => 'Russian Federation', 'ISO3166_1_Alpha_2' => 'RU', 'ISO3166_1_Alpha_3' => 'RUS', 'M49' => '643', 'ITU' => 'RUS', 'MARC' => 'ru', 'WMO' => 'RS', 'DS' => 'RUS', 'Dial' => '7', 'FIFA' => 'RUS', 'FIPS' => 'RS', 'GAUL' => '204', 'IOC' => 'RUS', 'ISO4217_Currency_Alphabetic_Code' => 'RUB', 'ISO4217_Currency_Country_Name' => 'RUSSIAN FEDERATION', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Russian Ruble', 'ISO4217_Currency_Numeric_Code' => '643', 'Is_Independent' => 'Yes', 'Capital' => 'Moscow', 'Continent' => 'EU', 'TLD' => '.ru', 'Languages' => 'ru,tt,xal,cau,ady,kv,ce,tyv,cv,udm,tut,mns,bua,myv,mdf,chm,ba,inh,tut,kbd,krc,ava,sah,nog', 'Geo_Name_ID' => '2017370', 'EDGAR' => '1Z'),
            182 => array('Country_Name' => 'Rwanda', 'Official_Name_English' => 'Rwanda', 'ISO3166_1_Alpha_2' => 'RW', 'ISO3166_1_Alpha_3' => 'RWA', 'M49' => '646', 'ITU' => 'RRW', 'MARC' => 'rw', 'WMO' => 'RW', 'DS' => 'RWA', 'Dial' => '250', 'FIFA' => 'RWA', 'FIPS' => 'RW', 'GAUL' => '205', 'IOC' => 'RWA', 'ISO4217_Currency_Alphabetic_Code' => 'RWF', 'ISO4217_Currency_Country_Name' => 'RWANDA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Rwanda Franc', 'ISO4217_Currency_Numeric_Code' => '646', 'Is_Independent' => 'Yes', 'Capital' => 'Kigali', 'Continent' => 'AF', 'TLD' => '.rw', 'Languages' => 'rw,en-RW,fr-RW,sw', 'Geo_Name_ID' => '49518', 'EDGAR' => 'S6'),
            183 => array('Country_Name' => 'Réunion', 'Official_Name_English' => 'Réunion', 'ISO3166_1_Alpha_2' => 'RE', 'ISO3166_1_Alpha_3' => 'REU', 'M49' => '638', 'ITU' => 'REU', 'MARC' => 're', 'WMO' => 'RE', 'DS' => 'F', 'Dial' => '262', 'FIFA' => 'REU', 'FIPS' => 'RE', 'GAUL' => '206', 'IOC' => 'REU', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'RÉUNION', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Saint-Denis', 'Continent' => 'AF', 'TLD' => '.re', 'Languages' => 'fr-RE', 'Geo_Name_ID' => '935317', 'EDGAR' => ''),
            184 => array('Country_Name' => 'Samoa', 'Official_Name_English' => 'Samoa', 'ISO3166_1_Alpha_2' => 'WS', 'ISO3166_1_Alpha_3' => 'WSM', 'M49' => '882', 'ITU' => 'SMO', 'MARC' => 'ws', 'WMO' => 'ZM', 'DS' => 'WS', 'Dial' => '685', 'FIFA' => 'SAM', 'FIPS' => 'WS', 'GAUL' => '212', 'IOC' => 'SAM', 'ISO4217_Currency_Alphabetic_Code' => 'WST', 'ISO4217_Currency_Country_Name' => 'SAMOA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Tala', 'ISO4217_Currency_Numeric_Code' => '882', 'Is_Independent' => 'Yes', 'Capital' => 'Apia', 'Continent' => 'OC', 'TLD' => '.ws', 'Languages' => 'sm,en-WS', 'Geo_Name_ID' => '4034894', 'EDGAR' => 'Y0'),
            185 => array('Country_Name' => 'San Marino', 'Official_Name_English' => 'San Marino', 'ISO3166_1_Alpha_2' => 'SM', 'ISO3166_1_Alpha_3' => 'SMR', 'M49' => '674', 'ITU' => 'SMR', 'MARC' => 'sm', 'WMO' => '', 'DS' => 'RSM', 'Dial' => '378', 'FIFA' => 'SMR', 'FIPS' => 'SM', 'GAUL' => '213', 'IOC' => 'SMR', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SAN MARINO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'San Marino', 'Continent' => 'EU', 'TLD' => '.sm', 'Languages' => 'it-SM', 'Geo_Name_ID' => '3168068', 'EDGAR' => 'S8'),
            186 => array('Country_Name' => 'Saudi Arabia', 'Official_Name_English' => 'Saudi Arabia', 'ISO3166_1_Alpha_2' => 'SA', 'ISO3166_1_Alpha_3' => 'SAU', 'M49' => '682', 'ITU' => 'ARS', 'MARC' => 'su', 'WMO' => 'SD', 'DS' => 'SA', 'Dial' => '966', 'FIFA' => 'KSA', 'FIPS' => 'SA', 'GAUL' => '215', 'IOC' => 'KSA', 'ISO4217_Currency_Alphabetic_Code' => 'SAR', 'ISO4217_Currency_Country_Name' => 'SAUDI ARABIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Saudi Riyal', 'ISO4217_Currency_Numeric_Code' => '682', 'Is_Independent' => 'Yes', 'Capital' => 'Riyadh', 'Continent' => 'AS', 'TLD' => '.sa', 'Languages' => 'ar-SA', 'Geo_Name_ID' => '102358', 'EDGAR' => 'T0'),
            187 => array('Country_Name' => 'Senegal', 'Official_Name_English' => 'Senegal', 'ISO3166_1_Alpha_2' => 'SN', 'ISO3166_1_Alpha_3' => 'SEN', 'M49' => '686', 'ITU' => 'SEN', 'MARC' => 'sg', 'WMO' => 'SG', 'DS' => 'SN', 'Dial' => '221', 'FIFA' => 'SEN', 'FIPS' => 'SG', 'GAUL' => '217', 'IOC' => 'SEN', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'SENEGAL', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Dakar', 'Continent' => 'AF', 'TLD' => '.sn', 'Languages' => 'fr-SN,wo,fuc,mnk', 'Geo_Name_ID' => '2245662', 'EDGAR' => 'T1'),
            188 => array('Country_Name' => 'Serbia', 'Official_Name_English' => 'Serbia', 'ISO3166_1_Alpha_2' => 'RS', 'ISO3166_1_Alpha_3' => 'SRB', 'M49' => '688', 'ITU' => 'SRB', 'MARC' => 'rb', 'WMO' => 'YG', 'DS' => 'SRB', 'Dial' => '381 p', 'FIFA' => 'SRB', 'FIPS' => 'RI,KV', 'GAUL' => '2648', 'IOC' => 'SRB', 'ISO4217_Currency_Alphabetic_Code' => 'RSD', 'ISO4217_Currency_Country_Name' => 'SERBIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Serbian Dinar', 'ISO4217_Currency_Numeric_Code' => '941', 'Is_Independent' => 'Yes', 'Capital' => 'Belgrade', 'Continent' => 'EU', 'TLD' => '.rs', 'Languages' => 'sr,hu,bs,rom', 'Geo_Name_ID' => '6290252', 'EDGAR' => 'Z2'),
            189 => array('Country_Name' => 'Seychelles', 'Official_Name_English' => 'Seychelles', 'ISO3166_1_Alpha_2' => 'SC', 'ISO3166_1_Alpha_3' => 'SYC', 'M49' => '690', 'ITU' => 'SEY', 'MARC' => 'se', 'WMO' => 'SC', 'DS' => 'SY', 'Dial' => '248', 'FIFA' => 'SEY', 'FIPS' => 'SE', 'GAUL' => '220', 'IOC' => 'SEY', 'ISO4217_Currency_Alphabetic_Code' => 'SCR', 'ISO4217_Currency_Country_Name' => 'SEYCHELLES', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Seychelles Rupee', 'ISO4217_Currency_Numeric_Code' => '690', 'Is_Independent' => 'Yes', 'Capital' => 'Victoria', 'Continent' => 'AF', 'TLD' => '.sc', 'Languages' => 'en-SC,fr-SC', 'Geo_Name_ID' => '241170', 'EDGAR' => 'T2'),
            190 => array('Country_Name' => 'Sierra Leone', 'Official_Name_English' => 'Sierra Leone', 'ISO3166_1_Alpha_2' => 'SL', 'ISO3166_1_Alpha_3' => 'SLE', 'M49' => '694', 'ITU' => 'SRL', 'MARC' => 'sl', 'WMO' => 'SL', 'DS' => 'WAL', 'Dial' => '232', 'FIFA' => 'SLE', 'FIPS' => 'SL', 'GAUL' => '221', 'IOC' => 'SLE', 'ISO4217_Currency_Alphabetic_Code' => 'SLL', 'ISO4217_Currency_Country_Name' => 'SIERRA LEONE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Leone', 'ISO4217_Currency_Numeric_Code' => '694', 'Is_Independent' => 'Yes', 'Capital' => 'Freetown', 'Continent' => 'AF', 'TLD' => '.sl', 'Languages' => 'en-SL,men,tem', 'Geo_Name_ID' => '2403846', 'EDGAR' => 'T8'),
            191 => array('Country_Name' => 'Singapore', 'Official_Name_English' => 'Singapore', 'ISO3166_1_Alpha_2' => 'SG', 'ISO3166_1_Alpha_3' => 'SGP', 'M49' => '702', 'ITU' => 'SNG', 'MARC' => 'si', 'WMO' => 'SR', 'DS' => 'SGP', 'Dial' => '65', 'FIFA' => 'SIN', 'FIPS' => 'SN', 'GAUL' => '222', 'IOC' => 'SIN', 'ISO4217_Currency_Alphabetic_Code' => 'SGD', 'ISO4217_Currency_Country_Name' => 'SINGAPORE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Singapore Dollar', 'ISO4217_Currency_Numeric_Code' => '702', 'Is_Independent' => 'Yes', 'Capital' => 'Singapore', 'Continent' => 'AS', 'TLD' => '.sg', 'Languages' => 'cmn,en-SG,ms-SG,ta-SG,zh-SG', 'Geo_Name_ID' => '1880251', 'EDGAR' => 'U0'),
            192 => array('Country_Name' => 'Sint Maarten', 'Official_Name_English' => 'Sint Maarten (Dutch part)', 'ISO3166_1_Alpha_2' => 'SX', 'ISO3166_1_Alpha_3' => 'SXM', 'M49' => '534', 'ITU' => '', 'MARC' => 'sn', 'WMO' => '', 'DS' => '', 'Dial' => '721', 'FIFA' => '', 'FIPS' => 'NN', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'ANG', 'ISO4217_Currency_Country_Name' => 'SINT MAARTEN (DUTCH PART)', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Netherlands Antillean Guilder', 'ISO4217_Currency_Numeric_Code' => '532', 'Is_Independent' => 'Part of NL', 'Capital' => 'Philipsburg', 'Continent' => 'NA', 'TLD' => '.sx', 'Languages' => 'nl,en', 'Geo_Name_ID' => '7609695', 'EDGAR' => ''),
            193 => array('Country_Name' => 'Slovakia', 'Official_Name_English' => 'Slovakia', 'ISO3166_1_Alpha_2' => 'SK', 'ISO3166_1_Alpha_3' => 'SVK', 'M49' => '703', 'ITU' => 'SVK', 'MARC' => 'xo', 'WMO' => 'SQ', 'DS' => 'SK', 'Dial' => '421', 'FIFA' => 'SVK', 'FIPS' => 'LO', 'GAUL' => '223', 'IOC' => 'SVK', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SLOVAKIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Bratislava', 'Continent' => 'EU', 'TLD' => '.sk', 'Languages' => 'sk,hu', 'Geo_Name_ID' => '3057568', 'EDGAR' => '2B'),
            194 => array('Country_Name' => 'Slovenia', 'Official_Name_English' => 'Slovenia', 'ISO3166_1_Alpha_2' => 'SI', 'ISO3166_1_Alpha_3' => 'SVN', 'M49' => '705', 'ITU' => 'SVN', 'MARC' => 'xv', 'WMO' => 'LJ', 'DS' => 'SLO', 'Dial' => '386', 'FIFA' => 'SVN', 'FIPS' => 'SI', 'GAUL' => '224', 'IOC' => 'SLO', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SLOVENIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Ljubljana', 'Continent' => 'EU', 'TLD' => '.si', 'Languages' => 'sl,sh', 'Geo_Name_ID' => '3190538', 'EDGAR' => '2A'),
            195 => array('Country_Name' => 'Solomon Islands', 'Official_Name_English' => 'Solomon Islands', 'ISO3166_1_Alpha_2' => 'SB', 'ISO3166_1_Alpha_3' => 'SLB', 'M49' => '090', 'ITU' => 'SLM', 'MARC' => 'bp', 'WMO' => 'SO', 'DS' => 'SB', 'Dial' => '677', 'FIFA' => 'SOL', 'FIPS' => 'BP', 'GAUL' => '225', 'IOC' => 'SOL', 'ISO4217_Currency_Alphabetic_Code' => 'SBD', 'ISO4217_Currency_Country_Name' => 'SOLOMON ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Solomon Islands Dollar', 'ISO4217_Currency_Numeric_Code' => '90', 'Is_Independent' => 'Yes', 'Capital' => 'Honiara', 'Continent' => 'OC', 'TLD' => '.sb', 'Languages' => 'en-SB,tpi', 'Geo_Name_ID' => '2103350', 'EDGAR' => 'D7'),
            196 => array('Country_Name' => 'Somalia', 'Official_Name_English' => 'Somalia', 'ISO3166_1_Alpha_2' => 'SO', 'ISO3166_1_Alpha_3' => 'SOM', 'M49' => '706', 'ITU' => 'SOM', 'MARC' => 'so', 'WMO' => 'SI', 'DS' => 'SO', 'Dial' => '252', 'FIFA' => 'SOM', 'FIPS' => 'SO', 'GAUL' => '226', 'IOC' => 'SOM', 'ISO4217_Currency_Alphabetic_Code' => 'SOS', 'ISO4217_Currency_Country_Name' => 'SOMALIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Somali Shilling', 'ISO4217_Currency_Numeric_Code' => '706', 'Is_Independent' => 'Yes', 'Capital' => 'Mogadishu', 'Continent' => 'AF', 'TLD' => '.so', 'Languages' => 'so-SO,ar-SO,it,en-SO', 'Geo_Name_ID' => '51537', 'EDGAR' => 'U1'),
            197 => array('Country_Name' => 'South Africa', 'Official_Name_English' => 'South Africa', 'ISO3166_1_Alpha_2' => 'ZA', 'ISO3166_1_Alpha_3' => 'ZAF', 'M49' => '710', 'ITU' => 'AFS', 'MARC' => 'sa', 'WMO' => 'ZA', 'DS' => 'ZA', 'Dial' => '27', 'FIFA' => 'RSA', 'FIPS' => 'SF', 'GAUL' => '227', 'IOC' => 'RSA', 'ISO4217_Currency_Alphabetic_Code' => 'ZAR', 'ISO4217_Currency_Country_Name' => 'SOUTH AFRICA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Rand', 'ISO4217_Currency_Numeric_Code' => '710', 'Is_Independent' => 'Yes', 'Capital' => 'Pretoria', 'Continent' => 'AF', 'TLD' => '.za', 'Languages' => 'zu,xh,af,nso,en-ZA,tn,st,ts,ss,ve,nr', 'Geo_Name_ID' => '953987', 'EDGAR' => 'T3'),
            198 => array('Country_Name' => 'South Georgia & South Sandwich Islands', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'GS', 'ISO3166_1_Alpha_3' => 'SGS', 'M49' => '239', 'ITU' => '', 'MARC' => 'xs', 'WMO' => '', 'DS' => '', 'Dial' => '500', 'FIFA' => '', 'FIPS' => 'SX', 'GAUL' => '228', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Grytviken', 'Continent' => 'AN', 'TLD' => '.gs', 'Languages' => 'en', 'Geo_Name_ID' => '3474415', 'EDGAR' => ''),
            199 => array('Country_Name' => 'South Korea', 'Official_Name_English' => 'Republic of Korea', 'ISO3166_1_Alpha_2' => 'KR', 'ISO3166_1_Alpha_3' => 'KOR', 'M49' => '410', 'ITU' => 'KOR', 'MARC' => 'ko', 'WMO' => 'KO', 'DS' => 'ROK', 'Dial' => '82', 'FIFA' => 'KOR', 'FIPS' => 'KS', 'GAUL' => '202', 'IOC' => 'KOR', 'ISO4217_Currency_Alphabetic_Code' => 'KRW', 'ISO4217_Currency_Country_Name' => 'KOREA, REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Won', 'ISO4217_Currency_Numeric_Code' => '410', 'Is_Independent' => 'Yes', 'Capital' => 'Seoul', 'Continent' => 'AS', 'TLD' => '.kr', 'Languages' => 'ko-KR,en', 'Geo_Name_ID' => '1835841', 'EDGAR' => 'M5'),
            200 => array('Country_Name' => 'South Sudan', 'Official_Name_English' => 'South Sudan', 'ISO3166_1_Alpha_2' => 'SS', 'ISO3166_1_Alpha_3' => 'SSD', 'M49' => '728', 'ITU' => 'SSD', 'MARC' => 'sd', 'WMO' => '', 'DS' => '', 'Dial' => '211', 'FIFA' => '', 'FIPS' => 'OD', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'SSP', 'ISO4217_Currency_Country_Name' => 'SOUTH SUDAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'South Sudanese Pound', 'ISO4217_Currency_Numeric_Code' => '728', 'Is_Independent' => 'Yes', 'Capital' => 'Juba', 'Continent' => 'AF', 'TLD' => '', 'Languages' => 'en', 'Geo_Name_ID' => '7909807', 'EDGAR' => ''),
            201 => array('Country_Name' => 'Spain', 'Official_Name_English' => 'Spain', 'ISO3166_1_Alpha_2' => 'ES', 'ISO3166_1_Alpha_3' => 'ESP', 'M49' => '724', 'ITU' => 'E', 'MARC' => 'sp', 'WMO' => 'SP', 'DS' => 'E', 'Dial' => '34', 'FIFA' => 'ESP', 'FIPS' => 'SP', 'GAUL' => '229', 'IOC' => 'ESP', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SPAIN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Madrid', 'Continent' => 'EU', 'TLD' => '.es', 'Languages' => 'es-ES,ca,gl,eu,oc', 'Geo_Name_ID' => '2510769', 'EDGAR' => 'U3'),
            202 => array('Country_Name' => 'Sri Lanka', 'Official_Name_English' => 'Sri Lanka', 'ISO3166_1_Alpha_2' => 'LK', 'ISO3166_1_Alpha_3' => 'LKA', 'M49' => '144', 'ITU' => 'CLN', 'MARC' => 'ce', 'WMO' => 'SB', 'DS' => 'CL', 'Dial' => '94', 'FIFA' => 'SRI', 'FIPS' => 'CE', 'GAUL' => '231', 'IOC' => 'SRI', 'ISO4217_Currency_Alphabetic_Code' => 'LKR', 'ISO4217_Currency_Country_Name' => 'SRI LANKA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Sri Lanka Rupee', 'ISO4217_Currency_Numeric_Code' => '144', 'Is_Independent' => 'Yes', 'Capital' => 'Colombo', 'Continent' => 'AS', 'TLD' => '.lk', 'Languages' => 'si,ta,en', 'Geo_Name_ID' => '1227603', 'EDGAR' => 'F1'),
            203 => array('Country_Name' => 'Saint Barthélemy', 'Official_Name_English' => 'Saint Barthélemy', 'ISO3166_1_Alpha_2' => 'BL', 'ISO3166_1_Alpha_3' => 'BLM', 'M49' => '652', 'ITU' => '', 'MARC' => 'sc', 'WMO' => '', 'DS' => '', 'Dial' => '590', 'FIFA' => '', 'FIPS' => 'TB', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SAINT BARTHÃ‰LEMY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Gustavia', 'Continent' => 'NA', 'TLD' => '.gp', 'Languages' => 'fr', 'Geo_Name_ID' => '3578476', 'EDGAR' => ''),
            204 => array('Country_Name' => 'St. Helena', 'Official_Name_English' => 'Saint Helena', 'ISO3166_1_Alpha_2' => 'SH', 'ISO3166_1_Alpha_3' => 'SHN', 'M49' => '654', 'ITU' => 'SHN', 'MARC' => 'xj', 'WMO' => 'HE', 'DS' => 'SH', 'Dial' => '290 n', 'FIFA' => 'SHN', 'FIPS' => 'SH', 'GAUL' => '207', 'IOC' => 'HEL', 'ISO4217_Currency_Alphabetic_Code' => 'SHP', 'ISO4217_Currency_Country_Name' => 'SAINT HELENA, ASCENSION AND TRISTAN DA CUNHA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Saint Helena Pound', 'ISO4217_Currency_Numeric_Code' => '654', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Jamestown', 'Continent' => 'AF', 'TLD' => '.sh', 'Languages' => 'en-SH', 'Geo_Name_ID' => '3370751', 'EDGAR' => ''),
            205 => array('Country_Name' => 'St. Kitts & Nevis', 'Official_Name_English' => 'Saint Kitts and Nevis', 'ISO3166_1_Alpha_2' => 'KN', 'ISO3166_1_Alpha_3' => 'KNA', 'M49' => '659', 'ITU' => 'KNA', 'MARC' => 'xd', 'WMO' => 'AT', 'DS' => 'KN', 'Dial' => '869', 'FIFA' => 'SKN', 'FIPS' => 'SC', 'GAUL' => '208', 'IOC' => 'SKN', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'SAINT KITTS AND NEVIS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Yes', 'Capital' => 'Basseterre', 'Continent' => 'NA', 'TLD' => '.kn', 'Languages' => 'en-KN', 'Geo_Name_ID' => '3575174', 'EDGAR' => 'U7'),
            206 => array('Country_Name' => 'St. Lucia', 'Official_Name_English' => 'Saint Lucia', 'ISO3166_1_Alpha_2' => 'LC', 'ISO3166_1_Alpha_3' => 'LCA', 'M49' => '662', 'ITU' => 'LCA', 'MARC' => 'xk', 'WMO' => 'LC', 'DS' => 'WL', 'Dial' => '758', 'FIFA' => 'LCA', 'FIPS' => 'ST', 'GAUL' => '209', 'IOC' => 'LCA', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'SAINT LUCIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Yes', 'Capital' => 'Castries', 'Continent' => 'NA', 'TLD' => '.lc', 'Languages' => 'en-LC', 'Geo_Name_ID' => '3576468', 'EDGAR' => 'U9'),
            207 => array('Country_Name' => 'St. Martin', 'Official_Name_English' => 'Saint Martin (French part)', 'ISO3166_1_Alpha_2' => 'MF', 'ISO3166_1_Alpha_3' => 'MAF', 'M49' => '663', 'ITU' => '', 'MARC' => 'st', 'WMO' => '', 'DS' => '', 'Dial' => '590', 'FIFA' => '', 'FIPS' => 'RN', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SAINT MARTIN (FRENCH PART)', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Marigot', 'Continent' => 'NA', 'TLD' => '.gp', 'Languages' => 'fr', 'Geo_Name_ID' => '3578421', 'EDGAR' => ''),
            208 => array('Country_Name' => 'St. Pierre & Miquelon', 'Official_Name_English' => 'Saint Pierre and Miquelon', 'ISO3166_1_Alpha_2' => 'PM', 'ISO3166_1_Alpha_3' => 'SPM', 'M49' => '666', 'ITU' => 'SPM', 'MARC' => 'xl', 'WMO' => 'FP', 'DS' => 'F', 'Dial' => '508', 'FIFA' => 'SPM', 'FIPS' => 'SB', 'GAUL' => '210', 'IOC' => 'SPM', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SAINT PIERRE AND MIQUELON', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Saint-Pierre', 'Continent' => 'NA', 'TLD' => '.pm', 'Languages' => 'fr-PM', 'Geo_Name_ID' => '3424932', 'EDGAR' => 'V0'),
            209 => array('Country_Name' => 'St. Vincent & Grenadines', 'Official_Name_English' => 'Saint Vincent and the Grenadines', 'ISO3166_1_Alpha_2' => 'VC', 'ISO3166_1_Alpha_3' => 'VCT', 'M49' => '670', 'ITU' => 'VCT', 'MARC' => 'xm', 'WMO' => 'VG', 'DS' => 'WV', 'Dial' => '784', 'FIFA' => 'VIN', 'FIPS' => 'VC', 'GAUL' => '211', 'IOC' => 'VIN', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'SAINT VINCENT AND THE GRENADINES', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Yes', 'Capital' => 'Kingstown', 'Continent' => 'NA', 'TLD' => '.vc', 'Languages' => 'en-VC,fr', 'Geo_Name_ID' => '3577815', 'EDGAR' => 'V1'),
            210 => array('Country_Name' => 'Sudan', 'Official_Name_English' => 'Sudan', 'ISO3166_1_Alpha_2' => 'SD', 'ISO3166_1_Alpha_3' => 'SDN', 'M49' => '729', 'ITU' => 'SDN', 'MARC' => 'sj', 'WMO' => 'SU', 'DS' => 'SUD', 'Dial' => '249', 'FIFA' => 'SUD', 'FIPS' => 'SU', 'GAUL' => '40764', 'IOC' => 'SUD', 'ISO4217_Currency_Alphabetic_Code' => 'SDG', 'ISO4217_Currency_Country_Name' => 'SUDAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Sudanese Pound', 'ISO4217_Currency_Numeric_Code' => '938', 'Is_Independent' => 'Yes', 'Capital' => 'Khartoum', 'Continent' => 'AF', 'TLD' => '.sd', 'Languages' => 'ar-SD,en,fia', 'Geo_Name_ID' => '366755', 'EDGAR' => 'V2'),
            211 => array('Country_Name' => 'Suriname', 'Official_Name_English' => 'Suriname', 'ISO3166_1_Alpha_2' => 'SR', 'ISO3166_1_Alpha_3' => 'SUR', 'M49' => '740', 'ITU' => 'SUR', 'MARC' => 'sr', 'WMO' => 'SM', 'DS' => 'SME', 'Dial' => '597', 'FIFA' => 'SUR', 'FIPS' => 'NS', 'GAUL' => '233', 'IOC' => 'SUR', 'ISO4217_Currency_Alphabetic_Code' => 'SRD', 'ISO4217_Currency_Country_Name' => 'SURINAME', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Surinam Dollar', 'ISO4217_Currency_Numeric_Code' => '968', 'Is_Independent' => 'Yes', 'Capital' => 'Paramaribo', 'Continent' => 'SA', 'TLD' => '.sr', 'Languages' => 'nl-SR,en,srn,hns,jv', 'Geo_Name_ID' => '3382998', 'EDGAR' => 'V3'),
            212 => array('Country_Name' => 'Svalbard & Jan Mayen', 'Official_Name_English' => 'Svalbard and Jan Mayen Islands', 'ISO3166_1_Alpha_2' => 'SJ', 'ISO3166_1_Alpha_3' => 'SJM', 'M49' => '744', 'ITU' => 'NOR', 'MARC' => '', 'WMO' => 'SZ', 'DS' => '', 'Dial' => '47', 'FIFA' => '', 'FIPS' => 'SV,JN', 'GAUL' => '234', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'NOK', 'ISO4217_Currency_Country_Name' => 'SVALBARD AND JAN MAYEN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Norwegian Krone', 'ISO4217_Currency_Numeric_Code' => '578', 'Is_Independent' => 'Territory of NO', 'Capital' => 'Longyearbyen', 'Continent' => 'EU', 'TLD' => '.sj', 'Languages' => 'no,ru', 'Geo_Name_ID' => '607072', 'EDGAR' => 'L9'),
            213 => array('Country_Name' => 'Swaziland', 'Official_Name_English' => 'Swaziland', 'ISO3166_1_Alpha_2' => 'SZ', 'ISO3166_1_Alpha_3' => 'SWZ', 'M49' => '748', 'ITU' => 'SWZ', 'MARC' => 'sq', 'WMO' => 'SV', 'DS' => 'SD', 'Dial' => '268', 'FIFA' => 'SWZ', 'FIPS' => 'WZ', 'GAUL' => '235', 'IOC' => 'SWZ', 'ISO4217_Currency_Alphabetic_Code' => 'SZL', 'ISO4217_Currency_Country_Name' => 'SWAZILAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Lilangeni', 'ISO4217_Currency_Numeric_Code' => '748', 'Is_Independent' => 'Yes', 'Capital' => 'Mbabane', 'Continent' => 'AF', 'TLD' => '.sz', 'Languages' => 'en-SZ,ss-SZ', 'Geo_Name_ID' => '934841', 'EDGAR' => 'V6'),
            214 => array('Country_Name' => 'Sweden', 'Official_Name_English' => 'Sweden', 'ISO3166_1_Alpha_2' => 'SE', 'ISO3166_1_Alpha_3' => 'SWE', 'M49' => '752', 'ITU' => 'S', 'MARC' => 'sw', 'WMO' => 'SN', 'DS' => 'S', 'Dial' => '46', 'FIFA' => 'SWE', 'FIPS' => 'SW', 'GAUL' => '236', 'IOC' => 'SWE', 'ISO4217_Currency_Alphabetic_Code' => 'SEK', 'ISO4217_Currency_Country_Name' => 'SWEDEN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Swedish Krona', 'ISO4217_Currency_Numeric_Code' => '752', 'Is_Independent' => 'Yes', 'Capital' => 'Stockholm', 'Continent' => 'EU', 'TLD' => '.se', 'Languages' => 'sv-SE,se,sma,fi-SE', 'Geo_Name_ID' => '2661886', 'EDGAR' => 'V7'),
            215 => array('Country_Name' => 'Switzerland', 'Official_Name_English' => 'Switzerland', 'ISO3166_1_Alpha_2' => 'CH', 'ISO3166_1_Alpha_3' => 'CHE', 'M49' => '756', 'ITU' => 'SUI', 'MARC' => 'sz', 'WMO' => 'SW', 'DS' => 'CH', 'Dial' => '41', 'FIFA' => 'SUI', 'FIPS' => 'SZ', 'GAUL' => '237', 'IOC' => 'SUI', 'ISO4217_Currency_Alphabetic_Code' => 'CHF', 'ISO4217_Currency_Country_Name' => 'SWITZERLAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Swiss Franc', 'ISO4217_Currency_Numeric_Code' => '756', 'Is_Independent' => 'Yes', 'Capital' => 'Bern', 'Continent' => 'EU', 'TLD' => '.ch', 'Languages' => 'de-CH,fr-CH,it-CH,rm', 'Geo_Name_ID' => '2658434', 'EDGAR' => 'V8'),
            216 => array('Country_Name' => 'Syria', 'Official_Name_English' => 'Syrian Arab Republic', 'ISO3166_1_Alpha_2' => 'SY', 'ISO3166_1_Alpha_3' => 'SYR', 'M49' => '760', 'ITU' => 'SYR', 'MARC' => 'sy', 'WMO' => 'SY', 'DS' => 'SYR', 'Dial' => '963', 'FIFA' => 'SYR', 'FIPS' => 'SY', 'GAUL' => '238', 'IOC' => 'SYR', 'ISO4217_Currency_Alphabetic_Code' => 'SYP', 'ISO4217_Currency_Country_Name' => 'SYRIAN ARAB REPUBLIC', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Syrian Pound', 'ISO4217_Currency_Numeric_Code' => '760', 'Is_Independent' => 'Yes', 'Capital' => 'Damascus', 'Continent' => 'AS', 'TLD' => '.sy', 'Languages' => 'ar-SY,ku,hy,arc,fr,en', 'Geo_Name_ID' => '163843', 'EDGAR' => 'V9'),
            217 => array('Country_Name' => 'Sao Tome and Principe', 'Official_Name_English' => 'Sao Tome and Principe', 'ISO3166_1_Alpha_2' => 'ST', 'ISO3166_1_Alpha_3' => 'STP', 'M49' => '678', 'ITU' => 'STP', 'MARC' => 'sf', 'WMO' => 'TP', 'DS' => 'ST', 'Dial' => '239', 'FIFA' => 'STP', 'FIPS' => 'TP', 'GAUL' => '214', 'IOC' => 'STP', 'ISO4217_Currency_Alphabetic_Code' => 'STD', 'ISO4217_Currency_Country_Name' => 'SAO TOME AND PRINCIPE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Dobra', 'ISO4217_Currency_Numeric_Code' => '678', 'Is_Independent' => 'Yes', 'Capital' => 'Sao Tome', 'Continent' => 'AF', 'TLD' => '.st', 'Languages' => 'pt-ST', 'Geo_Name_ID' => '2410758', 'EDGAR' => 'S9'),
            218 => array('Country_Name' => 'Taiwan', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'TW', 'ISO3166_1_Alpha_3' => 'TWN', 'M49' => '158', 'ITU' => '', 'MARC' => 'ch', 'WMO' => '', 'DS' => 'RC', 'Dial' => '886', 'FIFA' => 'TPE', 'FIPS' => 'TW', 'GAUL' => '925', 'IOC' => 'TPE', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Yes', 'Capital' => 'Taipei', 'Continent' => 'AS', 'TLD' => '.tw', 'Languages' => 'zh-TW,zh,nan,hak', 'Geo_Name_ID' => '1668284', 'EDGAR' => ''),
            219 => array('Country_Name' => 'Tajikistan', 'Official_Name_English' => 'Tajikistan', 'ISO3166_1_Alpha_2' => 'TJ', 'ISO3166_1_Alpha_3' => 'TJK', 'M49' => '762', 'ITU' => 'TJK', 'MARC' => 'ta', 'WMO' => 'TA', 'DS' => 'TJ', 'Dial' => '992', 'FIFA' => 'TJK', 'FIPS' => 'TI', 'GAUL' => '239', 'IOC' => 'TJK', 'ISO4217_Currency_Alphabetic_Code' => 'TJS', 'ISO4217_Currency_Country_Name' => 'TAJIKISTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Somoni', 'ISO4217_Currency_Numeric_Code' => '972', 'Is_Independent' => 'Yes', 'Capital' => 'Dushanbe', 'Continent' => 'AS', 'TLD' => '.tj', 'Languages' => 'tg,ru', 'Geo_Name_ID' => '1220409', 'EDGAR' => '2D'),
            220 => array('Country_Name' => 'Tanzania', 'Official_Name_English' => 'United Republic of Tanzania', 'ISO3166_1_Alpha_2' => 'TZ', 'ISO3166_1_Alpha_3' => 'TZA', 'M49' => '834', 'ITU' => 'TZA', 'MARC' => 'tz', 'WMO' => 'TN', 'DS' => 'EAT', 'Dial' => '255', 'FIFA' => 'TAN', 'FIPS' => 'TZ', 'GAUL' => '257', 'IOC' => 'TAN', 'ISO4217_Currency_Alphabetic_Code' => 'TZS', 'ISO4217_Currency_Country_Name' => 'TANZANIA, UNITED REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Tanzanian Shilling', 'ISO4217_Currency_Numeric_Code' => '834', 'Is_Independent' => 'Yes', 'Capital' => 'Dodoma', 'Continent' => 'AF', 'TLD' => '.tz', 'Languages' => 'sw-TZ,en,ar', 'Geo_Name_ID' => '149590', 'EDGAR' => 'W0'),
            221 => array('Country_Name' => 'Thailand', 'Official_Name_English' => 'Thailand', 'ISO3166_1_Alpha_2' => 'TH', 'ISO3166_1_Alpha_3' => 'THA', 'M49' => '764', 'ITU' => 'THA', 'MARC' => 'th', 'WMO' => 'TH', 'DS' => 'T', 'Dial' => '66', 'FIFA' => 'THA', 'FIPS' => 'TH', 'GAUL' => '240', 'IOC' => 'THA', 'ISO4217_Currency_Alphabetic_Code' => 'THB', 'ISO4217_Currency_Country_Name' => 'THAILAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Baht', 'ISO4217_Currency_Numeric_Code' => '764', 'Is_Independent' => 'Yes', 'Capital' => 'Bangkok', 'Continent' => 'AS', 'TLD' => '.th', 'Languages' => 'th,en', 'Geo_Name_ID' => '1605651', 'EDGAR' => 'W1'),
            222 => array('Country_Name' => 'Timor-Leste', 'Official_Name_English' => 'Timor-Leste', 'ISO3166_1_Alpha_2' => 'TL', 'ISO3166_1_Alpha_3' => 'TLS', 'M49' => '626', 'ITU' => 'TLS', 'MARC' => 'em', 'WMO' => 'TM', 'DS' => 'RI', 'Dial' => '670', 'FIFA' => 'TLS', 'FIPS' => 'TT', 'GAUL' => '242', 'IOC' => 'TLS', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'TIMOR-LESTE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Dili', 'Continent' => 'OC', 'TLD' => '.tl', 'Languages' => 'tet,pt-TL,id,en', 'Geo_Name_ID' => '1966436', 'EDGAR' => 'Z3'),
            223 => array('Country_Name' => 'Togo', 'Official_Name_English' => 'Togo', 'ISO3166_1_Alpha_2' => 'TG', 'ISO3166_1_Alpha_3' => 'TGO', 'M49' => '768', 'ITU' => 'TGO', 'MARC' => 'tg', 'WMO' => 'TG', 'DS' => 'TG', 'Dial' => '228', 'FIFA' => 'TOG', 'FIPS' => 'TO', 'GAUL' => '243', 'IOC' => 'TOG', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'TOGO', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Lome', 'Continent' => 'AF', 'TLD' => '.tg', 'Languages' => 'fr-TG,ee,hna,kbp,dag,ha', 'Geo_Name_ID' => '2363686', 'EDGAR' => 'W2'),
            224 => array('Country_Name' => 'Tokelau', 'Official_Name_English' => 'Tokelau', 'ISO3166_1_Alpha_2' => 'TK', 'ISO3166_1_Alpha_3' => 'TKL', 'M49' => '772', 'ITU' => 'TKL', 'MARC' => 'tl', 'WMO' => 'TK', 'DS' => 'NZ', 'Dial' => '690', 'FIFA' => 'TKL', 'FIPS' => 'TL', 'GAUL' => '244', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'NZD', 'ISO4217_Currency_Country_Name' => 'TOKELAU', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Zealand Dollar', 'ISO4217_Currency_Numeric_Code' => '554', 'Is_Independent' => 'Territory of NZ', 'Capital' => '', 'Continent' => 'OC', 'TLD' => '.tk', 'Languages' => 'tkl,en-TK', 'Geo_Name_ID' => '4031074', 'EDGAR' => 'W3'),
            225 => array('Country_Name' => 'Tonga', 'Official_Name_English' => 'Tonga', 'ISO3166_1_Alpha_2' => 'TO', 'ISO3166_1_Alpha_3' => 'TON', 'M49' => '776', 'ITU' => 'TON', 'MARC' => 'to', 'WMO' => 'TO', 'DS' => 'TO', 'Dial' => '676', 'FIFA' => 'TGA', 'FIPS' => 'TN', 'GAUL' => '245', 'IOC' => 'TGA', 'ISO4217_Currency_Alphabetic_Code' => 'TOP', 'ISO4217_Currency_Country_Name' => 'TONGA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Paâ€™anga', 'ISO4217_Currency_Numeric_Code' => '776', 'Is_Independent' => 'Yes', 'Capital' => 'Nuku\'alofa', 'Continent' => 'OC', 'TLD' => '.to', 'Languages' => 'to,en-TO', 'Geo_Name_ID' => '4032283', 'EDGAR' => 'W4'),
            226 => array('Country_Name' => 'Trinidad & Tobago', 'Official_Name_English' => 'Trinidad and Tobago', 'ISO3166_1_Alpha_2' => 'TT', 'ISO3166_1_Alpha_3' => 'TTO', 'M49' => '780', 'ITU' => 'TRD', 'MARC' => 'tr', 'WMO' => 'TD', 'DS' => 'TT', 'Dial' => '868', 'FIFA' => 'TRI', 'FIPS' => 'TD', 'GAUL' => '246', 'IOC' => 'TTO', 'ISO4217_Currency_Alphabetic_Code' => 'TTD', 'ISO4217_Currency_Country_Name' => 'TRINIDAD AND TOBAGO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Trinidad and Tobago Dollar', 'ISO4217_Currency_Numeric_Code' => '780', 'Is_Independent' => 'Yes', 'Capital' => 'Port of Spain', 'Continent' => 'NA', 'TLD' => '.tt', 'Languages' => 'en-TT,hns,fr,es,zh', 'Geo_Name_ID' => '3573591', 'EDGAR' => 'W5'),
            227 => array('Country_Name' => 'Tunisia', 'Official_Name_English' => 'Tunisia', 'ISO3166_1_Alpha_2' => 'TN', 'ISO3166_1_Alpha_3' => 'TUN', 'M49' => '788', 'ITU' => 'TUN', 'MARC' => 'ti', 'WMO' => 'TS', 'DS' => 'TN', 'Dial' => '216', 'FIFA' => 'TUN', 'FIPS' => 'TS', 'GAUL' => '248', 'IOC' => 'TUN', 'ISO4217_Currency_Alphabetic_Code' => 'TND', 'ISO4217_Currency_Country_Name' => 'TUNISIA', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Tunisian Dinar', 'ISO4217_Currency_Numeric_Code' => '788', 'Is_Independent' => 'Yes', 'Capital' => 'Tunis', 'Continent' => 'AF', 'TLD' => '.tn', 'Languages' => 'ar-TN,fr', 'Geo_Name_ID' => '2464461', 'EDGAR' => 'W6'),
            228 => array('Country_Name' => 'Turkey', 'Official_Name_English' => 'Turkey', 'ISO3166_1_Alpha_2' => 'TR', 'ISO3166_1_Alpha_3' => 'TUR', 'M49' => '792', 'ITU' => 'TUR', 'MARC' => 'tu', 'WMO' => 'TU', 'DS' => 'TR', 'Dial' => '90', 'FIFA' => 'TUR', 'FIPS' => 'TU', 'GAUL' => '249', 'IOC' => 'TUR', 'ISO4217_Currency_Alphabetic_Code' => 'TRY', 'ISO4217_Currency_Country_Name' => 'TURKEY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Turkish Lira', 'ISO4217_Currency_Numeric_Code' => '949', 'Is_Independent' => 'Yes', 'Capital' => 'Ankara', 'Continent' => 'AS', 'TLD' => '.tr', 'Languages' => 'tr-TR,ku,diq,az,av', 'Geo_Name_ID' => '298795', 'EDGAR' => 'W8'),
            229 => array('Country_Name' => 'Turkmenistan', 'Official_Name_English' => 'Turkmenistan', 'ISO3166_1_Alpha_2' => 'TM', 'ISO3166_1_Alpha_3' => 'TKM', 'M49' => '795', 'ITU' => 'TKM', 'MARC' => 'tk', 'WMO' => 'TR', 'DS' => 'TM', 'Dial' => '993', 'FIFA' => 'TKM', 'FIPS' => 'TX', 'GAUL' => '250', 'IOC' => 'TKM', 'ISO4217_Currency_Alphabetic_Code' => 'TMT', 'ISO4217_Currency_Country_Name' => 'TURKMENISTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Turkmenistan New Manat', 'ISO4217_Currency_Numeric_Code' => '934', 'Is_Independent' => 'Yes', 'Capital' => 'Ashgabat', 'Continent' => 'AS', 'TLD' => '.tm', 'Languages' => 'tk,ru,uz', 'Geo_Name_ID' => '1218197', 'EDGAR' => '2E'),
            230 => array('Country_Name' => 'Turks & Caicos Islands', 'Official_Name_English' => 'Turks and Caicos Islands', 'ISO3166_1_Alpha_2' => 'TC', 'ISO3166_1_Alpha_3' => 'TCA', 'M49' => '796', 'ITU' => 'TCA', 'MARC' => 'tc', 'WMO' => 'TI', 'DS' => '', 'Dial' => '649', 'FIFA' => 'TCA', 'FIPS' => 'TK', 'GAUL' => '251', 'IOC' => 'TKS', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'TURKS AND CAICOS ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Cockburn Town', 'Continent' => 'NA', 'TLD' => '.tc', 'Languages' => 'en-TC', 'Geo_Name_ID' => '3576916', 'EDGAR' => 'W7'),
            231 => array('Country_Name' => 'Tuvalu', 'Official_Name_English' => 'Tuvalu', 'ISO3166_1_Alpha_2' => 'TV', 'ISO3166_1_Alpha_3' => 'TUV', 'M49' => '798', 'ITU' => 'TUV', 'MARC' => 'tv', 'WMO' => 'TV', 'DS' => 'TV', 'Dial' => '688', 'FIFA' => 'TUV', 'FIPS' => 'TV', 'GAUL' => '252', 'IOC' => 'TUV', 'ISO4217_Currency_Alphabetic_Code' => 'AUD', 'ISO4217_Currency_Country_Name' => 'TUVALU', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Australian Dollar', 'ISO4217_Currency_Numeric_Code' => '36', 'Is_Independent' => 'Yes', 'Capital' => 'Funafuti', 'Continent' => 'OC', 'TLD' => '.tv', 'Languages' => 'tvl,en,sm,gil', 'Geo_Name_ID' => '2110297', 'EDGAR' => '2G'),
            232 => array('Country_Name' => 'U.S. Outlying Islands', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'UM', 'ISO3166_1_Alpha_3' => 'UMI', 'M49' => '581', 'ITU' => '', 'MARC' => 'ji,xf,wk,uc,up', 'WMO' => '', 'DS' => 'USA', 'Dial' => '', 'FIFA' => '', 'FIPS' => 'FQ,HQ,DQ,JQ,KQ,MQ,BQ,LQ,WQ', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territories of US', 'Capital' => '', 'Continent' => 'OC', 'TLD' => '.um', 'Languages' => 'en-UM', 'Geo_Name_ID' => '5854968', 'EDGAR' => ''),
            233 => array('Country_Name' => 'U.S. Virgin Islands', 'Official_Name_English' => 'United States Virgin Islands', 'ISO3166_1_Alpha_2' => 'VI', 'ISO3166_1_Alpha_3' => 'VIR', 'M49' => '850', 'ITU' => 'VIR', 'MARC' => 'vi', 'WMO' => 'VI', 'DS' => 'USA', 'Dial' => '340', 'FIFA' => 'VIR', 'FIPS' => 'VQ', 'GAUL' => '258', 'IOC' => 'ISV', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'VIRGIN ISLANDS (U.S.)', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Territory of US', 'Capital' => 'Charlotte Amalie', 'Continent' => 'NA', 'TLD' => '.vi', 'Languages' => 'en-VI', 'Geo_Name_ID' => '4796775', 'EDGAR' => ''),
            234 => array('Country_Name' => 'UK', 'Official_Name_English' => 'United Kingdom of Great Britain and Northern Ireland', 'ISO3166_1_Alpha_2' => 'GB', 'ISO3166_1_Alpha_3' => 'GBR', 'M49' => '826', 'ITU' => 'G', 'MARC' => 'xxk', 'WMO' => 'UK', 'DS' => 'GB', 'Dial' => '44', 'FIFA' => 'ENG,NIR,SCO,WAL', 'FIPS' => 'UK', 'GAUL' => '256', 'IOC' => 'GBR', 'ISO4217_Currency_Alphabetic_Code' => 'GBP', 'ISO4217_Currency_Country_Name' => 'UNITED KINGDOM', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pound Sterling', 'ISO4217_Currency_Numeric_Code' => '826', 'Is_Independent' => 'Yes', 'Capital' => 'London', 'Continent' => 'EU', 'TLD' => '.uk', 'Languages' => 'en-GB,cy-GB,gd', 'Geo_Name_ID' => '2635167', 'EDGAR' => 'X0'),
            235 => array('Country_Name' => 'US', 'Official_Name_English' => 'United States of America', 'ISO3166_1_Alpha_2' => 'US', 'ISO3166_1_Alpha_3' => 'USA', 'M49' => '840', 'ITU' => 'USA', 'MARC' => 'xxu', 'WMO' => 'US', 'DS' => 'USA', 'Dial' => '1', 'FIFA' => 'USA', 'FIPS' => 'US', 'GAUL' => '259', 'IOC' => 'USA', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'UNITED STATES', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Washington', 'Continent' => 'NA', 'TLD' => '.us', 'Languages' => 'en-US,es-US,haw,fr', 'Geo_Name_ID' => '6252001', 'EDGAR' => ''),
            236 => array('Country_Name' => 'Uganda', 'Official_Name_English' => 'Uganda', 'ISO3166_1_Alpha_2' => 'UG', 'ISO3166_1_Alpha_3' => 'UGA', 'M49' => '800', 'ITU' => 'UGA', 'MARC' => 'ug', 'WMO' => 'UG', 'DS' => 'EAU', 'Dial' => '256', 'FIFA' => 'UGA', 'FIPS' => 'UG', 'GAUL' => '253', 'IOC' => 'UGA', 'ISO4217_Currency_Alphabetic_Code' => 'UGX', 'ISO4217_Currency_Country_Name' => 'UGANDA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Uganda Shilling', 'ISO4217_Currency_Numeric_Code' => '800', 'Is_Independent' => 'Yes', 'Capital' => 'Kampala', 'Continent' => 'AF', 'TLD' => '.ug', 'Languages' => 'en-UG,lg,sw,ar', 'Geo_Name_ID' => '226074', 'EDGAR' => 'W9'),
            237 => array('Country_Name' => 'Ukraine', 'Official_Name_English' => 'Ukraine', 'ISO3166_1_Alpha_2' => 'UA', 'ISO3166_1_Alpha_3' => 'UKR', 'M49' => '804', 'ITU' => 'UKR', 'MARC' => 'un', 'WMO' => 'UR', 'DS' => 'UA', 'Dial' => '380', 'FIFA' => 'UKR', 'FIPS' => 'UP', 'GAUL' => '254', 'IOC' => 'UKR', 'ISO4217_Currency_Alphabetic_Code' => 'UAH', 'ISO4217_Currency_Country_Name' => 'UKRAINE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Hryvnia', 'ISO4217_Currency_Numeric_Code' => '980', 'Is_Independent' => 'Yes', 'Capital' => 'Kiev', 'Continent' => 'EU', 'TLD' => '.ua', 'Languages' => 'uk,ru-UA,rom,pl,hu', 'Geo_Name_ID' => '690791', 'EDGAR' => '2H'),
            238 => array('Country_Name' => 'United Arab Emirates', 'Official_Name_English' => 'United Arab Emirates', 'ISO3166_1_Alpha_2' => 'AE', 'ISO3166_1_Alpha_3' => 'ARE', 'M49' => '784', 'ITU' => 'UAE', 'MARC' => 'ts', 'WMO' => 'ER', 'DS' => '', 'Dial' => '971', 'FIFA' => 'UAE', 'FIPS' => 'AE', 'GAUL' => '255', 'IOC' => 'UAE', 'ISO4217_Currency_Alphabetic_Code' => 'AED', 'ISO4217_Currency_Country_Name' => 'UNITED ARAB EMIRATES', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'UAE Dirham', 'ISO4217_Currency_Numeric_Code' => '784', 'Is_Independent' => 'Yes', 'Capital' => 'Abu Dhabi', 'Continent' => 'AS', 'TLD' => '.ae', 'Languages' => 'ar-AE,fa,en,hi,ur', 'Geo_Name_ID' => '290557', 'EDGAR' => 'C0'),
            239 => array('Country_Name' => 'Uruguay', 'Official_Name_English' => 'Uruguay', 'ISO3166_1_Alpha_2' => 'UY', 'ISO3166_1_Alpha_3' => 'URY', 'M49' => '858', 'ITU' => 'URG', 'MARC' => 'uy', 'WMO' => 'UY', 'DS' => 'ROU', 'Dial' => '598', 'FIFA' => 'URU', 'FIPS' => 'UY', 'GAUL' => '260', 'IOC' => 'URU', 'ISO4217_Currency_Alphabetic_Code' => 'UYU', 'ISO4217_Currency_Country_Name' => 'URUGUAY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Peso Uruguayo', 'ISO4217_Currency_Numeric_Code' => '858', 'Is_Independent' => 'Yes', 'Capital' => 'Montevideo', 'Continent' => 'SA', 'TLD' => '.uy', 'Languages' => 'es-UY', 'Geo_Name_ID' => '3439705', 'EDGAR' => 'X3'),
            240 => array('Country_Name' => 'Uzbekistan', 'Official_Name_English' => 'Uzbekistan', 'ISO3166_1_Alpha_2' => 'UZ', 'ISO3166_1_Alpha_3' => 'UZB', 'M49' => '860', 'ITU' => 'UZB', 'MARC' => 'uz', 'WMO' => 'UZ', 'DS' => 'UZ', 'Dial' => '998', 'FIFA' => 'UZB', 'FIPS' => 'UZ', 'GAUL' => '261', 'IOC' => 'UZB', 'ISO4217_Currency_Alphabetic_Code' => 'UZS', 'ISO4217_Currency_Country_Name' => 'UZBEKISTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Uzbekistan Sum', 'ISO4217_Currency_Numeric_Code' => '860', 'Is_Independent' => 'Yes', 'Capital' => 'Tashkent', 'Continent' => 'AS', 'TLD' => '.uz', 'Languages' => 'uz,ru,tg', 'Geo_Name_ID' => '1512440', 'EDGAR' => '2K'),
            241 => array('Country_Name' => 'Vanuatu', 'Official_Name_English' => 'Vanuatu', 'ISO3166_1_Alpha_2' => 'VU', 'ISO3166_1_Alpha_3' => 'VUT', 'M49' => '548', 'ITU' => 'VUT', 'MARC' => 'nn', 'WMO' => 'NV', 'DS' => 'VU', 'Dial' => '678', 'FIFA' => 'VAN', 'FIPS' => 'NH', 'GAUL' => '262', 'IOC' => 'VAN', 'ISO4217_Currency_Alphabetic_Code' => 'VUV', 'ISO4217_Currency_Country_Name' => 'VANUATU', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Vatu', 'ISO4217_Currency_Numeric_Code' => '548', 'Is_Independent' => 'Yes', 'Capital' => 'Port Vila', 'Continent' => 'OC', 'TLD' => '.vu', 'Languages' => 'bi,en-VU,fr-VU', 'Geo_Name_ID' => '2134431', 'EDGAR' => '2L'),
            242 => array('Country_Name' => 'Vatican City', 'Official_Name_English' => 'Holy See', 'ISO3166_1_Alpha_2' => 'VA', 'ISO3166_1_Alpha_3' => 'VAT', 'M49' => '336', 'ITU' => 'CVA', 'MARC' => 'vc', 'WMO' => '', 'DS' => 'V', 'Dial' => '39-06', 'FIFA' => 'VAT', 'FIPS' => 'VT', 'GAUL' => '110', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'HOLY SEE (VATICAN CITY STATE)', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Vatican City', 'Continent' => 'EU', 'TLD' => '.va', 'Languages' => 'la,it,fr', 'Geo_Name_ID' => '3164670', 'EDGAR' => 'X4'),
            243 => array('Country_Name' => 'Venezuela', 'Official_Name_English' => 'Venezuela (Bolivarian Republic of)', 'ISO3166_1_Alpha_2' => 'VE', 'ISO3166_1_Alpha_3' => 'VEN', 'M49' => '862', 'ITU' => 'VEN', 'MARC' => 've', 'WMO' => 'VN', 'DS' => 'YV', 'Dial' => '58', 'FIFA' => 'VEN', 'FIPS' => 'VE', 'GAUL' => '263', 'IOC' => 'VEN', 'ISO4217_Currency_Alphabetic_Code' => 'VEF', 'ISO4217_Currency_Country_Name' => 'VENEZUELA, BOLIVARIAN REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Bolivar', 'ISO4217_Currency_Numeric_Code' => '937', 'Is_Independent' => 'Yes', 'Capital' => 'Caracas', 'Continent' => 'SA', 'TLD' => '.ve', 'Languages' => 'es-VE', 'Geo_Name_ID' => '3625428', 'EDGAR' => ''),
            244 => array('Country_Name' => 'Vietnam', 'Official_Name_English' => 'Viet Nam', 'ISO3166_1_Alpha_2' => 'VN', 'ISO3166_1_Alpha_3' => 'VNM', 'M49' => '704', 'ITU' => 'VTN', 'MARC' => 'vm', 'WMO' => 'VS', 'DS' => 'VN', 'Dial' => '84', 'FIFA' => 'VIE', 'FIPS' => 'VM', 'GAUL' => '264', 'IOC' => 'VIE', 'ISO4217_Currency_Alphabetic_Code' => 'VND', 'ISO4217_Currency_Country_Name' => 'VIET NAM', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Dong', 'ISO4217_Currency_Numeric_Code' => '704', 'Is_Independent' => 'Yes', 'Capital' => 'Hanoi', 'Continent' => 'AS', 'TLD' => '.vn', 'Languages' => 'vi,en,fr,zh,km', 'Geo_Name_ID' => '1562822', 'EDGAR' => 'Q1'),
            245 => array('Country_Name' => 'Wallis & Futuna', 'Official_Name_English' => 'Wallis and Futuna Islands', 'ISO3166_1_Alpha_2' => 'WF', 'ISO3166_1_Alpha_3' => 'WLF', 'M49' => '876', 'ITU' => 'WAL', 'MARC' => 'wf', 'WMO' => 'FW', 'DS' => 'F', 'Dial' => '681', 'FIFA' => 'WLF', 'FIPS' => 'WF', 'GAUL' => '266', 'IOC' => 'WAF', 'ISO4217_Currency_Alphabetic_Code' => 'XPF', 'ISO4217_Currency_Country_Name' => 'WALLIS AND FUTUNA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFP Franc', 'ISO4217_Currency_Numeric_Code' => '953', 'Is_Independent' => 'Territory of FR', 'Capital' => 'Mata Utu', 'Continent' => 'OC', 'TLD' => '.wf', 'Languages' => 'wls,fud,fr-WF', 'Geo_Name_ID' => '4034749', 'EDGAR' => 'X8'),
            246 => array('Country_Name' => 'Western Sahara', 'Official_Name_English' => 'Western Sahara', 'ISO3166_1_Alpha_2' => 'EH', 'ISO3166_1_Alpha_3' => 'ESH', 'M49' => '732', 'ITU' => 'AOE', 'MARC' => 'ss', 'WMO' => '', 'DS' => '', 'Dial' => '212', 'FIFA' => 'SAH', 'FIPS' => 'WI', 'GAUL' => '268', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'MAD', 'ISO4217_Currency_Country_Name' => 'WESTERN SAHARA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Moroccan Dirham', 'ISO4217_Currency_Numeric_Code' => '504', 'Is_Independent' => 'In contention', 'Capital' => 'El-Aaiun', 'Continent' => 'AF', 'TLD' => '.eh', 'Languages' => 'ar,mey', 'Geo_Name_ID' => '2461445', 'EDGAR' => 'U5'),
            247 => array('Country_Name' => 'Yemen', 'Official_Name_English' => 'Yemen', 'ISO3166_1_Alpha_2' => 'YE', 'ISO3166_1_Alpha_3' => 'YEM', 'M49' => '887', 'ITU' => 'YEM', 'MARC' => 'ye', 'WMO' => 'YE', 'DS' => 'YAR', 'Dial' => '967', 'FIFA' => 'YEM', 'FIPS' => 'YM', 'GAUL' => '269', 'IOC' => 'YEM', 'ISO4217_Currency_Alphabetic_Code' => 'YER', 'ISO4217_Currency_Country_Name' => 'YEMEN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Yemeni Rial', 'ISO4217_Currency_Numeric_Code' => '886', 'Is_Independent' => 'Yes', 'Capital' => 'Sanaa', 'Continent' => 'AS', 'TLD' => '.ye', 'Languages' => 'ar-YE', 'Geo_Name_ID' => '69543', 'EDGAR' => 'T7'),
            248 => array('Country_Name' => 'Zambia', 'Official_Name_English' => 'Zambia', 'ISO3166_1_Alpha_2' => 'ZM', 'ISO3166_1_Alpha_3' => 'ZMB', 'M49' => '894', 'ITU' => 'ZMB', 'MARC' => 'za', 'WMO' => 'ZB', 'DS' => 'Z', 'Dial' => '260', 'FIFA' => 'ZAM', 'FIPS' => 'ZA', 'GAUL' => '270', 'IOC' => 'ZAM', 'ISO4217_Currency_Alphabetic_Code' => 'ZMW', 'ISO4217_Currency_Country_Name' => 'ZAMBIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Zambian Kwacha', 'ISO4217_Currency_Numeric_Code' => '967', 'Is_Independent' => 'Yes', 'Capital' => 'Lusaka', 'Continent' => 'AF', 'TLD' => '.zm', 'Languages' => 'en-ZM,bem,loz,lun,lue,ny,toi', 'Geo_Name_ID' => '895949', 'EDGAR' => 'Y4'),
            249 => array('Country_Name' => 'Zimbabwe', 'Official_Name_English' => 'Zimbabwe', 'ISO3166_1_Alpha_2' => 'ZW', 'ISO3166_1_Alpha_3' => 'ZWE', 'M49' => '716', 'ITU' => 'ZWE', 'MARC' => 'rh', 'WMO' => 'ZW', 'DS' => 'ZW', 'Dial' => '263', 'FIFA' => 'ZIM', 'FIPS' => 'ZI', 'GAUL' => '271', 'IOC' => 'ZIM', 'ISO4217_Currency_Alphabetic_Code' => 'ZWL', 'ISO4217_Currency_Country_Name' => 'ZIMBABWE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Zimbabwe Dollar', 'ISO4217_Currency_Numeric_Code' => '932', 'Is_Independent' => 'Yes', 'Capital' => 'Harare', 'Continent' => 'AF', 'TLD' => '.zw', 'Languages' => 'en-ZW,sn,nr,nd', 'Geo_Name_ID' => '878675', 'EDGAR' => 'Y5'),
            250 => array('Country_Name' => 'Ãland Islands', 'Official_Name_English' => 'Ãland Islands', 'ISO3166_1_Alpha_2' => 'AX', 'ISO3166_1_Alpha_3' => 'ALA', 'M49' => '248', 'ITU' => '', 'MARC' => '', 'WMO' => '', 'DS' => 'FIN', 'Dial' => '358', 'FIFA' => 'ALD', 'FIPS' => '', 'GAUL' => '1242', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'ÃLAND ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FI', 'Capital' => 'Mariehamn', 'Continent' => 'EU', 'TLD' => '.ax', 'Languages' => 'sv-AX', 'Geo_Name_ID' => '661882', 'EDGAR' => ''),
        );
        return $countries_list;
    }

    public function countryListNew(){
        $countries_list = array(
//            0 => array('Country_Name' => '', 'Official_Name_English' => 'Channel Islands', 'ISO3166_1_Alpha_2' => '', 'ISO3166_1_Alpha_3' => '', 'M49' => '830', 'ITU' => '', 'MARC' => '', 'WMO' => '', 'DS' => '', 'Dial' => '', 'FIFA' => '', 'FIPS' => '', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => '', 'Capital' => '', 'Continent' => '', 'TLD' => '', 'Languages' => '', 'Geo_Name_ID' => '', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '', 'phone_min_digit' => '', 'phone_max_digit' => '', 'online_transaction_code' => '', 'display_sequence' => ''),
//            1 => array('Country_Name' => '', 'Official_Name_English' => 'Sark', 'ISO3166_1_Alpha_2' => '', 'ISO3166_1_Alpha_3' => '', 'M49' => '680', 'ITU' => '', 'MARC' => '', 'WMO' => '', 'DS' => '', 'Dial' => '', 'FIFA' => '', 'FIPS' => '', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => '', 'Capital' => '', 'Continent' => '', 'TLD' => '', 'Languages' => '', 'Geo_Name_ID' => '', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '', 'phone_min_digit' => '', 'phone_max_digit' => '', 'online_transaction_code' => '', 'display_sequence' => ''),
            2 => array('Country_Name' => 'Afghanistan', 'Official_Name_English' => 'Afghanistan', 'ISO3166_1_Alpha_2' => 'AF', 'ISO3166_1_Alpha_3' => 'AFG', 'M49' => '004', 'ITU' => 'AFG', 'MARC' => 'af', 'WMO' => 'AF', 'DS' => 'AFG', 'Dial' => '93', 'FIFA' => 'AFG', 'FIPS' => 'AF', 'GAUL' => '1', 'IOC' => 'AFG', 'ISO4217_Currency_Alphabetic_Code' => 'AFN', 'ISO4217_Currency_Country_Name' => 'AFGHANISTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Afghani', 'ISO4217_Currency_Numeric_Code' => '971', 'Is_Independent' => 'Yes', 'Capital' => 'Kabul', 'Continent' => 'AS', 'TLD' => '.af', 'Languages' => 'fa-AF,ps,uz-AF,tk', 'Geo_Name_ID' => '1149361', 'EDGAR' => 'B2', '' => '', 'currency_symbol' => 'AFN', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '1'),
            3 => array('Country_Name' => 'Albania', 'Official_Name_English' => 'Albania', 'ISO3166_1_Alpha_2' => 'AL', 'ISO3166_1_Alpha_3' => 'ALB', 'M49' => '008', 'ITU' => 'ALB', 'MARC' => 'aa', 'WMO' => 'AB', 'DS' => 'AL', 'Dial' => '355', 'FIFA' => 'ALB', 'FIPS' => 'AL', 'GAUL' => '3', 'IOC' => 'ALB', 'ISO4217_Currency_Alphabetic_Code' => 'ALL', 'ISO4217_Currency_Country_Name' => 'ALBANIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Lek', 'ISO4217_Currency_Numeric_Code' => '8', 'Is_Independent' => 'Yes', 'Capital' => 'Tirana', 'Continent' => 'EU', 'TLD' => '.al', 'Languages' => 'sq,el', 'Geo_Name_ID' => '783754', 'EDGAR' => 'B3', '' => '', 'currency_symbol' => 'ALL', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '2'),
            4 => array('Country_Name' => 'Algeria', 'Official_Name_English' => 'Algeria', 'ISO3166_1_Alpha_2' => 'DZ', 'ISO3166_1_Alpha_3' => 'DZA', 'M49' => '012', 'ITU' => 'ALG', 'MARC' => 'ae', 'WMO' => 'AL', 'DS' => 'DZ', 'Dial' => '213', 'FIFA' => 'ALG', 'FIPS' => 'AG', 'GAUL' => '4', 'IOC' => 'ALG', 'ISO4217_Currency_Alphabetic_Code' => 'DZD', 'ISO4217_Currency_Country_Name' => 'ALGERIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Algerian Dinar', 'ISO4217_Currency_Numeric_Code' => '12', 'Is_Independent' => 'Yes', 'Capital' => 'Algiers', 'Continent' => 'AF', 'TLD' => '.dz', 'Languages' => 'ar-DZ', 'Geo_Name_ID' => '2589581', 'EDGAR' => 'B4', '' => '', 'currency_symbol' => 'DZD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '3'),
            5 => array('Country_Name' => 'American Samoa', 'Official_Name_English' => 'American Samoa', 'ISO3166_1_Alpha_2' => 'AS', 'ISO3166_1_Alpha_3' => 'ASM', 'M49' => '016', 'ITU' => 'SMA', 'MARC' => 'as', 'WMO' => '', 'DS' => 'USA', 'Dial' => '684', 'FIFA' => 'ASA', 'FIPS' => 'AQ', 'GAUL' => '5', 'IOC' => 'ASA', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'AMERICAN SAMOA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Territory of US', 'Capital' => 'Pago Pago', 'Continent' => 'OC', 'TLD' => '.as', 'Languages' => 'en-AS,sm,to', 'Geo_Name_ID' => '5880801', 'EDGAR' => 'B5', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '4'),
            6 => array('Country_Name' => 'Andorra', 'Official_Name_English' => 'Andorra', 'ISO3166_1_Alpha_2' => 'AD', 'ISO3166_1_Alpha_3' => 'AND', 'M49' => '020', 'ITU' => 'AND', 'MARC' => 'an', 'WMO' => '', 'DS' => 'AND', 'Dial' => '376', 'FIFA' => 'AND', 'FIPS' => 'AN', 'GAUL' => '7', 'IOC' => 'AND', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'ANDORRA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Andorra la Vella', 'Continent' => 'EU', 'TLD' => '.ad', 'Languages' => 'ca', 'Geo_Name_ID' => '3041565', 'EDGAR' => 'B6', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '5'),
            7 => array('Country_Name' => 'Angola', 'Official_Name_English' => 'Angola', 'ISO3166_1_Alpha_2' => 'AO', 'ISO3166_1_Alpha_3' => 'AGO', 'M49' => '024', 'ITU' => 'AGL', 'MARC' => 'ao', 'WMO' => 'AN', 'DS' => 'AO', 'Dial' => '244', 'FIFA' => 'ANG', 'FIPS' => 'AO', 'GAUL' => '8', 'IOC' => 'ANG', 'ISO4217_Currency_Alphabetic_Code' => 'AOA', 'ISO4217_Currency_Country_Name' => 'ANGOLA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Kwanza', 'ISO4217_Currency_Numeric_Code' => '973', 'Is_Independent' => 'Yes', 'Capital' => 'Luanda', 'Continent' => 'AF', 'TLD' => '.ao', 'Languages' => 'pt-AO', 'Geo_Name_ID' => '3351879', 'EDGAR' => 'B7', '' => '', 'currency_symbol' => 'AOA', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '6'),
            8 => array('Country_Name' => 'Anguilla', 'Official_Name_English' => 'Anguilla', 'ISO3166_1_Alpha_2' => 'AI', 'ISO3166_1_Alpha_3' => 'AIA', 'M49' => '660', 'ITU' => 'AIA', 'MARC' => 'am', 'WMO' => '', 'DS' => '', 'Dial' => '264', 'FIFA' => 'AIA', 'FIPS' => 'AV', 'GAUL' => '9', 'IOC' => 'AIA', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'ANGUILLA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Territory of GB', 'Capital' => 'The Valley', 'Continent' => 'NA', 'TLD' => '.ai', 'Languages' => 'en-AI', 'Geo_Name_ID' => '3573511', 'EDGAR' => '1A', '' => '', 'currency_symbol' => 'XCD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '7'),
            9 => array('Country_Name' => 'Antarctica', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'AQ', 'ISO3166_1_Alpha_3' => 'ATA', 'M49' => '010', 'ITU' => '', 'MARC' => 'ay', 'WMO' => 'AA', 'DS' => '', 'Dial' => '672', 'FIFA' => 'ROS', 'FIPS' => 'AY', 'GAUL' => '10', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'International', 'Capital' => '', 'Continent' => 'AN', 'TLD' => '.aq', 'Languages' => '', 'Geo_Name_ID' => '6697173', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '8'),
            10 => array('Country_Name' => 'Antigua & Barbuda', 'Official_Name_English' => 'Antigua and Barbuda', 'ISO3166_1_Alpha_2' => 'AG', 'ISO3166_1_Alpha_3' => 'ATG', 'M49' => '028', 'ITU' => 'ATG', 'MARC' => 'aq', 'WMO' => 'AT', 'DS' => '', 'Dial' => '268', 'FIFA' => 'ATG', 'FIPS' => 'AC', 'GAUL' => '11', 'IOC' => 'ANT', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'ANTIGUA AND BARBUDA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Yes', 'Capital' => 'St. John\'s', 'Continent' => 'NA', 'TLD' => '.ag', 'Languages' => 'en-AG', 'Geo_Name_ID' => '3576396', 'EDGAR' => 'B9', '' => '', 'currency_symbol' => 'XCD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '9'),
            11 => array('Country_Name' => 'Argentina', 'Official_Name_English' => 'Argentina', 'ISO3166_1_Alpha_2' => 'AR', 'ISO3166_1_Alpha_3' => 'ARG', 'M49' => '032', 'ITU' => 'ARG', 'MARC' => 'ag', 'WMO' => 'AG', 'DS' => 'RA', 'Dial' => '54', 'FIFA' => 'ARG', 'FIPS' => 'AR', 'GAUL' => '12', 'IOC' => 'ARG', 'ISO4217_Currency_Alphabetic_Code' => 'ARS', 'ISO4217_Currency_Country_Name' => 'ARGENTINA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Argentine Peso', 'ISO4217_Currency_Numeric_Code' => '32', 'Is_Independent' => 'Yes', 'Capital' => 'Buenos Aires', 'Continent' => 'SA', 'TLD' => '.ar', 'Languages' => 'es-AR,en,it,de,fr,gn', 'Geo_Name_ID' => '3865483', 'EDGAR' => 'C1', '' => '', 'currency_symbol' => 'ARS', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '10'),
            12 => array('Country_Name' => 'Armenia', 'Official_Name_English' => 'Armenia', 'ISO3166_1_Alpha_2' => 'AM', 'ISO3166_1_Alpha_3' => 'ARM', 'M49' => '051', 'ITU' => 'ARM', 'MARC' => 'ai', 'WMO' => 'AY', 'DS' => 'AM', 'Dial' => '374', 'FIFA' => 'ARM', 'FIPS' => 'AM', 'GAUL' => '13', 'IOC' => 'ARM', 'ISO4217_Currency_Alphabetic_Code' => 'AMD', 'ISO4217_Currency_Country_Name' => 'ARMENIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Armenian Dram', 'ISO4217_Currency_Numeric_Code' => '51', 'Is_Independent' => 'Yes', 'Capital' => 'Yerevan', 'Continent' => 'AS', 'TLD' => '.am', 'Languages' => 'hy', 'Geo_Name_ID' => '174982', 'EDGAR' => '1B', '' => '', 'currency_symbol' => 'AMD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '11'),
            13 => array('Country_Name' => 'Aruba', 'Official_Name_English' => 'Aruba', 'ISO3166_1_Alpha_2' => 'AW', 'ISO3166_1_Alpha_3' => 'ABW', 'M49' => '533', 'ITU' => 'ABW', 'MARC' => 'aw', 'WMO' => 'NU', 'DS' => 'AW', 'Dial' => '297', 'FIFA' => 'ARU', 'FIPS' => 'AA', 'GAUL' => '14', 'IOC' => 'ARU', 'ISO4217_Currency_Alphabetic_Code' => 'AWG', 'ISO4217_Currency_Country_Name' => 'ARUBA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Aruban Florin', 'ISO4217_Currency_Numeric_Code' => '533', 'Is_Independent' => 'Part of NL', 'Capital' => 'Oranjestad', 'Continent' => 'NA', 'TLD' => '.aw', 'Languages' => 'nl-AW,es,en', 'Geo_Name_ID' => '3577279', 'EDGAR' => '1C', '' => '', 'currency_symbol' => 'AWG', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '12'),
            14 => array('Country_Name' => 'Australia', 'Official_Name_English' => 'Australia', 'ISO3166_1_Alpha_2' => 'AU', 'ISO3166_1_Alpha_3' => 'AUS', 'M49' => '036', 'ITU' => 'AUS', 'MARC' => 'at', 'WMO' => 'AU', 'DS' => 'AUS', 'Dial' => '61', 'FIFA' => 'AUS', 'FIPS' => 'AS', 'GAUL' => '17', 'IOC' => 'AUS', 'ISO4217_Currency_Alphabetic_Code' => 'AUD', 'ISO4217_Currency_Country_Name' => 'AUSTRALIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Australian Dollar', 'ISO4217_Currency_Numeric_Code' => '36', 'Is_Independent' => 'Yes', 'Capital' => 'Canberra', 'Continent' => 'OC', 'TLD' => '.au', 'Languages' => 'en-AU', 'Geo_Name_ID' => '2077456', 'EDGAR' => 'C3', '' => '', 'currency_symbol' => 'AUD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '13'),
            15 => array('Country_Name' => 'Austria', 'Official_Name_English' => 'Austria', 'ISO3166_1_Alpha_2' => 'AT', 'ISO3166_1_Alpha_3' => 'AUT', 'M49' => '040', 'ITU' => 'AUT', 'MARC' => 'au', 'WMO' => 'OS', 'DS' => 'A', 'Dial' => '43', 'FIFA' => 'AUT', 'FIPS' => 'AU', 'GAUL' => '18', 'IOC' => 'AUT', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'AUSTRIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Vienna', 'Continent' => 'EU', 'TLD' => '.at', 'Languages' => 'de-AT,hr,hu,sl', 'Geo_Name_ID' => '2782113', 'EDGAR' => 'C4', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '14'),
            16 => array('Country_Name' => 'Azerbaijan', 'Official_Name_English' => 'Azerbaijan', 'ISO3166_1_Alpha_2' => 'AZ', 'ISO3166_1_Alpha_3' => 'AZE', 'M49' => '031', 'ITU' => 'AZE', 'MARC' => 'aj', 'WMO' => 'AJ', 'DS' => 'AZ', 'Dial' => '994', 'FIFA' => 'AZE', 'FIPS' => 'AJ', 'GAUL' => '19', 'IOC' => 'AZE', 'ISO4217_Currency_Alphabetic_Code' => 'AZN', 'ISO4217_Currency_Country_Name' => 'AZERBAIJAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Azerbaijanian Manat', 'ISO4217_Currency_Numeric_Code' => '944', 'Is_Independent' => 'Yes', 'Capital' => 'Baku', 'Continent' => 'AS', 'TLD' => '.az', 'Languages' => 'az,ru,hy', 'Geo_Name_ID' => '587116', 'EDGAR' => '1D', '' => '', 'currency_symbol' => 'AZN', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '15'),
            17 => array('Country_Name' => 'Bahamas', 'Official_Name_English' => 'Bahamas', 'ISO3166_1_Alpha_2' => 'BS', 'ISO3166_1_Alpha_3' => 'BHS', 'M49' => '044', 'ITU' => 'BAH', 'MARC' => 'bf', 'WMO' => 'BA', 'DS' => 'BS', 'Dial' => '242', 'FIFA' => 'BAH', 'FIPS' => 'BF', 'GAUL' => '20', 'IOC' => 'BAH', 'ISO4217_Currency_Alphabetic_Code' => 'BSD', 'ISO4217_Currency_Country_Name' => 'BAHAMAS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Bahamian Dollar', 'ISO4217_Currency_Numeric_Code' => '44', 'Is_Independent' => 'Yes', 'Capital' => 'Nassau', 'Continent' => 'NA', 'TLD' => '.bs', 'Languages' => 'en-BS', 'Geo_Name_ID' => '3572887', 'EDGAR' => 'C5', '' => '', 'currency_symbol' => 'BSD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '16'),
            18 => array('Country_Name' => 'Bahrain', 'Official_Name_English' => 'Bahrain', 'ISO3166_1_Alpha_2' => 'BH', 'ISO3166_1_Alpha_3' => 'BHR', 'M49' => '048', 'ITU' => 'BHR', 'MARC' => 'ba', 'WMO' => 'BN', 'DS' => 'BRN', 'Dial' => '973', 'FIFA' => 'BHR', 'FIPS' => 'BA', 'GAUL' => '21', 'IOC' => 'BRN', 'ISO4217_Currency_Alphabetic_Code' => 'BHD', 'ISO4217_Currency_Country_Name' => 'BAHRAIN', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Bahraini Dinar', 'ISO4217_Currency_Numeric_Code' => '48', 'Is_Independent' => 'Yes', 'Capital' => 'Manama', 'Continent' => 'AS', 'TLD' => '.bh', 'Languages' => 'ar-BH,en,fa,ur', 'Geo_Name_ID' => '290291', 'EDGAR' => 'C6', '' => '', 'currency_symbol' => 'BHD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '17'),
            19 => array('Country_Name' => 'Bangladesh', 'Official_Name_English' => 'Bangladesh', 'ISO3166_1_Alpha_2' => 'BD', 'ISO3166_1_Alpha_3' => 'BGD', 'M49' => '050', 'ITU' => 'BGD', 'MARC' => 'bg', 'WMO' => 'BW', 'DS' => 'BD', 'Dial' => '880', 'FIFA' => 'BAN', 'FIPS' => 'BG', 'GAUL' => '23', 'IOC' => 'BAN', 'ISO4217_Currency_Alphabetic_Code' => 'BDT', 'ISO4217_Currency_Country_Name' => 'BANGLADESH', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Taka', 'ISO4217_Currency_Numeric_Code' => '50', 'Is_Independent' => 'Yes', 'Capital' => 'Dhaka', 'Continent' => 'AS', 'TLD' => '.bd', 'Languages' => 'bn-BD,en', 'Geo_Name_ID' => '1210997', 'EDGAR' => 'C7', '' => '', 'currency_symbol' => 'BDT', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '18'),
            20 => array('Country_Name' => 'Barbados', 'Official_Name_English' => 'Barbados', 'ISO3166_1_Alpha_2' => 'BB', 'ISO3166_1_Alpha_3' => 'BRB', 'M49' => '052', 'ITU' => 'BRB', 'MARC' => 'bb', 'WMO' => 'BR', 'DS' => 'BDS', 'Dial' => '246', 'FIFA' => 'BRB', 'FIPS' => 'BB', 'GAUL' => '24', 'IOC' => 'BAR', 'ISO4217_Currency_Alphabetic_Code' => 'BBD', 'ISO4217_Currency_Country_Name' => 'BARBADOS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Barbados Dollar', 'ISO4217_Currency_Numeric_Code' => '52', 'Is_Independent' => 'Yes', 'Capital' => 'Bridgetown', 'Continent' => 'NA', 'TLD' => '.bb', 'Languages' => 'en-BB', 'Geo_Name_ID' => '3374084', 'EDGAR' => 'C8', '' => '', 'currency_symbol' => 'BBD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '19'),
            21 => array('Country_Name' => 'Belarus', 'Official_Name_English' => 'Belarus', 'ISO3166_1_Alpha_2' => 'BY', 'ISO3166_1_Alpha_3' => 'BLR', 'M49' => '112', 'ITU' => 'BLR', 'MARC' => 'bw', 'WMO' => 'BY', 'DS' => 'BY', 'Dial' => '375', 'FIFA' => 'BLR', 'FIPS' => 'BO', 'GAUL' => '26', 'IOC' => 'BLR', 'ISO4217_Currency_Alphabetic_Code' => 'BYR', 'ISO4217_Currency_Country_Name' => 'BELARUS', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Belarussian Ruble', 'ISO4217_Currency_Numeric_Code' => '974', 'Is_Independent' => 'Yes', 'Capital' => 'Minsk', 'Continent' => 'EU', 'TLD' => '.by', 'Languages' => 'be,ru', 'Geo_Name_ID' => '630336', 'EDGAR' => '1F', '' => '', 'currency_symbol' => 'BYR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '20'),
            22 => array('Country_Name' => 'Belgium', 'Official_Name_English' => 'Belgium', 'ISO3166_1_Alpha_2' => 'BE', 'ISO3166_1_Alpha_3' => 'BEL', 'M49' => '056', 'ITU' => 'BEL', 'MARC' => 'be', 'WMO' => 'BX', 'DS' => 'B', 'Dial' => '32', 'FIFA' => 'BEL', 'FIPS' => 'BE', 'GAUL' => '27', 'IOC' => 'BEL', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'BELGIUM', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Brussels', 'Continent' => 'EU', 'TLD' => '.be', 'Languages' => 'nl-BE,fr-BE,de-BE', 'Geo_Name_ID' => '2802361', 'EDGAR' => 'C9', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '21'),
            23 => array('Country_Name' => 'Belize', 'Official_Name_English' => 'Belize', 'ISO3166_1_Alpha_2' => 'BZ', 'ISO3166_1_Alpha_3' => 'BLZ', 'M49' => '084', 'ITU' => 'BLZ', 'MARC' => 'bh', 'WMO' => 'BH', 'DS' => 'BH', 'Dial' => '501', 'FIFA' => 'BLZ', 'FIPS' => 'BH', 'GAUL' => '28', 'IOC' => 'BIZ', 'ISO4217_Currency_Alphabetic_Code' => 'BZD', 'ISO4217_Currency_Country_Name' => 'BELIZE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Belize Dollar', 'ISO4217_Currency_Numeric_Code' => '84', 'Is_Independent' => 'Yes', 'Capital' => 'Belmopan', 'Continent' => 'NA', 'TLD' => '.bz', 'Languages' => 'en-BZ,es', 'Geo_Name_ID' => '3582678', 'EDGAR' => 'D1', '' => '', 'currency_symbol' => 'BZD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '22'),
            24 => array('Country_Name' => 'Benin', 'Official_Name_English' => 'Benin', 'ISO3166_1_Alpha_2' => 'BJ', 'ISO3166_1_Alpha_3' => 'BEN', 'M49' => '204', 'ITU' => 'BEN', 'MARC' => 'dm', 'WMO' => 'BJ', 'DS' => 'DY', 'Dial' => '229', 'FIFA' => 'BEN', 'FIPS' => 'BN', 'GAUL' => '29', 'IOC' => 'BEN', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'BENIN', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Porto-Novo', 'Continent' => 'AF', 'TLD' => '.bj', 'Languages' => 'fr-BJ', 'Geo_Name_ID' => '2395170', 'EDGAR' => 'G6', '' => '', 'currency_symbol' => 'XOF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '23'),
            25 => array('Country_Name' => 'Bermuda', 'Official_Name_English' => 'Bermuda', 'ISO3166_1_Alpha_2' => 'BM', 'ISO3166_1_Alpha_3' => 'BMU', 'M49' => '060', 'ITU' => 'BER', 'MARC' => 'bm', 'WMO' => 'BE', 'DS' => 'BM', 'Dial' => '441', 'FIFA' => 'BER', 'FIPS' => 'BD', 'GAUL' => '30', 'IOC' => 'BER', 'ISO4217_Currency_Alphabetic_Code' => 'BMD', 'ISO4217_Currency_Country_Name' => 'BERMUDA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Bermudian Dollar', 'ISO4217_Currency_Numeric_Code' => '60', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Hamilton', 'Continent' => 'NA', 'TLD' => '.bm', 'Languages' => 'en-BM,pt', 'Geo_Name_ID' => '3573345', 'EDGAR' => 'D0', '' => '', 'currency_symbol' => 'BMD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '24'),
            26 => array('Country_Name' => 'Bhutan', 'Official_Name_English' => 'Bhutan', 'ISO3166_1_Alpha_2' => 'BT', 'ISO3166_1_Alpha_3' => 'BTN', 'M49' => '064', 'ITU' => 'BTN', 'MARC' => 'bt', 'WMO' => '', 'DS' => 'BT', 'Dial' => '975', 'FIFA' => 'BHU', 'FIPS' => 'BT', 'GAUL' => '31', 'IOC' => 'BHU', 'ISO4217_Currency_Alphabetic_Code' => 'INR', 'ISO4217_Currency_Country_Name' => 'BHUTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Indian Rupee', 'ISO4217_Currency_Numeric_Code' => '356', 'Is_Independent' => 'Yes', 'Capital' => 'Thimphu', 'Continent' => 'AS', 'TLD' => '.bt', 'Languages' => 'dz', 'Geo_Name_ID' => '1252634', 'EDGAR' => 'D2', '' => '', 'currency_symbol' => 'INR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '25'),
            27 => array('Country_Name' => 'Bolivia', 'Official_Name_English' => 'Bolivia (Plurinational State of)', 'ISO3166_1_Alpha_2' => 'BO', 'ISO3166_1_Alpha_3' => 'BOL', 'M49' => '068', 'ITU' => 'BOL', 'MARC' => 'bo', 'WMO' => 'BO', 'DS' => 'BOL', 'Dial' => '591', 'FIFA' => 'BOL', 'FIPS' => 'BL', 'GAUL' => '33', 'IOC' => 'BOL', 'ISO4217_Currency_Alphabetic_Code' => 'BOB', 'ISO4217_Currency_Country_Name' => 'BOLIVIA, PLURINATIONAL STATE OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Boliviano', 'ISO4217_Currency_Numeric_Code' => '68', 'Is_Independent' => 'Yes', 'Capital' => 'Sucre', 'Continent' => 'SA', 'TLD' => '.bo', 'Languages' => 'es-BO,qu,ay', 'Geo_Name_ID' => '3923057', 'EDGAR' => '', '' => '', 'currency_symbol' => 'BOB', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '26'),
            28 => array('Country_Name' => 'Bosnia', 'Official_Name_English' => 'Bosnia and Herzegovina', 'ISO3166_1_Alpha_2' => 'BA', 'ISO3166_1_Alpha_3' => 'BIH', 'M49' => '070', 'ITU' => 'BIH', 'MARC' => 'bn', 'WMO' => 'BG', 'DS' => 'BIH', 'Dial' => '387', 'FIFA' => 'BIH', 'FIPS' => 'BK', 'GAUL' => '34', 'IOC' => 'BIH', 'ISO4217_Currency_Alphabetic_Code' => 'BAM', 'ISO4217_Currency_Country_Name' => 'BOSNIA AND HERZEGOVINA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Convertible Mark', 'ISO4217_Currency_Numeric_Code' => '977', 'Is_Independent' => 'Yes', 'Capital' => 'Sarajevo', 'Continent' => 'EU', 'TLD' => '.ba', 'Languages' => 'bs,hr-BA,sr-BA', 'Geo_Name_ID' => '3277605', 'EDGAR' => '1E', '' => '', 'currency_symbol' => 'BAM', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '27'),
            29 => array('Country_Name' => 'Botswana', 'Official_Name_English' => 'Botswana', 'ISO3166_1_Alpha_2' => 'BW', 'ISO3166_1_Alpha_3' => 'BWA', 'M49' => '072', 'ITU' => 'BOT', 'MARC' => 'bs', 'WMO' => 'BC', 'DS' => 'BW', 'Dial' => '267', 'FIFA' => 'BOT', 'FIPS' => 'BC', 'GAUL' => '35', 'IOC' => 'BOT', 'ISO4217_Currency_Alphabetic_Code' => 'BWP', 'ISO4217_Currency_Country_Name' => 'BOTSWANA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pula', 'ISO4217_Currency_Numeric_Code' => '72', 'Is_Independent' => 'Yes', 'Capital' => 'Gaborone', 'Continent' => 'AF', 'TLD' => '.bw', 'Languages' => 'en-BW,tn-BW', 'Geo_Name_ID' => '933860', 'EDGAR' => 'B1', '' => '', 'currency_symbol' => 'BWP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '28'),
            30 => array('Country_Name' => 'Bouvet Island', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'BV', 'ISO3166_1_Alpha_3' => 'BVT', 'M49' => '074', 'ITU' => '', 'MARC' => 'bv', 'WMO' => 'BV', 'DS' => 'BV', 'Dial' => '47', 'FIFA' => '', 'FIPS' => 'BV', 'GAUL' => '36', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of NO', 'Capital' => '', 'Continent' => 'AN', 'TLD' => '.bv', 'Languages' => '', 'Geo_Name_ID' => '3371123', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '29'),
            31 => array('Country_Name' => 'Brazil', 'Official_Name_English' => 'Brazil', 'ISO3166_1_Alpha_2' => 'BR', 'ISO3166_1_Alpha_3' => 'BRA', 'M49' => '076', 'ITU' => 'B', 'MARC' => 'bl', 'WMO' => 'BZ', 'DS' => 'BR', 'Dial' => '55', 'FIFA' => 'BRA', 'FIPS' => 'BR', 'GAUL' => '37', 'IOC' => 'BRA', 'ISO4217_Currency_Alphabetic_Code' => 'BRL', 'ISO4217_Currency_Country_Name' => 'BRAZIL', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Brazilian Real', 'ISO4217_Currency_Numeric_Code' => '986', 'Is_Independent' => 'Yes', 'Capital' => 'Brasilia', 'Continent' => 'SA', 'TLD' => '.br', 'Languages' => 'pt-BR,es,en,fr', 'Geo_Name_ID' => '3469034', 'EDGAR' => 'D5', '' => '', 'currency_symbol' => 'BRL', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '30'),
            32 => array('Country_Name' => 'British Indian Ocean Territory', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'IO', 'ISO3166_1_Alpha_3' => 'IOT', 'M49' => '086', 'ITU' => 'BIO', 'MARC' => 'bi', 'WMO' => '', 'DS' => '', 'Dial' => '246', 'FIFA' => '', 'FIPS' => 'IO', 'GAUL' => '38', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Diego Garcia', 'Continent' => 'AS', 'TLD' => '.io', 'Languages' => 'en-IO', 'Geo_Name_ID' => '1282588', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '31'),
            33 => array('Country_Name' => 'British Virgin Islands', 'Official_Name_English' => 'British Virgin Islands', 'ISO3166_1_Alpha_2' => 'VG', 'ISO3166_1_Alpha_3' => 'VGB', 'M49' => '092', 'ITU' => 'VRG', 'MARC' => 'vb', 'WMO' => 'VI', 'DS' => 'BVI', 'Dial' => '284', 'FIFA' => 'VGB', 'FIPS' => 'VI', 'GAUL' => '39', 'IOC' => 'IVB', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'VIRGIN ISLANDS (BRITISH)', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Road Town', 'Continent' => 'NA', 'TLD' => '.vg', 'Languages' => 'en-VG', 'Geo_Name_ID' => '3577718', 'EDGAR' => '', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '32'),
            34 => array('Country_Name' => 'Brunei', 'Official_Name_English' => 'Brunei Darussalam', 'ISO3166_1_Alpha_2' => 'BN', 'ISO3166_1_Alpha_3' => 'BRN', 'M49' => '096', 'ITU' => 'BRU', 'MARC' => 'bx', 'WMO' => 'BD', 'DS' => 'BRU', 'Dial' => '673', 'FIFA' => 'BRU', 'FIPS' => 'BX', 'GAUL' => '40', 'IOC' => 'BRU', 'ISO4217_Currency_Alphabetic_Code' => 'BND', 'ISO4217_Currency_Country_Name' => 'BRUNEI DARUSSALAM', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Brunei Dollar', 'ISO4217_Currency_Numeric_Code' => '96', 'Is_Independent' => 'Yes', 'Capital' => 'Bandar Seri Begawan', 'Continent' => 'AS', 'TLD' => '.bn', 'Languages' => 'ms-BN,en-BN', 'Geo_Name_ID' => '1820814', 'EDGAR' => 'D9', '' => '', 'currency_symbol' => 'BND', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '33'),
            35 => array('Country_Name' => 'Bulgaria', 'Official_Name_English' => 'Bulgaria', 'ISO3166_1_Alpha_2' => 'BG', 'ISO3166_1_Alpha_3' => 'BGR', 'M49' => '100', 'ITU' => 'BUL', 'MARC' => 'bu', 'WMO' => 'BU', 'DS' => 'BG', 'Dial' => '359', 'FIFA' => 'BUL', 'FIPS' => 'BU', 'GAUL' => '41', 'IOC' => 'BUL', 'ISO4217_Currency_Alphabetic_Code' => 'BGN', 'ISO4217_Currency_Country_Name' => 'BULGARIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Bulgarian Lev', 'ISO4217_Currency_Numeric_Code' => '975', 'Is_Independent' => 'Yes', 'Capital' => 'Sofia', 'Continent' => 'EU', 'TLD' => '.bg', 'Languages' => 'bg,tr-BG,rom', 'Geo_Name_ID' => '732800', 'EDGAR' => 'E0', '' => '', 'currency_symbol' => 'BGN', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '34'),
            36 => array('Country_Name' => 'Burkina Faso', 'Official_Name_English' => 'Burkina Faso', 'ISO3166_1_Alpha_2' => 'BF', 'ISO3166_1_Alpha_3' => 'BFA', 'M49' => '854', 'ITU' => 'BFA', 'MARC' => 'uv', 'WMO' => 'HV', 'DS' => 'BF', 'Dial' => '226', 'FIFA' => 'BFA', 'FIPS' => 'UV', 'GAUL' => '42', 'IOC' => 'BUR', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'BURKINA FASO', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Ouagadougou', 'Continent' => 'AF', 'TLD' => '.bf', 'Languages' => 'fr-BF', 'Geo_Name_ID' => '2361809', 'EDGAR' => 'X2', '' => '', 'currency_symbol' => 'XOF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '35'),
            37 => array('Country_Name' => 'Burundi', 'Official_Name_English' => 'Burundi', 'ISO3166_1_Alpha_2' => 'BI', 'ISO3166_1_Alpha_3' => 'BDI', 'M49' => '108', 'ITU' => 'BDI', 'MARC' => 'bd', 'WMO' => 'BI', 'DS' => 'RU', 'Dial' => '257', 'FIFA' => 'BDI', 'FIPS' => 'BY', 'GAUL' => '43', 'IOC' => 'BDI', 'ISO4217_Currency_Alphabetic_Code' => 'BIF', 'ISO4217_Currency_Country_Name' => 'BURUNDI', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Burundi Franc', 'ISO4217_Currency_Numeric_Code' => '108', 'Is_Independent' => 'Yes', 'Capital' => 'Bujumbura', 'Continent' => 'AF', 'TLD' => '.bi', 'Languages' => 'fr-BI,rn', 'Geo_Name_ID' => '433561', 'EDGAR' => 'E2', '' => '', 'currency_symbol' => 'BIF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '36'),
            38 => array('Country_Name' => 'Cambodia', 'Official_Name_English' => 'Cambodia', 'ISO3166_1_Alpha_2' => 'KH', 'ISO3166_1_Alpha_3' => 'KHM', 'M49' => '116', 'ITU' => 'CBG', 'MARC' => 'cb', 'WMO' => 'KP', 'DS' => 'K', 'Dial' => '855', 'FIFA' => 'CAM', 'FIPS' => 'CB', 'GAUL' => '44', 'IOC' => 'CAM', 'ISO4217_Currency_Alphabetic_Code' => 'KHR', 'ISO4217_Currency_Country_Name' => 'CAMBODIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Riel', 'ISO4217_Currency_Numeric_Code' => '116', 'Is_Independent' => 'Yes', 'Capital' => 'Phnom Penh', 'Continent' => 'AS', 'TLD' => '.kh', 'Languages' => 'km,fr,en', 'Geo_Name_ID' => '1831722', 'EDGAR' => 'E3', '' => '', 'currency_symbol' => 'KHR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '37'),
            39 => array('Country_Name' => 'Cameroon', 'Official_Name_English' => 'Cameroon', 'ISO3166_1_Alpha_2' => 'CM', 'ISO3166_1_Alpha_3' => 'CMR', 'M49' => '120', 'ITU' => 'CME', 'MARC' => 'cm', 'WMO' => 'CM', 'DS' => 'CAM', 'Dial' => '237', 'FIFA' => 'CMR', 'FIPS' => 'CM', 'GAUL' => '45', 'IOC' => 'CMR', 'ISO4217_Currency_Alphabetic_Code' => 'XAF', 'ISO4217_Currency_Country_Name' => 'CAMEROON', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BEAC', 'ISO4217_Currency_Numeric_Code' => '950', 'Is_Independent' => 'Yes', 'Capital' => 'Yaounde', 'Continent' => 'AF', 'TLD' => '.cm', 'Languages' => 'en-CM,fr-CM', 'Geo_Name_ID' => '2233387', 'EDGAR' => 'E4', '' => '', 'currency_symbol' => 'XAF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '38'),
            40 => array('Country_Name' => 'Canada', 'Official_Name_English' => 'Canada', 'ISO3166_1_Alpha_2' => 'CA', 'ISO3166_1_Alpha_3' => 'CAN', 'M49' => '124', 'ITU' => 'CAN', 'MARC' => 'xxc', 'WMO' => 'CN', 'DS' => 'CDN', 'Dial' => '1', 'FIFA' => 'CAN', 'FIPS' => 'CA', 'GAUL' => '46', 'IOC' => 'CAN', 'ISO4217_Currency_Alphabetic_Code' => 'CAD', 'ISO4217_Currency_Country_Name' => 'CANADA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Canadian Dollar', 'ISO4217_Currency_Numeric_Code' => '124', 'Is_Independent' => 'Yes', 'Capital' => 'Ottawa', 'Continent' => 'NA', 'TLD' => '.ca', 'Languages' => 'en-CA,fr-CA,iu', 'Geo_Name_ID' => '6251999', 'EDGAR' => '', '' => '', 'currency_symbol' => 'CAD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '39'),
            41 => array('Country_Name' => 'Cape Verde', 'Official_Name_English' => 'Cabo Verde', 'ISO3166_1_Alpha_2' => 'CV', 'ISO3166_1_Alpha_3' => 'CPV', 'M49' => '132', 'ITU' => 'CPV', 'MARC' => 'cv', 'WMO' => 'CV', 'DS' => 'CV', 'Dial' => '238', 'FIFA' => 'CPV', 'FIPS' => 'CV', 'GAUL' => '47', 'IOC' => 'CPV', 'ISO4217_Currency_Alphabetic_Code' => 'CVE', 'ISO4217_Currency_Country_Name' => 'CABO VERDE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Cabo Verde Escudo', 'ISO4217_Currency_Numeric_Code' => '132', 'Is_Independent' => 'Yes', 'Capital' => 'Praia', 'Continent' => 'AF', 'TLD' => '.cv', 'Languages' => 'pt-CV', 'Geo_Name_ID' => '3374766', 'EDGAR' => '', '' => '', 'currency_symbol' => 'CVE', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '40'),
            42 => array('Country_Name' => 'Caribbean Netherlands', 'Official_Name_English' => 'Bonaire, Sint Eustatius and Saba', 'ISO3166_1_Alpha_2' => 'BQ', 'ISO3166_1_Alpha_3' => 'BES', 'M49' => '535', 'ITU' => 'ATN', 'MARC' => 'ca', 'WMO' => 'NU', 'DS' => 'NA', 'Dial' => '599', 'FIFA' => 'ANT', 'FIPS' => 'NL', 'GAUL' => '176', 'IOC' => 'AHO', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'BONAIRE, SINT EUSTATIUS AND SABA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Part of NL', 'Capital' => '', 'Continent' => 'NA', 'TLD' => '.bq', 'Languages' => 'nl,pap,en', 'Geo_Name_ID' => '7626844', 'EDGAR' => '', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '41'),
            43 => array('Country_Name' => 'Cayman Islands', 'Official_Name_English' => 'Cayman Islands', 'ISO3166_1_Alpha_2' => 'KY', 'ISO3166_1_Alpha_3' => 'CYM', 'M49' => '136', 'ITU' => 'CYM', 'MARC' => 'cj', 'WMO' => 'GC', 'DS' => 'KY', 'Dial' => '345', 'FIFA' => 'CAY', 'FIPS' => 'CJ', 'GAUL' => '48', 'IOC' => 'CAY', 'ISO4217_Currency_Alphabetic_Code' => 'KYD', 'ISO4217_Currency_Country_Name' => 'CAYMAN ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Cayman Islands Dollar', 'ISO4217_Currency_Numeric_Code' => '136', 'Is_Independent' => 'Territory of GB', 'Capital' => 'George Town', 'Continent' => 'NA', 'TLD' => '.ky', 'Languages' => 'en-KY', 'Geo_Name_ID' => '3580718', 'EDGAR' => 'E9', '' => '', 'currency_symbol' => 'KYD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '42'),
            44 => array('Country_Name' => 'Central African Republic', 'Official_Name_English' => 'Central African Republic', 'ISO3166_1_Alpha_2' => 'CF', 'ISO3166_1_Alpha_3' => 'CAF', 'M49' => '140', 'ITU' => 'CAF', 'MARC' => 'cx', 'WMO' => 'CE', 'DS' => 'RCA', 'Dial' => '236', 'FIFA' => 'CTA', 'FIPS' => 'CT', 'GAUL' => '49', 'IOC' => 'CAF', 'ISO4217_Currency_Alphabetic_Code' => 'XAF', 'ISO4217_Currency_Country_Name' => 'CENTRAL AFRICAN REPUBLIC', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BEAC', 'ISO4217_Currency_Numeric_Code' => '950', 'Is_Independent' => 'Yes', 'Capital' => 'Bangui', 'Continent' => 'AF', 'TLD' => '.cf', 'Languages' => 'fr-CF,sg,ln,kg', 'Geo_Name_ID' => '239880', 'EDGAR' => 'F0', '' => '', 'currency_symbol' => 'XAF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '43'),
            45 => array('Country_Name' => 'Chad', 'Official_Name_English' => 'Chad', 'ISO3166_1_Alpha_2' => 'TD', 'ISO3166_1_Alpha_3' => 'TCD', 'M49' => '148', 'ITU' => 'TCD', 'MARC' => 'cd', 'WMO' => 'CD', 'DS' => 'TCH', 'Dial' => '235', 'FIFA' => 'CHA', 'FIPS' => 'CD', 'GAUL' => '50', 'IOC' => 'CHA', 'ISO4217_Currency_Alphabetic_Code' => 'XAF', 'ISO4217_Currency_Country_Name' => 'CHAD', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BEAC', 'ISO4217_Currency_Numeric_Code' => '950', 'Is_Independent' => 'Yes', 'Capital' => 'N\'Djamena', 'Continent' => 'AF', 'TLD' => '.td', 'Languages' => 'fr-TD,ar-TD,sre', 'Geo_Name_ID' => '2434508', 'EDGAR' => 'F2', '' => '', 'currency_symbol' => 'XAF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '44'),
            46 => array('Country_Name' => 'Chile', 'Official_Name_English' => 'Chile', 'ISO3166_1_Alpha_2' => 'CL', 'ISO3166_1_Alpha_3' => 'CHL', 'M49' => '152', 'ITU' => 'CHL', 'MARC' => 'cl', 'WMO' => 'CH', 'DS' => 'RCH', 'Dial' => '56', 'FIFA' => 'CHI', 'FIPS' => 'CI', 'GAUL' => '51', 'IOC' => 'CHI', 'ISO4217_Currency_Alphabetic_Code' => 'CLP', 'ISO4217_Currency_Country_Name' => 'CHILE', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Chilean Peso', 'ISO4217_Currency_Numeric_Code' => '152', 'Is_Independent' => 'Yes', 'Capital' => 'Santiago', 'Continent' => 'SA', 'TLD' => '.cl', 'Languages' => 'es-CL', 'Geo_Name_ID' => '3895114', 'EDGAR' => 'F3', '' => '', 'currency_symbol' => 'CLP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '45'),
            47 => array('Country_Name' => 'China', 'Official_Name_English' => 'China', 'ISO3166_1_Alpha_2' => 'CN', 'ISO3166_1_Alpha_3' => 'CHN', 'M49' => '156', 'ITU' => 'CHN', 'MARC' => 'cc', 'WMO' => 'CI', 'DS' => 'CN', 'Dial' => '86', 'FIFA' => 'CHN', 'FIPS' => 'CH', 'GAUL' => '53', 'IOC' => 'CHN', 'ISO4217_Currency_Alphabetic_Code' => 'CNY', 'ISO4217_Currency_Country_Name' => 'CHINA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Yuan Renminbi', 'ISO4217_Currency_Numeric_Code' => '156', 'Is_Independent' => 'Yes', 'Capital' => 'Beijing', 'Continent' => 'AS', 'TLD' => '.cn', 'Languages' => 'zh-CN,yue,wuu,dta,ug,za', 'Geo_Name_ID' => '1814991', 'EDGAR' => 'F4', '' => '', 'currency_symbol' => 'CNY', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '46'),
            48 => array('Country_Name' => 'Christmas Island', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'CX', 'ISO3166_1_Alpha_3' => 'CXR', 'M49' => '162', 'ITU' => 'CHR', 'MARC' => 'xa', 'WMO' => 'KI', 'DS' => 'AUS', 'Dial' => '61', 'FIFA' => 'CXR', 'FIPS' => 'KT', 'GAUL' => '54', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of AU', 'Capital' => 'Flying Fish Cove', 'Continent' => 'AS', 'TLD' => '.cx', 'Languages' => 'en,zh,ms-CC', 'Geo_Name_ID' => '2078138', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '47'),
            49 => array('Country_Name' => 'Cocos (Keeling) Islands', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'CC', 'ISO3166_1_Alpha_3' => 'CCK', 'M49' => '166', 'ITU' => 'ICO', 'MARC' => 'xb', 'WMO' => 'KK', 'DS' => 'AUS', 'Dial' => '61', 'FIFA' => 'CCK', 'FIPS' => 'CK', 'GAUL' => '56', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of AU', 'Capital' => 'West Island', 'Continent' => 'AS', 'TLD' => '.cc', 'Languages' => 'ms-CC,en', 'Geo_Name_ID' => '1547376', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '48'),
            50 => array('Country_Name' => 'Colombia', 'Official_Name_English' => 'Colombia', 'ISO3166_1_Alpha_2' => 'CO', 'ISO3166_1_Alpha_3' => 'COL', 'M49' => '170', 'ITU' => 'CLM', 'MARC' => 'ck', 'WMO' => 'CO', 'DS' => 'CO', 'Dial' => '57', 'FIFA' => 'COL', 'FIPS' => 'CO', 'GAUL' => '57', 'IOC' => 'COL', 'ISO4217_Currency_Alphabetic_Code' => 'COP', 'ISO4217_Currency_Country_Name' => 'COLOMBIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Colombian Peso', 'ISO4217_Currency_Numeric_Code' => '170', 'Is_Independent' => 'Yes', 'Capital' => 'Bogota', 'Continent' => 'SA', 'TLD' => '.co', 'Languages' => 'es-CO', 'Geo_Name_ID' => '3686110', 'EDGAR' => 'F8', '' => '', 'currency_symbol' => 'COP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '49'),
            51 => array('Country_Name' => 'Comoros', 'Official_Name_English' => 'Comoros', 'ISO3166_1_Alpha_2' => 'KM', 'ISO3166_1_Alpha_3' => 'COM', 'M49' => '174', 'ITU' => 'COM', 'MARC' => 'cq', 'WMO' => 'IC', 'DS' => 'KM', 'Dial' => '269', 'FIFA' => 'COM', 'FIPS' => 'CN', 'GAUL' => '58', 'IOC' => 'COM', 'ISO4217_Currency_Alphabetic_Code' => 'KMF', 'ISO4217_Currency_Country_Name' => 'COMOROS', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Comoro Franc', 'ISO4217_Currency_Numeric_Code' => '174', 'Is_Independent' => 'Yes', 'Capital' => 'Moroni', 'Continent' => 'AF', 'TLD' => '.km', 'Languages' => 'ar,fr-KM', 'Geo_Name_ID' => '921929', 'EDGAR' => 'F9', '' => '', 'currency_symbol' => 'KMF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '50'),
            52 => array('Country_Name' => 'Congo - Brazzaville', 'Official_Name_English' => 'Congo', 'ISO3166_1_Alpha_2' => 'CG', 'ISO3166_1_Alpha_3' => 'COG', 'M49' => '178', 'ITU' => 'COG', 'MARC' => 'cf', 'WMO' => 'CG', 'DS' => 'RCB', 'Dial' => '242', 'FIFA' => 'CGO', 'FIPS' => 'CF', 'GAUL' => '59', 'IOC' => 'CGO', 'ISO4217_Currency_Alphabetic_Code' => 'XAF', 'ISO4217_Currency_Country_Name' => 'CONGO', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BEAC', 'ISO4217_Currency_Numeric_Code' => '950', 'Is_Independent' => 'Yes', 'Capital' => 'Brazzaville', 'Continent' => 'AF', 'TLD' => '.cg', 'Languages' => 'fr-CG,kg,ln-CG', 'Geo_Name_ID' => '2260494', 'EDGAR' => 'G0', '' => '', 'currency_symbol' => 'XAF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '51'),
            53 => array('Country_Name' => 'Congo - Kinshasa', 'Official_Name_English' => 'Democratic Republic of the Congo', 'ISO3166_1_Alpha_2' => 'CD', 'ISO3166_1_Alpha_3' => 'COD', 'M49' => '180', 'ITU' => 'COD', 'MARC' => 'cg', 'WMO' => 'ZR', 'DS' => 'ZRE', 'Dial' => '243', 'FIFA' => 'COD', 'FIPS' => 'CG', 'GAUL' => '68', 'IOC' => 'COD', 'ISO4217_Currency_Alphabetic_Code' => 'COD', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Yes', 'Capital' => 'Kinshasa', 'Continent' => 'AF', 'TLD' => '.cd', 'Languages' => 'fr-CD,ln,kg', 'Geo_Name_ID' => '203312', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '52'),
            54 => array('Country_Name' => 'Cook Islands', 'Official_Name_English' => 'Cook Islands', 'ISO3166_1_Alpha_2' => 'CK', 'ISO3166_1_Alpha_3' => 'COK', 'M49' => '184', 'ITU' => 'CKH', 'MARC' => 'cw', 'WMO' => 'KU', 'DS' => 'NZ', 'Dial' => '682', 'FIFA' => 'COK', 'FIPS' => 'CW', 'GAUL' => '60', 'IOC' => 'COK', 'ISO4217_Currency_Alphabetic_Code' => 'NZD', 'ISO4217_Currency_Country_Name' => 'COOK ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Zealand Dollar', 'ISO4217_Currency_Numeric_Code' => '554', 'Is_Independent' => 'Associated with NZ', 'Capital' => 'Avarua', 'Continent' => 'OC', 'TLD' => '.ck', 'Languages' => 'en-CK,mi', 'Geo_Name_ID' => '1899402', 'EDGAR' => 'G1', '' => '', 'currency_symbol' => 'NZD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '53'),
            55 => array('Country_Name' => 'Costa Rica', 'Official_Name_English' => 'Costa Rica', 'ISO3166_1_Alpha_2' => 'CR', 'ISO3166_1_Alpha_3' => 'CRI', 'M49' => '188', 'ITU' => 'CTR', 'MARC' => 'cr', 'WMO' => 'CS', 'DS' => 'CR', 'Dial' => '506', 'FIFA' => 'CRC', 'FIPS' => 'CS', 'GAUL' => '61', 'IOC' => 'CRC', 'ISO4217_Currency_Alphabetic_Code' => 'CRC', 'ISO4217_Currency_Country_Name' => 'COSTA RICA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Costa Rican Colon', 'ISO4217_Currency_Numeric_Code' => '188', 'Is_Independent' => 'Yes', 'Capital' => 'San Jose', 'Continent' => 'NA', 'TLD' => '.cr', 'Languages' => 'es-CR,en', 'Geo_Name_ID' => '3624060', 'EDGAR' => 'G2', '' => '', 'currency_symbol' => 'CRC', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '54'),
            56 => array('Country_Name' => 'Croatia', 'Official_Name_English' => 'Croatia', 'ISO3166_1_Alpha_2' => 'HR', 'ISO3166_1_Alpha_3' => 'HRV', 'M49' => '191', 'ITU' => 'HRV', 'MARC' => 'ci', 'WMO' => 'RH', 'DS' => 'HR', 'Dial' => '385', 'FIFA' => 'CRO', 'FIPS' => 'HR', 'GAUL' => '62', 'IOC' => 'CRO', 'ISO4217_Currency_Alphabetic_Code' => 'HRK', 'ISO4217_Currency_Country_Name' => 'CROATIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Croatian Kuna', 'ISO4217_Currency_Numeric_Code' => '191', 'Is_Independent' => 'Yes', 'Capital' => 'Zagreb', 'Continent' => 'EU', 'TLD' => '.hr', 'Languages' => 'hr-HR,sr', 'Geo_Name_ID' => '3202326', 'EDGAR' => '1M', '' => '', 'currency_symbol' => 'HRK', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '55'),
            57 => array('Country_Name' => 'Cuba', 'Official_Name_English' => 'Cuba', 'ISO3166_1_Alpha_2' => 'CU', 'ISO3166_1_Alpha_3' => 'CUB', 'M49' => '192', 'ITU' => 'CUB', 'MARC' => 'cu', 'WMO' => 'CU', 'DS' => 'C', 'Dial' => '53', 'FIFA' => 'CUB', 'FIPS' => 'CU', 'GAUL' => '63', 'IOC' => 'CUB', 'ISO4217_Currency_Alphabetic_Code' => 'CUP', 'ISO4217_Currency_Country_Name' => 'CUBA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Cuban Peso', 'ISO4217_Currency_Numeric_Code' => '192', 'Is_Independent' => 'Yes', 'Capital' => 'Havana', 'Continent' => 'NA', 'TLD' => '.cu', 'Languages' => 'es-CU', 'Geo_Name_ID' => '3562981', 'EDGAR' => 'G3', '' => '', 'currency_symbol' => 'CUP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '56'),
            58 => array('Country_Name' => 'Curaçao', 'Official_Name_English' => 'Curaçao', 'ISO3166_1_Alpha_2' => 'CW', 'ISO3166_1_Alpha_3' => 'CUW', 'M49' => '531', 'ITU' => '', 'MARC' => 'co', 'WMO' => '', 'DS' => '', 'Dial' => '599', 'FIFA' => '', 'FIPS' => 'UC', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'ANG', 'ISO4217_Currency_Country_Name' => 'CURAÇAO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Netherlands Antillean Guilder', 'ISO4217_Currency_Numeric_Code' => '532', 'Is_Independent' => 'Part of NL', 'Capital' => 'Willemstad', 'Continent' => 'NA', 'TLD' => '.cw', 'Languages' => 'nl,pap', 'Geo_Name_ID' => '7626836', 'EDGAR' => '', '' => '', 'currency_symbol' => 'ANG', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '57'),
            59 => array('Country_Name' => 'Cyprus', 'Official_Name_English' => 'Cyprus', 'ISO3166_1_Alpha_2' => 'CY', 'ISO3166_1_Alpha_3' => 'CYP', 'M49' => '196', 'ITU' => 'CYP', 'MARC' => 'cy', 'WMO' => 'CY', 'DS' => 'CY', 'Dial' => '357', 'FIFA' => 'CYP', 'FIPS' => 'CY', 'GAUL' => '64', 'IOC' => 'CYP', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'CYPRUS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Nicosia', 'Continent' => 'EU', 'TLD' => '.cy', 'Languages' => 'el-CY,tr-CY,en', 'Geo_Name_ID' => '146669', 'EDGAR' => 'G4', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '58'),
            60 => array('Country_Name' => 'Czech Republic', 'Official_Name_English' => 'Czechia', 'ISO3166_1_Alpha_2' => 'CZ', 'ISO3166_1_Alpha_3' => 'CZE', 'M49' => '203', 'ITU' => 'CZE', 'MARC' => 'xr', 'WMO' => 'CZ', 'DS' => 'CZ', 'Dial' => '420', 'FIFA' => 'CZE', 'FIPS' => 'EZ', 'GAUL' => '65', 'IOC' => 'CZE', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Yes', 'Capital' => 'Prague', 'Continent' => 'EU', 'TLD' => '.cz', 'Languages' => 'cs,sk', 'Geo_Name_ID' => '3077311', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '59'),
            61 => array('Country_Name' => 'Côte d\'Ivoire', 'Official_Name_English' => 'Côte d\'Ivoire', 'ISO3166_1_Alpha_2' => 'CI', 'ISO3166_1_Alpha_3' => 'CIV', 'M49' => '384', 'ITU' => 'CTI', 'MARC' => 'iv', 'WMO' => 'IV', 'DS' => 'CI', 'Dial' => '225', 'FIFA' => 'CIV', 'FIPS' => 'IV', 'GAUL' => '66', 'IOC' => 'CIV', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'CÔTE D\'IVOIRE', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Yamoussoukro', 'Continent' => 'AF', 'TLD' => '.ci', 'Languages' => 'fr-CI', 'Geo_Name_ID' => '2287781', 'EDGAR' => '', '' => '', 'currency_symbol' => 'XOF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '60'),
            62 => array('Country_Name' => 'Denmark', 'Official_Name_English' => 'Denmark', 'ISO3166_1_Alpha_2' => 'DK', 'ISO3166_1_Alpha_3' => 'DNK', 'M49' => '208', 'ITU' => 'DNK', 'MARC' => 'dk', 'WMO' => 'DN', 'DS' => 'DK', 'Dial' => '45', 'FIFA' => 'DEN', 'FIPS' => 'DA', 'GAUL' => '69', 'IOC' => 'DEN', 'ISO4217_Currency_Alphabetic_Code' => 'DKK', 'ISO4217_Currency_Country_Name' => 'DENMARK', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Danish Krone', 'ISO4217_Currency_Numeric_Code' => '208', 'Is_Independent' => 'Yes', 'Capital' => 'Copenhagen', 'Continent' => 'EU', 'TLD' => '.dk', 'Languages' => 'da-DK,en,fo,de-DK', 'Geo_Name_ID' => '2623032', 'EDGAR' => 'G7', '' => '', 'currency_symbol' => 'DKK', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '61'),
            63 => array('Country_Name' => 'Djibouti', 'Official_Name_English' => 'Djibouti', 'ISO3166_1_Alpha_2' => 'DJ', 'ISO3166_1_Alpha_3' => 'DJI', 'M49' => '262', 'ITU' => 'DJI', 'MARC' => 'ft', 'WMO' => 'DJ', 'DS' => 'F', 'Dial' => '253', 'FIFA' => 'DJI', 'FIPS' => 'DJ', 'GAUL' => '70', 'IOC' => 'DJI', 'ISO4217_Currency_Alphabetic_Code' => 'DJF', 'ISO4217_Currency_Country_Name' => 'DJIBOUTI', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Djibouti Franc', 'ISO4217_Currency_Numeric_Code' => '262', 'Is_Independent' => 'Yes', 'Capital' => 'Djibouti', 'Continent' => 'AF', 'TLD' => '.dj', 'Languages' => 'fr-DJ,ar,so-DJ,aa', 'Geo_Name_ID' => '223816', 'EDGAR' => '1G', '' => '', 'currency_symbol' => 'DJF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '62'),
            64 => array('Country_Name' => 'Dominica', 'Official_Name_English' => 'Dominica', 'ISO3166_1_Alpha_2' => 'DM', 'ISO3166_1_Alpha_3' => 'DMA', 'M49' => '212', 'ITU' => 'DMA', 'MARC' => 'dq', 'WMO' => 'DO', 'DS' => 'WD', 'Dial' => '767', 'FIFA' => 'DMA', 'FIPS' => 'DO', 'GAUL' => '71', 'IOC' => 'DMA', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'DOMINICA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Yes', 'Capital' => 'Roseau', 'Continent' => 'NA', 'TLD' => '.dm', 'Languages' => 'en-DM', 'Geo_Name_ID' => '3575830', 'EDGAR' => 'G9', '' => '', 'currency_symbol' => 'XCD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '63'),
            65 => array('Country_Name' => 'Dominican Republic', 'Official_Name_English' => 'Dominican Republic', 'ISO3166_1_Alpha_2' => 'DO', 'ISO3166_1_Alpha_3' => 'DOM', 'M49' => '214', 'ITU' => 'DOM', 'MARC' => 'dr', 'WMO' => 'DR', 'DS' => 'DOM', 'Dial' => '809', 'FIFA' => 'DOM', 'FIPS' => 'DR', 'GAUL' => '72', 'IOC' => 'DOM', 'ISO4217_Currency_Alphabetic_Code' => 'DOP', 'ISO4217_Currency_Country_Name' => 'DOMINICAN REPUBLIC', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Dominican Peso', 'ISO4217_Currency_Numeric_Code' => '214', 'Is_Independent' => 'Yes', 'Capital' => 'Santo Domingo', 'Continent' => 'NA', 'TLD' => '.do', 'Languages' => 'es-DO', 'Geo_Name_ID' => '3508796', 'EDGAR' => 'G8', '' => '', 'currency_symbol' => 'DOP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '64'),
            66 => array('Country_Name' => 'Ecuador', 'Official_Name_English' => 'Ecuador', 'ISO3166_1_Alpha_2' => 'EC', 'ISO3166_1_Alpha_3' => 'ECU', 'M49' => '218', 'ITU' => 'EQA', 'MARC' => 'ec', 'WMO' => 'EQ', 'DS' => 'EC', 'Dial' => '593', 'FIFA' => 'ECU', 'FIPS' => 'EC', 'GAUL' => '73', 'IOC' => 'ECU', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'ECUADOR', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Quito', 'Continent' => 'SA', 'TLD' => '.ec', 'Languages' => 'es-EC', 'Geo_Name_ID' => '3658394', 'EDGAR' => 'H1', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '65'),
            67 => array('Country_Name' => 'Egypt', 'Official_Name_English' => 'Egypt', 'ISO3166_1_Alpha_2' => 'EG', 'ISO3166_1_Alpha_3' => 'EGY', 'M49' => '818', 'ITU' => 'EGY', 'MARC' => 'ua', 'WMO' => 'EG', 'DS' => 'ET', 'Dial' => '20', 'FIFA' => 'EGY', 'FIPS' => 'EG', 'GAUL' => '40765', 'IOC' => 'EGY', 'ISO4217_Currency_Alphabetic_Code' => 'EGP', 'ISO4217_Currency_Country_Name' => 'EGYPT', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Egyptian Pound', 'ISO4217_Currency_Numeric_Code' => '818', 'Is_Independent' => 'Yes', 'Capital' => 'Cairo', 'Continent' => 'AF', 'TLD' => '.eg', 'Languages' => 'ar-EG,en,fr', 'Geo_Name_ID' => '357994', 'EDGAR' => 'H2', '' => '', 'currency_symbol' => 'EGP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '66'),
            68 => array('Country_Name' => 'El Salvador', 'Official_Name_English' => 'El Salvador', 'ISO3166_1_Alpha_2' => 'SV', 'ISO3166_1_Alpha_3' => 'SLV', 'M49' => '222', 'ITU' => 'SLV', 'MARC' => 'es', 'WMO' => 'ES', 'DS' => 'ES', 'Dial' => '503', 'FIFA' => 'SLV', 'FIPS' => 'ES', 'GAUL' => '75', 'IOC' => 'ESA', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'EL SALVADOR', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'San Salvador', 'Continent' => 'NA', 'TLD' => '.sv', 'Languages' => 'es-SV', 'Geo_Name_ID' => '3585968', 'EDGAR' => 'H3', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '67'),
            69 => array('Country_Name' => 'Equatorial Guinea', 'Official_Name_English' => 'Equatorial Guinea', 'ISO3166_1_Alpha_2' => 'GQ', 'ISO3166_1_Alpha_3' => 'GNQ', 'M49' => '226', 'ITU' => 'GNE', 'MARC' => 'eg', 'WMO' => 'GQ', 'DS' => 'EQ', 'Dial' => '240', 'FIFA' => 'EQG', 'FIPS' => 'EK', 'GAUL' => '76', 'IOC' => 'GEQ', 'ISO4217_Currency_Alphabetic_Code' => 'XAF', 'ISO4217_Currency_Country_Name' => 'EQUATORIAL GUINEA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BEAC', 'ISO4217_Currency_Numeric_Code' => '950', 'Is_Independent' => 'Yes', 'Capital' => 'Malabo', 'Continent' => 'AF', 'TLD' => '.gq', 'Languages' => 'es-GQ,fr', 'Geo_Name_ID' => '2309096', 'EDGAR' => 'H4', '' => '', 'currency_symbol' => 'XAF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '68'),
            70 => array('Country_Name' => 'Eritrea', 'Official_Name_English' => 'Eritrea', 'ISO3166_1_Alpha_2' => 'ER', 'ISO3166_1_Alpha_3' => 'ERI', 'M49' => '232', 'ITU' => 'ERI', 'MARC' => 'ea', 'WMO' => '', 'DS' => 'ER', 'Dial' => '291', 'FIFA' => 'ERI', 'FIPS' => 'ER', 'GAUL' => '77', 'IOC' => 'ERI', 'ISO4217_Currency_Alphabetic_Code' => 'ERN', 'ISO4217_Currency_Country_Name' => 'ERITREA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Nakfa', 'ISO4217_Currency_Numeric_Code' => '232', 'Is_Independent' => 'Yes', 'Capital' => 'Asmara', 'Continent' => 'AF', 'TLD' => '.er', 'Languages' => 'aa-ER,ar,tig,kun,ti-ER', 'Geo_Name_ID' => '338010', 'EDGAR' => '1J', '' => '', 'currency_symbol' => 'ERN', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '69'),
            71 => array('Country_Name' => 'Estonia', 'Official_Name_English' => 'Estonia', 'ISO3166_1_Alpha_2' => 'EE', 'ISO3166_1_Alpha_3' => 'EST', 'M49' => '233', 'ITU' => 'EST', 'MARC' => 'er', 'WMO' => 'EO', 'DS' => 'EST', 'Dial' => '372', 'FIFA' => 'EST', 'FIPS' => 'EN', 'GAUL' => '78', 'IOC' => 'EST', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'ESTONIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Tallinn', 'Continent' => 'EU', 'TLD' => '.ee', 'Languages' => 'et,ru', 'Geo_Name_ID' => '453733', 'EDGAR' => '1H', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '70'),
            72 => array('Country_Name' => 'Ethiopia', 'Official_Name_English' => 'Ethiopia', 'ISO3166_1_Alpha_2' => 'ET', 'ISO3166_1_Alpha_3' => 'ETH', 'M49' => '231', 'ITU' => 'ETH', 'MARC' => 'et', 'WMO' => 'ET', 'DS' => 'ETH', 'Dial' => '251', 'FIFA' => 'ETH', 'FIPS' => 'ET', 'GAUL' => '79', 'IOC' => 'ETH', 'ISO4217_Currency_Alphabetic_Code' => 'ETB', 'ISO4217_Currency_Country_Name' => 'ETHIOPIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Ethiopian Birr', 'ISO4217_Currency_Numeric_Code' => '230', 'Is_Independent' => 'Yes', 'Capital' => 'Addis Ababa', 'Continent' => 'AF', 'TLD' => '.et', 'Languages' => 'am,en-ET,om-ET,ti-ET,so-ET,sid', 'Geo_Name_ID' => '337996', 'EDGAR' => 'H5', '' => '', 'currency_symbol' => 'ETB', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '71'),
            73 => array('Country_Name' => 'Falkland Islands', 'Official_Name_English' => 'Falkland Islands (Malvinas)', 'ISO3166_1_Alpha_2' => 'FK', 'ISO3166_1_Alpha_3' => 'FLK', 'M49' => '238', 'ITU' => 'FLK', 'MARC' => 'fk', 'WMO' => 'FK', 'DS' => '', 'Dial' => '500', 'FIFA' => 'FLK', 'FIPS' => 'FK', 'GAUL' => '81', 'IOC' => 'FLK', 'ISO4217_Currency_Alphabetic_Code' => 'FKP', 'ISO4217_Currency_Country_Name' => 'FALKLAND ISLANDS (MALVINAS)', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Falkland Islands Pound', 'ISO4217_Currency_Numeric_Code' => '238', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Stanley', 'Continent' => 'SA', 'TLD' => '.fk', 'Languages' => 'en-FK', 'Geo_Name_ID' => '3474414', 'EDGAR' => 'H7', '' => '', 'currency_symbol' => 'FKP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '72'),
            74 => array('Country_Name' => 'Faroe Islands', 'Official_Name_English' => 'Faeroe Islands', 'ISO3166_1_Alpha_2' => 'FO', 'ISO3166_1_Alpha_3' => 'FRO', 'M49' => '234', 'ITU' => 'FRO', 'MARC' => 'fa', 'WMO' => 'FA', 'DS' => 'FO', 'Dial' => '298', 'FIFA' => 'FRO', 'FIPS' => 'FO', 'GAUL' => '82', 'IOC' => 'FAR', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Part of DK', 'Capital' => 'Torshavn', 'Continent' => 'EU', 'TLD' => '.fo', 'Languages' => 'fo,da-FO', 'Geo_Name_ID' => '2622320', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '73'),
            75 => array('Country_Name' => 'Fiji', 'Official_Name_English' => 'Fiji', 'ISO3166_1_Alpha_2' => 'FJ', 'ISO3166_1_Alpha_3' => 'FJI', 'M49' => '242', 'ITU' => 'FJI', 'MARC' => 'fj', 'WMO' => 'FJ', 'DS' => 'FJI', 'Dial' => '679', 'FIFA' => 'FIJ', 'FIPS' => 'FJ', 'GAUL' => '83', 'IOC' => 'FIJ', 'ISO4217_Currency_Alphabetic_Code' => 'FJD', 'ISO4217_Currency_Country_Name' => 'FIJI', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Fiji Dollar', 'ISO4217_Currency_Numeric_Code' => '242', 'Is_Independent' => 'Yes', 'Capital' => 'Suva', 'Continent' => 'OC', 'TLD' => '.fj', 'Languages' => 'en-FJ,fj', 'Geo_Name_ID' => '2205218', 'EDGAR' => 'H8', '' => '', 'currency_symbol' => 'FJD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '74'),
            76 => array('Country_Name' => 'Finland', 'Official_Name_English' => 'Finland', 'ISO3166_1_Alpha_2' => 'FI', 'ISO3166_1_Alpha_3' => 'FIN', 'M49' => '246', 'ITU' => 'FIN', 'MARC' => 'fi', 'WMO' => 'FI', 'DS' => 'FIN', 'Dial' => '358', 'FIFA' => 'FIN', 'FIPS' => 'FI', 'GAUL' => '84', 'IOC' => 'FIN', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'FINLAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Helsinki', 'Continent' => 'EU', 'TLD' => '.fi', 'Languages' => 'fi-FI,sv-FI,smn', 'Geo_Name_ID' => '660013', 'EDGAR' => 'H9', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '75'),
            77 => array('Country_Name' => 'France', 'Official_Name_English' => 'France', 'ISO3166_1_Alpha_2' => 'FR', 'ISO3166_1_Alpha_3' => 'FRA', 'M49' => '250', 'ITU' => 'F', 'MARC' => 'fr', 'WMO' => 'FR', 'DS' => 'F', 'Dial' => '33', 'FIFA' => 'FRA', 'FIPS' => 'FR', 'GAUL' => '85', 'IOC' => 'FRA', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'FRANCE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Paris', 'Continent' => 'EU', 'TLD' => '.fr', 'Languages' => 'fr-FR,frp,br,co,ca,eu,oc', 'Geo_Name_ID' => '3017382', 'EDGAR' => 'I0', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '76'),
            78 => array('Country_Name' => 'French Guiana', 'Official_Name_English' => 'French Guiana', 'ISO3166_1_Alpha_2' => 'GF', 'ISO3166_1_Alpha_3' => 'GUF', 'M49' => '254', 'ITU' => 'GUF', 'MARC' => 'fg', 'WMO' => 'FG', 'DS' => 'F', 'Dial' => '594', 'FIFA' => 'GUF', 'FIPS' => 'FG', 'GAUL' => '86', 'IOC' => 'FGU', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'FRENCH GUIANA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Cayenne', 'Continent' => 'SA', 'TLD' => '.gf', 'Languages' => 'fr-GF', 'Geo_Name_ID' => '3381670', 'EDGAR' => 'I3', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '77'),
            79 => array('Country_Name' => 'French Polynesia', 'Official_Name_English' => 'French Polynesia', 'ISO3166_1_Alpha_2' => 'PF', 'ISO3166_1_Alpha_3' => 'PYF', 'M49' => '258', 'ITU' => 'OCE', 'MARC' => 'fp', 'WMO' => 'PF', 'DS' => 'F', 'Dial' => '689', 'FIFA' => 'TAH', 'FIPS' => 'FP', 'GAUL' => '87', 'IOC' => 'FPO', 'ISO4217_Currency_Alphabetic_Code' => 'XPF', 'ISO4217_Currency_Country_Name' => 'FRENCH POLYNESIA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFP Franc', 'ISO4217_Currency_Numeric_Code' => '953', 'Is_Independent' => 'Territory of FR', 'Capital' => 'Papeete', 'Continent' => 'OC', 'TLD' => '.pf', 'Languages' => 'fr-PF,ty', 'Geo_Name_ID' => '4030656', 'EDGAR' => 'I4', '' => '', 'currency_symbol' => 'XPF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '78'),
            80 => array('Country_Name' => 'French Southern Territories', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'TF', 'ISO3166_1_Alpha_3' => 'ATF', 'M49' => '260', 'ITU' => '', 'MARC' => 'fs', 'WMO' => '', 'DS' => 'F', 'Dial' => '262', 'FIFA' => '', 'FIPS' => 'FS', 'GAUL' => '88', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of FR', 'Capital' => 'Port-aux-Francais', 'Continent' => 'AN', 'TLD' => '.tf', 'Languages' => 'fr', 'Geo_Name_ID' => '1546748', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '79'),
            81 => array('Country_Name' => 'Gabon', 'Official_Name_English' => 'Gabon', 'ISO3166_1_Alpha_2' => 'GA', 'ISO3166_1_Alpha_3' => 'GAB', 'M49' => '266', 'ITU' => 'GAB', 'MARC' => 'go', 'WMO' => 'GO', 'DS' => 'G', 'Dial' => '241', 'FIFA' => 'GAB', 'FIPS' => 'GB', 'GAUL' => '89', 'IOC' => 'GAB', 'ISO4217_Currency_Alphabetic_Code' => 'XAF', 'ISO4217_Currency_Country_Name' => 'GABON', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BEAC', 'ISO4217_Currency_Numeric_Code' => '950', 'Is_Independent' => 'Yes', 'Capital' => 'Libreville', 'Continent' => 'AF', 'TLD' => '.ga', 'Languages' => 'fr-GA', 'Geo_Name_ID' => '2400553', 'EDGAR' => 'I5', '' => '', 'currency_symbol' => 'XAF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '80'),
            82 => array('Country_Name' => 'Gambia', 'Official_Name_English' => 'Gambia', 'ISO3166_1_Alpha_2' => 'GM', 'ISO3166_1_Alpha_3' => 'GMB', 'M49' => '270', 'ITU' => 'GMB', 'MARC' => 'gm', 'WMO' => 'GB', 'DS' => 'WAG', 'Dial' => '220', 'FIFA' => 'GAM', 'FIPS' => 'GA', 'GAUL' => '90', 'IOC' => 'GAM', 'ISO4217_Currency_Alphabetic_Code' => 'GMD', 'ISO4217_Currency_Country_Name' => 'GAMBIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Dalasi', 'ISO4217_Currency_Numeric_Code' => '270', 'Is_Independent' => 'Yes', 'Capital' => 'Banjul', 'Continent' => 'AF', 'TLD' => '.gm', 'Languages' => 'en-GM,mnk,wof,wo,ff', 'Geo_Name_ID' => '2413451', 'EDGAR' => 'I6', '' => '', 'currency_symbol' => 'GMD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '81'),
            83 => array('Country_Name' => 'Georgia', 'Official_Name_English' => 'Georgia', 'ISO3166_1_Alpha_2' => 'GE', 'ISO3166_1_Alpha_3' => 'GEO', 'M49' => '268', 'ITU' => 'GEO', 'MARC' => 'gs', 'WMO' => 'GG', 'DS' => 'GE', 'Dial' => '995', 'FIFA' => 'GEO', 'FIPS' => 'GG', 'GAUL' => '92', 'IOC' => 'GEO', 'ISO4217_Currency_Alphabetic_Code' => 'GEL', 'ISO4217_Currency_Country_Name' => 'GEORGIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Lari', 'ISO4217_Currency_Numeric_Code' => '981', 'Is_Independent' => 'Yes', 'Capital' => 'Tbilisi', 'Continent' => 'AS', 'TLD' => '.ge', 'Languages' => 'ka,ru,hy,az', 'Geo_Name_ID' => '614540', 'EDGAR' => '2Q', '' => '', 'currency_symbol' => 'GEL', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '82'),
            84 => array('Country_Name' => 'Germany', 'Official_Name_English' => 'Germany', 'ISO3166_1_Alpha_2' => 'DE', 'ISO3166_1_Alpha_3' => 'DEU', 'M49' => '276', 'ITU' => 'D', 'MARC' => 'gw', 'WMO' => 'DL', 'DS' => 'D', 'Dial' => '49', 'FIFA' => 'GER', 'FIPS' => 'GM', 'GAUL' => '93', 'IOC' => 'GER', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'GERMANY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Berlin', 'Continent' => 'EU', 'TLD' => '.de', 'Languages' => 'de', 'Geo_Name_ID' => '2921044', 'EDGAR' => '2M', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '83'),
            85 => array('Country_Name' => 'Ghana', 'Official_Name_English' => 'Ghana', 'ISO3166_1_Alpha_2' => 'GH', 'ISO3166_1_Alpha_3' => 'GHA', 'M49' => '288', 'ITU' => 'GHA', 'MARC' => 'gh', 'WMO' => 'GH', 'DS' => 'GH', 'Dial' => '233', 'FIFA' => 'GHA', 'FIPS' => 'GH', 'GAUL' => '94', 'IOC' => 'GHA', 'ISO4217_Currency_Alphabetic_Code' => 'GHS', 'ISO4217_Currency_Country_Name' => 'GHANA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Ghana Cedi', 'ISO4217_Currency_Numeric_Code' => '936', 'Is_Independent' => 'Yes', 'Capital' => 'Accra', 'Continent' => 'AF', 'TLD' => '.gh', 'Languages' => 'en-GH,ak,ee,tw', 'Geo_Name_ID' => '2300660', 'EDGAR' => 'J0', '' => '', 'currency_symbol' => 'GHS', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '84'),
            86 => array('Country_Name' => 'Gibraltar', 'Official_Name_English' => 'Gibraltar', 'ISO3166_1_Alpha_2' => 'GI', 'ISO3166_1_Alpha_3' => 'GIB', 'M49' => '292', 'ITU' => 'GIB', 'MARC' => 'gi', 'WMO' => 'GI', 'DS' => 'GBZ', 'Dial' => '350', 'FIFA' => 'GBZ', 'FIPS' => 'GI', 'GAUL' => '95', 'IOC' => 'GIB', 'ISO4217_Currency_Alphabetic_Code' => 'GIP', 'ISO4217_Currency_Country_Name' => 'GIBRALTAR', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Gibraltar Pound', 'ISO4217_Currency_Numeric_Code' => '292', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Gibraltar', 'Continent' => 'EU', 'TLD' => '.gi', 'Languages' => 'en-GI,es,it,pt', 'Geo_Name_ID' => '2411586', 'EDGAR' => 'J1', '' => '', 'currency_symbol' => 'GIP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '85'),
            87 => array('Country_Name' => 'Greece', 'Official_Name_English' => 'Greece', 'ISO3166_1_Alpha_2' => 'GR', 'ISO3166_1_Alpha_3' => 'GRC', 'M49' => '300', 'ITU' => 'GRC', 'MARC' => 'gr', 'WMO' => 'GR', 'DS' => 'GR', 'Dial' => '30', 'FIFA' => 'GRE', 'FIPS' => 'GR', 'GAUL' => '97', 'IOC' => 'GRE', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'GREECE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Athens', 'Continent' => 'EU', 'TLD' => '.gr', 'Languages' => 'el-GR,en,fr', 'Geo_Name_ID' => '390903', 'EDGAR' => 'J3', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '86'),
            88 => array('Country_Name' => 'Greenland', 'Official_Name_English' => 'Greenland', 'ISO3166_1_Alpha_2' => 'GL', 'ISO3166_1_Alpha_3' => 'GRL', 'M49' => '304', 'ITU' => 'GRL', 'MARC' => 'gl', 'WMO' => 'GL', 'DS' => 'DK', 'Dial' => '299', 'FIFA' => 'GRL', 'FIPS' => 'GL', 'GAUL' => '98', 'IOC' => 'GRL', 'ISO4217_Currency_Alphabetic_Code' => 'DKK', 'ISO4217_Currency_Country_Name' => 'GREENLAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Danish Krone', 'ISO4217_Currency_Numeric_Code' => '208', 'Is_Independent' => 'Part of DK', 'Capital' => 'Nuuk', 'Continent' => 'NA', 'TLD' => '.gl', 'Languages' => 'kl,da-GL,en', 'Geo_Name_ID' => '3425505', 'EDGAR' => 'J4', '' => '', 'currency_symbol' => 'DKK', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '87'),
            89 => array('Country_Name' => 'Grenada', 'Official_Name_English' => 'Grenada', 'ISO3166_1_Alpha_2' => 'GD', 'ISO3166_1_Alpha_3' => 'GRD', 'M49' => '308', 'ITU' => 'GRD', 'MARC' => 'gd', 'WMO' => 'GD', 'DS' => 'WG', 'Dial' => '473', 'FIFA' => 'GRN', 'FIPS' => 'GJ', 'GAUL' => '99', 'IOC' => 'GRN', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'GRENADA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Yes', 'Capital' => 'St. George\'s', 'Continent' => 'NA', 'TLD' => '.gd', 'Languages' => 'en-GD', 'Geo_Name_ID' => '3580239', 'EDGAR' => 'J5', '' => '', 'currency_symbol' => 'XCD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '88'),
            90 => array('Country_Name' => 'Guadeloupe', 'Official_Name_English' => 'Guadeloupe', 'ISO3166_1_Alpha_2' => 'GP', 'ISO3166_1_Alpha_3' => 'GLP', 'M49' => '312', 'ITU' => 'GDL', 'MARC' => 'gp', 'WMO' => 'MF', 'DS' => 'F', 'Dial' => '590', 'FIFA' => 'GLP', 'FIPS' => 'GP', 'GAUL' => '100', 'IOC' => 'GUD', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'GUADELOUPE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Basse-Terre', 'Continent' => 'NA', 'TLD' => '.gp', 'Languages' => 'fr-GP', 'Geo_Name_ID' => '3579143', 'EDGAR' => 'J6', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '89'),
            91 => array('Country_Name' => 'Guam', 'Official_Name_English' => 'Guam', 'ISO3166_1_Alpha_2' => 'GU', 'ISO3166_1_Alpha_3' => 'GUM', 'M49' => '316', 'ITU' => 'GUM', 'MARC' => 'gu', 'WMO' => 'GM', 'DS' => 'USA', 'Dial' => '671', 'FIFA' => 'GUM', 'FIPS' => 'GQ', 'GAUL' => '101', 'IOC' => 'GUM', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'GUAM', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Territory of US', 'Capital' => 'Hagatna', 'Continent' => 'OC', 'TLD' => '.gu', 'Languages' => 'en-GU,ch-GU', 'Geo_Name_ID' => '4043988', 'EDGAR' => 'GU', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '90'),
            92 => array('Country_Name' => 'Guatemala', 'Official_Name_English' => 'Guatemala', 'ISO3166_1_Alpha_2' => 'GT', 'ISO3166_1_Alpha_3' => 'GTM', 'M49' => '320', 'ITU' => 'GTM', 'MARC' => 'gt', 'WMO' => 'GU', 'DS' => 'GCA', 'Dial' => '502', 'FIFA' => 'GUA', 'FIPS' => 'GT', 'GAUL' => '103', 'IOC' => 'GUA', 'ISO4217_Currency_Alphabetic_Code' => 'GTQ', 'ISO4217_Currency_Country_Name' => 'GUATEMALA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Quetzal', 'ISO4217_Currency_Numeric_Code' => '320', 'Is_Independent' => 'Yes', 'Capital' => 'Guatemala City', 'Continent' => 'NA', 'TLD' => '.gt', 'Languages' => 'es-GT', 'Geo_Name_ID' => '3595528', 'EDGAR' => 'J8', '' => '', 'currency_symbol' => 'GTQ', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '91'),
            93 => array('Country_Name' => 'Guernsey', 'Official_Name_English' => 'Guernsey', 'ISO3166_1_Alpha_2' => 'GG', 'ISO3166_1_Alpha_3' => 'GGY', 'M49' => '831', 'ITU' => '', 'MARC' => 'uik', 'WMO' => '', 'DS' => 'GBG', 'Dial' => '44', 'FIFA' => 'GBG', 'FIPS' => 'GK', 'GAUL' => '104', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'GBP', 'ISO4217_Currency_Country_Name' => 'GUERNSEY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pound Sterling', 'ISO4217_Currency_Numeric_Code' => '826', 'Is_Independent' => 'Crown dependency of GB', 'Capital' => 'St Peter Port', 'Continent' => 'EU', 'TLD' => '.gg', 'Languages' => 'en,fr', 'Geo_Name_ID' => '3042362', 'EDGAR' => 'Y7', '' => '', 'currency_symbol' => 'GBP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '92'),
            94 => array('Country_Name' => 'Guinea', 'Official_Name_English' => 'Guinea', 'ISO3166_1_Alpha_2' => 'GN', 'ISO3166_1_Alpha_3' => 'GIN', 'M49' => '324', 'ITU' => 'GUI', 'MARC' => 'gv', 'WMO' => 'GN', 'DS' => 'RG', 'Dial' => '224', 'FIFA' => 'GUI', 'FIPS' => 'GV', 'GAUL' => '106', 'IOC' => 'GUI', 'ISO4217_Currency_Alphabetic_Code' => 'GNF', 'ISO4217_Currency_Country_Name' => 'GUINEA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Guinea Franc', 'ISO4217_Currency_Numeric_Code' => '324', 'Is_Independent' => 'Yes', 'Capital' => 'Conakry', 'Continent' => 'AF', 'TLD' => '.gn', 'Languages' => 'fr-GN', 'Geo_Name_ID' => '2420477', 'EDGAR' => 'J9', '' => '', 'currency_symbol' => 'GNF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '93'),
            95 => array('Country_Name' => 'Guinea-Bissau', 'Official_Name_English' => 'Guinea-Bissau', 'ISO3166_1_Alpha_2' => 'GW', 'ISO3166_1_Alpha_3' => 'GNB', 'M49' => '624', 'ITU' => 'GNB', 'MARC' => 'pg', 'WMO' => 'GW', 'DS' => 'GW', 'Dial' => '245', 'FIFA' => 'GNB', 'FIPS' => 'PU', 'GAUL' => '105', 'IOC' => 'GBS', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'GUINEA-BISSAU', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Bissau', 'Continent' => 'AF', 'TLD' => '.gw', 'Languages' => 'pt-GW,pov', 'Geo_Name_ID' => '2372248', 'EDGAR' => 'S0', '' => '', 'currency_symbol' => 'XOF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '94'),
            96 => array('Country_Name' => 'Guyana', 'Official_Name_English' => 'Guyana', 'ISO3166_1_Alpha_2' => 'GY', 'ISO3166_1_Alpha_3' => 'GUY', 'M49' => '328', 'ITU' => 'GUY', 'MARC' => 'gy', 'WMO' => 'GY', 'DS' => 'GUY', 'Dial' => '592', 'FIFA' => 'GUY', 'FIPS' => 'GY', 'GAUL' => '107', 'IOC' => 'GUY', 'ISO4217_Currency_Alphabetic_Code' => 'GYD', 'ISO4217_Currency_Country_Name' => 'GUYANA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Guyana Dollar', 'ISO4217_Currency_Numeric_Code' => '328', 'Is_Independent' => 'Yes', 'Capital' => 'Georgetown', 'Continent' => 'SA', 'TLD' => '.gy', 'Languages' => 'en-GY', 'Geo_Name_ID' => '3378535', 'EDGAR' => 'K0', '' => '', 'currency_symbol' => 'GYD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '95'),
            97 => array('Country_Name' => 'Haiti', 'Official_Name_English' => 'Haiti', 'ISO3166_1_Alpha_2' => 'HT', 'ISO3166_1_Alpha_3' => 'HTI', 'M49' => '332', 'ITU' => 'HTI', 'MARC' => 'ht', 'WMO' => 'HA', 'DS' => 'RH', 'Dial' => '509', 'FIFA' => 'HAI', 'FIPS' => 'HA', 'GAUL' => '108', 'IOC' => 'HAI', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'HAITI', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Port-au-Prince', 'Continent' => 'NA', 'TLD' => '.ht', 'Languages' => 'ht,fr-HT', 'Geo_Name_ID' => '3723988', 'EDGAR' => 'K1', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '96'),
            98 => array('Country_Name' => 'Heard & McDonald Islands', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'HM', 'ISO3166_1_Alpha_3' => 'HMD', 'M49' => '334', 'ITU' => '', 'MARC' => 'hm', 'WMO' => '', 'DS' => 'AUS', 'Dial' => '672', 'FIFA' => '', 'FIPS' => 'HM', 'GAUL' => '109', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of AU', 'Capital' => '', 'Continent' => 'AN', 'TLD' => '.hm', 'Languages' => '', 'Geo_Name_ID' => '1547314', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '97'),
            99 => array('Country_Name' => 'Honduras', 'Official_Name_English' => 'Honduras', 'ISO3166_1_Alpha_2' => 'HN', 'ISO3166_1_Alpha_3' => 'HND', 'M49' => '340', 'ITU' => 'HND', 'MARC' => 'ho', 'WMO' => 'HO', 'DS' => '', 'Dial' => '504', 'FIFA' => 'HON', 'FIPS' => 'HO', 'GAUL' => '111', 'IOC' => 'HON', 'ISO4217_Currency_Alphabetic_Code' => 'HNL', 'ISO4217_Currency_Country_Name' => 'HONDURAS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Lempira', 'ISO4217_Currency_Numeric_Code' => '340', 'Is_Independent' => 'Yes', 'Capital' => 'Tegucigalpa', 'Continent' => 'NA', 'TLD' => '.hn', 'Languages' => 'es-HN', 'Geo_Name_ID' => '3608932', 'EDGAR' => 'K2', '' => '', 'currency_symbol' => 'HNL', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '98'),
            100 => array('Country_Name' => 'Hong Kong', 'Official_Name_English' => 'China, Hong Kong Special Administrative Region', 'ISO3166_1_Alpha_2' => 'HK', 'ISO3166_1_Alpha_3' => 'HKG', 'M49' => '344', 'ITU' => 'HKG', 'MARC' => '', 'WMO' => 'HK', 'DS' => 'HK', 'Dial' => '852', 'FIFA' => 'HKG', 'FIPS' => 'HK', 'GAUL' => '33364', 'IOC' => 'HKG', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Part of CN', 'Capital' => 'Hong Kong', 'Continent' => 'AS', 'TLD' => '.hk', 'Languages' => 'zh-HK,yue,zh,en', 'Geo_Name_ID' => '1819730', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '99'),
            101 => array('Country_Name' => 'Hungary', 'Official_Name_English' => 'Hungary', 'ISO3166_1_Alpha_2' => 'HU', 'ISO3166_1_Alpha_3' => 'HUN', 'M49' => '348', 'ITU' => 'HNG', 'MARC' => 'hu', 'WMO' => 'HU', 'DS' => 'H', 'Dial' => '36', 'FIFA' => 'HUN', 'FIPS' => 'HU', 'GAUL' => '113', 'IOC' => 'HUN', 'ISO4217_Currency_Alphabetic_Code' => 'HUF', 'ISO4217_Currency_Country_Name' => 'HUNGARY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Forint', 'ISO4217_Currency_Numeric_Code' => '348', 'Is_Independent' => 'Yes', 'Capital' => 'Budapest', 'Continent' => 'EU', 'TLD' => '.hu', 'Languages' => 'hu-HU', 'Geo_Name_ID' => '719819', 'EDGAR' => 'K5', '' => '', 'currency_symbol' => 'HUF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '100'),
            102 => array('Country_Name' => 'Iceland', 'Official_Name_English' => 'Iceland', 'ISO3166_1_Alpha_2' => 'IS', 'ISO3166_1_Alpha_3' => 'ISL', 'M49' => '352', 'ITU' => 'ISL', 'MARC' => 'ic', 'WMO' => 'IL', 'DS' => 'IS', 'Dial' => '354', 'FIFA' => 'ISL', 'FIPS' => 'IC', 'GAUL' => '114', 'IOC' => 'ISL', 'ISO4217_Currency_Alphabetic_Code' => 'ISK', 'ISO4217_Currency_Country_Name' => 'ICELAND', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Iceland Krona', 'ISO4217_Currency_Numeric_Code' => '352', 'Is_Independent' => 'Yes', 'Capital' => 'Reykjavik', 'Continent' => 'EU', 'TLD' => '.is', 'Languages' => 'is,en,de,da,sv,no', 'Geo_Name_ID' => '2629691', 'EDGAR' => 'K6', '' => '', 'currency_symbol' => 'ISK', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '101'),
            103 => array('Country_Name' => 'India', 'Official_Name_English' => 'India', 'ISO3166_1_Alpha_2' => 'IN', 'ISO3166_1_Alpha_3' => 'IND', 'M49' => '356', 'ITU' => 'IND', 'MARC' => 'ii', 'WMO' => 'IN', 'DS' => 'IND', 'Dial' => '91', 'FIFA' => 'IND', 'FIPS' => 'IN', 'GAUL' => '115', 'IOC' => 'IND', 'ISO4217_Currency_Alphabetic_Code' => 'INR', 'ISO4217_Currency_Country_Name' => 'INDIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Indian Rupee', 'ISO4217_Currency_Numeric_Code' => '356', 'Is_Independent' => 'Yes', 'Capital' => 'New Delhi', 'Continent' => 'AS', 'TLD' => '.in', 'Languages' => 'en-IN,hi,bn,te,mr,ta,ur,gu,kn,ml,or,pa,as,bh,sat,ks,ne,sd,kok,doi,mni,sit,sa,fr,lus,inc', 'Geo_Name_ID' => '1269750', 'EDGAR' => 'K7', '' => '', 'currency_symbol' => 'INR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '102'),
            104 => array('Country_Name' => 'Indonesia', 'Official_Name_English' => 'Indonesia', 'ISO3166_1_Alpha_2' => 'ID', 'ISO3166_1_Alpha_3' => 'IDN', 'M49' => '360', 'ITU' => 'INS', 'MARC' => 'io', 'WMO' => 'ID', 'DS' => 'RI', 'Dial' => '62', 'FIFA' => 'IDN', 'FIPS' => 'ID', 'GAUL' => '116', 'IOC' => 'INA', 'ISO4217_Currency_Alphabetic_Code' => 'IDR', 'ISO4217_Currency_Country_Name' => 'INDONESIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Rupiah', 'ISO4217_Currency_Numeric_Code' => '360', 'Is_Independent' => 'Yes', 'Capital' => 'Jakarta', 'Continent' => 'AS', 'TLD' => '.id', 'Languages' => 'id,en,nl,jv', 'Geo_Name_ID' => '1643084', 'EDGAR' => 'K8', '' => '', 'currency_symbol' => 'IDR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '103'),
            105 => array('Country_Name' => 'Iran', 'Official_Name_English' => 'Iran (Islamic Republic of)', 'ISO3166_1_Alpha_2' => 'IR', 'ISO3166_1_Alpha_3' => 'IRN', 'M49' => '364', 'ITU' => 'IRN', 'MARC' => 'ir', 'WMO' => 'IR', 'DS' => 'IR', 'Dial' => '98', 'FIFA' => 'IRN', 'FIPS' => 'IR', 'GAUL' => '117', 'IOC' => 'IRI', 'ISO4217_Currency_Alphabetic_Code' => 'IRR', 'ISO4217_Currency_Country_Name' => 'IRAN, ISLAMIC REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Iranian Rial', 'ISO4217_Currency_Numeric_Code' => '364', 'Is_Independent' => 'Yes', 'Capital' => 'Tehran', 'Continent' => 'AS', 'TLD' => '.ir', 'Languages' => 'fa-IR,ku', 'Geo_Name_ID' => '130758', 'EDGAR' => 'K9', '' => '', 'currency_symbol' => 'IRR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '104'),
            106 => array('Country_Name' => 'Iraq', 'Official_Name_English' => 'Iraq', 'ISO3166_1_Alpha_2' => 'IQ', 'ISO3166_1_Alpha_3' => 'IRQ', 'M49' => '368', 'ITU' => 'IRQ', 'MARC' => 'iq', 'WMO' => 'IQ', 'DS' => 'IRQ', 'Dial' => '964', 'FIFA' => 'IRQ', 'FIPS' => 'IZ', 'GAUL' => '118', 'IOC' => 'IRQ', 'ISO4217_Currency_Alphabetic_Code' => 'IQD', 'ISO4217_Currency_Country_Name' => 'IRAQ', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Iraqi Dinar', 'ISO4217_Currency_Numeric_Code' => '368', 'Is_Independent' => 'Yes', 'Capital' => 'Baghdad', 'Continent' => 'AS', 'TLD' => '.iq', 'Languages' => 'ar-IQ,ku,hy', 'Geo_Name_ID' => '99237', 'EDGAR' => 'L0', '' => '', 'currency_symbol' => 'IQD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '105'),
            107 => array('Country_Name' => 'Ireland', 'Official_Name_English' => 'Ireland', 'ISO3166_1_Alpha_2' => 'IE', 'ISO3166_1_Alpha_3' => 'IRL', 'M49' => '372', 'ITU' => 'IRL', 'MARC' => 'ie', 'WMO' => 'IE', 'DS' => 'IRL', 'Dial' => '353', 'FIFA' => 'IRL', 'FIPS' => 'EI', 'GAUL' => '119', 'IOC' => 'IRL', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'IRELAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Dublin', 'Continent' => 'EU', 'TLD' => '.ie', 'Languages' => 'en-IE,ga-IE', 'Geo_Name_ID' => '2963597', 'EDGAR' => 'L2', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '106'),
            108 => array('Country_Name' => 'Isle of Man', 'Official_Name_English' => 'Isle of Man', 'ISO3166_1_Alpha_2' => 'IM', 'ISO3166_1_Alpha_3' => 'IMN', 'M49' => '833', 'ITU' => '', 'MARC' => 'uik', 'WMO' => '', 'DS' => 'GBM', 'Dial' => '44', 'FIFA' => 'GBM', 'FIPS' => 'IM', 'GAUL' => '120', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'GBP', 'ISO4217_Currency_Country_Name' => 'ISLE OF MAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pound Sterling', 'ISO4217_Currency_Numeric_Code' => '826', 'Is_Independent' => 'Crown dependency of GB', 'Capital' => 'Douglas', 'Continent' => 'EU', 'TLD' => '.im', 'Languages' => 'en,gv', 'Geo_Name_ID' => '3042225', 'EDGAR' => 'Y8', '' => '', 'currency_symbol' => 'GBP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '107'),
            109 => array('Country_Name' => 'Israel', 'Official_Name_English' => 'Israel', 'ISO3166_1_Alpha_2' => 'IL', 'ISO3166_1_Alpha_3' => 'ISR', 'M49' => '376', 'ITU' => 'ISR', 'MARC' => 'is', 'WMO' => 'IS', 'DS' => 'IL', 'Dial' => '972', 'FIFA' => 'ISR', 'FIPS' => 'IS', 'GAUL' => '121', 'IOC' => 'ISR', 'ISO4217_Currency_Alphabetic_Code' => 'ILS', 'ISO4217_Currency_Country_Name' => 'ISRAEL', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Israeli Sheqel', 'ISO4217_Currency_Numeric_Code' => '376', 'Is_Independent' => 'Yes', 'Capital' => 'Jerusalem', 'Continent' => 'AS', 'TLD' => '.il', 'Languages' => 'he,ar-IL,en-IL,', 'Geo_Name_ID' => '294640', 'EDGAR' => 'L3', '' => '', 'currency_symbol' => 'ILS', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '108'),
            110 => array('Country_Name' => 'Italy', 'Official_Name_English' => 'Italy', 'ISO3166_1_Alpha_2' => 'IT', 'ISO3166_1_Alpha_3' => 'ITA', 'M49' => '380', 'ITU' => 'I', 'MARC' => 'it', 'WMO' => 'IY', 'DS' => 'I', 'Dial' => '39', 'FIFA' => 'ITA', 'FIPS' => 'IT', 'GAUL' => '122', 'IOC' => 'ITA', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'ITALY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Rome', 'Continent' => 'EU', 'TLD' => '.it', 'Languages' => 'it-IT,de-IT,fr-IT,sc,ca,co,sl', 'Geo_Name_ID' => '3175395', 'EDGAR' => 'L6', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '109'),
            111 => array('Country_Name' => 'Jamaica', 'Official_Name_English' => 'Jamaica', 'ISO3166_1_Alpha_2' => 'JM', 'ISO3166_1_Alpha_3' => 'JAM', 'M49' => '388', 'ITU' => 'JMC', 'MARC' => 'jm', 'WMO' => 'JM', 'DS' => 'JA', 'Dial' => '876', 'FIFA' => 'JAM', 'FIPS' => 'JM', 'GAUL' => '123', 'IOC' => 'JAM', 'ISO4217_Currency_Alphabetic_Code' => 'JMD', 'ISO4217_Currency_Country_Name' => 'JAMAICA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Jamaican Dollar', 'ISO4217_Currency_Numeric_Code' => '388', 'Is_Independent' => 'Yes', 'Capital' => 'Kingston', 'Continent' => 'NA', 'TLD' => '.jm', 'Languages' => 'en-JM', 'Geo_Name_ID' => '3489940', 'EDGAR' => 'L8', '' => '', 'currency_symbol' => 'JMD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '110'),
            112 => array('Country_Name' => 'Japan', 'Official_Name_English' => 'Japan', 'ISO3166_1_Alpha_2' => 'JP', 'ISO3166_1_Alpha_3' => 'JPN', 'M49' => '392', 'ITU' => 'J', 'MARC' => 'ja', 'WMO' => 'JP', 'DS' => 'J', 'Dial' => '81', 'FIFA' => 'JPN', 'FIPS' => 'JA', 'GAUL' => '126', 'IOC' => 'JPN', 'ISO4217_Currency_Alphabetic_Code' => 'JPY', 'ISO4217_Currency_Country_Name' => 'JAPAN', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Yen', 'ISO4217_Currency_Numeric_Code' => '392', 'Is_Independent' => 'Yes', 'Capital' => 'Tokyo', 'Continent' => 'AS', 'TLD' => '.jp', 'Languages' => 'ja', 'Geo_Name_ID' => '1861060', 'EDGAR' => 'M0', '' => '', 'currency_symbol' => 'JPY', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '111'),
            113 => array('Country_Name' => 'Jersey', 'Official_Name_English' => 'Jersey', 'ISO3166_1_Alpha_2' => 'JE', 'ISO3166_1_Alpha_3' => 'JEY', 'M49' => '832', 'ITU' => '', 'MARC' => 'uik', 'WMO' => '', 'DS' => 'GBJ', 'Dial' => '44', 'FIFA' => 'GBJ', 'FIPS' => 'JE', 'GAUL' => '128', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'GBP', 'ISO4217_Currency_Country_Name' => 'JERSEY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pound Sterling', 'ISO4217_Currency_Numeric_Code' => '826', 'Is_Independent' => 'Crown dependency of GB', 'Capital' => 'Saint Helier', 'Continent' => 'EU', 'TLD' => '.je', 'Languages' => 'en,pt', 'Geo_Name_ID' => '3042142', 'EDGAR' => 'Y9', '' => '', 'currency_symbol' => 'GBP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '112'),
            114 => array('Country_Name' => 'Jordan', 'Official_Name_English' => 'Jordan', 'ISO3166_1_Alpha_2' => 'JO', 'ISO3166_1_Alpha_3' => 'JOR', 'M49' => '400', 'ITU' => 'JOR', 'MARC' => 'jo', 'WMO' => 'JD', 'DS' => 'HKJ', 'Dial' => '962', 'FIFA' => 'JOR', 'FIPS' => 'JO', 'GAUL' => '130', 'IOC' => 'JOR', 'ISO4217_Currency_Alphabetic_Code' => 'JOD', 'ISO4217_Currency_Country_Name' => 'JORDAN', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Jordanian Dinar', 'ISO4217_Currency_Numeric_Code' => '400', 'Is_Independent' => 'Yes', 'Capital' => 'Amman', 'Continent' => 'AS', 'TLD' => '.jo', 'Languages' => 'ar-JO,en', 'Geo_Name_ID' => '248816', 'EDGAR' => 'M2', '' => '', 'currency_symbol' => 'JOD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '113'),
            115 => array('Country_Name' => 'Kazakhstan', 'Official_Name_English' => 'Kazakhstan', 'ISO3166_1_Alpha_2' => 'KZ', 'ISO3166_1_Alpha_3' => 'KAZ', 'M49' => '398', 'ITU' => 'KAZ', 'MARC' => 'kz', 'WMO' => 'KZ', 'DS' => 'KZ', 'Dial' => '7', 'FIFA' => 'KAZ', 'FIPS' => 'KZ', 'GAUL' => '132', 'IOC' => 'KAZ', 'ISO4217_Currency_Alphabetic_Code' => 'KZT', 'ISO4217_Currency_Country_Name' => 'KAZAKHSTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Tenge', 'ISO4217_Currency_Numeric_Code' => '398', 'Is_Independent' => 'Yes', 'Capital' => 'Astana', 'Continent' => 'AS', 'TLD' => '.kz', 'Languages' => 'kk,ru', 'Geo_Name_ID' => '1522867', 'EDGAR' => '', '' => '', 'currency_symbol' => 'KZT', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '114'),
            116 => array('Country_Name' => 'Kenya', 'Official_Name_English' => 'Kenya', 'ISO3166_1_Alpha_2' => 'KE', 'ISO3166_1_Alpha_3' => 'KEN', 'M49' => '404', 'ITU' => 'KEN', 'MARC' => 'ke', 'WMO' => 'KN', 'DS' => 'EAK', 'Dial' => '254', 'FIFA' => 'KEN', 'FIPS' => 'KE', 'GAUL' => '133', 'IOC' => 'KEN', 'ISO4217_Currency_Alphabetic_Code' => 'KES', 'ISO4217_Currency_Country_Name' => 'KENYA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Kenyan Shilling', 'ISO4217_Currency_Numeric_Code' => '404', 'Is_Independent' => 'Yes', 'Capital' => 'Nairobi', 'Continent' => 'AF', 'TLD' => '.ke', 'Languages' => 'en-KE,sw-KE', 'Geo_Name_ID' => '192950', 'EDGAR' => 'M3', '' => '', 'currency_symbol' => 'KES', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '115'),
            117 => array('Country_Name' => 'Kiribati', 'Official_Name_English' => 'Kiribati', 'ISO3166_1_Alpha_2' => 'KI', 'ISO3166_1_Alpha_3' => 'KIR', 'M49' => '296', 'ITU' => 'KIR', 'MARC' => 'gb', 'WMO' => 'KB', 'DS' => '', 'Dial' => '686', 'FIFA' => 'KIR', 'FIPS' => 'KR', 'GAUL' => '135', 'IOC' => 'KIR', 'ISO4217_Currency_Alphabetic_Code' => 'AUD', 'ISO4217_Currency_Country_Name' => 'KIRIBATI', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Australian Dollar', 'ISO4217_Currency_Numeric_Code' => '36', 'Is_Independent' => 'Yes', 'Capital' => 'Tarawa', 'Continent' => 'OC', 'TLD' => '.ki', 'Languages' => 'en-KI,gil', 'Geo_Name_ID' => '4030945', 'EDGAR' => 'J2', '' => '', 'currency_symbol' => 'AUD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '116'),
            118 => array('Country_Name' => 'Kuwait', 'Official_Name_English' => 'Kuwait', 'ISO3166_1_Alpha_2' => 'KW', 'ISO3166_1_Alpha_3' => 'KWT', 'M49' => '414', 'ITU' => 'KWT', 'MARC' => 'ku', 'WMO' => 'KW', 'DS' => 'KWT', 'Dial' => '965', 'FIFA' => 'KUW', 'FIPS' => 'KU', 'GAUL' => '137', 'IOC' => 'KUW', 'ISO4217_Currency_Alphabetic_Code' => 'KWD', 'ISO4217_Currency_Country_Name' => 'KUWAIT', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Kuwaiti Dinar', 'ISO4217_Currency_Numeric_Code' => '414', 'Is_Independent' => 'Yes', 'Capital' => 'Kuwait City', 'Continent' => 'AS', 'TLD' => '.kw', 'Languages' => 'ar-KW,en', 'Geo_Name_ID' => '285570', 'EDGAR' => 'M6', '' => '', 'currency_symbol' => 'KWD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '117'),
            119 => array('Country_Name' => 'Kyrgyzstan', 'Official_Name_English' => 'Kyrgyzstan', 'ISO3166_1_Alpha_2' => 'KG', 'ISO3166_1_Alpha_3' => 'KGZ', 'M49' => '417', 'ITU' => 'KGZ', 'MARC' => 'kg', 'WMO' => 'KG', 'DS' => 'KS', 'Dial' => '996', 'FIFA' => 'KGZ', 'FIPS' => 'KG', 'GAUL' => '138', 'IOC' => 'KGZ', 'ISO4217_Currency_Alphabetic_Code' => 'KGS', 'ISO4217_Currency_Country_Name' => 'KYRGYZSTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Som', 'ISO4217_Currency_Numeric_Code' => '417', 'Is_Independent' => 'Yes', 'Capital' => 'Bishkek', 'Continent' => 'AS', 'TLD' => '.kg', 'Languages' => 'ky,uz,ru', 'Geo_Name_ID' => '1527747', 'EDGAR' => '1N', '' => '', 'currency_symbol' => 'KGS', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '118'),
            120 => array('Country_Name' => 'Laos', 'Official_Name_English' => 'Lao People\'s Democratic Republic', 'ISO3166_1_Alpha_2' => 'LA', 'ISO3166_1_Alpha_3' => 'LAO', 'M49' => '418', 'ITU' => 'LAO', 'MARC' => 'ls', 'WMO' => 'LA', 'DS' => 'LAO', 'Dial' => '856', 'FIFA' => 'LAO', 'FIPS' => 'LA', 'GAUL' => '139', 'IOC' => 'LAO', 'ISO4217_Currency_Alphabetic_Code' => 'LAK', 'ISO4217_Currency_Country_Name' => 'LAO PEOPLEâ€™S DEMOCRATIC REPUBLIC', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Kip', 'ISO4217_Currency_Numeric_Code' => '418', 'Is_Independent' => 'Yes', 'Capital' => 'Vientiane', 'Continent' => 'AS', 'TLD' => '.la', 'Languages' => 'lo,fr,en', 'Geo_Name_ID' => '1655842', 'EDGAR' => '', '' => '', 'currency_symbol' => 'LAK', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '119'),
            121 => array('Country_Name' => 'Latvia', 'Official_Name_English' => 'Latvia', 'ISO3166_1_Alpha_2' => 'LV', 'ISO3166_1_Alpha_3' => 'LVA', 'M49' => '428', 'ITU' => 'LVA', 'MARC' => 'lv', 'WMO' => 'LV', 'DS' => 'LV', 'Dial' => '371', 'FIFA' => 'LVA', 'FIPS' => 'LG', 'GAUL' => '140', 'IOC' => 'LAT', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'LATVIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Riga', 'Continent' => 'EU', 'TLD' => '.lv', 'Languages' => 'lv,ru,lt', 'Geo_Name_ID' => '458258', 'EDGAR' => '1R', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '120'),
            122 => array('Country_Name' => 'Lebanon', 'Official_Name_English' => 'Lebanon', 'ISO3166_1_Alpha_2' => 'LB', 'ISO3166_1_Alpha_3' => 'LBN', 'M49' => '422', 'ITU' => 'LBN', 'MARC' => 'le', 'WMO' => 'LB', 'DS' => 'RL', 'Dial' => '961', 'FIFA' => 'LIB', 'FIPS' => 'LE', 'GAUL' => '141', 'IOC' => 'LIB', 'ISO4217_Currency_Alphabetic_Code' => 'LBP', 'ISO4217_Currency_Country_Name' => 'LEBANON', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Lebanese Pound', 'ISO4217_Currency_Numeric_Code' => '422', 'Is_Independent' => 'Yes', 'Capital' => 'Beirut', 'Continent' => 'AS', 'TLD' => '.lb', 'Languages' => 'ar-LB,fr-LB,en,hy', 'Geo_Name_ID' => '272103', 'EDGAR' => 'M8', '' => '', 'currency_symbol' => 'LBP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '121'),
            123 => array('Country_Name' => 'Lesotho', 'Official_Name_English' => 'Lesotho', 'ISO3166_1_Alpha_2' => 'LS', 'ISO3166_1_Alpha_3' => 'LSO', 'M49' => '426', 'ITU' => 'LSO', 'MARC' => 'lo', 'WMO' => 'LS', 'DS' => 'LS', 'Dial' => '266', 'FIFA' => 'LES', 'FIPS' => 'LT', 'GAUL' => '142', 'IOC' => 'LES', 'ISO4217_Currency_Alphabetic_Code' => 'ZAR', 'ISO4217_Currency_Country_Name' => 'LESOTHO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Rand', 'ISO4217_Currency_Numeric_Code' => '710', 'Is_Independent' => 'Yes', 'Capital' => 'Maseru', 'Continent' => 'AF', 'TLD' => '.ls', 'Languages' => 'en-LS,st,zu,xh', 'Geo_Name_ID' => '932692', 'EDGAR' => 'M9', '' => '', 'currency_symbol' => 'ZAR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '122'),
            124 => array('Country_Name' => 'Liberia', 'Official_Name_English' => 'Liberia', 'ISO3166_1_Alpha_2' => 'LR', 'ISO3166_1_Alpha_3' => 'LBR', 'M49' => '430', 'ITU' => 'LBR', 'MARC' => 'lb', 'WMO' => 'LI', 'DS' => 'LB', 'Dial' => '231', 'FIFA' => 'LBR', 'FIPS' => 'LI', 'GAUL' => '144', 'IOC' => 'LBR', 'ISO4217_Currency_Alphabetic_Code' => 'LRD', 'ISO4217_Currency_Country_Name' => 'LIBERIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Liberian Dollar', 'ISO4217_Currency_Numeric_Code' => '430', 'Is_Independent' => 'Yes', 'Capital' => 'Monrovia', 'Continent' => 'AF', 'TLD' => '.lr', 'Languages' => 'en-LR', 'Geo_Name_ID' => '2275384', 'EDGAR' => 'N0', '' => '', 'currency_symbol' => 'LRD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '123'),
            125 => array('Country_Name' => 'Libya', 'Official_Name_English' => 'Libya', 'ISO3166_1_Alpha_2' => 'LY', 'ISO3166_1_Alpha_3' => 'LBY', 'M49' => '434', 'ITU' => 'LBY', 'MARC' => 'ly', 'WMO' => 'LY', 'DS' => 'LAR', 'Dial' => '218', 'FIFA' => 'LBY', 'FIPS' => 'LY', 'GAUL' => '145', 'IOC' => 'LBA', 'ISO4217_Currency_Alphabetic_Code' => 'LYD', 'ISO4217_Currency_Country_Name' => 'LIBYA', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Libyan Dinar', 'ISO4217_Currency_Numeric_Code' => '434', 'Is_Independent' => 'Yes', 'Capital' => 'Tripoli', 'Continent' => 'AF', 'TLD' => '.ly', 'Languages' => 'ar-LY,it,en', 'Geo_Name_ID' => '2215636', 'EDGAR' => '', '' => '', 'currency_symbol' => 'LYD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '124'),
            126 => array('Country_Name' => 'Liechtenstein', 'Official_Name_English' => 'Liechtenstein', 'ISO3166_1_Alpha_2' => 'LI', 'ISO3166_1_Alpha_3' => 'LIE', 'M49' => '438', 'ITU' => 'LIE', 'MARC' => 'lh', 'WMO' => '', 'DS' => 'FL', 'Dial' => '423', 'FIFA' => 'LIE', 'FIPS' => 'LS', 'GAUL' => '146', 'IOC' => 'LIE', 'ISO4217_Currency_Alphabetic_Code' => 'CHF', 'ISO4217_Currency_Country_Name' => 'LIECHTENSTEIN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Swiss Franc', 'ISO4217_Currency_Numeric_Code' => '756', 'Is_Independent' => 'Yes', 'Capital' => 'Vaduz', 'Continent' => 'EU', 'TLD' => '.li', 'Languages' => 'de-LI', 'Geo_Name_ID' => '3042058', 'EDGAR' => 'N2', '' => '', 'currency_symbol' => 'CHF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '125'),
            127 => array('Country_Name' => 'Lithuania', 'Official_Name_English' => 'Lithuania', 'ISO3166_1_Alpha_2' => 'LT', 'ISO3166_1_Alpha_3' => 'LTU', 'M49' => '440', 'ITU' => 'LTU', 'MARC' => 'li', 'WMO' => 'LT', 'DS' => 'LT', 'Dial' => '370', 'FIFA' => 'LTU', 'FIPS' => 'LH', 'GAUL' => '147', 'IOC' => 'LTU', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'LITHUANIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Vilnius', 'Continent' => 'EU', 'TLD' => '.lt', 'Languages' => 'lt,ru,pl', 'Geo_Name_ID' => '597427', 'EDGAR' => '1Q', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '126'),
            128 => array('Country_Name' => 'Luxembourg', 'Official_Name_English' => 'Luxembourg', 'ISO3166_1_Alpha_2' => 'LU', 'ISO3166_1_Alpha_3' => 'LUX', 'M49' => '442', 'ITU' => 'LUX', 'MARC' => 'lu', 'WMO' => 'BX', 'DS' => 'L', 'Dial' => '352', 'FIFA' => 'LUX', 'FIPS' => 'LU', 'GAUL' => '148', 'IOC' => 'LUX', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'LUXEMBOURG', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Luxembourg', 'Continent' => 'EU', 'TLD' => '.lu', 'Languages' => 'lb,de-LU,fr-LU', 'Geo_Name_ID' => '2960313', 'EDGAR' => 'N4', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '127'),
            129 => array('Country_Name' => 'Macau', 'Official_Name_English' => 'China, Macao Special Administrative Region', 'ISO3166_1_Alpha_2' => 'MO', 'ISO3166_1_Alpha_3' => 'MAC', 'M49' => '446', 'ITU' => 'MAC', 'MARC' => '', 'WMO' => 'MU', 'DS' => 'MO', 'Dial' => '853', 'FIFA' => 'MAC', 'FIPS' => 'MC', 'GAUL' => '149', 'IOC' => 'MAC', 'ISO4217_Currency_Alphabetic_Code' => 'MOP', 'ISO4217_Currency_Country_Name' => 'MACAO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pataca', 'ISO4217_Currency_Numeric_Code' => '446', 'Is_Independent' => 'Part of CN', 'Capital' => 'Macao', 'Continent' => 'AS', 'TLD' => '.mo', 'Languages' => 'zh,zh-MO,pt', 'Geo_Name_ID' => '1821275', 'EDGAR' => '', '' => '', 'currency_symbol' => 'MOP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '128'),
            130 => array('Country_Name' => 'Macedonia', 'Official_Name_English' => 'The former Yugoslav Republic of Macedonia', 'ISO3166_1_Alpha_2' => 'MK', 'ISO3166_1_Alpha_3' => 'MKD', 'M49' => '807', 'ITU' => 'MKD', 'MARC' => 'xn', 'WMO' => 'MJ', 'DS' => 'MK', 'Dial' => '389', 'FIFA' => 'MKD', 'FIPS' => 'MK', 'GAUL' => '241', 'IOC' => 'MKD', 'ISO4217_Currency_Alphabetic_Code' => 'MKD', 'ISO4217_Currency_Country_Name' => 'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Denar', 'ISO4217_Currency_Numeric_Code' => '807', 'Is_Independent' => 'Yes', 'Capital' => 'Skopje', 'Continent' => 'EU', 'TLD' => '.mk', 'Languages' => 'mk,sq,tr,rmm,sr', 'Geo_Name_ID' => '718075', 'EDGAR' => '1U', '' => '', 'currency_symbol' => 'MKD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '129'),
            131 => array('Country_Name' => 'Madagascar', 'Official_Name_English' => 'Madagascar', 'ISO3166_1_Alpha_2' => 'MG', 'ISO3166_1_Alpha_3' => 'MDG', 'M49' => '450', 'ITU' => 'MDG', 'MARC' => 'mg', 'WMO' => 'MG', 'DS' => 'RM', 'Dial' => '261', 'FIFA' => 'MAD', 'FIPS' => 'MA', 'GAUL' => '150', 'IOC' => 'MAD', 'ISO4217_Currency_Alphabetic_Code' => 'MGA', 'ISO4217_Currency_Country_Name' => 'MADAGASCAR', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Malagasy Ariary', 'ISO4217_Currency_Numeric_Code' => '969', 'Is_Independent' => 'Yes', 'Capital' => 'Antananarivo', 'Continent' => 'AF', 'TLD' => '.mg', 'Languages' => 'fr-MG,mg', 'Geo_Name_ID' => '1062947', 'EDGAR' => 'N6', '' => '', 'currency_symbol' => 'MGA', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '130'),
            132 => array('Country_Name' => 'Malawi', 'Official_Name_English' => 'Malawi', 'ISO3166_1_Alpha_2' => 'MW', 'ISO3166_1_Alpha_3' => 'MWI', 'M49' => '454', 'ITU' => 'MWI', 'MARC' => 'mw', 'WMO' => 'MW', 'DS' => 'MW', 'Dial' => '265', 'FIFA' => 'MWI', 'FIPS' => 'MI', 'GAUL' => '152', 'IOC' => 'MAW', 'ISO4217_Currency_Alphabetic_Code' => 'MWK', 'ISO4217_Currency_Country_Name' => 'MALAWI', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Kwacha', 'ISO4217_Currency_Numeric_Code' => '454', 'Is_Independent' => 'Yes', 'Capital' => 'Lilongwe', 'Continent' => 'AF', 'TLD' => '.mw', 'Languages' => 'ny,yao,tum,swk', 'Geo_Name_ID' => '927384', 'EDGAR' => 'N7', '' => '', 'currency_symbol' => 'MWK', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '131'),
            133 => array('Country_Name' => 'Malaysia', 'Official_Name_English' => 'Malaysia', 'ISO3166_1_Alpha_2' => 'MY', 'ISO3166_1_Alpha_3' => 'MYS', 'M49' => '458', 'ITU' => 'MLA', 'MARC' => 'my', 'WMO' => 'MS', 'DS' => 'MAL', 'Dial' => '60', 'FIFA' => 'MAS', 'FIPS' => 'MY', 'GAUL' => '153', 'IOC' => 'MAS', 'ISO4217_Currency_Alphabetic_Code' => 'MYR', 'ISO4217_Currency_Country_Name' => 'MALAYSIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Malaysian Ringgit', 'ISO4217_Currency_Numeric_Code' => '458', 'Is_Independent' => 'Yes', 'Capital' => 'Kuala Lumpur', 'Continent' => 'AS', 'TLD' => '.my', 'Languages' => 'ms-MY,en,zh,ta,te,ml,pa,th', 'Geo_Name_ID' => '1733045', 'EDGAR' => 'N8', '' => '', 'currency_symbol' => 'MYR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '132'),
            134 => array('Country_Name' => 'Maldives', 'Official_Name_English' => 'Maldives', 'ISO3166_1_Alpha_2' => 'MV', 'ISO3166_1_Alpha_3' => 'MDV', 'M49' => '462', 'ITU' => 'MLD', 'MARC' => 'xc', 'WMO' => 'MV', 'DS' => 'MV', 'Dial' => '960', 'FIFA' => 'MDV', 'FIPS' => 'MV', 'GAUL' => '154', 'IOC' => 'MDV', 'ISO4217_Currency_Alphabetic_Code' => 'MVR', 'ISO4217_Currency_Country_Name' => 'MALDIVES', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Rufiyaa', 'ISO4217_Currency_Numeric_Code' => '462', 'Is_Independent' => 'Yes', 'Capital' => 'Male', 'Continent' => 'AS', 'TLD' => '.mv', 'Languages' => 'dv,en', 'Geo_Name_ID' => '1282028', 'EDGAR' => 'N9', '' => '', 'currency_symbol' => 'MVR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '133'),
            135 => array('Country_Name' => 'Mali', 'Official_Name_English' => 'Mali', 'ISO3166_1_Alpha_2' => 'ML', 'ISO3166_1_Alpha_3' => 'MLI', 'M49' => '466', 'ITU' => 'MLI', 'MARC' => 'ml', 'WMO' => 'MI', 'DS' => 'RMM', 'Dial' => '223', 'FIFA' => 'MLI', 'FIPS' => 'ML', 'GAUL' => '155', 'IOC' => 'MLI', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'MALI', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Bamako', 'Continent' => 'AF', 'TLD' => '.ml', 'Languages' => 'fr-ML,bm', 'Geo_Name_ID' => '2453866', 'EDGAR' => 'O0', '' => '', 'currency_symbol' => 'XOF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '134'),
            136 => array('Country_Name' => 'Malta', 'Official_Name_English' => 'Malta', 'ISO3166_1_Alpha_2' => 'MT', 'ISO3166_1_Alpha_3' => 'MLT', 'M49' => '470', 'ITU' => 'MLT', 'MARC' => 'mm', 'WMO' => 'ML', 'DS' => 'M', 'Dial' => '356', 'FIFA' => 'MLT', 'FIPS' => 'MT', 'GAUL' => '156', 'IOC' => 'MLT', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'MALTA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Valletta', 'Continent' => 'EU', 'TLD' => '.mt', 'Languages' => 'mt,en-MT', 'Geo_Name_ID' => '2562770', 'EDGAR' => 'O1', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '135'),
            137 => array('Country_Name' => 'Marshall Islands', 'Official_Name_English' => 'Marshall Islands', 'ISO3166_1_Alpha_2' => 'MH', 'ISO3166_1_Alpha_3' => 'MHL', 'M49' => '584', 'ITU' => 'MHL', 'MARC' => 'xe', 'WMO' => 'MH', 'DS' => '', 'Dial' => '692', 'FIFA' => 'MHL', 'FIPS' => 'RM', 'GAUL' => '157', 'IOC' => 'MSH', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'MARSHALL ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Majuro', 'Continent' => 'OC', 'TLD' => '.mh', 'Languages' => 'mh,en-MH', 'Geo_Name_ID' => '2080185', 'EDGAR' => '1T', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '136'),
            138 => array('Country_Name' => 'Martinique', 'Official_Name_English' => 'Martinique', 'ISO3166_1_Alpha_2' => 'MQ', 'ISO3166_1_Alpha_3' => 'MTQ', 'M49' => '474', 'ITU' => 'MRT', 'MARC' => 'mq', 'WMO' => 'MR', 'DS' => 'F', 'Dial' => '596', 'FIFA' => 'MTQ', 'FIPS' => 'MB', 'GAUL' => '158', 'IOC' => 'MRT', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'MARTINIQUE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Fort-de-France', 'Continent' => 'NA', 'TLD' => '.mq', 'Languages' => 'fr-MQ', 'Geo_Name_ID' => '3570311', 'EDGAR' => 'O2', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '137'),
            139 => array('Country_Name' => 'Mauritania', 'Official_Name_English' => 'Mauritania', 'ISO3166_1_Alpha_2' => 'MR', 'ISO3166_1_Alpha_3' => 'MRT', 'M49' => '478', 'ITU' => 'MTN', 'MARC' => 'mu', 'WMO' => 'MT', 'DS' => 'RIM', 'Dial' => '222', 'FIFA' => 'MTN', 'FIPS' => 'MR', 'GAUL' => '159', 'IOC' => 'MTN', 'ISO4217_Currency_Alphabetic_Code' => 'MRO', 'ISO4217_Currency_Country_Name' => 'MAURITANIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Ouguiya', 'ISO4217_Currency_Numeric_Code' => '478', 'Is_Independent' => 'Yes', 'Capital' => 'Nouakchott', 'Continent' => 'AF', 'TLD' => '.mr', 'Languages' => 'ar-MR,fuc,snk,fr,mey,wo', 'Geo_Name_ID' => '2378080', 'EDGAR' => 'O3', '' => '', 'currency_symbol' => 'MRO', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '138'),
            140 => array('Country_Name' => 'Mauritius', 'Official_Name_English' => 'Mauritius', 'ISO3166_1_Alpha_2' => 'MU', 'ISO3166_1_Alpha_3' => 'MUS', 'M49' => '480', 'ITU' => 'MAU', 'MARC' => 'mf', 'WMO' => 'MA', 'DS' => 'MS', 'Dial' => '230', 'FIFA' => 'MRI', 'FIPS' => 'MP', 'GAUL' => '160', 'IOC' => 'MRI', 'ISO4217_Currency_Alphabetic_Code' => 'MUR', 'ISO4217_Currency_Country_Name' => 'MAURITIUS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Mauritius Rupee', 'ISO4217_Currency_Numeric_Code' => '480', 'Is_Independent' => 'Yes', 'Capital' => 'Port Louis', 'Continent' => 'AF', 'TLD' => '.mu', 'Languages' => 'en-MU,bho,fr', 'Geo_Name_ID' => '934292', 'EDGAR' => 'O4', '' => '', 'currency_symbol' => 'MUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '139'),
            141 => array('Country_Name' => 'Mayotte', 'Official_Name_English' => 'Mayotte', 'ISO3166_1_Alpha_2' => 'YT', 'ISO3166_1_Alpha_3' => 'MYT', 'M49' => '175', 'ITU' => 'MYT', 'MARC' => 'ot', 'WMO' => '', 'DS' => '', 'Dial' => '262', 'FIFA' => 'MYT', 'FIPS' => 'MF', 'GAUL' => '161', 'IOC' => 'MAY', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'MAYOTTE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Mamoudzou', 'Continent' => 'AF', 'TLD' => '.yt', 'Languages' => 'fr-YT', 'Geo_Name_ID' => '1024031', 'EDGAR' => '2P', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '140'),
            142 => array('Country_Name' => 'Mexico', 'Official_Name_English' => 'Mexico', 'ISO3166_1_Alpha_2' => 'MX', 'ISO3166_1_Alpha_3' => 'MEX', 'M49' => '484', 'ITU' => 'MEX', 'MARC' => 'mx', 'WMO' => 'MX', 'DS' => 'MEX', 'Dial' => '52', 'FIFA' => 'MEX', 'FIPS' => 'MX', 'GAUL' => '162', 'IOC' => 'MEX', 'ISO4217_Currency_Alphabetic_Code' => 'MXN', 'ISO4217_Currency_Country_Name' => 'MEXICO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Mexican Peso', 'ISO4217_Currency_Numeric_Code' => '484', 'Is_Independent' => 'Yes', 'Capital' => 'Mexico City', 'Continent' => 'NA', 'TLD' => '.mx', 'Languages' => 'es-MX', 'Geo_Name_ID' => '3996063', 'EDGAR' => 'O5', '' => '', 'currency_symbol' => 'MXN', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '141'),
            143 => array('Country_Name' => 'Micronesia', 'Official_Name_English' => 'Micronesia (Federated States of)', 'ISO3166_1_Alpha_2' => 'FM', 'ISO3166_1_Alpha_3' => 'FSM', 'M49' => '583', 'ITU' => 'FSM', 'MARC' => 'fm', 'WMO' => '', 'DS' => '', 'Dial' => '691', 'FIFA' => 'FSM', 'FIPS' => 'FM', 'GAUL' => '163', 'IOC' => 'FSM', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'MICRONESIA, FEDERATED STATES OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Palikir', 'Continent' => 'OC', 'TLD' => '.fm', 'Languages' => 'en-FM,chk,pon,yap,kos,uli,woe,nkr,kpg', 'Geo_Name_ID' => '2081918', 'EDGAR' => '1K', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '142'),
            144 => array('Country_Name' => 'Moldova', 'Official_Name_English' => 'Republic of Moldova', 'ISO3166_1_Alpha_2' => 'MD', 'ISO3166_1_Alpha_3' => 'MDA', 'M49' => '498', 'ITU' => 'MDA', 'MARC' => 'mv', 'WMO' => 'RM', 'DS' => 'MD', 'Dial' => '373', 'FIFA' => 'MDA', 'FIPS' => 'MD', 'GAUL' => '165', 'IOC' => 'MDA', 'ISO4217_Currency_Alphabetic_Code' => 'MDL', 'ISO4217_Currency_Country_Name' => 'MOLDOVA, REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Moldovan Leu', 'ISO4217_Currency_Numeric_Code' => '498', 'Is_Independent' => 'Yes', 'Capital' => 'Chisinau', 'Continent' => 'EU', 'TLD' => '.md', 'Languages' => 'ro,ru,gag,tr', 'Geo_Name_ID' => '617790', 'EDGAR' => '1S', '' => '', 'currency_symbol' => 'MDL', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '143'),
            145 => array('Country_Name' => 'Monaco', 'Official_Name_English' => 'Monaco', 'ISO3166_1_Alpha_2' => 'MC', 'ISO3166_1_Alpha_3' => 'MCO', 'M49' => '492', 'ITU' => 'MCO', 'MARC' => 'mc', 'WMO' => '', 'DS' => 'MC', 'Dial' => '377', 'FIFA' => 'MON', 'FIPS' => 'MN', 'GAUL' => '166', 'IOC' => 'MON', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'MONACO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Monaco', 'Continent' => 'EU', 'TLD' => '.mc', 'Languages' => 'fr-MC,en,it', 'Geo_Name_ID' => '2993457', 'EDGAR' => 'O9', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '144'),
            146 => array('Country_Name' => 'Mongolia', 'Official_Name_English' => 'Mongolia', 'ISO3166_1_Alpha_2' => 'MN', 'ISO3166_1_Alpha_3' => 'MNG', 'M49' => '496', 'ITU' => 'MNG', 'MARC' => 'mp', 'WMO' => 'MO', 'DS' => 'MGL', 'Dial' => '976', 'FIFA' => 'MNG', 'FIPS' => 'MG', 'GAUL' => '167', 'IOC' => 'MGL', 'ISO4217_Currency_Alphabetic_Code' => 'MNT', 'ISO4217_Currency_Country_Name' => 'MONGOLIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Tugrik', 'ISO4217_Currency_Numeric_Code' => '496', 'Is_Independent' => 'Yes', 'Capital' => 'Ulan Bator', 'Continent' => 'AS', 'TLD' => '.mn', 'Languages' => 'mn,ru', 'Geo_Name_ID' => '2029969', 'EDGAR' => 'P0', '' => '', 'currency_symbol' => 'MNT', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '145'),
            147 => array('Country_Name' => 'Montenegro', 'Official_Name_English' => 'Montenegro', 'ISO3166_1_Alpha_2' => 'ME', 'ISO3166_1_Alpha_3' => 'MNE', 'M49' => '499', 'ITU' => 'MNE', 'MARC' => 'mo', 'WMO' => '', 'DS' => 'MNE', 'Dial' => '382', 'FIFA' => 'MNE', 'FIPS' => 'MJ', 'GAUL' => '2647', 'IOC' => 'MGO', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'MONTENEGRO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Podgorica', 'Continent' => 'EU', 'TLD' => '.me', 'Languages' => 'sr,hu,bs,sq,hr,rom', 'Geo_Name_ID' => '3194884', 'EDGAR' => 'Z5', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '146'),
            148 => array('Country_Name' => 'Montserrat', 'Official_Name_English' => 'Montserrat', 'ISO3166_1_Alpha_2' => 'MS', 'ISO3166_1_Alpha_3' => 'MSR', 'M49' => '500', 'ITU' => 'MSR', 'MARC' => 'mj', 'WMO' => '', 'DS' => '', 'Dial' => '664', 'FIFA' => 'MSR', 'FIPS' => 'MH', 'GAUL' => '168', 'IOC' => 'MNT', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'MONTSERRAT', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Plymouth', 'Continent' => 'NA', 'TLD' => '.ms', 'Languages' => 'en-MS', 'Geo_Name_ID' => '3578097', 'EDGAR' => 'P1', '' => '', 'currency_symbol' => 'XCD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '147'),
            149 => array('Country_Name' => 'Morocco', 'Official_Name_English' => 'Morocco', 'ISO3166_1_Alpha_2' => 'MA', 'ISO3166_1_Alpha_3' => 'MAR', 'M49' => '504', 'ITU' => 'MRC', 'MARC' => 'mr', 'WMO' => 'MC', 'DS' => 'MA', 'Dial' => '212', 'FIFA' => 'MAR', 'FIPS' => 'MO', 'GAUL' => '169', 'IOC' => 'MAR', 'ISO4217_Currency_Alphabetic_Code' => 'MAD', 'ISO4217_Currency_Country_Name' => 'MOROCCO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Moroccan Dirham', 'ISO4217_Currency_Numeric_Code' => '504', 'Is_Independent' => 'Yes', 'Capital' => 'Rabat', 'Continent' => 'AF', 'TLD' => '.ma', 'Languages' => 'ar-MA,ber,fr', 'Geo_Name_ID' => '2542007', 'EDGAR' => 'P2', '' => '', 'currency_symbol' => 'MAD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '148'),
            150 => array('Country_Name' => 'Mozambique', 'Official_Name_English' => 'Mozambique', 'ISO3166_1_Alpha_2' => 'MZ', 'ISO3166_1_Alpha_3' => 'MOZ', 'M49' => '508', 'ITU' => 'MOZ', 'MARC' => 'mz', 'WMO' => 'MZ', 'DS' => 'MOC', 'Dial' => '258', 'FIFA' => 'MOZ', 'FIPS' => 'MZ', 'GAUL' => '170', 'IOC' => 'MOZ', 'ISO4217_Currency_Alphabetic_Code' => 'MZN', 'ISO4217_Currency_Country_Name' => 'MOZAMBIQUE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Mozambique Metical', 'ISO4217_Currency_Numeric_Code' => '943', 'Is_Independent' => 'Yes', 'Capital' => 'Maputo', 'Continent' => 'AF', 'TLD' => '.mz', 'Languages' => 'pt-MZ,vmw', 'Geo_Name_ID' => '1036973', 'EDGAR' => 'P3', '' => '', 'currency_symbol' => 'MZN', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '149'),
            151 => array('Country_Name' => 'Myanmar', 'Official_Name_English' => 'Myanmar', 'ISO3166_1_Alpha_2' => 'MM', 'ISO3166_1_Alpha_3' => 'MMR', 'M49' => '104', 'ITU' => 'MYA', 'MARC' => 'br', 'WMO' => 'BM', 'DS' => 'BUR', 'Dial' => '95', 'FIFA' => 'MYA', 'FIPS' => 'BM', 'GAUL' => '171', 'IOC' => 'MYA', 'ISO4217_Currency_Alphabetic_Code' => 'MMK', 'ISO4217_Currency_Country_Name' => 'MYANMAR', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Kyat', 'ISO4217_Currency_Numeric_Code' => '104', 'Is_Independent' => 'Yes', 'Capital' => 'Nay Pyi Taw', 'Continent' => 'AS', 'TLD' => '.mm', 'Languages' => 'my', 'Geo_Name_ID' => '1327865', 'EDGAR' => 'E1', '' => '', 'currency_symbol' => 'MMK', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '150'),
            152 => array('Country_Name' => 'Namibia', 'Official_Name_English' => 'Namibia', 'ISO3166_1_Alpha_2' => 'NA', 'ISO3166_1_Alpha_3' => 'NAM', 'M49' => '516', 'ITU' => 'NMB', 'MARC' => 'sx', 'WMO' => 'NM', 'DS' => 'NAM', 'Dial' => '264', 'FIFA' => 'NAM', 'FIPS' => 'WA', 'GAUL' => '172', 'IOC' => 'NAM', 'ISO4217_Currency_Alphabetic_Code' => 'ZAR', 'ISO4217_Currency_Country_Name' => 'NAMIBIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Rand', 'ISO4217_Currency_Numeric_Code' => '710', 'Is_Independent' => 'Yes', 'Capital' => 'Windhoek', 'Continent' => 'AF', 'TLD' => '.na', 'Languages' => 'en-NA,af,de,hz,naq', 'Geo_Name_ID' => '3355338', 'EDGAR' => 'T6', '' => '', 'currency_symbol' => 'ZAR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '151'),
            153 => array('Country_Name' => 'Nauru', 'Official_Name_English' => 'Nauru', 'ISO3166_1_Alpha_2' => 'NR', 'ISO3166_1_Alpha_3' => 'NRU', 'M49' => '520', 'ITU' => 'NRU', 'MARC' => 'nu', 'WMO' => 'NW', 'DS' => 'NAU', 'Dial' => '674', 'FIFA' => 'NRU', 'FIPS' => 'NR', 'GAUL' => '173', 'IOC' => 'NRU', 'ISO4217_Currency_Alphabetic_Code' => 'AUD', 'ISO4217_Currency_Country_Name' => 'NAURU', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Australian Dollar', 'ISO4217_Currency_Numeric_Code' => '36', 'Is_Independent' => 'Yes', 'Capital' => 'Yaren', 'Continent' => 'OC', 'TLD' => '.nr', 'Languages' => 'na,en-NR', 'Geo_Name_ID' => '2110425', 'EDGAR' => 'P5', '' => '', 'currency_symbol' => 'AUD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '152'),
            154 => array('Country_Name' => 'Nepal', 'Official_Name_English' => 'Nepal', 'ISO3166_1_Alpha_2' => 'NP', 'ISO3166_1_Alpha_3' => 'NPL', 'M49' => '524', 'ITU' => 'NPL', 'MARC' => 'np', 'WMO' => 'NP', 'DS' => 'NEP', 'Dial' => '977', 'FIFA' => 'NEP', 'FIPS' => 'NP', 'GAUL' => '175', 'IOC' => 'NEP', 'ISO4217_Currency_Alphabetic_Code' => 'NPR', 'ISO4217_Currency_Country_Name' => 'NEPAL', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Nepalese Rupee', 'ISO4217_Currency_Numeric_Code' => '524', 'Is_Independent' => 'Yes', 'Capital' => 'Kathmandu', 'Continent' => 'AS', 'TLD' => '.np', 'Languages' => 'ne,en', 'Geo_Name_ID' => '1282988', 'EDGAR' => 'P6', '' => '', 'currency_symbol' => 'NPR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '153'),
            155 => array('Country_Name' => 'Netherlands', 'Official_Name_English' => 'Netherlands', 'ISO3166_1_Alpha_2' => 'NL', 'ISO3166_1_Alpha_3' => 'NLD', 'M49' => '528', 'ITU' => 'HOL', 'MARC' => 'ne', 'WMO' => 'NL', 'DS' => 'NL', 'Dial' => '31', 'FIFA' => 'NED', 'FIPS' => 'NL', 'GAUL' => '177', 'IOC' => 'NED', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'NETHERLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Amsterdam', 'Continent' => 'EU', 'TLD' => '.nl', 'Languages' => 'nl-NL,fy-NL', 'Geo_Name_ID' => '2750405', 'EDGAR' => 'P7', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '154'),
            156 => array('Country_Name' => 'New Caledonia', 'Official_Name_English' => 'New Caledonia', 'ISO3166_1_Alpha_2' => 'NC', 'ISO3166_1_Alpha_3' => 'NCL', 'M49' => '540', 'ITU' => 'NCL', 'MARC' => 'nl', 'WMO' => 'NC', 'DS' => 'F', 'Dial' => '687', 'FIFA' => 'NCL', 'FIPS' => 'NC', 'GAUL' => '178', 'IOC' => 'NCD', 'ISO4217_Currency_Alphabetic_Code' => 'XPF', 'ISO4217_Currency_Country_Name' => 'NEW CALEDONIA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFP Franc', 'ISO4217_Currency_Numeric_Code' => '953', 'Is_Independent' => 'Territory of FR', 'Capital' => 'Noumea', 'Continent' => 'OC', 'TLD' => '.nc', 'Languages' => 'fr-NC', 'Geo_Name_ID' => '2139685', 'EDGAR' => '1W', '' => '', 'currency_symbol' => 'XPF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '155'),
            157 => array('Country_Name' => 'New Zealand', 'Official_Name_English' => 'New Zealand', 'ISO3166_1_Alpha_2' => 'NZ', 'ISO3166_1_Alpha_3' => 'NZL', 'M49' => '554', 'ITU' => 'NZL', 'MARC' => 'nz', 'WMO' => 'NZ', 'DS' => 'NZ', 'Dial' => '64', 'FIFA' => 'NZL', 'FIPS' => 'NZ', 'GAUL' => '179', 'IOC' => 'NZL', 'ISO4217_Currency_Alphabetic_Code' => 'NZD', 'ISO4217_Currency_Country_Name' => 'NEW ZEALAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Zealand Dollar', 'ISO4217_Currency_Numeric_Code' => '554', 'Is_Independent' => 'Yes', 'Capital' => 'Wellington', 'Continent' => 'OC', 'TLD' => '.nz', 'Languages' => 'en-NZ,mi', 'Geo_Name_ID' => '2186224', 'EDGAR' => 'Q2', '' => '', 'currency_symbol' => 'NZD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '156'),
            158 => array('Country_Name' => 'Nicaragua', 'Official_Name_English' => 'Nicaragua', 'ISO3166_1_Alpha_2' => 'NI', 'ISO3166_1_Alpha_3' => 'NIC', 'M49' => '558', 'ITU' => 'NCG', 'MARC' => 'nq', 'WMO' => 'NK', 'DS' => 'NIC', 'Dial' => '505', 'FIFA' => 'NCA', 'FIPS' => 'NU', 'GAUL' => '180', 'IOC' => 'NCA', 'ISO4217_Currency_Alphabetic_Code' => 'NIO', 'ISO4217_Currency_Country_Name' => 'NICARAGUA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Cordoba Oro', 'ISO4217_Currency_Numeric_Code' => '558', 'Is_Independent' => 'Yes', 'Capital' => 'Managua', 'Continent' => 'NA', 'TLD' => '.ni', 'Languages' => 'es-NI,en', 'Geo_Name_ID' => '3617476', 'EDGAR' => 'Q3', '' => '', 'currency_symbol' => 'NIO', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '157'),
            159 => array('Country_Name' => 'Niger', 'Official_Name_English' => 'Niger', 'ISO3166_1_Alpha_2' => 'NE', 'ISO3166_1_Alpha_3' => 'NER', 'M49' => '562', 'ITU' => 'NGR', 'MARC' => 'ng', 'WMO' => 'NR', 'DS' => 'RN', 'Dial' => '227', 'FIFA' => 'NIG', 'FIPS' => 'NG', 'GAUL' => '181', 'IOC' => 'NIG', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'NIGER', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Niamey', 'Continent' => 'AF', 'TLD' => '.ne', 'Languages' => 'fr-NE,ha,kr,dje', 'Geo_Name_ID' => '2440476', 'EDGAR' => 'Q4', '' => '', 'currency_symbol' => 'XOF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '158'),
            160 => array('Country_Name' => 'Nigeria', 'Official_Name_English' => 'Nigeria', 'ISO3166_1_Alpha_2' => 'NG', 'ISO3166_1_Alpha_3' => 'NGA', 'M49' => '566', 'ITU' => 'NIG', 'MARC' => 'nr', 'WMO' => 'NI', 'DS' => 'WAN', 'Dial' => '234', 'FIFA' => 'NGA', 'FIPS' => 'NI', 'GAUL' => '182', 'IOC' => 'NGR', 'ISO4217_Currency_Alphabetic_Code' => 'NGN', 'ISO4217_Currency_Country_Name' => 'NIGERIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Naira', 'ISO4217_Currency_Numeric_Code' => '566', 'Is_Independent' => 'Yes', 'Capital' => 'Abuja', 'Continent' => 'AF', 'TLD' => '.ng', 'Languages' => 'en-NG,ha,yo,ig,ff', 'Geo_Name_ID' => '2328926', 'EDGAR' => 'Q5', '' => '', 'currency_symbol' => 'NGN', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '159'),
            161 => array('Country_Name' => 'Niue', 'Official_Name_English' => 'Niue', 'ISO3166_1_Alpha_2' => 'NU', 'ISO3166_1_Alpha_3' => 'NIU', 'M49' => '570', 'ITU' => 'NIU', 'MARC' => 'xh', 'WMO' => '', 'DS' => 'NZ', 'Dial' => '683', 'FIFA' => 'NIU', 'FIPS' => 'NE', 'GAUL' => '183', 'IOC' => 'NIU', 'ISO4217_Currency_Alphabetic_Code' => 'NZD', 'ISO4217_Currency_Country_Name' => 'NIUE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Zealand Dollar', 'ISO4217_Currency_Numeric_Code' => '554', 'Is_Independent' => 'Associated with NZ', 'Capital' => 'Alofi', 'Continent' => 'OC', 'TLD' => '.nu', 'Languages' => 'niu,en-NU', 'Geo_Name_ID' => '4036232', 'EDGAR' => 'Q6', '' => '', 'currency_symbol' => 'NZD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '160'),
            162 => array('Country_Name' => 'Norfolk Island', 'Official_Name_English' => 'Norfolk Island', 'ISO3166_1_Alpha_2' => 'NF', 'ISO3166_1_Alpha_3' => 'NFK', 'M49' => '574', 'ITU' => 'NFK', 'MARC' => 'nx', 'WMO' => 'NF', 'DS' => 'AUS', 'Dial' => '672', 'FIFA' => 'NFK', 'FIPS' => 'NF', 'GAUL' => '184', 'IOC' => 'NFI', 'ISO4217_Currency_Alphabetic_Code' => 'AUD', 'ISO4217_Currency_Country_Name' => 'NORFOLK ISLAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Australian Dollar', 'ISO4217_Currency_Numeric_Code' => '36', 'Is_Independent' => 'Territory of AU', 'Capital' => 'Kingston', 'Continent' => 'OC', 'TLD' => '.nf', 'Languages' => 'en-NF', 'Geo_Name_ID' => '2155115', 'EDGAR' => 'Q7', '' => '', 'currency_symbol' => 'AUD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '161'),
            163 => array('Country_Name' => 'North Korea', 'Official_Name_English' => 'Democratic People\'s Republic of Korea', 'ISO3166_1_Alpha_2' => 'KP', 'ISO3166_1_Alpha_3' => 'PRK', 'M49' => '408', 'ITU' => 'KRE', 'MARC' => 'kn', 'WMO' => 'KR', 'DS' => '', 'Dial' => '850', 'FIFA' => 'PRK', 'FIPS' => 'KN', 'GAUL' => '67', 'IOC' => 'PRK', 'ISO4217_Currency_Alphabetic_Code' => 'KPW', 'ISO4217_Currency_Country_Name' => 'KOREA, DEMOCRATIC PEOPLEâ€™S REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'North Korean Won', 'ISO4217_Currency_Numeric_Code' => '408', 'Is_Independent' => 'Yes', 'Capital' => 'Pyongyang', 'Continent' => 'AS', 'TLD' => '.kp', 'Languages' => 'ko-KP', 'Geo_Name_ID' => '1873107', 'EDGAR' => '', '' => '', 'currency_symbol' => 'KPW', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '162'),
            164 => array('Country_Name' => 'Northern Mariana Islands', 'Official_Name_English' => 'Northern Mariana Islands', 'ISO3166_1_Alpha_2' => 'MP', 'ISO3166_1_Alpha_3' => 'MNP', 'M49' => '580', 'ITU' => 'MRA', 'MARC' => 'nw', 'WMO' => 'MY', 'DS' => 'USA', 'Dial' => '670', 'FIFA' => 'NMI', 'FIPS' => 'CQ', 'GAUL' => '185', 'IOC' => 'NMA', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'NORTHERN MARIANA ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Commonwealth of US', 'Capital' => 'Saipan', 'Continent' => 'OC', 'TLD' => '.mp', 'Languages' => 'fil,tl,zh,ch-MP,en-MP', 'Geo_Name_ID' => '4041468', 'EDGAR' => '1V', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '163'),
            165 => array('Country_Name' => 'Norway', 'Official_Name_English' => 'Norway', 'ISO3166_1_Alpha_2' => 'NO', 'ISO3166_1_Alpha_3' => 'NOR', 'M49' => '578', 'ITU' => 'NOR', 'MARC' => 'no', 'WMO' => 'NO', 'DS' => 'N', 'Dial' => '47', 'FIFA' => 'NOR', 'FIPS' => 'NO', 'GAUL' => '186', 'IOC' => 'NOR', 'ISO4217_Currency_Alphabetic_Code' => 'NOK', 'ISO4217_Currency_Country_Name' => 'NORWAY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Norwegian Krone', 'ISO4217_Currency_Numeric_Code' => '578', 'Is_Independent' => 'Yes', 'Capital' => 'Oslo', 'Continent' => 'EU', 'TLD' => '.no', 'Languages' => 'no,nb,nn,se,fi', 'Geo_Name_ID' => '3144096', 'EDGAR' => 'Q8', '' => '', 'currency_symbol' => 'NOK', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '164'),
            166 => array('Country_Name' => 'Oman', 'Official_Name_English' => 'Oman', 'ISO3166_1_Alpha_2' => 'OM', 'ISO3166_1_Alpha_3' => 'OMN', 'M49' => '512', 'ITU' => 'OMA', 'MARC' => 'mk', 'WMO' => 'OM', 'DS' => '', 'Dial' => '968', 'FIFA' => 'OMA', 'FIPS' => 'MU', 'GAUL' => '187', 'IOC' => 'OMA', 'ISO4217_Currency_Alphabetic_Code' => 'OMR', 'ISO4217_Currency_Country_Name' => 'OMAN', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Rial Omani', 'ISO4217_Currency_Numeric_Code' => '512', 'Is_Independent' => 'Yes', 'Capital' => 'Muscat', 'Continent' => 'AS', 'TLD' => '.om', 'Languages' => 'ar-OM,en,bal,ur', 'Geo_Name_ID' => '286963', 'EDGAR' => 'P4', '' => '', 'currency_symbol' => 'OMR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '165'),
            167 => array('Country_Name' => 'Pakistan', 'Official_Name_English' => 'Pakistan', 'ISO3166_1_Alpha_2' => 'PK', 'ISO3166_1_Alpha_3' => 'PAK', 'M49' => '586', 'ITU' => 'PAK', 'MARC' => 'pk', 'WMO' => 'PK', 'DS' => 'PK', 'Dial' => '92', 'FIFA' => 'PAK', 'FIPS' => 'PK', 'GAUL' => '188', 'IOC' => 'PAK', 'ISO4217_Currency_Alphabetic_Code' => 'PKR', 'ISO4217_Currency_Country_Name' => 'PAKISTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pakistan Rupee', 'ISO4217_Currency_Numeric_Code' => '586', 'Is_Independent' => 'Yes', 'Capital' => 'Islamabad', 'Continent' => 'AS', 'TLD' => '.pk', 'Languages' => 'ur-PK,en-PK,pa,sd,ps,brh', 'Geo_Name_ID' => '1168579', 'EDGAR' => 'R0', '' => '', 'currency_symbol' => 'PKR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '166'),
            168 => array('Country_Name' => 'Palau', 'Official_Name_English' => 'Palau', 'ISO3166_1_Alpha_2' => 'PW', 'ISO3166_1_Alpha_3' => 'PLW', 'M49' => '585', 'ITU' => 'PLW', 'MARC' => 'pw', 'WMO' => '', 'DS' => '', 'Dial' => '680', 'FIFA' => 'PLW', 'FIPS' => 'PS', 'GAUL' => '189', 'IOC' => 'PLW', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'PALAU', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Melekeok', 'Continent' => 'OC', 'TLD' => '.pw', 'Languages' => 'pau,sov,en-PW,tox,ja,fil,zh', 'Geo_Name_ID' => '1559582', 'EDGAR' => '1Y', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '167'),
            169 => array('Country_Name' => 'Palestine', 'Official_Name_English' => 'State of Palestine', 'ISO3166_1_Alpha_2' => 'PS', 'ISO3166_1_Alpha_3' => 'PSE', 'M49' => '275', 'ITU' => '', 'MARC' => 'gz,wj', 'WMO' => '', 'DS' => '', 'Dial' => '970', 'FIFA' => 'PLE', 'FIPS' => 'GZ,WE', 'GAUL' => '91,267', 'IOC' => 'PLE', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => 'PALESTINE, STATE OF', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => 'No universal currency', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'In contention', 'Capital' => 'East Jerusalem', 'Continent' => 'AS', 'TLD' => '.ps', 'Languages' => 'ar-PS', 'Geo_Name_ID' => '6254930', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '168'),
            170 => array('Country_Name' => 'Panama', 'Official_Name_English' => 'Panama', 'ISO3166_1_Alpha_2' => 'PA', 'ISO3166_1_Alpha_3' => 'PAN', 'M49' => '591', 'ITU' => 'PNR', 'MARC' => 'pn', 'WMO' => 'PM', 'DS' => 'PA', 'Dial' => '507', 'FIFA' => 'PAN', 'FIPS' => 'PM', 'GAUL' => '191', 'IOC' => 'PAN', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'PANAMA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Panama City', 'Continent' => 'NA', 'TLD' => '.pa', 'Languages' => 'es-PA,en', 'Geo_Name_ID' => '3703430', 'EDGAR' => 'R1', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '169'),
            171 => array('Country_Name' => 'Papua New Guinea', 'Official_Name_English' => 'Papua New Guinea', 'ISO3166_1_Alpha_2' => 'PG', 'ISO3166_1_Alpha_3' => 'PNG', 'M49' => '598', 'ITU' => 'PNG', 'MARC' => 'pp', 'WMO' => 'NG', 'DS' => 'PNG', 'Dial' => '675', 'FIFA' => 'PNG', 'FIPS' => 'PP', 'GAUL' => '192', 'IOC' => 'PNG', 'ISO4217_Currency_Alphabetic_Code' => 'PGK', 'ISO4217_Currency_Country_Name' => 'PAPUA NEW GUINEA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Kina', 'ISO4217_Currency_Numeric_Code' => '598', 'Is_Independent' => 'Yes', 'Capital' => 'Port Moresby', 'Continent' => 'OC', 'TLD' => '.pg', 'Languages' => 'en-PG,ho,meu,tpi', 'Geo_Name_ID' => '2088628', 'EDGAR' => 'R2', '' => '', 'currency_symbol' => 'PGK', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '170'),
            172 => array('Country_Name' => 'Paraguay', 'Official_Name_English' => 'Paraguay', 'ISO3166_1_Alpha_2' => 'PY', 'ISO3166_1_Alpha_3' => 'PRY', 'M49' => '600', 'ITU' => 'PRG', 'MARC' => 'py', 'WMO' => 'PY', 'DS' => 'PY', 'Dial' => '595', 'FIFA' => 'PAR', 'FIPS' => 'PA', 'GAUL' => '194', 'IOC' => 'PAR', 'ISO4217_Currency_Alphabetic_Code' => 'PYG', 'ISO4217_Currency_Country_Name' => 'PARAGUAY', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Guarani', 'ISO4217_Currency_Numeric_Code' => '600', 'Is_Independent' => 'Yes', 'Capital' => 'Asuncion', 'Continent' => 'SA', 'TLD' => '.py', 'Languages' => 'es-PY,gn', 'Geo_Name_ID' => '3437598', 'EDGAR' => 'R4', '' => '', 'currency_symbol' => 'PYG', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '171'),
            173 => array('Country_Name' => 'Peru', 'Official_Name_English' => 'Peru', 'ISO3166_1_Alpha_2' => 'PE', 'ISO3166_1_Alpha_3' => 'PER', 'M49' => '604', 'ITU' => 'PRU', 'MARC' => 'pe', 'WMO' => 'PR', 'DS' => 'PE', 'Dial' => '51', 'FIFA' => 'PER', 'FIPS' => 'PE', 'GAUL' => '195', 'IOC' => 'PER', 'ISO4217_Currency_Alphabetic_Code' => 'PEN', 'ISO4217_Currency_Country_Name' => 'PERU', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Nuevo Sol', 'ISO4217_Currency_Numeric_Code' => '604', 'Is_Independent' => 'Yes', 'Capital' => 'Lima', 'Continent' => 'SA', 'TLD' => '.pe', 'Languages' => 'es-PE,qu,ay', 'Geo_Name_ID' => '3932488', 'EDGAR' => 'R5', '' => '', 'currency_symbol' => 'PEN', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '172'),
            174 => array('Country_Name' => 'Philippines', 'Official_Name_English' => 'Philippines', 'ISO3166_1_Alpha_2' => 'PH', 'ISO3166_1_Alpha_3' => 'PHL', 'M49' => '608', 'ITU' => 'PHL', 'MARC' => 'ph', 'WMO' => 'PH', 'DS' => 'RP', 'Dial' => '63', 'FIFA' => 'PHI', 'FIPS' => 'RP', 'GAUL' => '196', 'IOC' => 'PHI', 'ISO4217_Currency_Alphabetic_Code' => 'PHP', 'ISO4217_Currency_Country_Name' => 'PHILIPPINES', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Philippine Peso', 'ISO4217_Currency_Numeric_Code' => '608', 'Is_Independent' => 'Yes', 'Capital' => 'Manila', 'Continent' => 'AS', 'TLD' => '.ph', 'Languages' => 'tl,en-PH,fil', 'Geo_Name_ID' => '1694008', 'EDGAR' => 'R6', '' => '', 'currency_symbol' => 'PHP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '173'),
            175 => array('Country_Name' => 'Pitcairn Islands', 'Official_Name_English' => 'Pitcairn', 'ISO3166_1_Alpha_2' => 'PN', 'ISO3166_1_Alpha_3' => 'PCN', 'M49' => '612', 'ITU' => 'PTC', 'MARC' => 'pc', 'WMO' => 'PT', 'DS' => '', 'Dial' => '870', 'FIFA' => 'PCN', 'FIPS' => 'PC', 'GAUL' => '197', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'NZD', 'ISO4217_Currency_Country_Name' => 'PITCAIRN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Zealand Dollar', 'ISO4217_Currency_Numeric_Code' => '554', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Adamstown', 'Continent' => 'OC', 'TLD' => '.pn', 'Languages' => 'en-PN', 'Geo_Name_ID' => '4030699', 'EDGAR' => 'R8', '' => '', 'currency_symbol' => 'NZD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '174'),
            176 => array('Country_Name' => 'Poland', 'Official_Name_English' => 'Poland', 'ISO3166_1_Alpha_2' => 'PL', 'ISO3166_1_Alpha_3' => 'POL', 'M49' => '616', 'ITU' => 'POL', 'MARC' => 'pl', 'WMO' => 'PL', 'DS' => 'PL', 'Dial' => '48', 'FIFA' => 'POL', 'FIPS' => 'PL', 'GAUL' => '198', 'IOC' => 'POL', 'ISO4217_Currency_Alphabetic_Code' => 'PLN', 'ISO4217_Currency_Country_Name' => 'POLAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Zloty', 'ISO4217_Currency_Numeric_Code' => '985', 'Is_Independent' => 'Yes', 'Capital' => 'Warsaw', 'Continent' => 'EU', 'TLD' => '.pl', 'Languages' => 'pl', 'Geo_Name_ID' => '798544', 'EDGAR' => 'R9', '' => '', 'currency_symbol' => 'PLN', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '175'),
            177 => array('Country_Name' => 'Portugal', 'Official_Name_English' => 'Portugal', 'ISO3166_1_Alpha_2' => 'PT', 'ISO3166_1_Alpha_3' => 'PRT', 'M49' => '620', 'ITU' => 'POR', 'MARC' => 'po', 'WMO' => 'PO', 'DS' => 'P', 'Dial' => '351', 'FIFA' => 'POR', 'FIPS' => 'PO', 'GAUL' => '199', 'IOC' => 'POR', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'PORTUGAL', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Lisbon', 'Continent' => 'EU', 'TLD' => '.pt', 'Languages' => 'pt-PT,mwl', 'Geo_Name_ID' => '2264397', 'EDGAR' => 'S1', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '176'),
            178 => array('Country_Name' => 'Puerto Rico', 'Official_Name_English' => 'Puerto Rico', 'ISO3166_1_Alpha_2' => 'PR', 'ISO3166_1_Alpha_3' => 'PRI', 'M49' => '630', 'ITU' => 'PTR', 'MARC' => 'pr', 'WMO' => 'PU', 'DS' => 'USA', 'Dial' => '1', 'FIFA' => 'PUR', 'FIPS' => 'RQ', 'GAUL' => '200', 'IOC' => 'PUR', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'PUERTO RICO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Commonwealth of US', 'Capital' => 'San Juan', 'Continent' => 'NA', 'TLD' => '.pr', 'Languages' => 'en-PR,es-PR', 'Geo_Name_ID' => '4566966', 'EDGAR' => 'PR', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '177'),
            179 => array('Country_Name' => 'Qatar', 'Official_Name_English' => 'Qatar', 'ISO3166_1_Alpha_2' => 'QA', 'ISO3166_1_Alpha_3' => 'QAT', 'M49' => '634', 'ITU' => 'QAT', 'MARC' => 'qa', 'WMO' => 'QT', 'DS' => 'Q', 'Dial' => '974', 'FIFA' => 'QAT', 'FIPS' => 'QA', 'GAUL' => '201', 'IOC' => 'QAT', 'ISO4217_Currency_Alphabetic_Code' => 'QAR', 'ISO4217_Currency_Country_Name' => 'QATAR', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Qatari Rial', 'ISO4217_Currency_Numeric_Code' => '634', 'Is_Independent' => 'Yes', 'Capital' => 'Doha', 'Continent' => 'AS', 'TLD' => '.qa', 'Languages' => 'ar-QA,es', 'Geo_Name_ID' => '289688', 'EDGAR' => 'S3', '' => '', 'currency_symbol' => 'QAR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '178'),
            180 => array('Country_Name' => 'Romania', 'Official_Name_English' => 'Romania', 'ISO3166_1_Alpha_2' => 'RO', 'ISO3166_1_Alpha_3' => 'ROU', 'M49' => '642', 'ITU' => 'ROU', 'MARC' => 'rm', 'WMO' => 'RO', 'DS' => 'RO', 'Dial' => '40', 'FIFA' => 'ROU', 'FIPS' => 'RO', 'GAUL' => '203', 'IOC' => 'ROU', 'ISO4217_Currency_Alphabetic_Code' => 'RON', 'ISO4217_Currency_Country_Name' => 'ROMANIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Romanian Leu', 'ISO4217_Currency_Numeric_Code' => '946', 'Is_Independent' => 'Yes', 'Capital' => 'Bucharest', 'Continent' => 'EU', 'TLD' => '.ro', 'Languages' => 'ro,hu,rom', 'Geo_Name_ID' => '798549', 'EDGAR' => 'S5', '' => '', 'currency_symbol' => 'RON', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '179'),
            181 => array('Country_Name' => 'Russia', 'Official_Name_English' => 'Russian Federation', 'ISO3166_1_Alpha_2' => 'RU', 'ISO3166_1_Alpha_3' => 'RUS', 'M49' => '643', 'ITU' => 'RUS', 'MARC' => 'ru', 'WMO' => 'RS', 'DS' => 'RUS', 'Dial' => '7', 'FIFA' => 'RUS', 'FIPS' => 'RS', 'GAUL' => '204', 'IOC' => 'RUS', 'ISO4217_Currency_Alphabetic_Code' => 'RUB', 'ISO4217_Currency_Country_Name' => 'RUSSIAN FEDERATION', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Russian Ruble', 'ISO4217_Currency_Numeric_Code' => '643', 'Is_Independent' => 'Yes', 'Capital' => 'Moscow', 'Continent' => 'EU', 'TLD' => '.ru', 'Languages' => 'ru,tt,xal,cau,ady,kv,ce,tyv,cv,udm,tut,mns,bua,myv,mdf,chm,ba,inh,tut,kbd,krc,ava,sah,nog', 'Geo_Name_ID' => '2017370', 'EDGAR' => '1Z', '' => '', 'currency_symbol' => 'RUB', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '180'),
            182 => array('Country_Name' => 'Rwanda', 'Official_Name_English' => 'Rwanda', 'ISO3166_1_Alpha_2' => 'RW', 'ISO3166_1_Alpha_3' => 'RWA', 'M49' => '646', 'ITU' => 'RRW', 'MARC' => 'rw', 'WMO' => 'RW', 'DS' => 'RWA', 'Dial' => '250', 'FIFA' => 'RWA', 'FIPS' => 'RW', 'GAUL' => '205', 'IOC' => 'RWA', 'ISO4217_Currency_Alphabetic_Code' => 'RWF', 'ISO4217_Currency_Country_Name' => 'RWANDA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Rwanda Franc', 'ISO4217_Currency_Numeric_Code' => '646', 'Is_Independent' => 'Yes', 'Capital' => 'Kigali', 'Continent' => 'AF', 'TLD' => '.rw', 'Languages' => 'rw,en-RW,fr-RW,sw', 'Geo_Name_ID' => '49518', 'EDGAR' => 'S6', '' => '', 'currency_symbol' => 'RWF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '181'),
            183 => array('Country_Name' => 'Réunion', 'Official_Name_English' => 'Réunion', 'ISO3166_1_Alpha_2' => 'RE', 'ISO3166_1_Alpha_3' => 'REU', 'M49' => '638', 'ITU' => 'REU', 'MARC' => 're', 'WMO' => 'RE', 'DS' => 'F', 'Dial' => '262', 'FIFA' => 'REU', 'FIPS' => 'RE', 'GAUL' => '206', 'IOC' => 'REU', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'RÉUNION', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Saint-Denis', 'Continent' => 'AF', 'TLD' => '.re', 'Languages' => 'fr-RE', 'Geo_Name_ID' => '935317', 'EDGAR' => '', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '182'),
            184 => array('Country_Name' => 'Samoa', 'Official_Name_English' => 'Samoa', 'ISO3166_1_Alpha_2' => 'WS', 'ISO3166_1_Alpha_3' => 'WSM', 'M49' => '882', 'ITU' => 'SMO', 'MARC' => 'ws', 'WMO' => 'ZM', 'DS' => 'WS', 'Dial' => '685', 'FIFA' => 'SAM', 'FIPS' => 'WS', 'GAUL' => '212', 'IOC' => 'SAM', 'ISO4217_Currency_Alphabetic_Code' => 'WST', 'ISO4217_Currency_Country_Name' => 'SAMOA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Tala', 'ISO4217_Currency_Numeric_Code' => '882', 'Is_Independent' => 'Yes', 'Capital' => 'Apia', 'Continent' => 'OC', 'TLD' => '.ws', 'Languages' => 'sm,en-WS', 'Geo_Name_ID' => '4034894', 'EDGAR' => 'Y0', '' => '', 'currency_symbol' => 'WST', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '183'),
            185 => array('Country_Name' => 'San Marino', 'Official_Name_English' => 'San Marino', 'ISO3166_1_Alpha_2' => 'SM', 'ISO3166_1_Alpha_3' => 'SMR', 'M49' => '674', 'ITU' => 'SMR', 'MARC' => 'sm', 'WMO' => '', 'DS' => 'RSM', 'Dial' => '378', 'FIFA' => 'SMR', 'FIPS' => 'SM', 'GAUL' => '213', 'IOC' => 'SMR', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SAN MARINO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'San Marino', 'Continent' => 'EU', 'TLD' => '.sm', 'Languages' => 'it-SM', 'Geo_Name_ID' => '3168068', 'EDGAR' => 'S8', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '184'),
            186 => array('Country_Name' => 'Saudi Arabia', 'Official_Name_English' => 'Saudi Arabia', 'ISO3166_1_Alpha_2' => 'SA', 'ISO3166_1_Alpha_3' => 'SAU', 'M49' => '682', 'ITU' => 'ARS', 'MARC' => 'su', 'WMO' => 'SD', 'DS' => 'SA', 'Dial' => '966', 'FIFA' => 'KSA', 'FIPS' => 'SA', 'GAUL' => '215', 'IOC' => 'KSA', 'ISO4217_Currency_Alphabetic_Code' => 'SAR', 'ISO4217_Currency_Country_Name' => 'SAUDI ARABIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Saudi Riyal', 'ISO4217_Currency_Numeric_Code' => '682', 'Is_Independent' => 'Yes', 'Capital' => 'Riyadh', 'Continent' => 'AS', 'TLD' => '.sa', 'Languages' => 'ar-SA', 'Geo_Name_ID' => '102358', 'EDGAR' => 'T0', '' => '', 'currency_symbol' => 'SAR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '185'),
            187 => array('Country_Name' => 'Senegal', 'Official_Name_English' => 'Senegal', 'ISO3166_1_Alpha_2' => 'SN', 'ISO3166_1_Alpha_3' => 'SEN', 'M49' => '686', 'ITU' => 'SEN', 'MARC' => 'sg', 'WMO' => 'SG', 'DS' => 'SN', 'Dial' => '221', 'FIFA' => 'SEN', 'FIPS' => 'SG', 'GAUL' => '217', 'IOC' => 'SEN', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'SENEGAL', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Dakar', 'Continent' => 'AF', 'TLD' => '.sn', 'Languages' => 'fr-SN,wo,fuc,mnk', 'Geo_Name_ID' => '2245662', 'EDGAR' => 'T1', '' => '', 'currency_symbol' => 'XOF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '186'),
            188 => array('Country_Name' => 'Serbia', 'Official_Name_English' => 'Serbia', 'ISO3166_1_Alpha_2' => 'RS', 'ISO3166_1_Alpha_3' => 'SRB', 'M49' => '688', 'ITU' => 'SRB', 'MARC' => 'rb', 'WMO' => 'YG', 'DS' => 'SRB', 'Dial' => '381 p', 'FIFA' => 'SRB', 'FIPS' => 'RI,KV', 'GAUL' => '2648', 'IOC' => 'SRB', 'ISO4217_Currency_Alphabetic_Code' => 'RSD', 'ISO4217_Currency_Country_Name' => 'SERBIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Serbian Dinar', 'ISO4217_Currency_Numeric_Code' => '941', 'Is_Independent' => 'Yes', 'Capital' => 'Belgrade', 'Continent' => 'EU', 'TLD' => '.rs', 'Languages' => 'sr,hu,bs,rom', 'Geo_Name_ID' => '6290252', 'EDGAR' => 'Z2', '' => '', 'currency_symbol' => 'RSD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '187'),
            189 => array('Country_Name' => 'Seychelles', 'Official_Name_English' => 'Seychelles', 'ISO3166_1_Alpha_2' => 'SC', 'ISO3166_1_Alpha_3' => 'SYC', 'M49' => '690', 'ITU' => 'SEY', 'MARC' => 'se', 'WMO' => 'SC', 'DS' => 'SY', 'Dial' => '248', 'FIFA' => 'SEY', 'FIPS' => 'SE', 'GAUL' => '220', 'IOC' => 'SEY', 'ISO4217_Currency_Alphabetic_Code' => 'SCR', 'ISO4217_Currency_Country_Name' => 'SEYCHELLES', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Seychelles Rupee', 'ISO4217_Currency_Numeric_Code' => '690', 'Is_Independent' => 'Yes', 'Capital' => 'Victoria', 'Continent' => 'AF', 'TLD' => '.sc', 'Languages' => 'en-SC,fr-SC', 'Geo_Name_ID' => '241170', 'EDGAR' => 'T2', '' => '', 'currency_symbol' => 'SCR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '188'),
            190 => array('Country_Name' => 'Sierra Leone', 'Official_Name_English' => 'Sierra Leone', 'ISO3166_1_Alpha_2' => 'SL', 'ISO3166_1_Alpha_3' => 'SLE', 'M49' => '694', 'ITU' => 'SRL', 'MARC' => 'sl', 'WMO' => 'SL', 'DS' => 'WAL', 'Dial' => '232', 'FIFA' => 'SLE', 'FIPS' => 'SL', 'GAUL' => '221', 'IOC' => 'SLE', 'ISO4217_Currency_Alphabetic_Code' => 'SLL', 'ISO4217_Currency_Country_Name' => 'SIERRA LEONE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Leone', 'ISO4217_Currency_Numeric_Code' => '694', 'Is_Independent' => 'Yes', 'Capital' => 'Freetown', 'Continent' => 'AF', 'TLD' => '.sl', 'Languages' => 'en-SL,men,tem', 'Geo_Name_ID' => '2403846', 'EDGAR' => 'T8', '' => '', 'currency_symbol' => 'SLL', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '189'),
            191 => array('Country_Name' => 'Singapore', 'Official_Name_English' => 'Singapore', 'ISO3166_1_Alpha_2' => 'SG', 'ISO3166_1_Alpha_3' => 'SGP', 'M49' => '702', 'ITU' => 'SNG', 'MARC' => 'si', 'WMO' => 'SR', 'DS' => 'SGP', 'Dial' => '65', 'FIFA' => 'SIN', 'FIPS' => 'SN', 'GAUL' => '222', 'IOC' => 'SIN', 'ISO4217_Currency_Alphabetic_Code' => 'SGD', 'ISO4217_Currency_Country_Name' => 'SINGAPORE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Singapore Dollar', 'ISO4217_Currency_Numeric_Code' => '702', 'Is_Independent' => 'Yes', 'Capital' => 'Singapore', 'Continent' => 'AS', 'TLD' => '.sg', 'Languages' => 'cmn,en-SG,ms-SG,ta-SG,zh-SG', 'Geo_Name_ID' => '1880251', 'EDGAR' => 'U0', '' => '', 'currency_symbol' => 'SGD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '190'),
            192 => array('Country_Name' => 'Sint Maarten', 'Official_Name_English' => 'Sint Maarten (Dutch part)', 'ISO3166_1_Alpha_2' => 'SX', 'ISO3166_1_Alpha_3' => 'SXM', 'M49' => '534', 'ITU' => '', 'MARC' => 'sn', 'WMO' => '', 'DS' => '', 'Dial' => '721', 'FIFA' => '', 'FIPS' => 'NN', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'ANG', 'ISO4217_Currency_Country_Name' => 'SINT MAARTEN (DUTCH PART)', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Netherlands Antillean Guilder', 'ISO4217_Currency_Numeric_Code' => '532', 'Is_Independent' => 'Part of NL', 'Capital' => 'Philipsburg', 'Continent' => 'NA', 'TLD' => '.sx', 'Languages' => 'nl,en', 'Geo_Name_ID' => '7609695', 'EDGAR' => '', '' => '', 'currency_symbol' => 'ANG', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '191'),
            193 => array('Country_Name' => 'Slovakia', 'Official_Name_English' => 'Slovakia', 'ISO3166_1_Alpha_2' => 'SK', 'ISO3166_1_Alpha_3' => 'SVK', 'M49' => '703', 'ITU' => 'SVK', 'MARC' => 'xo', 'WMO' => 'SQ', 'DS' => 'SK', 'Dial' => '421', 'FIFA' => 'SVK', 'FIPS' => 'LO', 'GAUL' => '223', 'IOC' => 'SVK', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SLOVAKIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Bratislava', 'Continent' => 'EU', 'TLD' => '.sk', 'Languages' => 'sk,hu', 'Geo_Name_ID' => '3057568', 'EDGAR' => '2B', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '192'),
            194 => array('Country_Name' => 'Slovenia', 'Official_Name_English' => 'Slovenia', 'ISO3166_1_Alpha_2' => 'SI', 'ISO3166_1_Alpha_3' => 'SVN', 'M49' => '705', 'ITU' => 'SVN', 'MARC' => 'xv', 'WMO' => 'LJ', 'DS' => 'SLO', 'Dial' => '386', 'FIFA' => 'SVN', 'FIPS' => 'SI', 'GAUL' => '224', 'IOC' => 'SLO', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SLOVENIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Ljubljana', 'Continent' => 'EU', 'TLD' => '.si', 'Languages' => 'sl,sh', 'Geo_Name_ID' => '3190538', 'EDGAR' => '2A', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '193'),
            195 => array('Country_Name' => 'Solomon Islands', 'Official_Name_English' => 'Solomon Islands', 'ISO3166_1_Alpha_2' => 'SB', 'ISO3166_1_Alpha_3' => 'SLB', 'M49' => '090', 'ITU' => 'SLM', 'MARC' => 'bp', 'WMO' => 'SO', 'DS' => 'SB', 'Dial' => '677', 'FIFA' => 'SOL', 'FIPS' => 'BP', 'GAUL' => '225', 'IOC' => 'SOL', 'ISO4217_Currency_Alphabetic_Code' => 'SBD', 'ISO4217_Currency_Country_Name' => 'SOLOMON ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Solomon Islands Dollar', 'ISO4217_Currency_Numeric_Code' => '90', 'Is_Independent' => 'Yes', 'Capital' => 'Honiara', 'Continent' => 'OC', 'TLD' => '.sb', 'Languages' => 'en-SB,tpi', 'Geo_Name_ID' => '2103350', 'EDGAR' => 'D7', '' => '', 'currency_symbol' => 'SBD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '194'),
            196 => array('Country_Name' => 'Somalia', 'Official_Name_English' => 'Somalia', 'ISO3166_1_Alpha_2' => 'SO', 'ISO3166_1_Alpha_3' => 'SOM', 'M49' => '706', 'ITU' => 'SOM', 'MARC' => 'so', 'WMO' => 'SI', 'DS' => 'SO', 'Dial' => '252', 'FIFA' => 'SOM', 'FIPS' => 'SO', 'GAUL' => '226', 'IOC' => 'SOM', 'ISO4217_Currency_Alphabetic_Code' => 'SOS', 'ISO4217_Currency_Country_Name' => 'SOMALIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Somali Shilling', 'ISO4217_Currency_Numeric_Code' => '706', 'Is_Independent' => 'Yes', 'Capital' => 'Mogadishu', 'Continent' => 'AF', 'TLD' => '.so', 'Languages' => 'so-SO,ar-SO,it,en-SO', 'Geo_Name_ID' => '51537', 'EDGAR' => 'U1', '' => '', 'currency_symbol' => 'SOS', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '195'),
            197 => array('Country_Name' => 'South Africa', 'Official_Name_English' => 'South Africa', 'ISO3166_1_Alpha_2' => 'ZA', 'ISO3166_1_Alpha_3' => 'ZAF', 'M49' => '710', 'ITU' => 'AFS', 'MARC' => 'sa', 'WMO' => 'ZA', 'DS' => 'ZA', 'Dial' => '27', 'FIFA' => 'RSA', 'FIPS' => 'SF', 'GAUL' => '227', 'IOC' => 'RSA', 'ISO4217_Currency_Alphabetic_Code' => 'ZAR', 'ISO4217_Currency_Country_Name' => 'SOUTH AFRICA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Rand', 'ISO4217_Currency_Numeric_Code' => '710', 'Is_Independent' => 'Yes', 'Capital' => 'Pretoria', 'Continent' => 'AF', 'TLD' => '.za', 'Languages' => 'zu,xh,af,nso,en-ZA,tn,st,ts,ss,ve,nr', 'Geo_Name_ID' => '953987', 'EDGAR' => 'T3', '' => '', 'currency_symbol' => 'ZAR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '196'),
            198 => array('Country_Name' => 'South Georgia & South Sandwich Islands', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'GS', 'ISO3166_1_Alpha_3' => 'SGS', 'M49' => '239', 'ITU' => '', 'MARC' => 'xs', 'WMO' => '', 'DS' => '', 'Dial' => '500', 'FIFA' => '', 'FIPS' => 'SX', 'GAUL' => '228', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Grytviken', 'Continent' => 'AN', 'TLD' => '.gs', 'Languages' => 'en', 'Geo_Name_ID' => '3474415', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '197'),
            199 => array('Country_Name' => 'South Korea', 'Official_Name_English' => 'Republic of Korea', 'ISO3166_1_Alpha_2' => 'KR', 'ISO3166_1_Alpha_3' => 'KOR', 'M49' => '410', 'ITU' => 'KOR', 'MARC' => 'ko', 'WMO' => 'KO', 'DS' => 'ROK', 'Dial' => '82', 'FIFA' => 'KOR', 'FIPS' => 'KS', 'GAUL' => '202', 'IOC' => 'KOR', 'ISO4217_Currency_Alphabetic_Code' => 'KRW', 'ISO4217_Currency_Country_Name' => 'KOREA, REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Won', 'ISO4217_Currency_Numeric_Code' => '410', 'Is_Independent' => 'Yes', 'Capital' => 'Seoul', 'Continent' => 'AS', 'TLD' => '.kr', 'Languages' => 'ko-KR,en', 'Geo_Name_ID' => '1835841', 'EDGAR' => 'M5', '' => '', 'currency_symbol' => 'KRW', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '198'),
            200 => array('Country_Name' => 'South Sudan', 'Official_Name_English' => 'South Sudan', 'ISO3166_1_Alpha_2' => 'SS', 'ISO3166_1_Alpha_3' => 'SSD', 'M49' => '728', 'ITU' => 'SSD', 'MARC' => 'sd', 'WMO' => '', 'DS' => '', 'Dial' => '211', 'FIFA' => '', 'FIPS' => 'OD', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'SSP', 'ISO4217_Currency_Country_Name' => 'SOUTH SUDAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'South Sudanese Pound', 'ISO4217_Currency_Numeric_Code' => '728', 'Is_Independent' => 'Yes', 'Capital' => 'Juba', 'Continent' => 'AF', 'TLD' => '', 'Languages' => 'en', 'Geo_Name_ID' => '7909807', 'EDGAR' => '', '' => '', 'currency_symbol' => 'SSP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '199'),
            201 => array('Country_Name' => 'Spain', 'Official_Name_English' => 'Spain', 'ISO3166_1_Alpha_2' => 'ES', 'ISO3166_1_Alpha_3' => 'ESP', 'M49' => '724', 'ITU' => 'E', 'MARC' => 'sp', 'WMO' => 'SP', 'DS' => 'E', 'Dial' => '34', 'FIFA' => 'ESP', 'FIPS' => 'SP', 'GAUL' => '229', 'IOC' => 'ESP', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SPAIN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Madrid', 'Continent' => 'EU', 'TLD' => '.es', 'Languages' => 'es-ES,ca,gl,eu,oc', 'Geo_Name_ID' => '2510769', 'EDGAR' => 'U3', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '200'),
            202 => array('Country_Name' => 'Sri Lanka', 'Official_Name_English' => 'Sri Lanka', 'ISO3166_1_Alpha_2' => 'LK', 'ISO3166_1_Alpha_3' => 'LKA', 'M49' => '144', 'ITU' => 'CLN', 'MARC' => 'ce', 'WMO' => 'SB', 'DS' => 'CL', 'Dial' => '94', 'FIFA' => 'SRI', 'FIPS' => 'CE', 'GAUL' => '231', 'IOC' => 'SRI', 'ISO4217_Currency_Alphabetic_Code' => 'LKR', 'ISO4217_Currency_Country_Name' => 'SRI LANKA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Sri Lanka Rupee', 'ISO4217_Currency_Numeric_Code' => '144', 'Is_Independent' => 'Yes', 'Capital' => 'Colombo', 'Continent' => 'AS', 'TLD' => '.lk', 'Languages' => 'si,ta,en', 'Geo_Name_ID' => '1227603', 'EDGAR' => 'F1', '' => '', 'currency_symbol' => 'LKR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '201'),
            203 => array('Country_Name' => 'Saint Barthélemy', 'Official_Name_English' => 'Saint Barthélemy', 'ISO3166_1_Alpha_2' => 'BL', 'ISO3166_1_Alpha_3' => 'BLM', 'M49' => '652', 'ITU' => '', 'MARC' => 'sc', 'WMO' => '', 'DS' => '', 'Dial' => '590', 'FIFA' => '', 'FIPS' => 'TB', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SAINT BARTHÃ‰LEMY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Gustavia', 'Continent' => 'NA', 'TLD' => '.gp', 'Languages' => 'fr', 'Geo_Name_ID' => '3578476', 'EDGAR' => '', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '202'),
            204 => array('Country_Name' => 'St. Helena', 'Official_Name_English' => 'Saint Helena', 'ISO3166_1_Alpha_2' => 'SH', 'ISO3166_1_Alpha_3' => 'SHN', 'M49' => '654', 'ITU' => 'SHN', 'MARC' => 'xj', 'WMO' => 'HE', 'DS' => 'SH', 'Dial' => '290 n', 'FIFA' => 'SHN', 'FIPS' => 'SH', 'GAUL' => '207', 'IOC' => 'HEL', 'ISO4217_Currency_Alphabetic_Code' => 'SHP', 'ISO4217_Currency_Country_Name' => 'SAINT HELENA, ASCENSION AND TRISTAN DA CUNHA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Saint Helena Pound', 'ISO4217_Currency_Numeric_Code' => '654', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Jamestown', 'Continent' => 'AF', 'TLD' => '.sh', 'Languages' => 'en-SH', 'Geo_Name_ID' => '3370751', 'EDGAR' => '', '' => '', 'currency_symbol' => 'SHP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '203'),
            205 => array('Country_Name' => 'St. Kitts & Nevis', 'Official_Name_English' => 'Saint Kitts and Nevis', 'ISO3166_1_Alpha_2' => 'KN', 'ISO3166_1_Alpha_3' => 'KNA', 'M49' => '659', 'ITU' => 'KNA', 'MARC' => 'xd', 'WMO' => 'AT', 'DS' => 'KN', 'Dial' => '869', 'FIFA' => 'SKN', 'FIPS' => 'SC', 'GAUL' => '208', 'IOC' => 'SKN', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'SAINT KITTS AND NEVIS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Yes', 'Capital' => 'Basseterre', 'Continent' => 'NA', 'TLD' => '.kn', 'Languages' => 'en-KN', 'Geo_Name_ID' => '3575174', 'EDGAR' => 'U7', '' => '', 'currency_symbol' => 'XCD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '204'),
            206 => array('Country_Name' => 'St. Lucia', 'Official_Name_English' => 'Saint Lucia', 'ISO3166_1_Alpha_2' => 'LC', 'ISO3166_1_Alpha_3' => 'LCA', 'M49' => '662', 'ITU' => 'LCA', 'MARC' => 'xk', 'WMO' => 'LC', 'DS' => 'WL', 'Dial' => '758', 'FIFA' => 'LCA', 'FIPS' => 'ST', 'GAUL' => '209', 'IOC' => 'LCA', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'SAINT LUCIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Yes', 'Capital' => 'Castries', 'Continent' => 'NA', 'TLD' => '.lc', 'Languages' => 'en-LC', 'Geo_Name_ID' => '3576468', 'EDGAR' => 'U9', '' => '', 'currency_symbol' => 'XCD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '205'),
            207 => array('Country_Name' => 'St. Martin', 'Official_Name_English' => 'Saint Martin (French part)', 'ISO3166_1_Alpha_2' => 'MF', 'ISO3166_1_Alpha_3' => 'MAF', 'M49' => '663', 'ITU' => '', 'MARC' => 'st', 'WMO' => '', 'DS' => '', 'Dial' => '590', 'FIFA' => '', 'FIPS' => 'RN', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SAINT MARTIN (FRENCH PART)', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Marigot', 'Continent' => 'NA', 'TLD' => '.gp', 'Languages' => 'fr', 'Geo_Name_ID' => '3578421', 'EDGAR' => '', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '206'),
            208 => array('Country_Name' => 'St. Pierre & Miquelon', 'Official_Name_English' => 'Saint Pierre and Miquelon', 'ISO3166_1_Alpha_2' => 'PM', 'ISO3166_1_Alpha_3' => 'SPM', 'M49' => '666', 'ITU' => 'SPM', 'MARC' => 'xl', 'WMO' => 'FP', 'DS' => 'F', 'Dial' => '508', 'FIFA' => 'SPM', 'FIPS' => 'SB', 'GAUL' => '210', 'IOC' => 'SPM', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'SAINT PIERRE AND MIQUELON', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FR', 'Capital' => 'Saint-Pierre', 'Continent' => 'NA', 'TLD' => '.pm', 'Languages' => 'fr-PM', 'Geo_Name_ID' => '3424932', 'EDGAR' => 'V0', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '207'),
            209 => array('Country_Name' => 'St. Vincent & Grenadines', 'Official_Name_English' => 'Saint Vincent and the Grenadines', 'ISO3166_1_Alpha_2' => 'VC', 'ISO3166_1_Alpha_3' => 'VCT', 'M49' => '670', 'ITU' => 'VCT', 'MARC' => 'xm', 'WMO' => 'VG', 'DS' => 'WV', 'Dial' => '784', 'FIFA' => 'VIN', 'FIPS' => 'VC', 'GAUL' => '211', 'IOC' => 'VIN', 'ISO4217_Currency_Alphabetic_Code' => 'XCD', 'ISO4217_Currency_Country_Name' => 'SAINT VINCENT AND THE GRENADINES', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'East Caribbean Dollar', 'ISO4217_Currency_Numeric_Code' => '951', 'Is_Independent' => 'Yes', 'Capital' => 'Kingstown', 'Continent' => 'NA', 'TLD' => '.vc', 'Languages' => 'en-VC,fr', 'Geo_Name_ID' => '3577815', 'EDGAR' => 'V1', '' => '', 'currency_symbol' => 'XCD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '208'),
            210 => array('Country_Name' => 'Sudan', 'Official_Name_English' => 'Sudan', 'ISO3166_1_Alpha_2' => 'SD', 'ISO3166_1_Alpha_3' => 'SDN', 'M49' => '729', 'ITU' => 'SDN', 'MARC' => 'sj', 'WMO' => 'SU', 'DS' => 'SUD', 'Dial' => '249', 'FIFA' => 'SUD', 'FIPS' => 'SU', 'GAUL' => '40764', 'IOC' => 'SUD', 'ISO4217_Currency_Alphabetic_Code' => 'SDG', 'ISO4217_Currency_Country_Name' => 'SUDAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Sudanese Pound', 'ISO4217_Currency_Numeric_Code' => '938', 'Is_Independent' => 'Yes', 'Capital' => 'Khartoum', 'Continent' => 'AF', 'TLD' => '.sd', 'Languages' => 'ar-SD,en,fia', 'Geo_Name_ID' => '366755', 'EDGAR' => 'V2', '' => '', 'currency_symbol' => 'SDG', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '209'),
            211 => array('Country_Name' => 'Suriname', 'Official_Name_English' => 'Suriname', 'ISO3166_1_Alpha_2' => 'SR', 'ISO3166_1_Alpha_3' => 'SUR', 'M49' => '740', 'ITU' => 'SUR', 'MARC' => 'sr', 'WMO' => 'SM', 'DS' => 'SME', 'Dial' => '597', 'FIFA' => 'SUR', 'FIPS' => 'NS', 'GAUL' => '233', 'IOC' => 'SUR', 'ISO4217_Currency_Alphabetic_Code' => 'SRD', 'ISO4217_Currency_Country_Name' => 'SURINAME', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Surinam Dollar', 'ISO4217_Currency_Numeric_Code' => '968', 'Is_Independent' => 'Yes', 'Capital' => 'Paramaribo', 'Continent' => 'SA', 'TLD' => '.sr', 'Languages' => 'nl-SR,en,srn,hns,jv', 'Geo_Name_ID' => '3382998', 'EDGAR' => 'V3', '' => '', 'currency_symbol' => 'SRD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '210'),
            212 => array('Country_Name' => 'Svalbard & Jan Mayen', 'Official_Name_English' => 'Svalbard and Jan Mayen Islands', 'ISO3166_1_Alpha_2' => 'SJ', 'ISO3166_1_Alpha_3' => 'SJM', 'M49' => '744', 'ITU' => 'NOR', 'MARC' => '', 'WMO' => 'SZ', 'DS' => '', 'Dial' => '47', 'FIFA' => '', 'FIPS' => 'SV,JN', 'GAUL' => '234', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'NOK', 'ISO4217_Currency_Country_Name' => 'SVALBARD AND JAN MAYEN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Norwegian Krone', 'ISO4217_Currency_Numeric_Code' => '578', 'Is_Independent' => 'Territory of NO', 'Capital' => 'Longyearbyen', 'Continent' => 'EU', 'TLD' => '.sj', 'Languages' => 'no,ru', 'Geo_Name_ID' => '607072', 'EDGAR' => 'L9', '' => '', 'currency_symbol' => 'NOK', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '211'),
            213 => array('Country_Name' => 'Swaziland', 'Official_Name_English' => 'Swaziland', 'ISO3166_1_Alpha_2' => 'SZ', 'ISO3166_1_Alpha_3' => 'SWZ', 'M49' => '748', 'ITU' => 'SWZ', 'MARC' => 'sq', 'WMO' => 'SV', 'DS' => 'SD', 'Dial' => '268', 'FIFA' => 'SWZ', 'FIPS' => 'WZ', 'GAUL' => '235', 'IOC' => 'SWZ', 'ISO4217_Currency_Alphabetic_Code' => 'SZL', 'ISO4217_Currency_Country_Name' => 'SWAZILAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Lilangeni', 'ISO4217_Currency_Numeric_Code' => '748', 'Is_Independent' => 'Yes', 'Capital' => 'Mbabane', 'Continent' => 'AF', 'TLD' => '.sz', 'Languages' => 'en-SZ,ss-SZ', 'Geo_Name_ID' => '934841', 'EDGAR' => 'V6', '' => '', 'currency_symbol' => 'SZL', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '212'),
            214 => array('Country_Name' => 'Sweden', 'Official_Name_English' => 'Sweden', 'ISO3166_1_Alpha_2' => 'SE', 'ISO3166_1_Alpha_3' => 'SWE', 'M49' => '752', 'ITU' => 'S', 'MARC' => 'sw', 'WMO' => 'SN', 'DS' => 'S', 'Dial' => '46', 'FIFA' => 'SWE', 'FIPS' => 'SW', 'GAUL' => '236', 'IOC' => 'SWE', 'ISO4217_Currency_Alphabetic_Code' => 'SEK', 'ISO4217_Currency_Country_Name' => 'SWEDEN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Swedish Krona', 'ISO4217_Currency_Numeric_Code' => '752', 'Is_Independent' => 'Yes', 'Capital' => 'Stockholm', 'Continent' => 'EU', 'TLD' => '.se', 'Languages' => 'sv-SE,se,sma,fi-SE', 'Geo_Name_ID' => '2661886', 'EDGAR' => 'V7', '' => '', 'currency_symbol' => 'SEK', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '213'),
            215 => array('Country_Name' => 'Switzerland', 'Official_Name_English' => 'Switzerland', 'ISO3166_1_Alpha_2' => 'CH', 'ISO3166_1_Alpha_3' => 'CHE', 'M49' => '756', 'ITU' => 'SUI', 'MARC' => 'sz', 'WMO' => 'SW', 'DS' => 'CH', 'Dial' => '41', 'FIFA' => 'SUI', 'FIPS' => 'SZ', 'GAUL' => '237', 'IOC' => 'SUI', 'ISO4217_Currency_Alphabetic_Code' => 'CHF', 'ISO4217_Currency_Country_Name' => 'SWITZERLAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Swiss Franc', 'ISO4217_Currency_Numeric_Code' => '756', 'Is_Independent' => 'Yes', 'Capital' => 'Bern', 'Continent' => 'EU', 'TLD' => '.ch', 'Languages' => 'de-CH,fr-CH,it-CH,rm', 'Geo_Name_ID' => '2658434', 'EDGAR' => 'V8', '' => '', 'currency_symbol' => 'CHF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '214'),
            216 => array('Country_Name' => 'Syria', 'Official_Name_English' => 'Syrian Arab Republic', 'ISO3166_1_Alpha_2' => 'SY', 'ISO3166_1_Alpha_3' => 'SYR', 'M49' => '760', 'ITU' => 'SYR', 'MARC' => 'sy', 'WMO' => 'SY', 'DS' => 'SYR', 'Dial' => '963', 'FIFA' => 'SYR', 'FIPS' => 'SY', 'GAUL' => '238', 'IOC' => 'SYR', 'ISO4217_Currency_Alphabetic_Code' => 'SYP', 'ISO4217_Currency_Country_Name' => 'SYRIAN ARAB REPUBLIC', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Syrian Pound', 'ISO4217_Currency_Numeric_Code' => '760', 'Is_Independent' => 'Yes', 'Capital' => 'Damascus', 'Continent' => 'AS', 'TLD' => '.sy', 'Languages' => 'ar-SY,ku,hy,arc,fr,en', 'Geo_Name_ID' => '163843', 'EDGAR' => 'V9', '' => '', 'currency_symbol' => 'SYP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '215'),
            217 => array('Country_Name' => 'Sao Tome and Principe', 'Official_Name_English' => 'Sao Tome and Principe', 'ISO3166_1_Alpha_2' => 'ST', 'ISO3166_1_Alpha_3' => 'STP', 'M49' => '678', 'ITU' => 'STP', 'MARC' => 'sf', 'WMO' => 'TP', 'DS' => 'ST', 'Dial' => '239', 'FIFA' => 'STP', 'FIPS' => 'TP', 'GAUL' => '214', 'IOC' => 'STP', 'ISO4217_Currency_Alphabetic_Code' => 'STD', 'ISO4217_Currency_Country_Name' => 'SAO TOME AND PRINCIPE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Dobra', 'ISO4217_Currency_Numeric_Code' => '678', 'Is_Independent' => 'Yes', 'Capital' => 'Sao Tome', 'Continent' => 'AF', 'TLD' => '.st', 'Languages' => 'pt-ST', 'Geo_Name_ID' => '2410758', 'EDGAR' => 'S9', '' => '', 'currency_symbol' => 'STD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '216'),
            218 => array('Country_Name' => 'Taiwan', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'TW', 'ISO3166_1_Alpha_3' => 'TWN', 'M49' => '158', 'ITU' => '', 'MARC' => 'ch', 'WMO' => '', 'DS' => 'RC', 'Dial' => '886', 'FIFA' => 'TPE', 'FIPS' => 'TW', 'GAUL' => '925', 'IOC' => 'TPE', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Yes', 'Capital' => 'Taipei', 'Continent' => 'AS', 'TLD' => '.tw', 'Languages' => 'zh-TW,zh,nan,hak', 'Geo_Name_ID' => '1668284', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '217'),
            219 => array('Country_Name' => 'Tajikistan', 'Official_Name_English' => 'Tajikistan', 'ISO3166_1_Alpha_2' => 'TJ', 'ISO3166_1_Alpha_3' => 'TJK', 'M49' => '762', 'ITU' => 'TJK', 'MARC' => 'ta', 'WMO' => 'TA', 'DS' => 'TJ', 'Dial' => '992', 'FIFA' => 'TJK', 'FIPS' => 'TI', 'GAUL' => '239', 'IOC' => 'TJK', 'ISO4217_Currency_Alphabetic_Code' => 'TJS', 'ISO4217_Currency_Country_Name' => 'TAJIKISTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Somoni', 'ISO4217_Currency_Numeric_Code' => '972', 'Is_Independent' => 'Yes', 'Capital' => 'Dushanbe', 'Continent' => 'AS', 'TLD' => '.tj', 'Languages' => 'tg,ru', 'Geo_Name_ID' => '1220409', 'EDGAR' => '2D', '' => '', 'currency_symbol' => 'TJS', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '218'),
            220 => array('Country_Name' => 'Tanzania', 'Official_Name_English' => 'United Republic of Tanzania', 'ISO3166_1_Alpha_2' => 'TZ', 'ISO3166_1_Alpha_3' => 'TZA', 'M49' => '834', 'ITU' => 'TZA', 'MARC' => 'tz', 'WMO' => 'TN', 'DS' => 'EAT', 'Dial' => '255', 'FIFA' => 'TAN', 'FIPS' => 'TZ', 'GAUL' => '257', 'IOC' => 'TAN', 'ISO4217_Currency_Alphabetic_Code' => 'TZS', 'ISO4217_Currency_Country_Name' => 'TANZANIA, UNITED REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Tanzanian Shilling', 'ISO4217_Currency_Numeric_Code' => '834', 'Is_Independent' => 'Yes', 'Capital' => 'Dodoma', 'Continent' => 'AF', 'TLD' => '.tz', 'Languages' => 'sw-TZ,en,ar', 'Geo_Name_ID' => '149590', 'EDGAR' => 'W0', '' => '', 'currency_symbol' => 'TZS', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '219'),
            221 => array('Country_Name' => 'Thailand', 'Official_Name_English' => 'Thailand', 'ISO3166_1_Alpha_2' => 'TH', 'ISO3166_1_Alpha_3' => 'THA', 'M49' => '764', 'ITU' => 'THA', 'MARC' => 'th', 'WMO' => 'TH', 'DS' => 'T', 'Dial' => '66', 'FIFA' => 'THA', 'FIPS' => 'TH', 'GAUL' => '240', 'IOC' => 'THA', 'ISO4217_Currency_Alphabetic_Code' => 'THB', 'ISO4217_Currency_Country_Name' => 'THAILAND', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Baht', 'ISO4217_Currency_Numeric_Code' => '764', 'Is_Independent' => 'Yes', 'Capital' => 'Bangkok', 'Continent' => 'AS', 'TLD' => '.th', 'Languages' => 'th,en', 'Geo_Name_ID' => '1605651', 'EDGAR' => 'W1', '' => '', 'currency_symbol' => 'THB', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '220'),
            222 => array('Country_Name' => 'Timor-Leste', 'Official_Name_English' => 'Timor-Leste', 'ISO3166_1_Alpha_2' => 'TL', 'ISO3166_1_Alpha_3' => 'TLS', 'M49' => '626', 'ITU' => 'TLS', 'MARC' => 'em', 'WMO' => 'TM', 'DS' => 'RI', 'Dial' => '670', 'FIFA' => 'TLS', 'FIPS' => 'TT', 'GAUL' => '242', 'IOC' => 'TLS', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'TIMOR-LESTE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Dili', 'Continent' => 'OC', 'TLD' => '.tl', 'Languages' => 'tet,pt-TL,id,en', 'Geo_Name_ID' => '1966436', 'EDGAR' => 'Z3', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '221'),
            223 => array('Country_Name' => 'Togo', 'Official_Name_English' => 'Togo', 'ISO3166_1_Alpha_2' => 'TG', 'ISO3166_1_Alpha_3' => 'TGO', 'M49' => '768', 'ITU' => 'TGO', 'MARC' => 'tg', 'WMO' => 'TG', 'DS' => 'TG', 'Dial' => '228', 'FIFA' => 'TOG', 'FIPS' => 'TO', 'GAUL' => '243', 'IOC' => 'TOG', 'ISO4217_Currency_Alphabetic_Code' => 'XOF', 'ISO4217_Currency_Country_Name' => 'TOGO', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFA Franc BCEAO', 'ISO4217_Currency_Numeric_Code' => '952', 'Is_Independent' => 'Yes', 'Capital' => 'Lome', 'Continent' => 'AF', 'TLD' => '.tg', 'Languages' => 'fr-TG,ee,hna,kbp,dag,ha', 'Geo_Name_ID' => '2363686', 'EDGAR' => 'W2', '' => '', 'currency_symbol' => 'XOF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '222'),
            224 => array('Country_Name' => 'Tokelau', 'Official_Name_English' => 'Tokelau', 'ISO3166_1_Alpha_2' => 'TK', 'ISO3166_1_Alpha_3' => 'TKL', 'M49' => '772', 'ITU' => 'TKL', 'MARC' => 'tl', 'WMO' => 'TK', 'DS' => 'NZ', 'Dial' => '690', 'FIFA' => 'TKL', 'FIPS' => 'TL', 'GAUL' => '244', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'NZD', 'ISO4217_Currency_Country_Name' => 'TOKELAU', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'New Zealand Dollar', 'ISO4217_Currency_Numeric_Code' => '554', 'Is_Independent' => 'Territory of NZ', 'Capital' => '', 'Continent' => 'OC', 'TLD' => '.tk', 'Languages' => 'tkl,en-TK', 'Geo_Name_ID' => '4031074', 'EDGAR' => 'W3', '' => '', 'currency_symbol' => 'NZD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '223'),
            225 => array('Country_Name' => 'Tonga', 'Official_Name_English' => 'Tonga', 'ISO3166_1_Alpha_2' => 'TO', 'ISO3166_1_Alpha_3' => 'TON', 'M49' => '776', 'ITU' => 'TON', 'MARC' => 'to', 'WMO' => 'TO', 'DS' => 'TO', 'Dial' => '676', 'FIFA' => 'TGA', 'FIPS' => 'TN', 'GAUL' => '245', 'IOC' => 'TGA', 'ISO4217_Currency_Alphabetic_Code' => 'TOP', 'ISO4217_Currency_Country_Name' => 'TONGA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Paâ€™anga', 'ISO4217_Currency_Numeric_Code' => '776', 'Is_Independent' => 'Yes', 'Capital' => 'Nuku\'alofa', 'Continent' => 'OC', 'TLD' => '.to', 'Languages' => 'to,en-TO', 'Geo_Name_ID' => '4032283', 'EDGAR' => 'W4', '' => '', 'currency_symbol' => 'TOP', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '224'),
            226 => array('Country_Name' => 'Trinidad & Tobago', 'Official_Name_English' => 'Trinidad and Tobago', 'ISO3166_1_Alpha_2' => 'TT', 'ISO3166_1_Alpha_3' => 'TTO', 'M49' => '780', 'ITU' => 'TRD', 'MARC' => 'tr', 'WMO' => 'TD', 'DS' => 'TT', 'Dial' => '868', 'FIFA' => 'TRI', 'FIPS' => 'TD', 'GAUL' => '246', 'IOC' => 'TTO', 'ISO4217_Currency_Alphabetic_Code' => 'TTD', 'ISO4217_Currency_Country_Name' => 'TRINIDAD AND TOBAGO', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Trinidad and Tobago Dollar', 'ISO4217_Currency_Numeric_Code' => '780', 'Is_Independent' => 'Yes', 'Capital' => 'Port of Spain', 'Continent' => 'NA', 'TLD' => '.tt', 'Languages' => 'en-TT,hns,fr,es,zh', 'Geo_Name_ID' => '3573591', 'EDGAR' => 'W5', '' => '', 'currency_symbol' => 'TTD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '225'),
            227 => array('Country_Name' => 'Tunisia', 'Official_Name_English' => 'Tunisia', 'ISO3166_1_Alpha_2' => 'TN', 'ISO3166_1_Alpha_3' => 'TUN', 'M49' => '788', 'ITU' => 'TUN', 'MARC' => 'ti', 'WMO' => 'TS', 'DS' => 'TN', 'Dial' => '216', 'FIFA' => 'TUN', 'FIPS' => 'TS', 'GAUL' => '248', 'IOC' => 'TUN', 'ISO4217_Currency_Alphabetic_Code' => 'TND', 'ISO4217_Currency_Country_Name' => 'TUNISIA', 'ISO4217_Currency_Minor_Unit' => '3', 'ISO4217_Currency_Name' => 'Tunisian Dinar', 'ISO4217_Currency_Numeric_Code' => '788', 'Is_Independent' => 'Yes', 'Capital' => 'Tunis', 'Continent' => 'AF', 'TLD' => '.tn', 'Languages' => 'ar-TN,fr', 'Geo_Name_ID' => '2464461', 'EDGAR' => 'W6', '' => '', 'currency_symbol' => 'TND', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '226'),
            228 => array('Country_Name' => 'Turkey', 'Official_Name_English' => 'Turkey', 'ISO3166_1_Alpha_2' => 'TR', 'ISO3166_1_Alpha_3' => 'TUR', 'M49' => '792', 'ITU' => 'TUR', 'MARC' => 'tu', 'WMO' => 'TU', 'DS' => 'TR', 'Dial' => '90', 'FIFA' => 'TUR', 'FIPS' => 'TU', 'GAUL' => '249', 'IOC' => 'TUR', 'ISO4217_Currency_Alphabetic_Code' => 'TRY', 'ISO4217_Currency_Country_Name' => 'TURKEY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Turkish Lira', 'ISO4217_Currency_Numeric_Code' => '949', 'Is_Independent' => 'Yes', 'Capital' => 'Ankara', 'Continent' => 'AS', 'TLD' => '.tr', 'Languages' => 'tr-TR,ku,diq,az,av', 'Geo_Name_ID' => '298795', 'EDGAR' => 'W8', '' => '', 'currency_symbol' => 'TRY', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '227'),
            229 => array('Country_Name' => 'Turkmenistan', 'Official_Name_English' => 'Turkmenistan', 'ISO3166_1_Alpha_2' => 'TM', 'ISO3166_1_Alpha_3' => 'TKM', 'M49' => '795', 'ITU' => 'TKM', 'MARC' => 'tk', 'WMO' => 'TR', 'DS' => 'TM', 'Dial' => '993', 'FIFA' => 'TKM', 'FIPS' => 'TX', 'GAUL' => '250', 'IOC' => 'TKM', 'ISO4217_Currency_Alphabetic_Code' => 'TMT', 'ISO4217_Currency_Country_Name' => 'TURKMENISTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Turkmenistan New Manat', 'ISO4217_Currency_Numeric_Code' => '934', 'Is_Independent' => 'Yes', 'Capital' => 'Ashgabat', 'Continent' => 'AS', 'TLD' => '.tm', 'Languages' => 'tk,ru,uz', 'Geo_Name_ID' => '1218197', 'EDGAR' => '2E', '' => '', 'currency_symbol' => 'TMT', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '228'),
            230 => array('Country_Name' => 'Turks & Caicos Islands', 'Official_Name_English' => 'Turks and Caicos Islands', 'ISO3166_1_Alpha_2' => 'TC', 'ISO3166_1_Alpha_3' => 'TCA', 'M49' => '796', 'ITU' => 'TCA', 'MARC' => 'tc', 'WMO' => 'TI', 'DS' => '', 'Dial' => '649', 'FIFA' => 'TCA', 'FIPS' => 'TK', 'GAUL' => '251', 'IOC' => 'TKS', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'TURKS AND CAICOS ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Territory of GB', 'Capital' => 'Cockburn Town', 'Continent' => 'NA', 'TLD' => '.tc', 'Languages' => 'en-TC', 'Geo_Name_ID' => '3576916', 'EDGAR' => 'W7', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '229'),
            231 => array('Country_Name' => 'Tuvalu', 'Official_Name_English' => 'Tuvalu', 'ISO3166_1_Alpha_2' => 'TV', 'ISO3166_1_Alpha_3' => 'TUV', 'M49' => '798', 'ITU' => 'TUV', 'MARC' => 'tv', 'WMO' => 'TV', 'DS' => 'TV', 'Dial' => '688', 'FIFA' => 'TUV', 'FIPS' => 'TV', 'GAUL' => '252', 'IOC' => 'TUV', 'ISO4217_Currency_Alphabetic_Code' => 'AUD', 'ISO4217_Currency_Country_Name' => 'TUVALU', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Australian Dollar', 'ISO4217_Currency_Numeric_Code' => '36', 'Is_Independent' => 'Yes', 'Capital' => 'Funafuti', 'Continent' => 'OC', 'TLD' => '.tv', 'Languages' => 'tvl,en,sm,gil', 'Geo_Name_ID' => '2110297', 'EDGAR' => '2G', '' => '', 'currency_symbol' => 'AUD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '230'),
            232 => array('Country_Name' => 'U.S. Outlying Islands', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => 'UM', 'ISO3166_1_Alpha_3' => 'UMI', 'M49' => '581', 'ITU' => '', 'MARC' => 'ji,xf,wk,uc,up', 'WMO' => '', 'DS' => 'USA', 'Dial' => '', 'FIFA' => '', 'FIPS' => 'FQ,HQ,DQ,JQ,KQ,MQ,BQ,LQ,WQ', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => 'Territories of US', 'Capital' => '', 'Continent' => 'OC', 'TLD' => '.um', 'Languages' => 'en-UM', 'Geo_Name_ID' => '5854968', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '231'),
            233 => array('Country_Name' => 'U.S. Virgin Islands', 'Official_Name_English' => 'United States Virgin Islands', 'ISO3166_1_Alpha_2' => 'VI', 'ISO3166_1_Alpha_3' => 'VIR', 'M49' => '850', 'ITU' => 'VIR', 'MARC' => 'vi', 'WMO' => 'VI', 'DS' => 'USA', 'Dial' => '340', 'FIFA' => 'VIR', 'FIPS' => 'VQ', 'GAUL' => '258', 'IOC' => 'ISV', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'VIRGIN ISLANDS (U.S.)', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Territory of US', 'Capital' => 'Charlotte Amalie', 'Continent' => 'NA', 'TLD' => '.vi', 'Languages' => 'en-VI', 'Geo_Name_ID' => '4796775', 'EDGAR' => '', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '232'),
            234 => array('Country_Name' => 'UK', 'Official_Name_English' => 'United Kingdom of Great Britain and Northern Ireland', 'ISO3166_1_Alpha_2' => 'GB', 'ISO3166_1_Alpha_3' => 'GBR', 'M49' => '826', 'ITU' => 'G', 'MARC' => 'xxk', 'WMO' => 'UK', 'DS' => 'GB', 'Dial' => '44', 'FIFA' => 'ENG,NIR,SCO,WAL', 'FIPS' => 'UK', 'GAUL' => '256', 'IOC' => 'GBR', 'ISO4217_Currency_Alphabetic_Code' => 'GBP', 'ISO4217_Currency_Country_Name' => 'UNITED KINGDOM', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Pound Sterling', 'ISO4217_Currency_Numeric_Code' => '826', 'Is_Independent' => 'Yes', 'Capital' => 'London', 'Continent' => 'EU', 'TLD' => '.uk', 'Languages' => 'en-GB,cy-GB,gd', 'Geo_Name_ID' => '2635167', 'EDGAR' => 'X0', '' => '', 'currency_symbol' => 'GBP', 'distance_unit' => '2', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '233'),
            235 => array('Country_Name' => 'US', 'Official_Name_English' => 'United States of America', 'ISO3166_1_Alpha_2' => 'US', 'ISO3166_1_Alpha_3' => 'USA', 'M49' => '840', 'ITU' => 'USA', 'MARC' => 'xxu', 'WMO' => 'US', 'DS' => 'USA', 'Dial' => '1', 'FIFA' => 'USA', 'FIPS' => 'US', 'GAUL' => '259', 'IOC' => 'USA', 'ISO4217_Currency_Alphabetic_Code' => 'USD', 'ISO4217_Currency_Country_Name' => 'UNITED STATES', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'US Dollar', 'ISO4217_Currency_Numeric_Code' => '840', 'Is_Independent' => 'Yes', 'Capital' => 'Washington', 'Continent' => 'NA', 'TLD' => '.us', 'Languages' => 'en-US,es-US,haw,fr', 'Geo_Name_ID' => '6252001', 'EDGAR' => '', '' => '', 'currency_symbol' => 'USD', 'distance_unit' => '2', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '234'),
            236 => array('Country_Name' => 'Uganda', 'Official_Name_English' => 'Uganda', 'ISO3166_1_Alpha_2' => 'UG', 'ISO3166_1_Alpha_3' => 'UGA', 'M49' => '800', 'ITU' => 'UGA', 'MARC' => 'ug', 'WMO' => 'UG', 'DS' => 'EAU', 'Dial' => '256', 'FIFA' => 'UGA', 'FIPS' => 'UG', 'GAUL' => '253', 'IOC' => 'UGA', 'ISO4217_Currency_Alphabetic_Code' => 'UGX', 'ISO4217_Currency_Country_Name' => 'UGANDA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Uganda Shilling', 'ISO4217_Currency_Numeric_Code' => '800', 'Is_Independent' => 'Yes', 'Capital' => 'Kampala', 'Continent' => 'AF', 'TLD' => '.ug', 'Languages' => 'en-UG,lg,sw,ar', 'Geo_Name_ID' => '226074', 'EDGAR' => 'W9', '' => '', 'currency_symbol' => 'UGX', 'distance_unit' => '2', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '235'),
            237 => array('Country_Name' => 'Ukraine', 'Official_Name_English' => 'Ukraine', 'ISO3166_1_Alpha_2' => 'UA', 'ISO3166_1_Alpha_3' => 'UKR', 'M49' => '804', 'ITU' => 'UKR', 'MARC' => 'un', 'WMO' => 'UR', 'DS' => 'UA', 'Dial' => '380', 'FIFA' => 'UKR', 'FIPS' => 'UP', 'GAUL' => '254', 'IOC' => 'UKR', 'ISO4217_Currency_Alphabetic_Code' => 'UAH', 'ISO4217_Currency_Country_Name' => 'UKRAINE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Hryvnia', 'ISO4217_Currency_Numeric_Code' => '980', 'Is_Independent' => 'Yes', 'Capital' => 'Kiev', 'Continent' => 'EU', 'TLD' => '.ua', 'Languages' => 'uk,ru-UA,rom,pl,hu', 'Geo_Name_ID' => '690791', 'EDGAR' => '2H', '' => '', 'currency_symbol' => 'UAH', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '236'),
            238 => array('Country_Name' => 'United Arab Emirates', 'Official_Name_English' => 'United Arab Emirates', 'ISO3166_1_Alpha_2' => 'AE', 'ISO3166_1_Alpha_3' => 'ARE', 'M49' => '784', 'ITU' => 'UAE', 'MARC' => 'ts', 'WMO' => 'ER', 'DS' => '', 'Dial' => '971', 'FIFA' => 'UAE', 'FIPS' => 'AE', 'GAUL' => '255', 'IOC' => 'UAE', 'ISO4217_Currency_Alphabetic_Code' => 'AED', 'ISO4217_Currency_Country_Name' => 'UNITED ARAB EMIRATES', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'UAE Dirham', 'ISO4217_Currency_Numeric_Code' => '784', 'Is_Independent' => 'Yes', 'Capital' => 'Abu Dhabi', 'Continent' => 'AS', 'TLD' => '.ae', 'Languages' => 'ar-AE,fa,en,hi,ur', 'Geo_Name_ID' => '290557', 'EDGAR' => 'C0', '' => '', 'currency_symbol' => 'AED', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '237'),
            239 => array('Country_Name' => 'Uruguay', 'Official_Name_English' => 'Uruguay', 'ISO3166_1_Alpha_2' => 'UY', 'ISO3166_1_Alpha_3' => 'URY', 'M49' => '858', 'ITU' => 'URG', 'MARC' => 'uy', 'WMO' => 'UY', 'DS' => 'ROU', 'Dial' => '598', 'FIFA' => 'URU', 'FIPS' => 'UY', 'GAUL' => '260', 'IOC' => 'URU', 'ISO4217_Currency_Alphabetic_Code' => 'UYU', 'ISO4217_Currency_Country_Name' => 'URUGUAY', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Peso Uruguayo', 'ISO4217_Currency_Numeric_Code' => '858', 'Is_Independent' => 'Yes', 'Capital' => 'Montevideo', 'Continent' => 'SA', 'TLD' => '.uy', 'Languages' => 'es-UY', 'Geo_Name_ID' => '3439705', 'EDGAR' => 'X3', '' => '', 'currency_symbol' => 'UYU', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '238'),
            240 => array('Country_Name' => 'Uzbekistan', 'Official_Name_English' => 'Uzbekistan', 'ISO3166_1_Alpha_2' => 'UZ', 'ISO3166_1_Alpha_3' => 'UZB', 'M49' => '860', 'ITU' => 'UZB', 'MARC' => 'uz', 'WMO' => 'UZ', 'DS' => 'UZ', 'Dial' => '998', 'FIFA' => 'UZB', 'FIPS' => 'UZ', 'GAUL' => '261', 'IOC' => 'UZB', 'ISO4217_Currency_Alphabetic_Code' => 'UZS', 'ISO4217_Currency_Country_Name' => 'UZBEKISTAN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Uzbekistan Sum', 'ISO4217_Currency_Numeric_Code' => '860', 'Is_Independent' => 'Yes', 'Capital' => 'Tashkent', 'Continent' => 'AS', 'TLD' => '.uz', 'Languages' => 'uz,ru,tg', 'Geo_Name_ID' => '1512440', 'EDGAR' => '2K', '' => '', 'currency_symbol' => 'UZS', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '239'),
            241 => array('Country_Name' => 'Vanuatu', 'Official_Name_English' => 'Vanuatu', 'ISO3166_1_Alpha_2' => 'VU', 'ISO3166_1_Alpha_3' => 'VUT', 'M49' => '548', 'ITU' => 'VUT', 'MARC' => 'nn', 'WMO' => 'NV', 'DS' => 'VU', 'Dial' => '678', 'FIFA' => 'VAN', 'FIPS' => 'NH', 'GAUL' => '262', 'IOC' => 'VAN', 'ISO4217_Currency_Alphabetic_Code' => 'VUV', 'ISO4217_Currency_Country_Name' => 'VANUATU', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Vatu', 'ISO4217_Currency_Numeric_Code' => '548', 'Is_Independent' => 'Yes', 'Capital' => 'Port Vila', 'Continent' => 'OC', 'TLD' => '.vu', 'Languages' => 'bi,en-VU,fr-VU', 'Geo_Name_ID' => '2134431', 'EDGAR' => '2L', '' => '', 'currency_symbol' => 'VUV', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '240'),
            242 => array('Country_Name' => 'Vatican City', 'Official_Name_English' => 'Holy See', 'ISO3166_1_Alpha_2' => 'VA', 'ISO3166_1_Alpha_3' => 'VAT', 'M49' => '336', 'ITU' => 'CVA', 'MARC' => 'vc', 'WMO' => '', 'DS' => 'V', 'Dial' => '39-06', 'FIFA' => 'VAT', 'FIPS' => 'VT', 'GAUL' => '110', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'HOLY SEE (VATICAN CITY STATE)', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Yes', 'Capital' => 'Vatican City', 'Continent' => 'EU', 'TLD' => '.va', 'Languages' => 'la,it,fr', 'Geo_Name_ID' => '3164670', 'EDGAR' => 'X4', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '241'),
            243 => array('Country_Name' => 'Venezuela', 'Official_Name_English' => 'Venezuela (Bolivarian Republic of)', 'ISO3166_1_Alpha_2' => 'VE', 'ISO3166_1_Alpha_3' => 'VEN', 'M49' => '862', 'ITU' => 'VEN', 'MARC' => 've', 'WMO' => 'VN', 'DS' => 'YV', 'Dial' => '58', 'FIFA' => 'VEN', 'FIPS' => 'VE', 'GAUL' => '263', 'IOC' => 'VEN', 'ISO4217_Currency_Alphabetic_Code' => 'VEF', 'ISO4217_Currency_Country_Name' => 'VENEZUELA, BOLIVARIAN REPUBLIC OF', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Bolivar', 'ISO4217_Currency_Numeric_Code' => '937', 'Is_Independent' => 'Yes', 'Capital' => 'Caracas', 'Continent' => 'SA', 'TLD' => '.ve', 'Languages' => 'es-VE', 'Geo_Name_ID' => '3625428', 'EDGAR' => '', '' => '', 'currency_symbol' => 'VEF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '242'),
            244 => array('Country_Name' => 'Vietnam', 'Official_Name_English' => 'Viet Nam', 'ISO3166_1_Alpha_2' => 'VN', 'ISO3166_1_Alpha_3' => 'VNM', 'M49' => '704', 'ITU' => 'VTN', 'MARC' => 'vm', 'WMO' => 'VS', 'DS' => 'VN', 'Dial' => '84', 'FIFA' => 'VIE', 'FIPS' => 'VM', 'GAUL' => '264', 'IOC' => 'VIE', 'ISO4217_Currency_Alphabetic_Code' => 'VND', 'ISO4217_Currency_Country_Name' => 'VIET NAM', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'Dong', 'ISO4217_Currency_Numeric_Code' => '704', 'Is_Independent' => 'Yes', 'Capital' => 'Hanoi', 'Continent' => 'AS', 'TLD' => '.vn', 'Languages' => 'vi,en,fr,zh,km', 'Geo_Name_ID' => '1562822', 'EDGAR' => 'Q1', '' => '', 'currency_symbol' => 'VND', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '243'),
            245 => array('Country_Name' => 'Wallis & Futuna', 'Official_Name_English' => 'Wallis and Futuna Islands', 'ISO3166_1_Alpha_2' => 'WF', 'ISO3166_1_Alpha_3' => 'WLF', 'M49' => '876', 'ITU' => 'WAL', 'MARC' => 'wf', 'WMO' => 'FW', 'DS' => 'F', 'Dial' => '681', 'FIFA' => 'WLF', 'FIPS' => 'WF', 'GAUL' => '266', 'IOC' => 'WAF', 'ISO4217_Currency_Alphabetic_Code' => 'XPF', 'ISO4217_Currency_Country_Name' => 'WALLIS AND FUTUNA', 'ISO4217_Currency_Minor_Unit' => '0', 'ISO4217_Currency_Name' => 'CFP Franc', 'ISO4217_Currency_Numeric_Code' => '953', 'Is_Independent' => 'Territory of FR', 'Capital' => 'Mata Utu', 'Continent' => 'OC', 'TLD' => '.wf', 'Languages' => 'wls,fud,fr-WF', 'Geo_Name_ID' => '4034749', 'EDGAR' => 'X8', '' => '', 'currency_symbol' => 'XPF', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '244'),
            246 => array('Country_Name' => 'Western Sahara', 'Official_Name_English' => 'Western Sahara', 'ISO3166_1_Alpha_2' => 'EH', 'ISO3166_1_Alpha_3' => 'ESH', 'M49' => '732', 'ITU' => 'AOE', 'MARC' => 'ss', 'WMO' => '', 'DS' => '', 'Dial' => '212', 'FIFA' => 'SAH', 'FIPS' => 'WI', 'GAUL' => '268', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'MAD', 'ISO4217_Currency_Country_Name' => 'WESTERN SAHARA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Moroccan Dirham', 'ISO4217_Currency_Numeric_Code' => '504', 'Is_Independent' => 'In contention', 'Capital' => 'El-Aaiun', 'Continent' => 'AF', 'TLD' => '.eh', 'Languages' => 'ar,mey', 'Geo_Name_ID' => '2461445', 'EDGAR' => 'U5', '' => '', 'currency_symbol' => 'MAD', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '245'),
            247 => array('Country_Name' => 'Yemen', 'Official_Name_English' => 'Yemen', 'ISO3166_1_Alpha_2' => 'YE', 'ISO3166_1_Alpha_3' => 'YEM', 'M49' => '887', 'ITU' => 'YEM', 'MARC' => 'ye', 'WMO' => 'YE', 'DS' => 'YAR', 'Dial' => '967', 'FIFA' => 'YEM', 'FIPS' => 'YM', 'GAUL' => '269', 'IOC' => 'YEM', 'ISO4217_Currency_Alphabetic_Code' => 'YER', 'ISO4217_Currency_Country_Name' => 'YEMEN', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Yemeni Rial', 'ISO4217_Currency_Numeric_Code' => '886', 'Is_Independent' => 'Yes', 'Capital' => 'Sanaa', 'Continent' => 'AS', 'TLD' => '.ye', 'Languages' => 'ar-YE', 'Geo_Name_ID' => '69543', 'EDGAR' => 'T7', '' => '', 'currency_symbol' => 'YER', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '246'),
            248 => array('Country_Name' => 'Zambia', 'Official_Name_English' => 'Zambia', 'ISO3166_1_Alpha_2' => 'ZM', 'ISO3166_1_Alpha_3' => 'ZMB', 'M49' => '894', 'ITU' => 'ZMB', 'MARC' => 'za', 'WMO' => 'ZB', 'DS' => 'Z', 'Dial' => '260', 'FIFA' => 'ZAM', 'FIPS' => 'ZA', 'GAUL' => '270', 'IOC' => 'ZAM', 'ISO4217_Currency_Alphabetic_Code' => 'ZMW', 'ISO4217_Currency_Country_Name' => 'ZAMBIA', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Zambian Kwacha', 'ISO4217_Currency_Numeric_Code' => '967', 'Is_Independent' => 'Yes', 'Capital' => 'Lusaka', 'Continent' => 'AF', 'TLD' => '.zm', 'Languages' => 'en-ZM,bem,loz,lun,lue,ny,toi', 'Geo_Name_ID' => '895949', 'EDGAR' => 'Y4', '' => '', 'currency_symbol' => 'ZMW', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '247'),
            249 => array('Country_Name' => 'Zimbabwe', 'Official_Name_English' => 'Zimbabwe', 'ISO3166_1_Alpha_2' => 'ZW', 'ISO3166_1_Alpha_3' => 'ZWE', 'M49' => '716', 'ITU' => 'ZWE', 'MARC' => 'rh', 'WMO' => 'ZW', 'DS' => 'ZW', 'Dial' => '263', 'FIFA' => 'ZIM', 'FIPS' => 'ZI', 'GAUL' => '271', 'IOC' => 'ZIM', 'ISO4217_Currency_Alphabetic_Code' => 'ZWL', 'ISO4217_Currency_Country_Name' => 'ZIMBABWE', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Zimbabwe Dollar', 'ISO4217_Currency_Numeric_Code' => '932', 'Is_Independent' => 'Yes', 'Capital' => 'Harare', 'Continent' => 'AF', 'TLD' => '.zw', 'Languages' => 'en-ZW,sn,nr,nd', 'Geo_Name_ID' => '878675', 'EDGAR' => 'Y5', '' => '', 'currency_symbol' => 'ZWL', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '248'),
            250 => array('Country_Name' => 'Ãland Islands', 'Official_Name_English' => 'Ãland Islands', 'ISO3166_1_Alpha_2' => 'AX', 'ISO3166_1_Alpha_3' => 'ALA', 'M49' => '248', 'ITU' => '', 'MARC' => '', 'WMO' => '', 'DS' => 'FIN', 'Dial' => '358', 'FIFA' => 'ALD', 'FIPS' => '', 'GAUL' => '1242', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => 'EUR', 'ISO4217_Currency_Country_Name' => 'ÃLAND ISLANDS', 'ISO4217_Currency_Minor_Unit' => '2', 'ISO4217_Currency_Name' => 'Euro', 'ISO4217_Currency_Numeric_Code' => '978', 'Is_Independent' => 'Part of FI', 'Capital' => 'Mariehamn', 'Continent' => 'EU', 'TLD' => '.ax', 'Languages' => 'sv-AX', 'Geo_Name_ID' => '661882', 'EDGAR' => '', '' => '', 'currency_symbol' => 'EUR', 'distance_unit' => '1', 'phone_min_digit' => '8', 'phone_max_digit' => '12', 'online_transaction_code' => 'Branch Code', 'display_sequence' => '249'),
//            251 => array('Country_Name' => '', 'Official_Name_English' => '', 'ISO3166_1_Alpha_2' => '', 'ISO3166_1_Alpha_3' => '', 'M49' => '', 'ITU' => '', 'MARC' => '', 'WMO' => '', 'DS' => '', 'Dial' => '', 'FIFA' => '', 'FIPS' => '', 'GAUL' => '', 'IOC' => '', 'ISO4217_Currency_Alphabetic_Code' => '', 'ISO4217_Currency_Country_Name' => '', 'ISO4217_Currency_Minor_Unit' => '', 'ISO4217_Currency_Name' => '', 'ISO4217_Currency_Numeric_Code' => '', 'Is_Independent' => '', 'Capital' => '', 'Continent' => '', 'TLD' => '', 'Languages' => '', 'Geo_Name_ID' => '', 'EDGAR' => '', '' => '', 'currency_symbol' => '', 'distance_unit' => '', 'phone_min_digit' => '', 'phone_max_digit' => '', 'online_transaction_code' => '', 'display_sequence' => ''),
        );
        return $countries_list;
    }
}
